/*
 * File   : $Source: /usr/local/cvs/opencms/src/org/opencms/scheduler/Messages.java,v $
 * Date   : $Date: 2008-02-27 12:05:33 $
 * Version: $Revision: 1.12 $
 *
 * This library is part of OpenCms -
 * the Open Source Content Management System
 *
 * Copyright (c) 2002 - 2008 Alkacon Software GmbH (http://www.alkacon.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * For further information about Alkacon Software GmbH, please see the
 * company website: http://www.alkacon.com
 *
 * For further information about OpenCms, please see the
 * project website: http://www.opencms.org
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.opencms.scheduler;

import org.opencms.i18n.A_CmsMessageBundle;
import org.opencms.i18n.I_CmsMessageBundle;

/**
 * Convenience class to access the localized messages of this OpenCms package.<p> 
 * 
 * @version $Revision: 1.12 $ 
 * 
 * @since 6.0.0 
 */
public final class Messages extends A_CmsMessageBundle {

    /** Message constant for key in the resource bundle. */
    public static final String ERR_BAD_CONTEXT_INFO_0 = "ERR_BAD_CONTEXT_INFO_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_BAD_CRON_EXPRESSION_2 = "ERR_BAD_CRON_EXPRESSION_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_BAD_JOB_CLASS_NAME_1 = "ERR_BAD_JOB_CLASS_NAME_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_BAD_JOB_NAME_1 = "ERR_BAD_JOB_NAME_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_BAD_JOB_PARAMS_0 = "ERR_BAD_JOB_PARAMS_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_COULD_NOT_RESCHEDULE_JOB_2 = "ERR_COULD_NOT_RESCHEDULE_JOB_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_COULD_NOT_SCHEDULE_JOB_2 = "ERR_COULD_NOT_SCHEDULE_JOB_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_INIT_THREAD_COUNT_BOUNDS_0 = "ERR_INIT_THREAD_COUNT_BOUNDS_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_INVALID_JOB_CONFIGURATION_0 = "ERR_INVALID_JOB_CONFIGURATION_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_JOB_CLASS_BAD_INTERFACE_2 = "ERR_JOB_CLASS_BAD_INTERFACE_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_JOB_CLASS_NOT_FOUND_1 = "ERR_JOB_CLASS_NOT_FOUND_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_JOB_INFO_FROZEN_1 = "ERR_JOB_INFO_FROZEN_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_JOB_WITH_ID_DOES_NOT_EXIST_1 = "ERR_JOB_WITH_ID_DOES_NOT_EXIST_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_MAX_THREAD_COUNT_BOUNDS_0 = "ERR_MAX_THREAD_COUNT_BOUNDS_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_NO_SCHEDULER_1 = "ERR_NO_SCHEDULER_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_SCHEDULER_PRIORITY_BOUNDS_0 = "ERR_SCHEDULER_PRIORITY_BOUNDS_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_SCHEDULER_CONFIG_FINISHED_0 = "INIT_SCHEDULER_CONFIG_FINISHED_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_SCHEDULER_CREATED_1 = "INIT_SCHEDULER_CREATED_1";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_SCHEDULER_INITIALIZED_0 = "INIT_SCHEDULER_INITIALIZED_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_SCHEDULER_STARTED_0 = "INIT_SCHEDULER_STARTED_0";

    /** Message constant for key in the resource bundle. */
    public static final String INIT_SHUTDOWN_1 = "INIT_SHUTDOWN_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_BAD_INTERFACE_0 = "LOG_BAD_INTERFACE_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_CANNOT_START_SCHEDULER_0 = "LOG_CANNOT_START_SCHEDULER_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_CLASS_NOT_FOUND_1 = "LOG_CLASS_NOT_FOUND_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_ILLEGAL_ACCESS_0 = "LOG_ILLEGAL_ACCESS_0";

    /** Constant for message LOG_INSTANCE_GENERATION_0. */
    public static final String LOG_INSTANCE_GENERATION_0 = "LOG_INSTANCE_GENERATION_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_INVALID_JOB_1 = "LOG_INVALID_JOB_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_JOB_CREATED_1 = "LOG_JOB_CREATED_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_JOB_EXECUTED_1 = "LOG_JOB_EXECUTED_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_JOB_EXECUTION_ERROR_1 = "LOG_JOB_EXECUTION_ERROR_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_JOB_EXECUTION_OK_2 = "LOG_JOB_EXECUTION_OK_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_JOB_NEXT_EXECUTION_2 = "LOG_JOB_NEXT_EXECUTION_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_JOB_SCHEDULED_4 = "LOG_JOB_SCHEDULED_4";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_JOB_STARTING_1 = "LOG_JOB_STARTING_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_MULTIPLE_JOBS_FOUND_1 = "LOG_MULTIPLE_JOBS_FOUND_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_NO_SCHEDULER_0 = "LOG_NO_SCHEDULER_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_REUSING_INSTANCE_1 = "LOG_REUSING_INSTANCE_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_SHUTDOWN_ERROR_0 = "LOG_SHUTDOWN_ERROR_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_THREAD_ERROR_1 = "LOG_THREAD_ERROR_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_THREAD_INTERRUPTED_1 = "LOG_THREAD_INTERRUPTED_1";

    /** Name of the used resource bundle. */
    public static final String LOG_THREAD_POOL_SHUTDOWN_0 = "LOG_THREAD_POOL_SHUTDOWN_0";

    /** Name of the used resource bundle. */
    public static final String LOG_THREAD_POOL_STILL_ACTIVE_1 = "LOG_THREAD_POOL_STILL_ACTIVE_1";

    /** Name of the used resource bundle. */
    public static final String LOG_THREAD_POOL_UNAVAILABLE_0 = "LOG_THREAD_POOL_UNAVAILABLE_0";

    /** Name of the used resource bundle. */
    public static final String LOG_THREAD_POOL_WAITING_1 = "LOG_THREAD_POOL_WAITING_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_THREAD_SHUTDOWN_1 = "LOG_THREAD_SHUTDOWN_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_UNSCHEDULED_JOB_1 = "LOG_UNSCHEDULED_JOB_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_UNSCHEDULING_ERROR_1 = "LOG_UNSCHEDULING_ERROR_1";

    /** Name of the used resource bundle. */
    public static final String LOG_USING_THREAD_CLASSLOADER_1 = "LOG_USING_THREAD_CLASSLOADER_1";

    /** Name of the used resource bundle. */
    private static final String BUNDLE_NAME = "org.opencms.scheduler.messages";

    /** Static instance member. */
    private static final I_CmsMessageBundle INSTANCE = new Messages();

    /**
     * Hides the public constructor for this utility class.<p>
     */
    private Messages() {

        // hide the constructor
    }

    /**
     * Returns an instance of this localized message accessor.<p>
     * 
     * @return an instance of this localized message accessor
     */
    public static I_CmsMessageBundle get() {

        return INSTANCE;
    }

    /**
     * Returns the bundle name for this OpenCms package.<p>
     * 
     * @return the bundle name for this OpenCms package
     */
    public String getBundleName() {

        return BUNDLE_NAME;
    }
}
