/*
 * File   : $Source: /usr/local/cvs/opencms/src/org/opencms/security/Messages.java,v $
 * Date   : $Date: 2008-02-27 12:05:29 $
 * Version: $Revision: 1.25 $
 *
 * This library is part of OpenCms -
 * the Open Source Content Management System
 *
 * Copyright (c) 2002 - 2008 Alkacon Software GmbH (http://www.alkacon.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * For further information about Alkacon Software GmbH, please see the
 * company website: http://www.alkacon.com
 *
 * For further information about OpenCms, please see the
 * project website: http://www.opencms.org
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.opencms.security;

import org.opencms.i18n.A_CmsMessageBundle;
import org.opencms.i18n.I_CmsMessageBundle;

/**
 * Convenience class to access the localized messages of this OpenCms package.<p> 
 * 
 * @author Alexander Kandzior 
 * 
 * @version $Revision: 1.25 $ 
 * 
 * @since 6.0.0 
 */
public final class Messages extends A_CmsMessageBundle {

    /** Message constant for key in the resource bundle. */
    public static final String ERR_BAD_GROUPNAME_EMPTY_0 = "ERR_BAD_GROUPNAME_EMPTY_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_BAD_USERNAME_4 = "ERR_BAD_USERNAME_4";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_BAD_USERNAME_EMPTY_0 = "ERR_BAD_USERNAME_EMPTY_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_CANT_DELETE_DEFAULT_USER_1 = "ERR_CANT_DELETE_DEFAULT_USER_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_EMAIL_VALIDATION_1 = "ERR_EMAIL_VALIDATION_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_FIRSTNAME_EMPTY_0 = "ERR_FIRSTNAME_EMPTY_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_INVALID_NEWPWD_0 = "ERR_INVALID_NEWPWD_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_INVALID_PRINCIPAL_1 = "ERR_INVALID_PRINCIPAL_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_INVALID_PRINCIPAL_TYPE_2 = "ERR_INVALID_PRINCIPAL_TYPE_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_INVALID_USER_CONTEXT_0 = "ERR_INVALID_USER_CONTEXT_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_INVALID_USER_PWD_1 = "ERR_INVALID_USER_PWD_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_LASTNAME_EMPTY_0 = "ERR_LASTNAME_EMPTY_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_LOGIN_FAILED_2 = "ERR_LOGIN_FAILED_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_LOGIN_FAILED_DISABLED_2 = "ERR_LOGIN_FAILED_DISABLED_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_LOGIN_FAILED_NO_USER_2 = "ERR_LOGIN_FAILED_NO_USER_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_LOGIN_FAILED_TEMP_DISABLED_4 = "ERR_LOGIN_FAILED_TEMP_DISABLED_4";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_LOGIN_FAILED_WITH_MESSAGE_1 = "ERR_LOGIN_FAILED_WITH_MESSAGE_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_NEWPWD_EMPTY_0 = "ERR_NEWPWD_EMPTY_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_NEWPWD_MISMATCH_0 = "ERR_NEWPWD_MISMATCH_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_NO_PERMISSION_RESOURCE_1 = "ERR_NO_PERMISSION_RESOURCE_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_NOT_MANAGER_OF_PROJECT_2 = "ERR_NOT_MANAGER_OF_PROJECT_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ORGUNIT_ROOT_EDITION_0 = "ERR_ORGUNIT_ROOT_EDITION_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_PASSWORD_TOO_SHORT_1 = "ERR_PASSWORD_TOO_SHORT_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_RESOURCE_LOCKED_1 = "ERR_RESOURCE_LOCKED_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ROLE_VIOLATION_1 = "ERR_ROLE_VIOLATION_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_STARTUP_FINISHED_0 = "ERR_STARTUP_FINISHED_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_UNSUPPORTED_ALGORITHM_1 = "ERR_UNSUPPORTED_ALGORITHM_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_UNSUPPORTED_PASSWORD_ENCODING_1 = "ERR_UNSUPPORTED_PASSWORD_ENCODING_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_USER_NOT_IN_ROLE_2 = "ERR_USER_NOT_IN_ROLE_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_USER_NOT_IN_ROLE_FOR_ORGUNIT_3 = "ERR_USER_NOT_IN_ROLE_FOR_ORGUNIT_3";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_USER_NOT_IN_ROLE_FOR_RESOURCE_3 = "ERR_USER_NOT_IN_ROLE_FOR_RESOURCE_3";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_ZIPCODE_VALIDATION_1 = "ERR_ZIPCODE_VALIDATION_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ORGUNIT_DISPLAY_NAME_2 = "GUI_ORGUNIT_DISPLAY_NAME_2";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_PRINCIPAL_DISPLAY_NAME_2 = "GUI_PRINCIPAL_DISPLAY_NAME_2";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLE_DESCRIPTION_ACCOUNT_MANAGER_0 = "GUI_ROLE_DESCRIPTION_ACCOUNT_MANAGER_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLE_DESCRIPTION_ADMINISTRATOR_0 = "GUI_ROLE_DESCRIPTION_ADMINISTRATOR_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLE_DESCRIPTION_DATABASE_MANAGER_0 = "GUI_ROLE_DESCRIPTION_DATABASE_MANAGER_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLE_DESCRIPTION_DEVELOPER_0 = "GUI_ROLE_DESCRIPTION_DEVELOPER_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLE_DESCRIPTION_DIRECT_EDIT_USER_0 = "GUI_ROLE_DESCRIPTION_DIRECT_EDIT_USER_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLE_DESCRIPTION_PROJECT_MANAGER_0 = "GUI_ROLE_DESCRIPTION_PROJECT_MANAGER_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLE_DESCRIPTION_ROOT_ADMIN_0 = "GUI_ROLE_DESCRIPTION_ROOT_ADMIN_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLE_DESCRIPTION_VFS_MANAGER_0 = "GUI_ROLE_DESCRIPTION_VFS_MANAGER_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLE_DESCRIPTION_WORKPLACE_MANAGER_0 = "GUI_ROLE_DESCRIPTION_WORKPLACE_MANAGER_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLE_DESCRIPTION_WORKPLACE_USER_0 = "GUI_ROLE_DESCRIPTION_WORKPLACE_USER_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLENAME_ACCOUNT_MANAGER_0 = "GUI_ROLENAME_ACCOUNT_MANAGER_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLENAME_ADMINISTRATOR_0 = "GUI_ROLENAME_ADMINISTRATOR_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLENAME_DATABASE_MANAGER_0 = "GUI_ROLENAME_DATABASE_MANAGER_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLENAME_DEVELOPER_0 = "GUI_ROLENAME_DEVELOPER_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLENAME_DIRECT_EDIT_USER_0 = "GUI_ROLENAME_DIRECT_EDIT_USER_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLENAME_PROJECT_MANAGER_0 = "GUI_ROLENAME_PROJECT_MANAGER_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLENAME_ROOT_ADMIN_0 = "GUI_ROLENAME_ROOT_ADMIN_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLENAME_VFS_MANAGER_0 = "GUI_ROLENAME_VFS_MANAGER_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLENAME_WORKPLACE_MANAGER_0 = "GUI_ROLENAME_WORKPLACE_MANAGER_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ROLENAME_WORKPLACE_USER_0 = "GUI_ROLENAME_WORKPLACE_USER_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_INIT_CONFIG_CALLED_1 = "LOG_INIT_CONFIG_CALLED_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_NO_PERMISSION_RESOURCE_USER_4 = "LOG_NO_PERMISSION_RESOURCE_USER_4";

    /** Name of the used resource bundle. */
    private static final String BUNDLE_NAME = "org.opencms.security.messages";

    /** Static instance member. */
    private static final I_CmsMessageBundle INSTANCE = new Messages();

    /**
     * Hides the public constructor for this utility class.<p>
     */
    private Messages() {

        // hide the constructor
    }

    /**
     * Returns an instance of this localized message accessor.<p>
     * 
     * @return an instance of this localized message accessor
     */
    public static I_CmsMessageBundle get() {

        return INSTANCE;
    }

    /**
     * Returns the bundle name for this OpenCms package.<p>
     * 
     * @return the bundle name for this OpenCms package
     */
    public String getBundleName() {

        return BUNDLE_NAME;
    }
}