/*
 * File   : $Source: /usr/local/cvs/opencms/src/org/opencms/workplace/galleries/Messages.java,v $
 * Date   : $Date: 2008-02-27 12:05:50 $
 * Version: $Revision: 1.8 $
 *
 * This library is part of OpenCms -
 * the Open Source Content Management System
 *
 * Copyright (c) 2002 - 2008 Alkacon Software GmbH (http://www.alkacon.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * For further information about Alkacon Software GmbH, please see the
 * company website: http://www.alkacon.com
 *
 * For further information about OpenCms, please see the
 * project website: http://www.opencms.org
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.opencms.workplace.galleries;

import org.opencms.i18n.A_CmsMessageBundle;
import org.opencms.i18n.I_CmsMessageBundle;

/**
 * Convenience class to access the localized messages of this OpenCms package.<p> 
 * 
 * @author Jan Baudisch 
 * 
 * @version $Revision: 1.8 $ 
 * 
 * @since 6.0.0 
 */
public final class Messages extends A_CmsMessageBundle {

    /** Message constant for key in the resource bundle. */
    public static final String ERR_OPEN_GALLERY_1 = "ERR_OPEN_GALLERY_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_REASON_NO_DOWNLOADGALLERY_0 = "ERR_REASON_NO_DOWNLOADGALLERY_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_REASON_NO_HTMLGALLERY_0 = "ERR_REASON_NO_HTMLGALLERY_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_REASON_NO_IMAGEGALLERY_0 = "ERR_REASON_NO_IMAGEGALLERY_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_REASON_NO_LINKGALLERY_0 = "ERR_REASON_NO_LINKGALLERY_0";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_REASON_NO_TABLEGALLERY_0 = "ERR_REASON_NO_TABLEGALLERY_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_BUTTON_PASTE_0 = "GUI_BUTTON_PASTE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_BUTTON_PREVIEW_0 = "GUI_BUTTON_PREVIEW_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_INPUT_DATELASTMODIFIED_0 = "GUI_INPUT_DATELASTMODIFIED_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_INPUT_DESCRIPTION_0 = "GUI_INPUT_DESCRIPTION_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_INPUT_EDITPROPERTYINFO_0 = "GUI_INPUT_EDITPROPERTYINFO_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_INPUT_KEYWORDS_0 = "GUI_INPUT_KEYWORDS_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_INPUT_LINKTARGET_0 = "GUI_INPUT_LINKTARGET_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_INPUT_LINKTARGETBLANK_0 = "GUI_INPUT_LINKTARGETBLANK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_INPUT_LINKTARGETSELF_0 = "GUI_INPUT_LINKTARGETSELF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_INPUT_LINKTARGETTOP_0 = "GUI_INPUT_LINKTARGETTOP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_INPUT_LINKTO_0 = "GUI_INPUT_LINKTO_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_INPUT_SEARCH_0 = "GUI_INPUT_SEARCH_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_INPUT_TITLE_0 = "GUI_INPUT_TITLE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LABEL_KILOBYTES_0 = "GUI_LABEL_KILOBYTES_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LABEL_NAME_0 = "GUI_LABEL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LABEL_PIXELS_0 = "GUI_LABEL_PIXELS_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LABEL_SIZE_0 = "GUI_LABEL_SIZE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LABEL_TITLE_0 = "GUI_LABEL_TITLE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_MESSAGEBOX_TITLE_PUBLISHRESOURCE_0 = "GUI_MESSAGEBOX_TITLE_PUBLISHRESOURCE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_TITLE_DELETE_0 = "GUI_TITLE_DELETE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_TITLE_DOWNLOADGALLERY_0 = "GUI_TITLE_DOWNLOADGALLERY_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_TITLE_HTMLGALLERY_0 = "GUI_TITLE_HTMLGALLERY_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_TITLE_IMAGEGALLERY_0 = "GUI_TITLE_IMAGEGALLERY_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_TITLE_LINKGALLERY_0 = "GUI_TITLE_LINKGALLERY_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_TITLE_NEW_0 = "GUI_TITLE_NEW_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_TITLE_TABLEGALLERY_0 = "GUI_TITLE_TABLEGALLERY_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_CREATE_GALLERY_INSTANCE_FAILED_2 = "LOG_CREATE_GALLERY_INSTANCE_FAILED_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_CREATE_GALLERY_INSTANCE_FAILED_JSP_3 = "LOG_CREATE_GALLERY_INSTANCE_FAILED_JSP_3";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_UNKNOWN_GALLERY_TYPE_REQ_1 = "LOG_UNKNOWN_GALLERY_TYPE_REQ_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_UNKNOWN_GALLERY_TYPE_REQ_JSP_2 = "LOG_UNKNOWN_GALLERY_TYPE_REQ_JSP_2";

    /** Name of the used resource bundle. */
    private static final String BUNDLE_NAME = "org.opencms.workplace.galleries.messages";

    /**Prefix to create gallery not found key. */
    private static final String ERROR_REASON_NO_PREFIX = "ERR_REASON_NO_";

    /**Postfix to create gallery title key. */
    private static final String GUI_TITLE_POSTFIX = "_0";

    /**Prefix to create gallery title key. */
    private static final String GUI_TITLE_PREFIX = "GUI_TITLE_";

    /** Static instance member. */
    private static final I_CmsMessageBundle INSTANCE = new Messages();

    /**
     * Hides the public constructor for this utility class.<p>
     */
    private Messages() {

        // hide the constructor
    }

    /**
     * Returns an instance of this localized message accessor.<p>
     * 
     * @return an instance of this localized message accessor
     */
    public static I_CmsMessageBundle get() {

        return INSTANCE;
    }

    /**
     * Convert gallery name to not found error  key.
     * @param gallery gallery name for example "htmlgallery"
     * @return key as string "ERR_REASON_NO_HTMLGALLERY_0"
     */
    public static String getGalleryNotFoundKey(String gallery) {

        StringBuffer sb = new StringBuffer(ERROR_REASON_NO_PREFIX);
        sb.append(gallery.toUpperCase());
        sb.append(GUI_TITLE_POSTFIX);
        return sb.toString();
    }

    /**
     * Convert gallery name to title key.
     * @param gallery gallery name for example "htmlgallery"
     * @return key as string "GUI_TITLE_HTMLGALLERY_0"
     */
    public static String getTitleGalleryKey(String gallery) {

        StringBuffer sb = new StringBuffer(GUI_TITLE_PREFIX);
        sb.append(gallery.toUpperCase());
        sb.append(GUI_TITLE_POSTFIX);
        return sb.toString();
    }

    /**
     * Returns the bundle name for this OpenCms package.<p>
     * 
     * @return the bundle name for this OpenCms package
     */
    public String getBundleName() {

        return BUNDLE_NAME;
    }
}
