/*
 * File   : $Source: /usr/local/cvs/opencms/src/org/opencms/workplace/list/Messages.java,v $
 * Date   : $Date: 2008-02-27 12:05:28 $
 * Version: $Revision: 1.20 $
 *
 * This library is part of OpenCms -
 * the Open Source Content Management System
 *
 * Copyright (c) 2002 - 2008 Alkacon Software GmbH (http://www.alkacon.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * For further information about Alkacon Software GmbH, please see the
 * company website: http://www.alkacon.com
 *
 * For further information about OpenCms, please see the
 * project website: http://www.opencms.org
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.opencms.workplace.list;

import org.opencms.i18n.A_CmsMessageBundle;
import org.opencms.i18n.I_CmsMessageBundle;

/**
 * Convenience class to access the localized messages of this OpenCms package.<p> 
 * 
 * @author Michael Moossen
 * 
 * @version $Revision: 1.20 $ 
 * 
 * @since 6.0.0 
 */
public final class Messages extends A_CmsMessageBundle {

    /** Message constant for key in the resource bundle. */
    public static final String ERR_DUPLICATED_ID_1 = "ERR_DUPLICATED_ID_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_LIST_COLUMN_EXISTS_1 = "ERR_LIST_COLUMN_EXISTS_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_LIST_ENUM_PARSE_2 = "ERR_LIST_ENUM_PARSE_2";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_LIST_FILL_1 = "ERR_LIST_FILL_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_LIST_INVALID_COLUMN_1 = "ERR_LIST_INVALID_COLUMN_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_LIST_INVALID_NULL_ARG_1 = "ERR_LIST_INVALID_NULL_ARG_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_LIST_INVALID_PAGE_1 = "ERR_LIST_INVALID_PAGE_1";

    /** Message constant for key in the resource bundle. */
    public static final String ERR_LIST_UNSUPPORTED_ACTION_2 = "ERR_LIST_UNSUPPORTED_ACTION_2";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ACTION_PRINT_HELP_0 = "GUI_ACTION_PRINT_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_ACTION_PRINT_NAME_0 = "GUI_ACTION_PRINT_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITRESOURCE_ACTION_HELP_0 = "GUI_EDITRESOURCE_ACTION_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITRESOURCE_ACTION_NAME_0 = "GUI_EDITRESOURCE_ACTION_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITRESOURCE_DISABLED_ACTION_HELP_0 = "GUI_EDITRESOURCE_DISABLED_ACTION_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EDITRESOURCE_DISABLED_ACTION_NAME_0 = "GUI_EDITRESOURCE_DISABLED_ACTION_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EXPLORER_LIST_ACTION_INPROJECT_NAME_1 = "GUI_EXPLORER_LIST_ACTION_INPROJECT_NAME_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EXPLORER_LIST_ACTION_LOCK_HELP_0 = "GUI_EXPLORER_LIST_ACTION_LOCK_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EXPLORER_LIST_ACTION_LOCK_NAME_2 = "GUI_EXPLORER_LIST_ACTION_LOCK_NAME_2";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EXPLORER_LIST_ACTION_OUTPROJECT_NAME_1 = "GUI_EXPLORER_LIST_ACTION_OUTPROJECT_NAME_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EXPLORER_LIST_ACTION_PROJECTSTATE_HELP_0 = "GUI_EXPLORER_LIST_ACTION_PROJECTSTATE_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EXPLORER_LIST_ACTION_RES_HELP_0 = "GUI_EXPLORER_LIST_ACTION_RES_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EXPLORER_LIST_ACTION_UNLOCK_NAME_0 = "GUI_EXPLORER_LIST_ACTION_UNLOCK_NAME_0";
    
    /** Message constant for key in the resource bundle. */
    public static final String GUI_EXPLORER_LIST_COLS_EDIT_0 = "GUI_EXPLORER_LIST_COLS_EDIT_0";
    
    /** Message constant for key in the resource bundle. */
    public static final String GUI_EXPLORER_LIST_COLS_EDIT_HELP_0 = "GUI_EXPLORER_LIST_COLS_EDIT_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EXPLORER_LIST_COLS_EMPTY_0 = "GUI_EXPLORER_LIST_COLS_EMPTY_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EXPLORER_LIST_COLS_ICON_0 = "GUI_EXPLORER_LIST_COLS_ICON_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EXPLORER_LIST_COLS_ICON_HELP_0 = "GUI_EXPLORER_LIST_COLS_ICON_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EXPLORER_LIST_COLS_LOCK_0 = "GUI_EXPLORER_LIST_COLS_LOCK_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EXPLORER_LIST_COLS_PROJSTATE_0 = "GUI_EXPLORER_LIST_COLS_PROJSTATE_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EXPLORER_LIST_COLS_SELECT_0 = "GUI_EXPLORER_LIST_COLS_SELECT_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_EXPLORER_LIST_COLS_SELECT_HELP_0 = "GUI_EXPLORER_LIST_COLS_SELECT_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_ACTION_CSV_CONF_0 = "GUI_LIST_ACTION_CSV_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_ACTION_CSV_HELP_0 = "GUI_LIST_ACTION_CSV_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_ACTION_CSV_NAME_0 = "GUI_LIST_ACTION_CSV_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_ACTION_EXPLORER_SWITCH_CONF_0 = "GUI_LIST_ACTION_EXPLORER_SWITCH_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_ACTION_EXPLORER_SWITCH_HELP_0 = "GUI_LIST_ACTION_EXPLORER_SWITCH_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_ACTION_EXPLORER_SWITCH_NAME_0 = "GUI_LIST_ACTION_EXPLORER_SWITCH_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_ACTION_LIST_SWITCH_HELP_0 = "GUI_LIST_ACTION_LIST_SWITCH_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_ACTION_LIST_SWITCH_NAME_0 = "GUI_LIST_ACTION_LIST_SWITCH_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_ACTION_NO_SELECTION_0 = "GUI_LIST_ACTION_NO_SELECTION_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_ACTION_NO_SELECTION_MATCH_1 = "GUI_LIST_ACTION_NO_SELECTION_MATCH_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_ACTION_PRINT_CONF_0 = "GUI_LIST_ACTION_PRINT_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_ACTION_PRINT_HELP_0 = "GUI_LIST_ACTION_PRINT_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_ACTION_PRINT_NAME_0 = "GUI_LIST_ACTION_PRINT_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_ACTION_REFRESH_CONF_0 = "GUI_LIST_ACTION_REFRESH_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_ACTION_REFRESH_HELP_0 = "GUI_LIST_ACTION_REFRESH_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_ACTION_REFRESH_NAME_0 = "GUI_LIST_ACTION_REFRESH_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_ACTION_SEARCH_CONF_0 = "GUI_LIST_ACTION_SEARCH_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_ACTION_SEARCH_HELP_1 = "GUI_LIST_ACTION_SEARCH_HELP_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_ACTION_SEARCH_NAME_0 = "GUI_LIST_ACTION_SEARCH_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_ACTION_SHOWALL_CONF_0 = "GUI_LIST_ACTION_SHOWALL_CONF_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_ACTION_SHOWALL_HELP_0 = "GUI_LIST_ACTION_SHOWALL_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_ACTION_SHOWALL_NAME_0 = "GUI_LIST_ACTION_SHOWALL_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_COLUMN_ASC_SORT_1 = "GUI_LIST_COLUMN_ASC_SORT_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_COLUMN_DESC_SORT_1 = "GUI_LIST_COLUMN_DESC_SORT_1";

    /** Name of the used resource bundle. */
    public static final String GUI_LIST_COLUMN_NO_SORT_1 = "GUI_LIST_COLUMN_NO_SORT_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_DATE_FORMAT_1 = "GUI_LIST_DATE_FORMAT_1";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_DATE_FORMAT_NEVER_0 = "GUI_LIST_DATE_FORMAT_NEVER_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_EMPTY_0 = "GUI_LIST_EMPTY_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_PAGE_ENTRY_3 = "GUI_LIST_PAGE_ENTRY_3";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_PAGING_FILTER_TEXT_3 = "GUI_LIST_PAGING_FILTER_TEXT_3";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_PAGING_NEXT_HELP_0 = "GUI_LIST_PAGING_NEXT_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_PAGING_NEXT_HELPDIS_0 = "GUI_LIST_PAGING_NEXT_HELPDIS_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_PAGING_NEXT_NAME_0 = "GUI_LIST_PAGING_NEXT_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_PAGING_PREVIOUS_HELP_0 = "GUI_LIST_PAGING_PREVIOUS_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_PAGING_PREVIOUS_HELPDIS_0 = "GUI_LIST_PAGING_PREVIOUS_HELPDIS_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_PAGING_PREVIOUS_NAME_0 = "GUI_LIST_PAGING_PREVIOUS_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_PAGING_TEXT_2 = "GUI_LIST_PAGING_TEXT_2";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SINGLE_TITLE_FILTERED_TEXT_3 = "GUI_LIST_SINGLE_TITLE_FILTERED_TEXT_3";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_SINGLE_TITLE_TEXT_2 = "GUI_LIST_SINGLE_TITLE_TEXT_2";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_TITLE_FILTERED_TEXT_5 = "GUI_LIST_TITLE_FILTERED_TEXT_5";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_LIST_TITLE_TEXT_4 = "GUI_LIST_TITLE_TEXT_4";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_OPENRESOURCE_ACTION_DISABLED_HELP_0 = "GUI_OPENRESOURCE_ACTION_DISABLED_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_OPENRESOURCE_ACTION_HELP_0 = "GUI_OPENRESOURCE_ACTION_HELP_0";

    /** Message constant for key in the resource bundle. */
    public static final String GUI_OPENRESOURCE_ACTION_NAME_0 = "GUI_OPENRESOURCE_ACTION_NAME_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_COLLECTOR_GET_RESULTS_END_1 = "LOG_COLLECTOR_GET_RESULTS_END_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_COLLECTOR_GET_RESULTS_START_0 = "LOG_COLLECTOR_GET_RESULTS_START_0";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_COLLECTOR_PROCESS_ITEMS_END_1 = "LOG_COLLECTOR_PROCESS_ITEMS_END_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_COLLECTOR_PROCESS_ITEMS_START_1 = "LOG_COLLECTOR_PROCESS_ITEMS_START_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_END_ACTION_LIST_2 = "LOG_END_ACTION_LIST_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_END_DETAILS_LIST_2 = "LOG_END_DETAILS_LIST_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_END_INIT_LIST_1 = "LOG_END_INIT_LIST_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_END_METADATA_LIST_1 = "LOG_END_METADATA_LIST_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_END_REFRESH_LIST_1 = "LOG_END_REFRESH_LIST_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_END_WRITE_LIST_1 = "LOG_END_WRITE_LIST_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_START_ACTION_LIST_2 = "LOG_START_ACTION_LIST_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_START_DETAILS_LIST_2 = "LOG_START_DETAILS_LIST_2";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_START_INIT_LIST_1 = "LOG_START_INIT_LIST_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_START_METADATA_LIST_1 = "LOG_START_METADATA_LIST_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_START_REFRESH_LIST_1 = "LOG_START_REFRESH_LIST_1";

    /** Message constant for key in the resource bundle. */
    public static final String LOG_START_WRITE_LIST_1 = "LOG_START_WRITE_LIST_1";

    /** Name of the used resource bundle. */
    private static final String BUNDLE_NAME = "org.opencms.workplace.list.messages";

    /** Static instance member. */
    private static final I_CmsMessageBundle INSTANCE = new Messages();

    /**
     * Hides the public constructor for this utility class.<p>
     */
    private Messages() {

        // hide the constructor
    }

    /**
     * Returns an instance of this localized message accessor.<p>
     * 
     * @return an instance of this localized message accessor
     */
    public static I_CmsMessageBundle get() {

        return INSTANCE;
    }

    /**
     * Returns the bundle name for this OpenCms package.<p>
     * 
     * @return the bundle name for this OpenCms package
     */
    public String getBundleName() {

        return BUNDLE_NAME;
    }
}