/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * trunk/opends/resource/legal-notices/OpenDS.LICENSE
 * or https://OpenDS.dev.java.net/OpenDS.LICENSE.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * trunk/opends/resource/legal-notices/OpenDS.LICENSE.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2008 Sun Microsystems, Inc.
 */
package org.opends.server.admin.std.meta;



import org.opends.server.admin.BooleanPropertyDefinition;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.std.client.OrderingMatchingRuleCfgClient;
import org.opends.server.admin.std.server.MatchingRuleCfg;
import org.opends.server.admin.std.server.OrderingMatchingRuleCfg;
import org.opends.server.admin.Tag;
import org.opends.server.types.DN;



/**
 * An interface for querying the Ordering Matching Rule managed object
 * definition meta information.
 * <p>
 * Ordering Matching Rules define a set of rules for performing
 * ordering matching operations against assertion values.
 */
public final class OrderingMatchingRuleCfgDefn extends ManagedObjectDefinition<OrderingMatchingRuleCfgClient, OrderingMatchingRuleCfg> {

  // The singleton configuration definition instance.
  private static final OrderingMatchingRuleCfgDefn INSTANCE = new OrderingMatchingRuleCfgDefn();



  // Register the tags associated with this managed object definition.
  static {
    INSTANCE.registerTag(Tag.valueOf("core-server"));
  }



  /**
   * Get the Ordering Matching Rule configuration definition
   * singleton.
   *
   * @return Returns the Ordering Matching Rule configuration
   *         definition singleton.
   */
  public static OrderingMatchingRuleCfgDefn getInstance() {
    return INSTANCE;
  }



  /**
   * Private constructor.
   */
  private OrderingMatchingRuleCfgDefn() {
    super("ordering-matching-rule", MatchingRuleCfgDefn.getInstance());
  }



  /**
   * {@inheritDoc}
   */
  public OrderingMatchingRuleCfgClient createClientConfiguration(
      ManagedObject<? extends OrderingMatchingRuleCfgClient> impl) {
    return new OrderingMatchingRuleCfgClientImpl(impl);
  }



  /**
   * {@inheritDoc}
   */
  public OrderingMatchingRuleCfg createServerConfiguration(
      ServerManagedObject<? extends OrderingMatchingRuleCfg> impl) {
    return new OrderingMatchingRuleCfgServerImpl(impl);
  }



  /**
   * {@inheritDoc}
   */
  public Class<OrderingMatchingRuleCfg> getServerConfigurationClass() {
    return OrderingMatchingRuleCfg.class;
  }



  /**
   * Get the "enabled" property definition.
   * <p>
   * Indicates whether the Ordering Matching Rule is enabled for use.
   *
   * @return Returns the "enabled" property definition.
   */
  public BooleanPropertyDefinition getEnabledPropertyDefinition() {
    return MatchingRuleCfgDefn.getInstance().getEnabledPropertyDefinition();
  }



  /**
   * Get the "java-class" property definition.
   * <p>
   * Specifies the fully-qualified name of the Java class that
   * provides the Ordering Matching Rule implementation.
   *
   * @return Returns the "java-class" property definition.
   */
  public ClassPropertyDefinition getJavaClassPropertyDefinition() {
    return MatchingRuleCfgDefn.getInstance().getJavaClassPropertyDefinition();
  }



  /**
   * Managed object client implementation.
   */
  private static class OrderingMatchingRuleCfgClientImpl implements
    OrderingMatchingRuleCfgClient {

    // Private implementation.
    private ManagedObject<? extends OrderingMatchingRuleCfgClient> impl;



    // Private constructor.
    private OrderingMatchingRuleCfgClientImpl(
        ManagedObject<? extends OrderingMatchingRuleCfgClient> impl) {
      this.impl = impl;
    }



    /**
     * {@inheritDoc}
     */
    public Boolean isEnabled() {
      return impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
    }



    /**
     * {@inheritDoc}
     */
    public void setEnabled(boolean value) {
      impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
    }



    /**
     * {@inheritDoc}
     */
    public String getJavaClass() {
      return impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
    }



    /**
     * {@inheritDoc}
     */
    public void setJavaClass(String value) {
      impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
    }



    /**
     * {@inheritDoc}
     */
    public ManagedObjectDefinition<? extends OrderingMatchingRuleCfgClient, ? extends OrderingMatchingRuleCfg> definition() {
      return INSTANCE;
    }



    /**
     * {@inheritDoc}
     */
    public PropertyProvider properties() {
      return impl;
    }



    /**
     * {@inheritDoc}
     */
    public void commit() throws ManagedObjectAlreadyExistsException,
        MissingMandatoryPropertiesException, ConcurrentModificationException,
        OperationRejectedException, AuthorizationException,
        CommunicationException {
      impl.commit();
    }

  }



  /**
   * Managed object server implementation.
   */
  private static class OrderingMatchingRuleCfgServerImpl implements
    OrderingMatchingRuleCfg {

    // Private implementation.
    private ServerManagedObject<? extends OrderingMatchingRuleCfg> impl;

    // The value of the "enabled" property.
    private final boolean pEnabled;

    // The value of the "java-class" property.
    private final String pJavaClass;



    // Private constructor.
    private OrderingMatchingRuleCfgServerImpl(ServerManagedObject<? extends OrderingMatchingRuleCfg> impl) {
      this.impl = impl;
      this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
      this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
    }



    /**
     * {@inheritDoc}
     */
    public void addOrderingChangeListener(
        ConfigurationChangeListener<OrderingMatchingRuleCfg> listener) {
      impl.registerChangeListener(listener);
    }



    /**
     * {@inheritDoc}
     */
    public void removeOrderingChangeListener(
        ConfigurationChangeListener<OrderingMatchingRuleCfg> listener) {
      impl.deregisterChangeListener(listener);
    }
    /**
     * {@inheritDoc}
     */
    public void addChangeListener(
        ConfigurationChangeListener<MatchingRuleCfg> listener) {
      impl.registerChangeListener(listener);
    }



    /**
     * {@inheritDoc}
     */
    public void removeChangeListener(
        ConfigurationChangeListener<MatchingRuleCfg> listener) {
      impl.deregisterChangeListener(listener);
    }



    /**
     * {@inheritDoc}
     */
    public boolean isEnabled() {
      return pEnabled;
    }



    /**
     * {@inheritDoc}
     */
    public String getJavaClass() {
      return pJavaClass;
    }



    /**
     * {@inheritDoc}
     */
    public Class<? extends OrderingMatchingRuleCfg> configurationClass() {
      return OrderingMatchingRuleCfg.class;
    }



    /**
     * {@inheritDoc}
     */
    public DN dn() {
      return impl.getDN();
    }

  }
}
