/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * trunk/opends/resource/legal-notices/OpenDS.LICENSE
 * or https://OpenDS.dev.java.net/OpenDS.LICENSE.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * trunk/opends/resource/legal-notices/OpenDS.LICENSE.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2008 Sun Microsystems, Inc.
 */
package org.opends.server.admin.std.client;



import java.util.Collection;
import java.util.SortedSet;
import org.opends.server.admin.ConfigurationClient;
import org.opends.server.admin.IllegalPropertyValueException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyIsReadOnlyException;
import org.opends.server.admin.std.server.ReplicationServerCfg;



/**
 * A client-side interface for reading and modifying Replication
 * Server settings.
 * <p>
 * Replication Servers publish updates to Directory Servers within a
 * Replication Domain.
 */
public interface ReplicationServerCfgClient extends ConfigurationClient {

  /**
   * Get the configuration definition associated with this Replication Server.
   *
   * @return Returns the configuration definition associated with this Replication Server.
   */
  ManagedObjectDefinition<? extends ReplicationServerCfgClient, ? extends ReplicationServerCfg> definition();



  /**
   * Gets the "queue-size" property.
   * <p>
   * Specifies the number of changes that are kept in memory for each
   * Directory Server in the Replication Domain.
   *
   * @return Returns the value of the "queue-size" property.
   */
  int getQueueSize();



  /**
   * Sets the "queue-size" property.
   * <p>
   * Specifies the number of changes that are kept in memory for each
   * Directory Server in the Replication Domain.
   *
   * @param value The value of the "queue-size" property.
   * @throws IllegalPropertyValueException
   *           If the new value is invalid.
   */
  void setQueueSize(Integer value) throws IllegalPropertyValueException;



  /**
   * Gets the "replication-db-directory" property.
   * <p>
   * The path where the Replication Server stores all persistent
   * information.
   *
   * @return Returns the value of the "replication-db-directory" property.
   */
  String getReplicationDBDirectory();



  /**
   * Sets the "replication-db-directory" property.
   * <p>
   * The path where the Replication Server stores all persistent
   * information.
   * <p>
   * This property is read-only and can only be modified during
   * creation of a Replication Server.
   *
   * @param value The value of the "replication-db-directory" property.
   * @throws IllegalPropertyValueException
   *           If the new value is invalid.
   * @throws PropertyIsReadOnlyException
   *           If this Replication Server is not being initialized.
   */
  void setReplicationDBDirectory(String value) throws IllegalPropertyValueException, PropertyIsReadOnlyException;



  /**
   * Gets the "replication-port" property.
   * <p>
   * The port on which this Replication Server waits for connections
   * from other Replication Servers or Directory Servers.
   *
   * @return Returns the value of the "replication-port" property.
   */
  Integer getReplicationPort();



  /**
   * Sets the "replication-port" property.
   * <p>
   * The port on which this Replication Server waits for connections
   * from other Replication Servers or Directory Servers.
   *
   * @param value The value of the "replication-port" property.
   * @throws IllegalPropertyValueException
   *           If the new value is invalid.
   */
  void setReplicationPort(int value) throws IllegalPropertyValueException;



  /**
   * Gets the "replication-purge-delay" property.
   * <p>
   * The time (in seconds) after which the Replication Server erases
   * all persistent information.
   *
   * @return Returns the value of the "replication-purge-delay" property.
   */
  long getReplicationPurgeDelay();



  /**
   * Sets the "replication-purge-delay" property.
   * <p>
   * The time (in seconds) after which the Replication Server erases
   * all persistent information.
   *
   * @param value The value of the "replication-purge-delay" property.
   * @throws IllegalPropertyValueException
   *           If the new value is invalid.
   */
  void setReplicationPurgeDelay(Long value) throws IllegalPropertyValueException;



  /**
   * Gets the "replication-server" property.
   * <p>
   * Specifies the addresses of other Replication Servers to which
   * this Replication Server tries to connect at startup time.
   * <p>
   * Addresses must be specified using the syntax: hostname:port
   *
   * @return Returns the values of the "replication-server" property.
   */
  SortedSet<String> getReplicationServer();



  /**
   * Sets the "replication-server" property.
   * <p>
   * Specifies the addresses of other Replication Servers to which
   * this Replication Server tries to connect at startup time.
   * <p>
   * Addresses must be specified using the syntax: hostname:port
   *
   * @param values The values of the "replication-server" property.
   * @throws IllegalPropertyValueException
   *           If one or more of the new values are invalid.
   */
  void setReplicationServer(Collection<String> values) throws IllegalPropertyValueException;



  /**
   * Gets the "replication-server-id" property.
   * <p>
   * Specifies a unique identifier for the Replication Server.
   * <p>
   * Each Replication Server must have a different server ID.
   *
   * @return Returns the value of the "replication-server-id" property.
   */
  Integer getReplicationServerId();



  /**
   * Sets the "replication-server-id" property.
   * <p>
   * Specifies a unique identifier for the Replication Server.
   * <p>
   * Each Replication Server must have a different server ID.
   * <p>
   * This property is read-only and can only be modified during
   * creation of a Replication Server.
   *
   * @param value The value of the "replication-server-id" property.
   * @throws IllegalPropertyValueException
   *           If the new value is invalid.
   * @throws PropertyIsReadOnlyException
   *           If this Replication Server is not being initialized.
   */
  void setReplicationServerId(int value) throws IllegalPropertyValueException, PropertyIsReadOnlyException;



  /**
   * Gets the "window-size" property.
   * <p>
   * Specifies the window size that the Replication Server uses when
   * communicating with other Replication Servers.
   *
   * @return Returns the value of the "window-size" property.
   */
  int getWindowSize();



  /**
   * Sets the "window-size" property.
   * <p>
   * Specifies the window size that the Replication Server uses when
   * communicating with other Replication Servers.
   *
   * @param value The value of the "window-size" property.
   * @throws IllegalPropertyValueException
   *           If the new value is invalid.
   */
  void setWindowSize(Integer value) throws IllegalPropertyValueException;

}
