/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * trunk/opends/resource/legal-notices/OpenDS.LICENSE
 * or https://OpenDS.dev.java.net/OpenDS.LICENSE.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * trunk/opends/resource/legal-notices/OpenDS.LICENSE.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2008 Sun Microsystems, Inc.
 */
package org.opends.server.admin.std.server;



import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.types.DN;



/**
 * A server-side interface for querying Digest MD5 SASL Mechanism
 * Handler settings.
 * <p>
 * The DIGEST-MD5 SASL mechanism is used to perform all processing
 * related to SASL DIGEST-MD5 authentication.
 */
public interface DigestMD5SASLMechanismHandlerCfg extends SASLMechanismHandlerCfg {

  /**
   * Gets the configuration class associated with this Digest MD5 SASL Mechanism Handler.
   *
   * @return Returns the configuration class associated with this Digest MD5 SASL Mechanism Handler.
   */
  Class<? extends DigestMD5SASLMechanismHandlerCfg> configurationClass();



  /**
   * Register to be notified when this Digest MD5 SASL Mechanism Handler is changed.
   *
   * @param listener
   *          The Digest MD5 SASL Mechanism Handler configuration change listener.
   */
  void addDigestMD5ChangeListener(ConfigurationChangeListener<DigestMD5SASLMechanismHandlerCfg> listener);



  /**
   * Deregister an existing Digest MD5 SASL Mechanism Handler configuration change listener.
   *
   * @param listener
   *          The Digest MD5 SASL Mechanism Handler configuration change listener.
   */
  void removeDigestMD5ChangeListener(ConfigurationChangeListener<DigestMD5SASLMechanismHandlerCfg> listener);



  /**
   * Gets the "identity-mapper" property.
   * <p>
   * Specifies the name of the identity mapper that is to be used with
   * this SASL mechanism handler to match the authentication or
   * authorization ID included in the SASL bind request to the
   * corresponding user in the directory.
   *
   * @return Returns the value of the "identity-mapper" property.
   */
  String getIdentityMapper();



  /**
   * Gets the "identity-mapper" property as a DN.
   * <p>
   * Specifies the name of the identity mapper that is to be used with
   * this SASL mechanism handler to match the authentication or
   * authorization ID included in the SASL bind request to the
   * corresponding user in the directory.
   *
   * @return Returns the DN value of the "identity-mapper" property.
   */
  DN getIdentityMapperDN();



  /**
   * Gets the "java-class" property.
   * <p>
   * Specifies the fully-qualified name of the Java class that
   * provides the SASL mechanism handler implementation.
   *
   * @return Returns the value of the "java-class" property.
   */
  String getJavaClass();



  /**
   * Gets the "realm" property.
   * <p>
   * Specifies the realm that is to be used by the server for
   * DIGEST-MD5 authentication.
   * <p>
   * If this value is not provided, then the server defaults to use a
   * set of realm names that correspond to the defined suffixes.
   *
   * @return Returns the value of the "realm" property.
   */
  String getRealm();



  /**
   * Gets the "server-fqdn" property.
   * <p>
   * Specifies the DNS-resolvable fully-qualified domain name for the
   * server that is used when validating the digest-uri parameter
   * during the authentication process.
   * <p>
   * If this configuration attribute is present, then the server
   * expects that clients use a digest-uri equal to "ldap/" followed by
   * the value of this attribute. For example, if the attribute has a
   * value of "directory.example.com", then the server expects clients
   * to use a digest-uri of "ldap/directory.example.com". If no value
   * is provided, then the server does not attempt to validate the
   * digest-uri provided by the client and accepts any value.
   *
   * @return Returns the value of the "server-fqdn" property.
   */
  String getServerFqdn();

}
