/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * trunk/opends/resource/legal-notices/OpenDS.LICENSE
 * or https://OpenDS.dev.java.net/OpenDS.LICENSE.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * trunk/opends/resource/legal-notices/OpenDS.LICENSE.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2008 Sun Microsystems, Inc.
 */
package org.opends.server.admin.std.server;



import org.opends.server.admin.server.ConfigurationChangeListener;



/**
 * A server-side interface for querying Equality Matching Rule
 * settings.
 * <p>
 * Equality Matching Rules define a set of rules for performing
 * equality matching operations against assertion values (that is, to
 * determine whether an attribute value equals an assertion value).
 */
public interface EqualityMatchingRuleCfg extends MatchingRuleCfg {

  /**
   * Gets the configuration class associated with this Equality Matching Rule.
   *
   * @return Returns the configuration class associated with this Equality Matching Rule.
   */
  Class<? extends EqualityMatchingRuleCfg> configurationClass();



  /**
   * Register to be notified when this Equality Matching Rule is changed.
   *
   * @param listener
   *          The Equality Matching Rule configuration change listener.
   */
  void addEqualityChangeListener(ConfigurationChangeListener<EqualityMatchingRuleCfg> listener);



  /**
   * Deregister an existing Equality Matching Rule configuration change listener.
   *
   * @param listener
   *          The Equality Matching Rule configuration change listener.
   */
  void removeEqualityChangeListener(ConfigurationChangeListener<EqualityMatchingRuleCfg> listener);

}
