/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * trunk/opends/resource/legal-notices/OpenDS.LICENSE
 * or https://OpenDS.dev.java.net/OpenDS.LICENSE.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * trunk/opends/resource/legal-notices/OpenDS.LICENSE.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2008 Sun Microsystems, Inc.
 */
package org.opends.server.admin.std.server;



import java.util.SortedSet;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.types.DN;



/**
 * A server-side interface for querying Network Group settings.
 * <p>
 * The Network Group is used to classify incoming connections and
 * route requests to workflows.
 */
public interface NetworkGroupCfg extends Configuration {

  /**
   * Gets the configuration class associated with this Network Group.
   *
   * @return Returns the configuration class associated with this Network Group.
   */
  Class<? extends NetworkGroupCfg> configurationClass();



  /**
   * Register to be notified when this Network Group is changed.
   *
   * @param listener
   *          The Network Group configuration change listener.
   */
  void addChangeListener(ConfigurationChangeListener<NetworkGroupCfg> listener);



  /**
   * Deregister an existing Network Group configuration change listener.
   *
   * @param listener
   *          The Network Group configuration change listener.
   */
  void removeChangeListener(ConfigurationChangeListener<NetworkGroupCfg> listener);



  /**
   * Gets the "enabled" property.
   * <p>
   * Indicates whether the Network Group is enabled for use in the
   * server.
   * <p>
   * If a network group is not enabled, its workflows will not be
   * accessible when processing operations.
   *
   * @return Returns the value of the "enabled" property.
   */
  boolean isEnabled();



  /**
   * Gets the "network-group-id" property.
   * <p>
   * Specifies the name that is used to identify the associated
   * Network Group .
   * <p>
   * The name must be unique among all the Network Groups in the
   * server.
   *
   * @return Returns the value of the "network-group-id" property.
   */
  String getNetworkGroupId();



  /**
   * Gets the "workflow" property.
   * <p>
   * Identifies the workflows in the network group.
   *
   * @return Returns an unmodifiable set containing the values of the "workflow" property.
   */
  SortedSet<String> getWorkflow();



  /**
   * Gets the "workflow" property as a set of DNs.
   * <p>
   * Identifies the workflows in the network group.
   *
   * @return Returns the DN values of the "workflow" property.
   */
  SortedSet<DN> getWorkflowDNs();

}
