/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * trunk/opends/resource/legal-notices/OpenDS.LICENSE
 * or https://OpenDS.dev.java.net/OpenDS.LICENSE.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * trunk/opends/resource/legal-notices/OpenDS.LICENSE.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2006-2008 Sun Microsystems, Inc.
 */
package org.opends.server.extensions;


/**
 * This class defines a data structure that will hold state information for use
 * in the DIGEST-MD5 authentication process.  This information will support both
 * the two-stage initial authentication as well as subsequent authentication.
 */
public class DigestMD5StateInfo
{



  // The nonce generated by the server for this authentication session.
  private String nonce;

  // The hex string representation of the nonce count used by the last
  // successful authentication.
  private String nonceCount;



  /**
   * Creates a new instance of this DIGEST-MD5 state info structure.
   *
   * @param  nonce       The nonce generated by the server for this
   *                     authentication session.
   * @param  nonceCount  The hex string representation of the nonce count used
   *                     by the last successful authentication.
   */
  public DigestMD5StateInfo(String nonce, String nonceCount)
  {
    this.nonce      = nonce;
    this.nonceCount = nonceCount;
  }



  /**
   * Retrieves the nonce generated by the server for this authentication
   * session.
   *
   * @return  The nonce generated by the server for this authentication session.
   */
  public String getNonce()
  {
    return nonce;
  }



  /**
   * Retrieves the hex string representation of the nonce count used by the last
   * successful authentication.
   *
   * @return  The hex string representation of the nonce count used by the last
   *          successful authentication.
   */
  public String getNonceCount()
  {
    return nonceCount;
  }



  /**
   * Specifies the hex string representation of the nonce count used by the last
   * successful authentication.
   *
   * @param  nonceCount  The hex string representation of the nonce count used
   *                     by the last successful authentication.
   */
  public void setNonceCount(String nonceCount)
  {
    this.nonceCount = nonceCount;
  }
}

