/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * trunk/opends/resource/legal-notices/OpenDS.LICENSE
 * or https://OpenDS.dev.java.net/OpenDS.LICENSE.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * trunk/opends/resource/legal-notices/OpenDS.LICENSE.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2006-2008 Sun Microsystems, Inc.
 */
package org.opends.server.util;

/**
 * This file contains a number of constants that are used throughout the
 * Directory Server source.  It was dynamically generated as part of the
 * Directory Server build process and should not be edited directly.
 */
@org.opends.server.types.PublicAPI(
     stability=org.opends.server.types.StabilityLevel.UNCOMMITTED,
     mayInstantiate=false,
     mayExtend=false,
     mayInvoke=true)
public final class DynamicConstants
{
  /**
   * The official full product name for the Directory Server.
   */
  public static final String PRODUCT_NAME = "OpenDS Directory Server";

  /**
   * The short product name for the Directory Server.
   */
  public static final String SHORT_NAME = "OpenDS";

  /**
   * The major version number for the Directory Server.
   */
  public static final int MAJOR_VERSION = 1;

  /**
   * The minor version number for the Directory Server.
   */
  public static final int MINOR_VERSION = 0;

  /**
   * The point version number for the Directory Server.
   */
  public static final int POINT_VERSION = 0;

  /**
   * The official build number for the Directory Server.
   */
  public static final int BUILD_NUMBER = -1;

  /**
   * The version qualifier string for the Directory Server.
   */
  public static final String VERSION_QUALIFIER = "";

  /**
   * The set of bug IDs for fixes included in this build of the Directory
   * Server.
   */
  public static final String FIX_IDS = "";

  /**
   * The build ID for the generated build of the Directory Server.
   */
  public static final String BUILD_ID = "20080610152800Z";

  /**
   * The username of the user that created this build.
   */
  public static final String BUILD_USER = "builds";

  /**
   * The Java version used to generate this build.
   */
  public static final String BUILD_JAVA_VERSION = "1.5.0_12";

  /**
   * The vendor for the Java version used to generate this build.
   */
  public static final String BUILD_JAVA_VENDOR = "Sun Microsystems Inc.";

  /**
   * The JVM version used to generate this build.
   */
  public static final String BUILD_JVM_VERSION = "1.5.0_12-b04";

  /**
   * The vendor for the JVM used to generate this build.
   */
  public static final String BUILD_JVM_VENDOR = "Sun Microsystems Inc.";

  /**
   * The operating system on which this build was generated.
   */
  public static final String BUILD_OS = "SunOS 5.10 x86";

  /**
   * Indicates whether this is a debug build of the Directory Server that may
   * include additional debugging facilities not available in standard release
   * versions.
   */
  public static final boolean DEBUG_BUILD = false;

  /**
   * The Subversion revision number on which this build is based.
   */
  public static final long REVISION_NUMBER = 4337;

  /**
   * Indicates wheater this build includes AspectJ weaving for the debug logging
   * framework.
   */
  public static final boolean WEAVE_ENABLED = false;

  /**
   * A string representation of the version number.
   */
  public static final String VERSION_NUMBER_STRING =
       "1.0.0";

  /**
   * A compact version string for this product, suitable for use in path
   * names and similar cases.
   */
  public static final String COMPACT_VERSION_STRING =
       SHORT_NAME + "-" + VERSION_NUMBER_STRING;

  /**
   * A full version string for this product.
   */
  public static final String FULL_VERSION_STRING =
       PRODUCT_NAME + " " + VERSION_NUMBER_STRING +
       (((FIX_IDS != null) && (FIX_IDS.length() > 0))
        ? "+" + FIX_IDS
        : "");

  /**
   * A printable version string for this product.
   */
  public static final String PRINTABLE_VERSION_STRING =
       FULL_VERSION_STRING + System.getProperty("line.separator") +
       "Build " + BUILD_ID + System.getProperty("line.separator");
}
