/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * trunk/opends/resource/legal-notices/OpenDS.LICENSE
 * or https://OpenDS.dev.java.net/OpenDS.LICENSE.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * trunk/opends/resource/legal-notices/OpenDS.LICENSE.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2008 Sun Microsystems, Inc.
 */
package org.opends.server.admin.std.meta;



import org.opends.server.admin.BooleanPropertyDefinition;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.std.client.ApproximateMatchingRuleCfgClient;
import org.opends.server.admin.std.server.ApproximateMatchingRuleCfg;
import org.opends.server.admin.std.server.MatchingRuleCfg;
import org.opends.server.admin.Tag;
import org.opends.server.types.DN;



/**
 * An interface for querying the Approximate Matching Rule managed
 * object definition meta information.
 * <p>
 * Approximate Matching Rules define a set of rules for performing
 * approximate matching operations against assertion values. In many
 * cases, approximate matching is based on a "sounds like" operation.
 */
public final class ApproximateMatchingRuleCfgDefn extends ManagedObjectDefinition<ApproximateMatchingRuleCfgClient, ApproximateMatchingRuleCfg> {

  // The singleton configuration definition instance.
  private static final ApproximateMatchingRuleCfgDefn INSTANCE = new ApproximateMatchingRuleCfgDefn();



  // Register the tags associated with this managed object definition.
  static {
    INSTANCE.registerTag(Tag.valueOf("core-server"));
  }



  /**
   * Get the Approximate Matching Rule configuration definition
   * singleton.
   *
   * @return Returns the Approximate Matching Rule configuration
   *         definition singleton.
   */
  public static ApproximateMatchingRuleCfgDefn getInstance() {
    return INSTANCE;
  }



  /**
   * Private constructor.
   */
  private ApproximateMatchingRuleCfgDefn() {
    super("approximate-matching-rule", MatchingRuleCfgDefn.getInstance());
  }



  /**
   * {@inheritDoc}
   */
  public ApproximateMatchingRuleCfgClient createClientConfiguration(
      ManagedObject<? extends ApproximateMatchingRuleCfgClient> impl) {
    return new ApproximateMatchingRuleCfgClientImpl(impl);
  }



  /**
   * {@inheritDoc}
   */
  public ApproximateMatchingRuleCfg createServerConfiguration(
      ServerManagedObject<? extends ApproximateMatchingRuleCfg> impl) {
    return new ApproximateMatchingRuleCfgServerImpl(impl);
  }



  /**
   * {@inheritDoc}
   */
  public Class<ApproximateMatchingRuleCfg> getServerConfigurationClass() {
    return ApproximateMatchingRuleCfg.class;
  }



  /**
   * Get the "enabled" property definition.
   * <p>
   * Indicates whether the Approximate Matching Rule is enabled for
   * use.
   *
   * @return Returns the "enabled" property definition.
   */
  public BooleanPropertyDefinition getEnabledPropertyDefinition() {
    return MatchingRuleCfgDefn.getInstance().getEnabledPropertyDefinition();
  }



  /**
   * Get the "java-class" property definition.
   * <p>
   * Specifies the fully-qualified name of the Java class that
   * provides the Approximate Matching Rule implementation.
   *
   * @return Returns the "java-class" property definition.
   */
  public ClassPropertyDefinition getJavaClassPropertyDefinition() {
    return MatchingRuleCfgDefn.getInstance().getJavaClassPropertyDefinition();
  }



  /**
   * Managed object client implementation.
   */
  private static class ApproximateMatchingRuleCfgClientImpl implements
    ApproximateMatchingRuleCfgClient {

    // Private implementation.
    private ManagedObject<? extends ApproximateMatchingRuleCfgClient> impl;



    // Private constructor.
    private ApproximateMatchingRuleCfgClientImpl(
        ManagedObject<? extends ApproximateMatchingRuleCfgClient> impl) {
      this.impl = impl;
    }



    /**
     * {@inheritDoc}
     */
    public Boolean isEnabled() {
      return impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
    }



    /**
     * {@inheritDoc}
     */
    public void setEnabled(boolean value) {
      impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
    }



    /**
     * {@inheritDoc}
     */
    public String getJavaClass() {
      return impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
    }



    /**
     * {@inheritDoc}
     */
    public void setJavaClass(String value) {
      impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
    }



    /**
     * {@inheritDoc}
     */
    public ManagedObjectDefinition<? extends ApproximateMatchingRuleCfgClient, ? extends ApproximateMatchingRuleCfg> definition() {
      return INSTANCE;
    }



    /**
     * {@inheritDoc}
     */
    public PropertyProvider properties() {
      return impl;
    }



    /**
     * {@inheritDoc}
     */
    public void commit() throws ManagedObjectAlreadyExistsException,
        MissingMandatoryPropertiesException, ConcurrentModificationException,
        OperationRejectedException, AuthorizationException,
        CommunicationException {
      impl.commit();
    }

  }



  /**
   * Managed object server implementation.
   */
  private static class ApproximateMatchingRuleCfgServerImpl implements
    ApproximateMatchingRuleCfg {

    // Private implementation.
    private ServerManagedObject<? extends ApproximateMatchingRuleCfg> impl;

    // The value of the "enabled" property.
    private final boolean pEnabled;

    // The value of the "java-class" property.
    private final String pJavaClass;



    // Private constructor.
    private ApproximateMatchingRuleCfgServerImpl(ServerManagedObject<? extends ApproximateMatchingRuleCfg> impl) {
      this.impl = impl;
      this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
      this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
    }



    /**
     * {@inheritDoc}
     */
    public void addApproximateChangeListener(
        ConfigurationChangeListener<ApproximateMatchingRuleCfg> listener) {
      impl.registerChangeListener(listener);
    }



    /**
     * {@inheritDoc}
     */
    public void removeApproximateChangeListener(
        ConfigurationChangeListener<ApproximateMatchingRuleCfg> listener) {
      impl.deregisterChangeListener(listener);
    }
    /**
     * {@inheritDoc}
     */
    public void addChangeListener(
        ConfigurationChangeListener<MatchingRuleCfg> listener) {
      impl.registerChangeListener(listener);
    }



    /**
     * {@inheritDoc}
     */
    public void removeChangeListener(
        ConfigurationChangeListener<MatchingRuleCfg> listener) {
      impl.deregisterChangeListener(listener);
    }



    /**
     * {@inheritDoc}
     */
    public boolean isEnabled() {
      return pEnabled;
    }



    /**
     * {@inheritDoc}
     */
    public String getJavaClass() {
      return pJavaClass;
    }



    /**
     * {@inheritDoc}
     */
    public Class<? extends ApproximateMatchingRuleCfg> configurationClass() {
      return ApproximateMatchingRuleCfg.class;
    }



    /**
     * {@inheritDoc}
     */
    public DN dn() {
      return impl.getDN();
    }

  }
}
