/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * trunk/opends/resource/legal-notices/OpenDS.LICENSE
 * or https://OpenDS.dev.java.net/OpenDS.LICENSE.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * trunk/opends/resource/legal-notices/OpenDS.LICENSE.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2008 Sun Microsystems, Inc.
 */
package org.opends.server.admin.std.client;



import org.opends.server.admin.IllegalPropertyValueException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.std.server.AccessLogPublisherCfg;



/**
 * A client-side interface for reading and modifying Access Log
 * Publisher settings.
 * <p>
 * Access Log Publishers are responsible for distributing access log
 * messages from the access logger to a destination.
 */
public interface AccessLogPublisherCfgClient extends LogPublisherCfgClient {

  /**
   * Get the configuration definition associated with this Access Log Publisher.
   *
   * @return Returns the configuration definition associated with this Access Log Publisher.
   */
  ManagedObjectDefinition<? extends AccessLogPublisherCfgClient, ? extends AccessLogPublisherCfg> definition();



  /**
   * Gets the "java-class" property.
   * <p>
   * The fully-qualified name of the Java class that provides the
   * Access Log Publisher implementation.
   *
   * @return Returns the value of the "java-class" property.
   */
  String getJavaClass();



  /**
   * Sets the "java-class" property.
   * <p>
   * The fully-qualified name of the Java class that provides the
   * Access Log Publisher implementation.
   *
   * @param value The value of the "java-class" property.
   * @throws IllegalPropertyValueException
   *           If the new value is invalid.
   */
  void setJavaClass(String value) throws IllegalPropertyValueException;



  /**
   * Gets the "suppress-internal-operations" property.
   * <p>
   * Indicates whether internal operations (for example, operations
   * that are initiated by plugins) should be logged along with the
   * operations that are requested by users.
   *
   * @return Returns the value of the "suppress-internal-operations" property.
   */
  boolean isSuppressInternalOperations();



  /**
   * Sets the "suppress-internal-operations" property.
   * <p>
   * Indicates whether internal operations (for example, operations
   * that are initiated by plugins) should be logged along with the
   * operations that are requested by users.
   *
   * @param value The value of the "suppress-internal-operations" property.
   * @throws IllegalPropertyValueException
   *           If the new value is invalid.
   */
  void setSuppressInternalOperations(Boolean value) throws IllegalPropertyValueException;



  /**
   * Gets the "suppress-synchronization-operations" property.
   * <p>
   * Indicates whether access messages that are generated by
   * synchronization operations should be suppressed.
   *
   * @return Returns the value of the "suppress-synchronization-operations" property.
   */
  boolean isSuppressSynchronizationOperations();



  /**
   * Sets the "suppress-synchronization-operations" property.
   * <p>
   * Indicates whether access messages that are generated by
   * synchronization operations should be suppressed.
   *
   * @param value The value of the "suppress-synchronization-operations" property.
   * @throws IllegalPropertyValueException
   *           If the new value is invalid.
   */
  void setSuppressSynchronizationOperations(Boolean value) throws IllegalPropertyValueException;

}
