/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * trunk/opends/resource/legal-notices/OpenDS.LICENSE
 * or https://OpenDS.dev.java.net/OpenDS.LICENSE.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * trunk/opends/resource/legal-notices/OpenDS.LICENSE.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2008 Sun Microsystems, Inc.
 */
package org.opends.server.admin.std.client;



import java.util.Collection;
import java.util.SortedSet;
import org.opends.server.admin.ConfigurationClient;
import org.opends.server.admin.IllegalPropertyValueException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyIsReadOnlyException;
import org.opends.server.admin.std.server.NetworkGroupCfg;



/**
 * A client-side interface for reading and modifying Network Group
 * settings.
 * <p>
 * The Network Group is used to classify incoming connections and
 * route requests to workflows.
 */
public interface NetworkGroupCfgClient extends ConfigurationClient {

  /**
   * Get the configuration definition associated with this Network Group.
   *
   * @return Returns the configuration definition associated with this Network Group.
   */
  ManagedObjectDefinition<? extends NetworkGroupCfgClient, ? extends NetworkGroupCfg> definition();



  /**
   * Gets the "enabled" property.
   * <p>
   * Indicates whether the Network Group is enabled for use in the
   * server.
   * <p>
   * If a network group is not enabled, its workflows will not be
   * accessible when processing operations.
   *
   * @return Returns the value of the "enabled" property.
   */
  Boolean isEnabled();



  /**
   * Sets the "enabled" property.
   * <p>
   * Indicates whether the Network Group is enabled for use in the
   * server.
   * <p>
   * If a network group is not enabled, its workflows will not be
   * accessible when processing operations.
   *
   * @param value The value of the "enabled" property.
   * @throws IllegalPropertyValueException
   *           If the new value is invalid.
   */
  void setEnabled(boolean value) throws IllegalPropertyValueException;



  /**
   * Gets the "network-group-id" property.
   * <p>
   * Specifies the name that is used to identify the associated
   * Network Group .
   * <p>
   * The name must be unique among all the Network Groups in the
   * server.
   *
   * @return Returns the value of the "network-group-id" property.
   */
  String getNetworkGroupId();



  /**
   * Sets the "network-group-id" property.
   * <p>
   * Specifies the name that is used to identify the associated
   * Network Group .
   * <p>
   * The name must be unique among all the Network Groups in the
   * server.
   * <p>
   * This property is read-only and can only be modified during
   * creation of a Network Group.
   *
   * @param value The value of the "network-group-id" property.
   * @throws IllegalPropertyValueException
   *           If the new value is invalid.
   * @throws PropertyIsReadOnlyException
   *           If this Network Group is not being initialized.
   */
  void setNetworkGroupId(String value) throws IllegalPropertyValueException, PropertyIsReadOnlyException;



  /**
   * Gets the "workflow" property.
   * <p>
   * Identifies the workflows in the network group.
   *
   * @return Returns the values of the "workflow" property.
   */
  SortedSet<String> getWorkflow();



  /**
   * Sets the "workflow" property.
   * <p>
   * Identifies the workflows in the network group.
   * <p>
   * This property is read-only and can only be modified during
   * creation of a Network Group.
   *
   * @param values The values of the "workflow" property.
   * @throws IllegalPropertyValueException
   *           If one or more of the new values are invalid.
   * @throws PropertyIsReadOnlyException
   *           If this Network Group is not being initialized.
   */
  void setWorkflow(Collection<String> values) throws IllegalPropertyValueException, PropertyIsReadOnlyException;

}
