/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * trunk/opends/resource/legal-notices/OpenDS.LICENSE
 * or https://OpenDS.dev.java.net/OpenDS.LICENSE.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * trunk/opends/resource/legal-notices/OpenDS.LICENSE.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2008 Sun Microsystems, Inc.
 */
package org.opends.server.admin.std.server;



import java.util.SortedSet;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.meta.NetworkGroupRequestFilteringPolicyCfgDefn.AllowedOperations;
import org.opends.server.admin.std.meta.NetworkGroupRequestFilteringPolicyCfgDefn.AllowedSearchScopes;
import org.opends.server.types.DN;



/**
 * A server-side interface for querying Network Group Request
 * Filtering Policy settings.
 * <p>
 * The Network Group Request Filtering Policy is used to define the
 * type of requests allowed in the network group.
 */
public interface NetworkGroupRequestFilteringPolicyCfg extends Configuration {

  /**
   * Gets the configuration class associated with this Network Group Request Filtering Policy.
   *
   * @return Returns the configuration class associated with this Network Group Request Filtering Policy.
   */
  Class<? extends NetworkGroupRequestFilteringPolicyCfg> configurationClass();



  /**
   * Register to be notified when this Network Group Request Filtering Policy is changed.
   *
   * @param listener
   *          The Network Group Request Filtering Policy configuration change listener.
   */
  void addChangeListener(ConfigurationChangeListener<NetworkGroupRequestFilteringPolicyCfg> listener);



  /**
   * Deregister an existing Network Group Request Filtering Policy configuration change listener.
   *
   * @param listener
   *          The Network Group Request Filtering Policy configuration change listener.
   */
  void removeChangeListener(ConfigurationChangeListener<NetworkGroupRequestFilteringPolicyCfg> listener);



  /**
   * Gets the "allowed-attributes" property.
   * <p>
   * Specifies which attributes are allowed in search and compare
   * operations.
   * <p>
   * When this attribute is specified, only the listed attributes are
   * allowed in search and compare operations. If it is not set, all
   * the attributes are allowed, except those listed in
   * ds-cfg-prohibited-attributes.
   *
   * @return Returns an unmodifiable set containing the values of the "allowed-attributes" property.
   */
  SortedSet<String> getAllowedAttributes();



  /**
   * Gets the "allowed-operations" property.
   * <p>
   * Specifies which operations are allowed in the network group.
   * <p>
   * When this attribute is specified, only the listed operations are
   * allowed in the network group. If the attribute is not defined, all
   * the operations are allowed.
   *
   * @return Returns an unmodifiable set containing the values of the "allowed-operations" property.
   */
  SortedSet<AllowedOperations> getAllowedOperations();



  /**
   * Gets the "allowed-search-scopes" property.
   * <p>
   * Specifies which search scopes are allowed in the network group.
   * <p>
   * When this attribute is specified, only the listed scopes are
   * allowed in the network group. If it is not set, all search scopes
   * are allowed.
   *
   * @return Returns an unmodifiable set containing the values of the "allowed-search-scopes" property.
   */
  SortedSet<AllowedSearchScopes> getAllowedSearchScopes();



  /**
   * Gets the "allowed-subtrees" property.
   * <p>
   * Specifies which subtrees are exposed to clients.
   * <p>
   * When this attribute is specified, only the listed subtrees are
   * exposed. If it is not set, all the substrees are exposed. Note
   * that ds-cfg-prohibited-subtrees restricts the list of exposed
   * subtrees.
   *
   * @return Returns an unmodifiable set containing the values of the "allowed-subtrees" property.
   */
  SortedSet<DN> getAllowedSubtrees();



  /**
   * Gets the "prohibited-attributes" property.
   * <p>
   * Specifies which attributes are not allowed in search and compare
   * operations.
   * <p>
   * When this attribute is specified, all the listed attributes are
   * prohibited in search and compare operations. It should not be used
   * in conjunction with ds-cfg-allowed-attributes.
   *
   * @return Returns an unmodifiable set containing the values of the "prohibited-attributes" property.
   */
  SortedSet<String> getProhibitedAttributes();



  /**
   * Gets the "prohibited-subtrees" property.
   * <p>
   * Specifies which subtrees are not exposed to clients. Each
   * prohibited subtree must be subordinate to an allowed subtree.
   * <p>
   * When this attribute is specified, all the listed subtrees cannot
   * be accessed.
   *
   * @return Returns an unmodifiable set containing the values of the "prohibited-subtrees" property.
   */
  SortedSet<DN> getProhibitedSubtrees();

}
