/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * trunk/opends/resource/legal-notices/OpenDS.LICENSE
 * or https://OpenDS.dev.java.net/OpenDS.LICENSE.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * trunk/opends/resource/legal-notices/OpenDS.LICENSE.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2008 Sun Microsystems, Inc.
 */
package org.opends.server.admin.std.client;



import java.util.Collection;
import java.util.SortedSet;
import org.opends.server.admin.ConfigurationClient;
import org.opends.server.admin.IllegalPropertyValueException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.std.meta.NetworkGroupRequestFilteringPolicyCfgDefn.AllowedOperations;
import org.opends.server.admin.std.meta.NetworkGroupRequestFilteringPolicyCfgDefn.AllowedSearchScopes;
import org.opends.server.admin.std.server.NetworkGroupRequestFilteringPolicyCfg;
import org.opends.server.types.DN;



/**
 * A client-side interface for reading and modifying Network Group
 * Request Filtering Policy settings.
 * <p>
 * The Network Group Request Filtering Policy is used to define the
 * type of requests allowed in the network group.
 */
public interface NetworkGroupRequestFilteringPolicyCfgClient extends ConfigurationClient {

  /**
   * Get the configuration definition associated with this Network Group Request Filtering Policy.
   *
   * @return Returns the configuration definition associated with this Network Group Request Filtering Policy.
   */
  ManagedObjectDefinition<? extends NetworkGroupRequestFilteringPolicyCfgClient, ? extends NetworkGroupRequestFilteringPolicyCfg> definition();



  /**
   * Gets the "allowed-attributes" property.
   * <p>
   * Specifies which attributes are allowed in search and compare
   * operations.
   * <p>
   * When this attribute is specified, only the listed attributes are
   * allowed in search and compare operations. If it is not set, all
   * the attributes are allowed, except those listed in
   * ds-cfg-prohibited-attributes.
   *
   * @return Returns the values of the "allowed-attributes" property.
   */
  SortedSet<String> getAllowedAttributes();



  /**
   * Sets the "allowed-attributes" property.
   * <p>
   * Specifies which attributes are allowed in search and compare
   * operations.
   * <p>
   * When this attribute is specified, only the listed attributes are
   * allowed in search and compare operations. If it is not set, all
   * the attributes are allowed, except those listed in
   * ds-cfg-prohibited-attributes.
   *
   * @param values The values of the "allowed-attributes" property.
   * @throws IllegalPropertyValueException
   *           If one or more of the new values are invalid.
   */
  void setAllowedAttributes(Collection<String> values) throws IllegalPropertyValueException;



  /**
   * Gets the "allowed-operations" property.
   * <p>
   * Specifies which operations are allowed in the network group.
   * <p>
   * When this attribute is specified, only the listed operations are
   * allowed in the network group. If the attribute is not defined, all
   * the operations are allowed.
   *
   * @return Returns the values of the "allowed-operations" property.
   */
  SortedSet<AllowedOperations> getAllowedOperations();



  /**
   * Sets the "allowed-operations" property.
   * <p>
   * Specifies which operations are allowed in the network group.
   * <p>
   * When this attribute is specified, only the listed operations are
   * allowed in the network group. If the attribute is not defined, all
   * the operations are allowed.
   *
   * @param values The values of the "allowed-operations" property.
   * @throws IllegalPropertyValueException
   *           If one or more of the new values are invalid.
   */
  void setAllowedOperations(Collection<AllowedOperations> values) throws IllegalPropertyValueException;



  /**
   * Gets the "allowed-search-scopes" property.
   * <p>
   * Specifies which search scopes are allowed in the network group.
   * <p>
   * When this attribute is specified, only the listed scopes are
   * allowed in the network group. If it is not set, all search scopes
   * are allowed.
   *
   * @return Returns the values of the "allowed-search-scopes" property.
   */
  SortedSet<AllowedSearchScopes> getAllowedSearchScopes();



  /**
   * Sets the "allowed-search-scopes" property.
   * <p>
   * Specifies which search scopes are allowed in the network group.
   * <p>
   * When this attribute is specified, only the listed scopes are
   * allowed in the network group. If it is not set, all search scopes
   * are allowed.
   *
   * @param values The values of the "allowed-search-scopes" property.
   * @throws IllegalPropertyValueException
   *           If one or more of the new values are invalid.
   */
  void setAllowedSearchScopes(Collection<AllowedSearchScopes> values) throws IllegalPropertyValueException;



  /**
   * Gets the "allowed-subtrees" property.
   * <p>
   * Specifies which subtrees are exposed to clients.
   * <p>
   * When this attribute is specified, only the listed subtrees are
   * exposed. If it is not set, all the substrees are exposed. Note
   * that ds-cfg-prohibited-subtrees restricts the list of exposed
   * subtrees.
   *
   * @return Returns the values of the "allowed-subtrees" property.
   */
  SortedSet<DN> getAllowedSubtrees();



  /**
   * Sets the "allowed-subtrees" property.
   * <p>
   * Specifies which subtrees are exposed to clients.
   * <p>
   * When this attribute is specified, only the listed subtrees are
   * exposed. If it is not set, all the substrees are exposed. Note
   * that ds-cfg-prohibited-subtrees restricts the list of exposed
   * subtrees.
   *
   * @param values The values of the "allowed-subtrees" property.
   * @throws IllegalPropertyValueException
   *           If one or more of the new values are invalid.
   */
  void setAllowedSubtrees(Collection<DN> values) throws IllegalPropertyValueException;



  /**
   * Gets the "prohibited-attributes" property.
   * <p>
   * Specifies which attributes are not allowed in search and compare
   * operations.
   * <p>
   * When this attribute is specified, all the listed attributes are
   * prohibited in search and compare operations. It should not be used
   * in conjunction with ds-cfg-allowed-attributes.
   *
   * @return Returns the values of the "prohibited-attributes" property.
   */
  SortedSet<String> getProhibitedAttributes();



  /**
   * Sets the "prohibited-attributes" property.
   * <p>
   * Specifies which attributes are not allowed in search and compare
   * operations.
   * <p>
   * When this attribute is specified, all the listed attributes are
   * prohibited in search and compare operations. It should not be used
   * in conjunction with ds-cfg-allowed-attributes.
   *
   * @param values The values of the "prohibited-attributes" property.
   * @throws IllegalPropertyValueException
   *           If one or more of the new values are invalid.
   */
  void setProhibitedAttributes(Collection<String> values) throws IllegalPropertyValueException;



  /**
   * Gets the "prohibited-subtrees" property.
   * <p>
   * Specifies which subtrees are not exposed to clients. Each
   * prohibited subtree must be subordinate to an allowed subtree.
   * <p>
   * When this attribute is specified, all the listed subtrees cannot
   * be accessed.
   *
   * @return Returns the values of the "prohibited-subtrees" property.
   */
  SortedSet<DN> getProhibitedSubtrees();



  /**
   * Sets the "prohibited-subtrees" property.
   * <p>
   * Specifies which subtrees are not exposed to clients. Each
   * prohibited subtree must be subordinate to an allowed subtree.
   * <p>
   * When this attribute is specified, all the listed subtrees cannot
   * be accessed.
   *
   * @param values The values of the "prohibited-subtrees" property.
   * @throws IllegalPropertyValueException
   *           If one or more of the new values are invalid.
   */
  void setProhibitedSubtrees(Collection<DN> values) throws IllegalPropertyValueException;

}
