/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * trunk/opends/resource/legal-notices/OpenDS.LICENSE
 * or https://OpenDS.dev.java.net/OpenDS.LICENSE.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * trunk/opends/resource/legal-notices/OpenDS.LICENSE.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2008 Sun Microsystems, Inc.
 */
package org.opends.server.admin.std.client;



import org.opends.server.admin.ConfigurationClient;
import org.opends.server.admin.IllegalPropertyValueException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.std.meta.NetworkGroupResourceLimitsCfgDefn.ReferralBindPolicy;
import org.opends.server.admin.std.meta.NetworkGroupResourceLimitsCfgDefn.ReferralPolicy;
import org.opends.server.admin.std.server.NetworkGroupResourceLimitsCfg;



/**
 * A client-side interface for reading and modifying Network Group
 * Resource Limits settings.
 * <p>
 * The Network Group Resource Limits are used to define resource
 * limits enforced by the network group.
 */
public interface NetworkGroupResourceLimitsCfgClient extends ConfigurationClient {

  /**
   * Get the configuration definition associated with this Network Group Resource Limits.
   *
   * @return Returns the configuration definition associated with this Network Group Resource Limits.
   */
  ManagedObjectDefinition<? extends NetworkGroupResourceLimitsCfgClient, ? extends NetworkGroupResourceLimitsCfg> definition();



  /**
   * Gets the "max-concurrent-ops-per-connection" property.
   * <p>
   * Specifies the maximum number of concurrent operations per
   * connection.
   * <p>
   * A value of 0 means that no limit is enforced.
   *
   * @return Returns the value of the "max-concurrent-ops-per-connection" property.
   */
  int getMaxConcurrentOpsPerConnection();



  /**
   * Sets the "max-concurrent-ops-per-connection" property.
   * <p>
   * Specifies the maximum number of concurrent operations per
   * connection.
   * <p>
   * A value of 0 means that no limit is enforced.
   *
   * @param value The value of the "max-concurrent-ops-per-connection" property.
   * @throws IllegalPropertyValueException
   *           If the new value is invalid.
   */
  void setMaxConcurrentOpsPerConnection(Integer value) throws IllegalPropertyValueException;



  /**
   * Gets the "max-connections" property.
   * <p>
   * Specifies the maximum number of connections in the network group.
   * <p>
   * A value of 0 means that no limit is enforced.
   *
   * @return Returns the value of the "max-connections" property.
   */
  int getMaxConnections();



  /**
   * Sets the "max-connections" property.
   * <p>
   * Specifies the maximum number of connections in the network group.
   * <p>
   * A value of 0 means that no limit is enforced.
   *
   * @param value The value of the "max-connections" property.
   * @throws IllegalPropertyValueException
   *           If the new value is invalid.
   */
  void setMaxConnections(Integer value) throws IllegalPropertyValueException;



  /**
   * Gets the "max-connections-from-same-ip" property.
   * <p>
   * Specifies the maximum number of connections from the same client
   * (identified by its IP address).
   * <p>
   * A value of 0 means that no limit is enforced.
   *
   * @return Returns the value of the "max-connections-from-same-ip" property.
   */
  int getMaxConnectionsFromSameIP();



  /**
   * Sets the "max-connections-from-same-ip" property.
   * <p>
   * Specifies the maximum number of connections from the same client
   * (identified by its IP address).
   * <p>
   * A value of 0 means that no limit is enforced.
   *
   * @param value The value of the "max-connections-from-same-ip" property.
   * @throws IllegalPropertyValueException
   *           If the new value is invalid.
   */
  void setMaxConnectionsFromSameIP(Integer value) throws IllegalPropertyValueException;



  /**
   * Gets the "max-ops-per-connection" property.
   * <p>
   * Specifies the maximum number of operations per connection.
   * <p>
   * A value of 0 means that no limit is enforced.
   *
   * @return Returns the value of the "max-ops-per-connection" property.
   */
  int getMaxOpsPerConnection();



  /**
   * Sets the "max-ops-per-connection" property.
   * <p>
   * Specifies the maximum number of operations per connection.
   * <p>
   * A value of 0 means that no limit is enforced.
   *
   * @param value The value of the "max-ops-per-connection" property.
   * @throws IllegalPropertyValueException
   *           If the new value is invalid.
   */
  void setMaxOpsPerConnection(Integer value) throws IllegalPropertyValueException;



  /**
   * Gets the "min-substring-length" property.
   * <p>
   * Specifies the minimum length for a search substring.
   * <p>
   * Search operations with short search substring are likely to match
   * a high number of entries and might degrade performances. A value
   * of 0 indicates that no limit is enforced.
   *
   * @return Returns the value of the "min-substring-length" property.
   */
  int getMinSubstringLength();



  /**
   * Sets the "min-substring-length" property.
   * <p>
   * Specifies the minimum length for a search substring.
   * <p>
   * Search operations with short search substring are likely to match
   * a high number of entries and might degrade performances. A value
   * of 0 indicates that no limit is enforced.
   *
   * @param value The value of the "min-substring-length" property.
   * @throws IllegalPropertyValueException
   *           If the new value is invalid.
   */
  void setMinSubstringLength(Integer value) throws IllegalPropertyValueException;



  /**
   * Gets the "referral-bind-policy" property.
   * <p>
   * Specifies the referral bind policy.
   * <p>
   * The referral bind policy is used only when the referral policy is
   * set to "follow". It specifies whether the referral is followed
   * with the client bind DN and password or anonymously.
   *
   * @return Returns the value of the "referral-bind-policy" property.
   */
  ReferralBindPolicy getReferralBindPolicy();



  /**
   * Sets the "referral-bind-policy" property.
   * <p>
   * Specifies the referral bind policy.
   * <p>
   * The referral bind policy is used only when the referral policy is
   * set to "follow". It specifies whether the referral is followed
   * with the client bind DN and password or anonymously.
   *
   * @param value The value of the "referral-bind-policy" property.
   * @throws IllegalPropertyValueException
   *           If the new value is invalid.
   */
  void setReferralBindPolicy(ReferralBindPolicy value) throws IllegalPropertyValueException;



  /**
   * Gets the "referral-hop-limit" property.
   * <p>
   * Specifies the maximum number of hops when following referrals.
   * <p>
   * A value of 0 means that no limit is enforced.
   *
   * @return Returns the value of the "referral-hop-limit" property.
   */
  int getReferralHopLimit();



  /**
   * Sets the "referral-hop-limit" property.
   * <p>
   * Specifies the maximum number of hops when following referrals.
   * <p>
   * A value of 0 means that no limit is enforced.
   *
   * @param value The value of the "referral-hop-limit" property.
   * @throws IllegalPropertyValueException
   *           If the new value is invalid.
   */
  void setReferralHopLimit(Integer value) throws IllegalPropertyValueException;



  /**
   * Gets the "referral-policy" property.
   * <p>
   * Specifies the referral policy.
   * <p>
   * The referral policy defines the behavior when a referral is
   * received. The server can either discard the referral, forward the
   * referral to the client or follow the referral.
   *
   * @return Returns the value of the "referral-policy" property.
   */
  ReferralPolicy getReferralPolicy();



  /**
   * Sets the "referral-policy" property.
   * <p>
   * Specifies the referral policy.
   * <p>
   * The referral policy defines the behavior when a referral is
   * received. The server can either discard the referral, forward the
   * referral to the client or follow the referral.
   *
   * @param value The value of the "referral-policy" property.
   * @throws IllegalPropertyValueException
   *           If the new value is invalid.
   */
  void setReferralPolicy(ReferralPolicy value) throws IllegalPropertyValueException;



  /**
   * Gets the "search-size-limit" property.
   * <p>
   * Specifies the maximum number of entries that the Directory Server
   * should return to the client during a search operation.
   * <p>
   * A value of 0 indicates that no size limit is enforced. Note that
   * this is the network-group limit, but it may be overridden on a
   * per-user basis.
   *
   * @return Returns the value of the "search-size-limit" property.
   */
  Integer getSearchSizeLimit();



  /**
   * Sets the "search-size-limit" property.
   * <p>
   * Specifies the maximum number of entries that the Directory Server
   * should return to the client during a search operation.
   * <p>
   * A value of 0 indicates that no size limit is enforced. Note that
   * this is the network-group limit, but it may be overridden on a
   * per-user basis.
   *
   * @param value The value of the "search-size-limit" property.
   * @throws IllegalPropertyValueException
   *           If the new value is invalid.
   */
  void setSearchSizeLimit(Integer value) throws IllegalPropertyValueException;



  /**
   * Gets the "search-time-limit" property.
   * <p>
   * Specifies the maximum length of time that the Directory Server
   * should spend processing a search operation.
   * <p>
   * A value of 0 seconds indicates that no time limit is enforced.
   * Note that this is the network group time limit, but it may be
   * overridden on a per-user basis.
   *
   * @return Returns the value of the "search-time-limit" property.
   */
  Long getSearchTimeLimit();



  /**
   * Sets the "search-time-limit" property.
   * <p>
   * Specifies the maximum length of time that the Directory Server
   * should spend processing a search operation.
   * <p>
   * A value of 0 seconds indicates that no time limit is enforced.
   * Note that this is the network group time limit, but it may be
   * overridden on a per-user basis.
   *
   * @param value The value of the "search-time-limit" property.
   * @throws IllegalPropertyValueException
   *           If the new value is invalid.
   */
  void setSearchTimeLimit(Long value) throws IllegalPropertyValueException;

}
