/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * trunk/opends/resource/legal-notices/OpenDS.LICENSE
 * or https://OpenDS.dev.java.net/OpenDS.LICENSE.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * trunk/opends/resource/legal-notices/OpenDS.LICENSE.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2008 Sun Microsystems, Inc.
 */
package org.opends.server.admin.std.meta;



import java.util.Collection;
import java.util.SortedSet;
import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.DNPropertyDefinition;
import org.opends.server.admin.EnumPropertyDefinition;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.std.client.NetworkGroupRequestFilteringPolicyCfgClient;
import org.opends.server.admin.std.server.NetworkGroupRequestFilteringPolicyCfg;
import org.opends.server.admin.StringPropertyDefinition;
import org.opends.server.admin.Tag;
import org.opends.server.admin.TopCfgDefn;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.types.DN;



/**
 * An interface for querying the Network Group Request Filtering
 * Policy managed object definition meta information.
 * <p>
 * The Network Group Request Filtering Policy is used to define the
 * type of requests allowed in the network group.
 */
public final class NetworkGroupRequestFilteringPolicyCfgDefn extends ManagedObjectDefinition<NetworkGroupRequestFilteringPolicyCfgClient, NetworkGroupRequestFilteringPolicyCfg> {

  // The singleton configuration definition instance.
  private static final NetworkGroupRequestFilteringPolicyCfgDefn INSTANCE = new NetworkGroupRequestFilteringPolicyCfgDefn();



  /**
   * Defines the set of permissable values for the "allowed-operations" property.
   * <p>
   * Specifies which operations are allowed in the network group.
   * <p>
   * When this attribute is specified, only the listed operations are
   * allowed in the network group. If the attribute is not defined, all
   * the operations are allowed.
   */
  public static enum AllowedOperations {

    /**
     * Add operations.
     */
    ADD("add"),



    /**
     * Bind operations.
     */
    BIND("bind"),



    /**
     * Compare operations
     */
    COMPARE("compare"),



    /**
     * Delete operations
     */
    DELETE("delete"),



    /**
     * Extended operations
     */
    EXTENDED("extended"),



    /**
     * Inequality Search operations
     */
    INEQUALITY_SEARCH("inequality-search"),



    /**
     * Modify operations
     */
    MODIFY("modify"),



    /**
     * Rename operations
     */
    RENAME("rename"),



    /**
     * Search operations
     */
    SEARCH("search");



    // String representation of the value.
    private final String name;



    // Private constructor.
    private AllowedOperations(String name) { this.name = name; }



    /**
     * {@inheritDoc}
     */
    public String toString() { return name; }

  }



  /**
   * Defines the set of permissable values for the "allowed-search-scopes" property.
   * <p>
   * Specifies which search scopes are allowed in the network group.
   * <p>
   * When this attribute is specified, only the listed scopes are
   * allowed in the network group. If it is not set, all search scopes
   * are allowed.
   */
  public static enum AllowedSearchScopes {

    /**
     * Base-object search.
     */
    BASE("base"),



    /**
     * Subordinate subtree search
     */
    CHILDREN("children"),



    /**
     * One-level search.
     */
    ONE("one"),



    /**
     * Whole subtree search
     */
    SUB("sub");



    // String representation of the value.
    private final String name;



    // Private constructor.
    private AllowedSearchScopes(String name) { this.name = name; }



    /**
     * {@inheritDoc}
     */
    public String toString() { return name; }

  }



  // The "allowed-attributes" property definition.
  private static final StringPropertyDefinition PD_ALLOWED_ATTRIBUTES;



  // The "allowed-operations" property definition.
  private static final EnumPropertyDefinition<AllowedOperations> PD_ALLOWED_OPERATIONS;



  // The "allowed-search-scopes" property definition.
  private static final EnumPropertyDefinition<AllowedSearchScopes> PD_ALLOWED_SEARCH_SCOPES;



  // The "allowed-subtrees" property definition.
  private static final DNPropertyDefinition PD_ALLOWED_SUBTREES;



  // The "prohibited-attributes" property definition.
  private static final StringPropertyDefinition PD_PROHIBITED_ATTRIBUTES;



  // The "prohibited-subtrees" property definition.
  private static final DNPropertyDefinition PD_PROHIBITED_SUBTREES;



  // Build the "allowed-attributes" property definition.
  static {
      StringPropertyDefinition.Builder builder = StringPropertyDefinition.createBuilder(INSTANCE, "allowed-attributes");
      builder.setOption(PropertyOption.MULTI_VALUED);
      builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "allowed-attributes"));
      builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider<String>());
      PD_ALLOWED_ATTRIBUTES = builder.getInstance();
      INSTANCE.registerPropertyDefinition(PD_ALLOWED_ATTRIBUTES);
  }



  // Build the "allowed-operations" property definition.
  static {
      EnumPropertyDefinition.Builder<AllowedOperations> builder = EnumPropertyDefinition.createBuilder(INSTANCE, "allowed-operations");
      builder.setOption(PropertyOption.MULTI_VALUED);
      builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "allowed-operations"));
      builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider<AllowedOperations>());
      builder.setEnumClass(AllowedOperations.class);
      PD_ALLOWED_OPERATIONS = builder.getInstance();
      INSTANCE.registerPropertyDefinition(PD_ALLOWED_OPERATIONS);
  }



  // Build the "allowed-search-scopes" property definition.
  static {
      EnumPropertyDefinition.Builder<AllowedSearchScopes> builder = EnumPropertyDefinition.createBuilder(INSTANCE, "allowed-search-scopes");
      builder.setOption(PropertyOption.MULTI_VALUED);
      builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "allowed-search-scopes"));
      builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider<AllowedSearchScopes>());
      builder.setEnumClass(AllowedSearchScopes.class);
      PD_ALLOWED_SEARCH_SCOPES = builder.getInstance();
      INSTANCE.registerPropertyDefinition(PD_ALLOWED_SEARCH_SCOPES);
  }



  // Build the "allowed-subtrees" property definition.
  static {
      DNPropertyDefinition.Builder builder = DNPropertyDefinition.createBuilder(INSTANCE, "allowed-subtrees");
      builder.setOption(PropertyOption.MULTI_VALUED);
      builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "allowed-subtrees"));
      builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider<DN>());
      PD_ALLOWED_SUBTREES = builder.getInstance();
      INSTANCE.registerPropertyDefinition(PD_ALLOWED_SUBTREES);
  }



  // Build the "prohibited-attributes" property definition.
  static {
      StringPropertyDefinition.Builder builder = StringPropertyDefinition.createBuilder(INSTANCE, "prohibited-attributes");
      builder.setOption(PropertyOption.MULTI_VALUED);
      builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "prohibited-attributes"));
      builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider<String>());
      PD_PROHIBITED_ATTRIBUTES = builder.getInstance();
      INSTANCE.registerPropertyDefinition(PD_PROHIBITED_ATTRIBUTES);
  }



  // Build the "prohibited-subtrees" property definition.
  static {
      DNPropertyDefinition.Builder builder = DNPropertyDefinition.createBuilder(INSTANCE, "prohibited-subtrees");
      builder.setOption(PropertyOption.MULTI_VALUED);
      builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "prohibited-subtrees"));
      builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider<DN>());
      PD_PROHIBITED_SUBTREES = builder.getInstance();
      INSTANCE.registerPropertyDefinition(PD_PROHIBITED_SUBTREES);
  }



  // Register the tags associated with this managed object definition.
  static {
    INSTANCE.registerTag(Tag.valueOf("core-server"));
  }



  /**
   * Get the Network Group Request Filtering Policy configuration
   * definition singleton.
   *
   * @return Returns the Network Group Request Filtering Policy
   *         configuration definition singleton.
   */
  public static NetworkGroupRequestFilteringPolicyCfgDefn getInstance() {
    return INSTANCE;
  }



  /**
   * Private constructor.
   */
  private NetworkGroupRequestFilteringPolicyCfgDefn() {
    super("network-group-request-filtering-policy", TopCfgDefn.getInstance());
  }



  /**
   * {@inheritDoc}
   */
  public NetworkGroupRequestFilteringPolicyCfgClient createClientConfiguration(
      ManagedObject<? extends NetworkGroupRequestFilteringPolicyCfgClient> impl) {
    return new NetworkGroupRequestFilteringPolicyCfgClientImpl(impl);
  }



  /**
   * {@inheritDoc}
   */
  public NetworkGroupRequestFilteringPolicyCfg createServerConfiguration(
      ServerManagedObject<? extends NetworkGroupRequestFilteringPolicyCfg> impl) {
    return new NetworkGroupRequestFilteringPolicyCfgServerImpl(impl);
  }



  /**
   * {@inheritDoc}
   */
  public Class<NetworkGroupRequestFilteringPolicyCfg> getServerConfigurationClass() {
    return NetworkGroupRequestFilteringPolicyCfg.class;
  }



  /**
   * Get the "allowed-attributes" property definition.
   * <p>
   * Specifies which attributes are allowed in search and compare
   * operations.
   * <p>
   * When this attribute is specified, only the listed attributes are
   * allowed in search and compare operations. If it is not set, all
   * the attributes are allowed, except those listed in
   * ds-cfg-prohibited-attributes.
   *
   * @return Returns the "allowed-attributes" property definition.
   */
  public StringPropertyDefinition getAllowedAttributesPropertyDefinition() {
    return PD_ALLOWED_ATTRIBUTES;
  }



  /**
   * Get the "allowed-operations" property definition.
   * <p>
   * Specifies which operations are allowed in the network group.
   * <p>
   * When this attribute is specified, only the listed operations are
   * allowed in the network group. If the attribute is not defined, all
   * the operations are allowed.
   *
   * @return Returns the "allowed-operations" property definition.
   */
  public EnumPropertyDefinition<AllowedOperations> getAllowedOperationsPropertyDefinition() {
    return PD_ALLOWED_OPERATIONS;
  }



  /**
   * Get the "allowed-search-scopes" property definition.
   * <p>
   * Specifies which search scopes are allowed in the network group.
   * <p>
   * When this attribute is specified, only the listed scopes are
   * allowed in the network group. If it is not set, all search scopes
   * are allowed.
   *
   * @return Returns the "allowed-search-scopes" property definition.
   */
  public EnumPropertyDefinition<AllowedSearchScopes> getAllowedSearchScopesPropertyDefinition() {
    return PD_ALLOWED_SEARCH_SCOPES;
  }



  /**
   * Get the "allowed-subtrees" property definition.
   * <p>
   * Specifies which subtrees are exposed to clients.
   * <p>
   * When this attribute is specified, only the listed subtrees are
   * exposed. If it is not set, all the substrees are exposed. Note
   * that ds-cfg-prohibited-subtrees restricts the list of exposed
   * subtrees.
   *
   * @return Returns the "allowed-subtrees" property definition.
   */
  public DNPropertyDefinition getAllowedSubtreesPropertyDefinition() {
    return PD_ALLOWED_SUBTREES;
  }



  /**
   * Get the "prohibited-attributes" property definition.
   * <p>
   * Specifies which attributes are not allowed in search and compare
   * operations.
   * <p>
   * When this attribute is specified, all the listed attributes are
   * prohibited in search and compare operations. It should not be used
   * in conjunction with ds-cfg-allowed-attributes.
   *
   * @return Returns the "prohibited-attributes" property definition.
   */
  public StringPropertyDefinition getProhibitedAttributesPropertyDefinition() {
    return PD_PROHIBITED_ATTRIBUTES;
  }



  /**
   * Get the "prohibited-subtrees" property definition.
   * <p>
   * Specifies which subtrees are not exposed to clients. Each
   * prohibited subtree must be subordinate to an allowed subtree.
   * <p>
   * When this attribute is specified, all the listed subtrees cannot
   * be accessed.
   *
   * @return Returns the "prohibited-subtrees" property definition.
   */
  public DNPropertyDefinition getProhibitedSubtreesPropertyDefinition() {
    return PD_PROHIBITED_SUBTREES;
  }



  /**
   * Managed object client implementation.
   */
  private static class NetworkGroupRequestFilteringPolicyCfgClientImpl implements
    NetworkGroupRequestFilteringPolicyCfgClient {

    // Private implementation.
    private ManagedObject<? extends NetworkGroupRequestFilteringPolicyCfgClient> impl;



    // Private constructor.
    private NetworkGroupRequestFilteringPolicyCfgClientImpl(
        ManagedObject<? extends NetworkGroupRequestFilteringPolicyCfgClient> impl) {
      this.impl = impl;
    }



    /**
     * {@inheritDoc}
     */
    public SortedSet<String> getAllowedAttributes() {
      return impl.getPropertyValues(INSTANCE.getAllowedAttributesPropertyDefinition());
    }



    /**
     * {@inheritDoc}
     */
    public void setAllowedAttributes(Collection<String> values) {
      impl.setPropertyValues(INSTANCE.getAllowedAttributesPropertyDefinition(), values);
    }



    /**
     * {@inheritDoc}
     */
    public SortedSet<AllowedOperations> getAllowedOperations() {
      return impl.getPropertyValues(INSTANCE.getAllowedOperationsPropertyDefinition());
    }



    /**
     * {@inheritDoc}
     */
    public void setAllowedOperations(Collection<AllowedOperations> values) {
      impl.setPropertyValues(INSTANCE.getAllowedOperationsPropertyDefinition(), values);
    }



    /**
     * {@inheritDoc}
     */
    public SortedSet<AllowedSearchScopes> getAllowedSearchScopes() {
      return impl.getPropertyValues(INSTANCE.getAllowedSearchScopesPropertyDefinition());
    }



    /**
     * {@inheritDoc}
     */
    public void setAllowedSearchScopes(Collection<AllowedSearchScopes> values) {
      impl.setPropertyValues(INSTANCE.getAllowedSearchScopesPropertyDefinition(), values);
    }



    /**
     * {@inheritDoc}
     */
    public SortedSet<DN> getAllowedSubtrees() {
      return impl.getPropertyValues(INSTANCE.getAllowedSubtreesPropertyDefinition());
    }



    /**
     * {@inheritDoc}
     */
    public void setAllowedSubtrees(Collection<DN> values) {
      impl.setPropertyValues(INSTANCE.getAllowedSubtreesPropertyDefinition(), values);
    }



    /**
     * {@inheritDoc}
     */
    public SortedSet<String> getProhibitedAttributes() {
      return impl.getPropertyValues(INSTANCE.getProhibitedAttributesPropertyDefinition());
    }



    /**
     * {@inheritDoc}
     */
    public void setProhibitedAttributes(Collection<String> values) {
      impl.setPropertyValues(INSTANCE.getProhibitedAttributesPropertyDefinition(), values);
    }



    /**
     * {@inheritDoc}
     */
    public SortedSet<DN> getProhibitedSubtrees() {
      return impl.getPropertyValues(INSTANCE.getProhibitedSubtreesPropertyDefinition());
    }



    /**
     * {@inheritDoc}
     */
    public void setProhibitedSubtrees(Collection<DN> values) {
      impl.setPropertyValues(INSTANCE.getProhibitedSubtreesPropertyDefinition(), values);
    }



    /**
     * {@inheritDoc}
     */
    public ManagedObjectDefinition<? extends NetworkGroupRequestFilteringPolicyCfgClient, ? extends NetworkGroupRequestFilteringPolicyCfg> definition() {
      return INSTANCE;
    }



    /**
     * {@inheritDoc}
     */
    public PropertyProvider properties() {
      return impl;
    }



    /**
     * {@inheritDoc}
     */
    public void commit() throws ManagedObjectAlreadyExistsException,
        MissingMandatoryPropertiesException, ConcurrentModificationException,
        OperationRejectedException, AuthorizationException,
        CommunicationException {
      impl.commit();
    }

  }



  /**
   * Managed object server implementation.
   */
  private static class NetworkGroupRequestFilteringPolicyCfgServerImpl implements
    NetworkGroupRequestFilteringPolicyCfg {

    // Private implementation.
    private ServerManagedObject<? extends NetworkGroupRequestFilteringPolicyCfg> impl;

    // The value of the "allowed-attributes" property.
    private final SortedSet<String> pAllowedAttributes;

    // The value of the "allowed-operations" property.
    private final SortedSet<AllowedOperations> pAllowedOperations;

    // The value of the "allowed-search-scopes" property.
    private final SortedSet<AllowedSearchScopes> pAllowedSearchScopes;

    // The value of the "allowed-subtrees" property.
    private final SortedSet<DN> pAllowedSubtrees;

    // The value of the "prohibited-attributes" property.
    private final SortedSet<String> pProhibitedAttributes;

    // The value of the "prohibited-subtrees" property.
    private final SortedSet<DN> pProhibitedSubtrees;



    // Private constructor.
    private NetworkGroupRequestFilteringPolicyCfgServerImpl(ServerManagedObject<? extends NetworkGroupRequestFilteringPolicyCfg> impl) {
      this.impl = impl;
      this.pAllowedAttributes = impl.getPropertyValues(INSTANCE.getAllowedAttributesPropertyDefinition());
      this.pAllowedOperations = impl.getPropertyValues(INSTANCE.getAllowedOperationsPropertyDefinition());
      this.pAllowedSearchScopes = impl.getPropertyValues(INSTANCE.getAllowedSearchScopesPropertyDefinition());
      this.pAllowedSubtrees = impl.getPropertyValues(INSTANCE.getAllowedSubtreesPropertyDefinition());
      this.pProhibitedAttributes = impl.getPropertyValues(INSTANCE.getProhibitedAttributesPropertyDefinition());
      this.pProhibitedSubtrees = impl.getPropertyValues(INSTANCE.getProhibitedSubtreesPropertyDefinition());
    }



    /**
     * {@inheritDoc}
     */
    public void addChangeListener(
        ConfigurationChangeListener<NetworkGroupRequestFilteringPolicyCfg> listener) {
      impl.registerChangeListener(listener);
    }



    /**
     * {@inheritDoc}
     */
    public void removeChangeListener(
        ConfigurationChangeListener<NetworkGroupRequestFilteringPolicyCfg> listener) {
      impl.deregisterChangeListener(listener);
    }



    /**
     * {@inheritDoc}
     */
    public SortedSet<String> getAllowedAttributes() {
      return pAllowedAttributes;
    }



    /**
     * {@inheritDoc}
     */
    public SortedSet<AllowedOperations> getAllowedOperations() {
      return pAllowedOperations;
    }



    /**
     * {@inheritDoc}
     */
    public SortedSet<AllowedSearchScopes> getAllowedSearchScopes() {
      return pAllowedSearchScopes;
    }



    /**
     * {@inheritDoc}
     */
    public SortedSet<DN> getAllowedSubtrees() {
      return pAllowedSubtrees;
    }



    /**
     * {@inheritDoc}
     */
    public SortedSet<String> getProhibitedAttributes() {
      return pProhibitedAttributes;
    }



    /**
     * {@inheritDoc}
     */
    public SortedSet<DN> getProhibitedSubtrees() {
      return pProhibitedSubtrees;
    }



    /**
     * {@inheritDoc}
     */
    public Class<? extends NetworkGroupRequestFilteringPolicyCfg> configurationClass() {
      return NetworkGroupRequestFilteringPolicyCfg.class;
    }



    /**
     * {@inheritDoc}
     */
    public DN dn() {
      return impl.getDN();
    }

  }
}
