/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * trunk/opends/resource/legal-notices/OpenDS.LICENSE
 * or https://OpenDS.dev.java.net/OpenDS.LICENSE.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * trunk/opends/resource/legal-notices/OpenDS.LICENSE.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2008 Sun Microsystems, Inc.
 */
package org.opends.server.admin.std.meta;



import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.BooleanPropertyDefinition;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyIsReadOnlyException;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.std.client.WorkflowElementCfgClient;
import org.opends.server.admin.std.server.WorkflowElementCfg;
import org.opends.server.admin.StringPropertyDefinition;
import org.opends.server.admin.Tag;
import org.opends.server.admin.TopCfgDefn;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.types.DN;



/**
 * An interface for querying the Workflow Element managed object
 * definition meta information.
 * <p>
 * Workflow Elements implement a single processing step in a Work
 * Flow.
 */
public final class WorkflowElementCfgDefn extends ManagedObjectDefinition<WorkflowElementCfgClient, WorkflowElementCfg> {

  // The singleton configuration definition instance.
  private static final WorkflowElementCfgDefn INSTANCE = new WorkflowElementCfgDefn();



  // The "enabled" property definition.
  private static final BooleanPropertyDefinition PD_ENABLED;



  // The "java-class" property definition.
  private static final ClassPropertyDefinition PD_JAVA_CLASS;



  // The "workflow-element-id" property definition.
  private static final StringPropertyDefinition PD_WORKFLOW_ELEMENT_ID;



  // Build the "enabled" property definition.
  static {
      BooleanPropertyDefinition.Builder builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "enabled");
      builder.setOption(PropertyOption.MANDATORY);
      builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "enabled"));
      builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider<Boolean>());
      PD_ENABLED = builder.getInstance();
      INSTANCE.registerPropertyDefinition(PD_ENABLED);
  }



  // Build the "java-class" property definition.
  static {
      ClassPropertyDefinition.Builder builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
      builder.setOption(PropertyOption.MANDATORY);
      builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "java-class"));
      builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider<String>());
      builder.addInstanceOf("org.opends.server.workflowelement.WorkflowElement");
      PD_JAVA_CLASS = builder.getInstance();
      INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
  }



  // Build the "workflow-element-id" property definition.
  static {
      StringPropertyDefinition.Builder builder = StringPropertyDefinition.createBuilder(INSTANCE, "workflow-element-id");
      builder.setOption(PropertyOption.READ_ONLY);
      builder.setOption(PropertyOption.MANDATORY);
      builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "workflow-element-id"));
      builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider<String>());
      PD_WORKFLOW_ELEMENT_ID = builder.getInstance();
      INSTANCE.registerPropertyDefinition(PD_WORKFLOW_ELEMENT_ID);
  }



  // Register the tags associated with this managed object definition.
  static {
    INSTANCE.registerTag(Tag.valueOf("core-server"));
  }



  /**
   * Get the Workflow Element configuration definition singleton.
   *
   * @return Returns the Workflow Element configuration definition
   *         singleton.
   */
  public static WorkflowElementCfgDefn getInstance() {
    return INSTANCE;
  }



  /**
   * Private constructor.
   */
  private WorkflowElementCfgDefn() {
    super("workflow-element", TopCfgDefn.getInstance());
  }



  /**
   * {@inheritDoc}
   */
  public WorkflowElementCfgClient createClientConfiguration(
      ManagedObject<? extends WorkflowElementCfgClient> impl) {
    return new WorkflowElementCfgClientImpl(impl);
  }



  /**
   * {@inheritDoc}
   */
  public WorkflowElementCfg createServerConfiguration(
      ServerManagedObject<? extends WorkflowElementCfg> impl) {
    return new WorkflowElementCfgServerImpl(impl);
  }



  /**
   * {@inheritDoc}
   */
  public Class<WorkflowElementCfg> getServerConfigurationClass() {
    return WorkflowElementCfg.class;
  }



  /**
   * Get the "enabled" property definition.
   * <p>
   * Indicates whether the Workflow Element is enabled for use in the
   * server.
   * <p>
   * If a Workflow Element is not enabled, then its contents are not
   * accessible when processing operations.
   *
   * @return Returns the "enabled" property definition.
   */
  public BooleanPropertyDefinition getEnabledPropertyDefinition() {
    return PD_ENABLED;
  }



  /**
   * Get the "java-class" property definition.
   * <p>
   * Specifies the fully-qualified name of the Java class that
   * provides the Workflow Element implementation.
   *
   * @return Returns the "java-class" property definition.
   */
  public ClassPropertyDefinition getJavaClassPropertyDefinition() {
    return PD_JAVA_CLASS;
  }



  /**
   * Get the "workflow-element-id" property definition.
   * <p>
   * Provides a name that identifies the associated Workflow Element .
   * <p>
   * The name must be unique among all Workflow Elements in the
   * server.
   *
   * @return Returns the "workflow-element-id" property definition.
   */
  public StringPropertyDefinition getWorkflowElementIdPropertyDefinition() {
    return PD_WORKFLOW_ELEMENT_ID;
  }



  /**
   * Managed object client implementation.
   */
  private static class WorkflowElementCfgClientImpl implements
    WorkflowElementCfgClient {

    // Private implementation.
    private ManagedObject<? extends WorkflowElementCfgClient> impl;



    // Private constructor.
    private WorkflowElementCfgClientImpl(
        ManagedObject<? extends WorkflowElementCfgClient> impl) {
      this.impl = impl;
    }



    /**
     * {@inheritDoc}
     */
    public Boolean isEnabled() {
      return impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
    }



    /**
     * {@inheritDoc}
     */
    public void setEnabled(boolean value) {
      impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
    }



    /**
     * {@inheritDoc}
     */
    public String getJavaClass() {
      return impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
    }



    /**
     * {@inheritDoc}
     */
    public void setJavaClass(String value) {
      impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
    }



    /**
     * {@inheritDoc}
     */
    public String getWorkflowElementId() {
      return impl.getPropertyValue(INSTANCE.getWorkflowElementIdPropertyDefinition());
    }



    /**
     * {@inheritDoc}
     */
    public void setWorkflowElementId(String value) throws PropertyIsReadOnlyException {
      impl.setPropertyValue(INSTANCE.getWorkflowElementIdPropertyDefinition(), value);
    }



    /**
     * {@inheritDoc}
     */
    public ManagedObjectDefinition<? extends WorkflowElementCfgClient, ? extends WorkflowElementCfg> definition() {
      return INSTANCE;
    }



    /**
     * {@inheritDoc}
     */
    public PropertyProvider properties() {
      return impl;
    }



    /**
     * {@inheritDoc}
     */
    public void commit() throws ManagedObjectAlreadyExistsException,
        MissingMandatoryPropertiesException, ConcurrentModificationException,
        OperationRejectedException, AuthorizationException,
        CommunicationException {
      impl.commit();
    }

  }



  /**
   * Managed object server implementation.
   */
  private static class WorkflowElementCfgServerImpl implements
    WorkflowElementCfg {

    // Private implementation.
    private ServerManagedObject<? extends WorkflowElementCfg> impl;

    // The value of the "enabled" property.
    private final boolean pEnabled;

    // The value of the "java-class" property.
    private final String pJavaClass;

    // The value of the "workflow-element-id" property.
    private final String pWorkflowElementId;



    // Private constructor.
    private WorkflowElementCfgServerImpl(ServerManagedObject<? extends WorkflowElementCfg> impl) {
      this.impl = impl;
      this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
      this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
      this.pWorkflowElementId = impl.getPropertyValue(INSTANCE.getWorkflowElementIdPropertyDefinition());
    }



    /**
     * {@inheritDoc}
     */
    public void addChangeListener(
        ConfigurationChangeListener<WorkflowElementCfg> listener) {
      impl.registerChangeListener(listener);
    }



    /**
     * {@inheritDoc}
     */
    public void removeChangeListener(
        ConfigurationChangeListener<WorkflowElementCfg> listener) {
      impl.deregisterChangeListener(listener);
    }



    /**
     * {@inheritDoc}
     */
    public boolean isEnabled() {
      return pEnabled;
    }



    /**
     * {@inheritDoc}
     */
    public String getJavaClass() {
      return pJavaClass;
    }



    /**
     * {@inheritDoc}
     */
    public String getWorkflowElementId() {
      return pWorkflowElementId;
    }



    /**
     * {@inheritDoc}
     */
    public Class<? extends WorkflowElementCfg> configurationClass() {
      return WorkflowElementCfg.class;
    }



    /**
     * {@inheritDoc}
     */
    public DN dn() {
      return impl.getDN();
    }

  }
}
