/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * trunk/opends/resource/legal-notices/OpenDS.LICENSE
 * or https://OpenDS.dev.java.net/OpenDS.LICENSE.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * trunk/opends/resource/legal-notices/OpenDS.LICENSE.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2008 Sun Microsystems, Inc.
 */
package org.opends.server.admin.std.client;



import java.util.Collection;
import java.util.SortedSet;
import org.opends.server.admin.ConfigurationClient;
import org.opends.server.admin.IllegalPropertyValueException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.std.meta.NetworkGroupCriteriaCfgDefn.AllowedAuthMethod;
import org.opends.server.admin.std.meta.NetworkGroupCriteriaCfgDefn.AllowedLDAPPort;
import org.opends.server.admin.std.server.NetworkGroupCriteriaCfg;
import org.opends.server.types.AddressMask;



/**
 * A client-side interface for reading and modifying Network Group
 * Criteria settings.
 * <p>
 * The Network Group Criteria is used to classify incoming
 * connections.
 */
public interface NetworkGroupCriteriaCfgClient extends ConfigurationClient {

  /**
   * Get the configuration definition associated with this Network Group Criteria.
   *
   * @return Returns the configuration definition associated with this Network Group Criteria.
   */
  ManagedObjectDefinition<? extends NetworkGroupCriteriaCfgClient, ? extends NetworkGroupCriteriaCfg> definition();



  /**
   * Gets the "allowed-auth-method" property.
   * <p>
   * Specifies the allowed authorization methods for a client
   * connection to match the Network Group Criteria.
   *
   * @return Returns the values of the "allowed-auth-method" property.
   */
  SortedSet<AllowedAuthMethod> getAllowedAuthMethod();



  /**
   * Sets the "allowed-auth-method" property.
   * <p>
   * Specifies the allowed authorization methods for a client
   * connection to match the Network Group Criteria.
   *
   * @param values The values of the "allowed-auth-method" property.
   * @throws IllegalPropertyValueException
   *           If one or more of the new values are invalid.
   */
  void setAllowedAuthMethod(Collection<AllowedAuthMethod> values) throws IllegalPropertyValueException;



  /**
   * Gets the "allowed-ldap-port" property.
   * <p>
   * Specifies the allowed LDAP ports for the client connection to
   * match the Network Group Criteria.
   *
   * @return Returns the values of the "allowed-ldap-port" property.
   */
  SortedSet<AllowedLDAPPort> getAllowedLDAPPort();



  /**
   * Sets the "allowed-ldap-port" property.
   * <p>
   * Specifies the allowed LDAP ports for the client connection to
   * match the Network Group Criteria.
   *
   * @param values The values of the "allowed-ldap-port" property.
   * @throws IllegalPropertyValueException
   *           If one or more of the new values are invalid.
   */
  void setAllowedLDAPPort(Collection<AllowedLDAPPort> values) throws IllegalPropertyValueException;



  /**
   * Gets the "bind-dn-filter" property.
   * <p>
   * Specifies a bind DN filter for the client connection to match the
   * Network Group Criteria.
   * <p>
   * A valid bind DN filter is a string composed of zero or more
   * wildcards. A double wildcard ** replaces one or more RDN
   * components (as in uid=dmiller,**,dc=example,dc=com). A simple
   * wildcard * replaces either a whole RDN, or a whole type, or a
   * value substring (as in uid=bj*,ou=people,dc=example,dc=com).
   *
   * @return Returns the values of the "bind-dn-filter" property.
   */
  SortedSet<String> getBindDNFilter();



  /**
   * Sets the "bind-dn-filter" property.
   * <p>
   * Specifies a bind DN filter for the client connection to match the
   * Network Group Criteria.
   * <p>
   * A valid bind DN filter is a string composed of zero or more
   * wildcards. A double wildcard ** replaces one or more RDN
   * components (as in uid=dmiller,**,dc=example,dc=com). A simple
   * wildcard * replaces either a whole RDN, or a whole type, or a
   * value substring (as in uid=bj*,ou=people,dc=example,dc=com).
   *
   * @param values The values of the "bind-dn-filter" property.
   * @throws IllegalPropertyValueException
   *           If one or more of the new values are invalid.
   */
  void setBindDNFilter(Collection<String> values) throws IllegalPropertyValueException;



  /**
   * Gets the "ip-address-filter" property.
   * <p>
   * Specifies an IP address filter for the Network Group Criteria.
   * <p>
   * A valid IP address mask can be one of the followings:
   * 129.34.55.67 129.*.78.55 .sun.com foo.sun.com foo.*.sun.*
   * 128.*.*.* 129.45.23.67/22 128.33.21.21/32 *.*.*.* 129.45.67.34/0
   * foo.com foo 2001:fecd:ba23:cd1f:dcb1:1010:9234:4088/124
   * 2001:fecd:ba23:cd1f:dcb1:1010:9234:4088
   * [2001:fecd:ba23:cd1f:dcb1:1010:9234:4088]/45 ::/128 ::1/128 ::
   *
   * @return Returns the values of the "ip-address-filter" property.
   */
  SortedSet<AddressMask> getIPAddressFilter();



  /**
   * Sets the "ip-address-filter" property.
   * <p>
   * Specifies an IP address filter for the Network Group Criteria.
   * <p>
   * A valid IP address mask can be one of the followings:
   * 129.34.55.67 129.*.78.55 .sun.com foo.sun.com foo.*.sun.*
   * 128.*.*.* 129.45.23.67/22 128.33.21.21/32 *.*.*.* 129.45.67.34/0
   * foo.com foo 2001:fecd:ba23:cd1f:dcb1:1010:9234:4088/124
   * 2001:fecd:ba23:cd1f:dcb1:1010:9234:4088
   * [2001:fecd:ba23:cd1f:dcb1:1010:9234:4088]/45 ::/128 ::1/128 ::
   *
   * @param values The values of the "ip-address-filter" property.
   * @throws IllegalPropertyValueException
   *           If one or more of the new values are invalid.
   */
  void setIPAddressFilter(Collection<AddressMask> values) throws IllegalPropertyValueException;



  /**
   * Gets the "is-security-mandatory" property.
   * <p>
   * Specifies whether security is mandatory for the Network Group
   * Criteria.
   *
   * @return Returns the value of the "is-security-mandatory" property.
   */
  boolean isIsSecurityMandatory();



  /**
   * Sets the "is-security-mandatory" property.
   * <p>
   * Specifies whether security is mandatory for the Network Group
   * Criteria.
   *
   * @param value The value of the "is-security-mandatory" property.
   * @throws IllegalPropertyValueException
   *           If the new value is invalid.
   */
  void setIsSecurityMandatory(Boolean value) throws IllegalPropertyValueException;



  /**
   * Gets the "user-entry-filter" property.
   * <p>
   * Specifies a search filter that the entry of a bound client must
   * match.
   *
   * @return Returns the value of the "user-entry-filter" property.
   */
  String getUserEntryFilter();



  /**
   * Sets the "user-entry-filter" property.
   * <p>
   * Specifies a search filter that the entry of a bound client must
   * match.
   *
   * @param value The value of the "user-entry-filter" property.
   * @throws IllegalPropertyValueException
   *           If the new value is invalid.
   */
  void setUserEntryFilter(String value) throws IllegalPropertyValueException;

}
