/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.Locker;

public class ThreadLocker
extends BasicLocker {
    private ThreadLocker(EnvironmentImpl env) throws DatabaseException {
        super(env);
    }

    public static ThreadLocker createThreadLocker(EnvironmentImpl env) throws DatabaseException {
        ThreadLocker ret = null;
        try {
            ret = new ThreadLocker(env);
            ret.initApiReadLock();
        }
        catch (DatabaseException DE) {
            ret.operationEnd(false);
            throw DE;
        }
        return ret;
    }

    protected void checkState(boolean ignoreCalledByAbort) throws DatabaseException {
        if (this.thread != Thread.currentThread()) {
            throw new DatabaseException("Non-transactional Cursors may not be used in multiple threads; Cursor was created in " + this.thread + " but used in " + Thread.currentThread());
        }
    }

    public Locker newNonTxnLocker() throws DatabaseException {
        this.checkState(false);
        return ThreadLocker.createThreadLocker(this.envImpl);
    }

    public boolean sharesLocksWith(Locker other) {
        if (super.sharesLocksWith(other)) {
            return true;
        }
        if (other instanceof ThreadLocker) {
            return this.thread == ((ThreadLocker)other).thread;
        }
        return false;
    }
}

