/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.InitialLdapContext;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.opends.guitools.controlpanel.browser.BrowserController;
import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.guitools.controlpanel.datamodel.BaseDNDescriptor;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.ui.nodes.BasicNode;
import org.opends.guitools.controlpanel.ui.nodes.BrowserNodeInfo;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.util.cli.CommandBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewEntryTask
extends Task {
    private Entry newEntry;
    private String ldif;
    private Set<String> backendSet = new HashSet<String>();
    private BasicNode parentNode;
    private BrowserController controller;
    private DN dn;
    private boolean useAdminCtx = false;

    public NewEntryTask(ControlPanelInfo info, ProgressDialog dlg, Entry newEntry, String ldif, BasicNode parentNode, BrowserController controller) {
        super(info, dlg);
        this.newEntry = newEntry;
        this.ldif = ldif;
        this.parentNode = parentNode;
        this.controller = controller;
        this.dn = newEntry.getDN();
        for (BackendDescriptor backend : info.getServerDescriptor().getBackends()) {
            for (BaseDNDescriptor baseDN : backend.getBaseDns()) {
                if (!this.dn.isDescendantOf(baseDN.getDn())) continue;
                this.backendSet.add(backend.getBackendID());
            }
        }
    }

    @Override
    public Task.Type getType() {
        return Task.Type.NEW_ENTRY;
    }

    @Override
    public Set<String> getBackends() {
        return this.backendSet;
    }

    @Override
    public Message getTaskDescription() {
        return AdminToolMessages.INFO_CTRL_PANEL_NEW_ENTRY_TASK_DESCRIPTION.get(this.dn.toString());
    }

    @Override
    protected String getCommandLinePath() {
        return null;
    }

    protected ArrayList<String> getCommandLineArguments() {
        return new ArrayList<String>();
    }

    @Override
    public boolean canLaunch(Task taskToBeLaunched, Collection<Message> incompatibilityReasons) {
        boolean canLaunch = true;
        if (!this.isServerRunning() && this.state == Task.State.RUNNING) {
            TreeSet<String> backends = new TreeSet<String>(taskToBeLaunched.getBackends());
            backends.retainAll(this.getBackends());
            if (backends.size() > 0) {
                incompatibilityReasons.add(this.getIncompatibilityMessage(this, taskToBeLaunched));
                canLaunch = false;
            }
        }
        return canLaunch;
    }

    @Override
    public boolean regenerateDescriptor() {
        return false;
    }

    @Override
    public void runTask() {
        this.state = Task.State.RUNNING;
        this.lastException = null;
        try {
            InitialLdapContext ctx;
            if (this.parentNode != null) {
                ctx = this.controller.findConnectionForDisplayedEntry(this.parentNode);
                this.useAdminCtx = this.controller.isConfigurationNode(this.parentNode);
            } else {
                ctx = this.getInfo().getDirContext();
                this.useAdminCtx = true;
            }
            BasicAttributes attrs = new BasicAttributes();
            BasicAttribute objectclass = new BasicAttribute("objectClass");
            for (String oc : this.newEntry.getObjectClasses().values()) {
                objectclass.add(oc);
            }
            attrs.put(objectclass);
            for (Attribute attr : this.newEntry.getAttributes()) {
                String attrName = attr.getNameWithOptions();
                LinkedHashSet<AttributeValue> values = new LinkedHashSet<AttributeValue>();
                Iterator<AttributeValue> it = attr.iterator();
                while (it.hasNext()) {
                    values.add(it.next());
                }
                BasicAttribute a = new BasicAttribute(attrName);
                for (AttributeValue value : values) {
                    a.add(value.getValueBytes());
                }
                attrs.put(a);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NewEntryTask.this.printEquivalentCommand();
                    NewEntryTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressWithPoints(AdminToolMessages.INFO_CTRL_PANEL_CREATING_ENTRY.get(NewEntryTask.this.dn.toString()), ColorAndFontConstants.progressFont));
                }
            });
            ctx.createSubcontext(Utilities.getJNDIName(this.newEntry.getDN().toString()), (Attributes)attrs);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TreePath newPath;
                    BrowserNodeInfo nodeInfo;
                    TreePath parentPath;
                    NewEntryTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressDone(ColorAndFontConstants.progressFont));
                    if (NewEntryTask.this.parentNode != null && (parentPath = new TreePath(NewEntryTask.this.controller.getTreeModel().getPathToRoot(NewEntryTask.this.parentNode))) != null && (nodeInfo = NewEntryTask.this.controller.getNodeInfoFromPath(parentPath)) != null && (newPath = NewEntryTask.this.controller.notifyEntryAdded(NewEntryTask.this.controller.getNodeInfoFromPath(parentPath), NewEntryTask.this.newEntry.getDN().toString())) != null) {
                        NewEntryTask.this.controller.getTree().setSelectionPath(newPath);
                        NewEntryTask.this.controller.getTree().scrollPathToVisible(newPath);
                    }
                }
            });
            this.state = Task.State.FINISHED_SUCCESSFULLY;
        }
        catch (Throwable t) {
            this.lastException = t;
            this.state = Task.State.FINISHED_WITH_ERROR;
        }
    }

    private void printEquivalentCommand() {
        String[] lines;
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.getCommandLinePath("ldapmodify"));
        args.addAll(this.getObfuscatedCommandLineArguments(this.getConnectionCommandLineArguments(this.useAdminCtx, true)));
        args.add(this.getNoPropertiesFileArgument());
        args.add("--defaultAdd");
        StringBuilder sb = new StringBuilder();
        for (String arg : args) {
            sb.append(" " + CommandBuilder.escapeValue(arg));
        }
        sb.append("<br>");
        for (String line : lines = this.ldif.split("\n")) {
            sb.append(this.obfuscateLDIFLine(line));
            sb.append("<br>");
        }
        this.getProgressDialog().appendProgressHtml(Utilities.applyFont(AdminToolMessages.INFO_CTRL_PANEL_EQUIVALENT_CMD_TO_CREATE_ENTRY.get() + "<br><b>" + sb.toString() + "</b><br><br>", ColorAndFontConstants.progressFont));
    }
}

