/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.SortedSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.opends.guitools.controlpanel.datamodel.AbstractIndexDescriptor;
import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.guitools.controlpanel.datamodel.CategorizedComboBoxElement;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.datamodel.ServerDescriptor;
import org.opends.guitools.controlpanel.datamodel.SortableListModel;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.event.IndexModifiedEvent;
import org.opends.guitools.controlpanel.event.IndexModifiedListener;
import org.opends.guitools.controlpanel.task.RebuildIndexTask;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.ui.components.AddRemovePanel;
import org.opends.guitools.controlpanel.ui.renderer.CustomListCellRenderer;
import org.opends.guitools.controlpanel.ui.renderer.IndexCellRenderer;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;

public class RebuildIndexPanel
extends StatusGenericPanel
implements IndexModifiedListener {
    private static final long serialVersionUID = -4805445967165643375L;
    private JComboBox baseDNs;
    private AddRemovePanel<AbstractIndexDescriptor> addRemove;
    private JLabel lBaseDN;
    private JLabel lIndexes;
    private JLabel lNoBaseDNsFound;
    private HashMap<String, SortedSet<AbstractIndexDescriptor>> hmIndexes = new HashMap();

    public RebuildIndexPanel() {
        this.createLayout();
    }

    public void indexModified(IndexModifiedEvent ev) {
        this.refreshContents(this.getInfo().getServerDescriptor());
    }

    public void backendIndexesModified(IndexModifiedEvent ev) {
        this.refreshContents(this.getInfo().getServerDescriptor());
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        this.addErrorPane(gbc);
        gbc.gridwidth = 1;
        gbc.fill = 0;
        this.lBaseDN = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_BASE_DN_LABEL.get());
        this.add((Component)this.lBaseDN, gbc);
        gbc.insets.left = 10;
        gbc.gridx = 1;
        gbc.gridy = 0;
        this.baseDNs = Utilities.createComboBox();
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        this.baseDNs.setModel(model);
        this.baseDNs.setRenderer(new CustomListCellRenderer(this.baseDNs));
        StatusGenericPanel.IgnoreItemListener listener = new StatusGenericPanel.IgnoreItemListener(this, this.baseDNs);
        this.baseDNs.addItemListener(listener);
        this.baseDNs.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                RebuildIndexPanel.this.comboBoxSelected(RebuildIndexPanel.this.hmIndexes, (CategorizedComboBoxElement)RebuildIndexPanel.this.baseDNs.getSelectedItem(), RebuildIndexPanel.this.addRemove);
            }
        });
        listener.itemStateChanged(null);
        this.add((Component)this.baseDNs, gbc);
        this.lNoBaseDNsFound = Utilities.createDefaultLabel(AdminToolMessages.INFO_CTRL_PANEL_NO_BASE_DNS_FOUND_LABEL.get());
        this.add((Component)this.lNoBaseDNsFound, gbc);
        this.lNoBaseDNsFound.setVisible(false);
        this.lIndexes = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_INDEXES_LABEL.get());
        gbc.insets.top = 10;
        gbc.insets.left = 0;
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        this.add((Component)this.lIndexes, gbc);
        this.addRemove = new AddRemovePanel<AbstractIndexDescriptor>(AbstractIndexDescriptor.class);
        this.addRemove.getAvailableLabel().setText(AdminToolMessages.INFO_CTRL_PANEL_AVAILABLE_INDEXES_LABEL.get().toString());
        this.addRemove.getSelectedLabel().setText(AdminToolMessages.INFO_CTRL_PANEL_SELECTED_INDEXES_LABEL.get().toString());
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.insets.top = 10;
        gbc.insets.left = 10;
        gbc.fill = 1;
        this.add(this.addRemove, gbc);
        ++gbc.gridy;
        gbc.insets.top = 3;
        JLabel explanation = Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_REQUIRES_REBUILD_LEGEND.get());
        this.add((Component)explanation, gbc);
        this.addBottomGlue(gbc);
    }

    public void setInfo(ControlPanelInfo info) {
        super.setInfo(info);
        IndexCellRenderer indexCellRenderer = new IndexCellRenderer(this.addRemove.getAvailableList(), info);
        this.addRemove.getAvailableList().setCellRenderer(indexCellRenderer);
        this.addRemove.getSelectedList().setCellRenderer(indexCellRenderer);
        info.addIndexModifiedListener(this);
    }

    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_REBUILD_INDEXES_TITLE.get();
    }

    public Component getPreferredFocusComponent() {
        return this.baseDNs;
    }

    public void configurationChanged(ConfigurationChangeEvent ev) {
        ServerDescriptor desc = ev.getNewDescriptor();
        this.refreshContents(desc);
    }

    private void refreshContents(ServerDescriptor desc) {
        this.updateIndexMap(desc, this.hmIndexes);
        this.updateBaseDNComboBoxModel((DefaultComboBoxModel)this.baseDNs.getModel(), desc);
        boolean allDisabled = false;
        for (BackendDescriptor backend : desc.getBackends()) {
            if (!this.displayBackend(backend) || !backend.isEnabled()) continue;
            allDisabled = false;
            break;
        }
        if (!allDisabled) {
            this.updateErrorPaneAndOKButtonIfAuthRequired(desc, AdminToolMessages.INFO_CTRL_PANEL_AUTHENTICATION_REQUIRED_FOR_DISABLE_BACKEND.get());
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                boolean comboVisible = RebuildIndexPanel.this.baseDNs.getModel().getSize() > 0;
                RebuildIndexPanel.this.baseDNs.setVisible(comboVisible);
                RebuildIndexPanel.this.lNoBaseDNsFound.setVisible(!comboVisible);
                RebuildIndexPanel.this.addRemove.getAvailableList().repaint();
                RebuildIndexPanel.this.addRemove.getSelectedList().repaint();
            }
        });
    }

    public void cancelClicked() {
        this.setPrimaryValid(this.lBaseDN);
        this.setSecondaryValid(this.addRemove.getSelectedLabel());
        super.cancelClicked();
    }

    public void okClicked() {
        SortableListModel<AbstractIndexDescriptor> model;
        this.setPrimaryValid(this.lBaseDN);
        this.setSecondaryValid(this.addRemove.getSelectedLabel());
        LinkedHashSet<Message> errors = new LinkedHashSet<Message>();
        String baseDN = this.getSelectedBaseDN();
        if (baseDN == null) {
            this.setPrimaryInvalid(this.lBaseDN);
            if (this.baseDNs.getItemCount() == 0) {
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_NO_BASE_DNS_DEFINED_LABEL.get());
            } else {
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_MUST_SELECT_BASE_DN.get());
            }
        }
        if ((model = this.addRemove.getSelectedListModel()).getSize() == 0) {
            this.setSecondaryInvalid(this.addRemove.getSelectedLabel());
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_MUST_SELECT_INDEX_TO_REBUILD.get());
        }
        if (errors.isEmpty()) {
            ProgressDialog progressDialog = new ProgressDialog((Component)Utilities.getParentDialog(this), this.getTitle(), this.getInfo());
            HashSet<String> baseDNs = new HashSet<String>();
            baseDNs.add(this.getSelectedBaseDN());
            RebuildIndexTask newTask = new RebuildIndexTask(this.getInfo(), progressDialog, baseDNs, this.addRemove.getSelectedListModel().getData());
            for (Task task : this.getInfo().getTasks()) {
                task.canLaunch(newTask, errors);
            }
            boolean confirmed = true;
            if (errors.isEmpty() && this.isServerRunning()) {
                String backendName = newTask.getBackends().iterator().next();
                confirmed = this.displayConfirmationDialog(AdminToolMessages.INFO_CTRL_PANEL_CONFIRMATION_REQUIRED_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_CONFIRM_REBUILD_INDEX_DETAILS.get(backendName));
            }
            if (errors.isEmpty() && confirmed) {
                this.launchOperation(newTask, AdminToolMessages.INFO_CTRL_PANEL_REBUILDING_INDEXES_SUMMARY.get(baseDN), AdminToolMessages.INFO_CTRL_PANEL_REBUILDING_INDEXES_SUCCESSFUL_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_REBUILDING_INDEXES_SUCCESSFUL_DETAILS.get(), AdminToolMessages.ERR_CTRL_PANEL_REBUILDING_INDEXES_ERROR_SUMMARY.get(), null, AdminToolMessages.ERR_CTRL_PANEL_REBUILDING_INDEXES_ERROR_DETAILS, progressDialog);
                progressDialog.setVisible(true);
                Utilities.getParentDialog(this).setVisible(false);
            }
        }
        if (errors.size() > 0) {
            this.displayErrorDialog(errors);
        }
    }

    protected boolean displayBackend(BackendDescriptor backend) {
        return !backend.isConfigBackend() && backend.getType() == BackendDescriptor.Type.LOCAL_DB;
    }

    private String getSelectedBaseDN() {
        String dn = null;
        CategorizedComboBoxElement o = (CategorizedComboBoxElement)this.baseDNs.getSelectedItem();
        if (o != null) {
            dn = (String)o.getValue();
        }
        return dn;
    }
}

