/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.TreeSet;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.ui.SchemaElementPanel;
import org.opends.guitools.controlpanel.ui.StandardObjectClassPanel;
import org.opends.guitools.controlpanel.ui.components.TitlePanel;
import org.opends.guitools.controlpanel.util.LowerCaseComparator;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.api.MatchingRule;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.Schema;

public class StandardAttributePanel
extends SchemaElementPanel {
    private static final long serialVersionUID = -7922968631524763675L;
    private TitlePanel titlePanel = new TitlePanel(Message.EMPTY, Message.EMPTY);
    private JLabel name = Utilities.createDefaultLabel();
    private JLabel parent = Utilities.createDefaultLabel();
    private JLabel oid = Utilities.createDefaultLabel();
    private JLabel aliases = Utilities.createDefaultLabel();
    private JLabel origin = Utilities.createDefaultLabel();
    private JLabel description = Utilities.createDefaultLabel();
    private JLabel usage = Utilities.createDefaultLabel();
    private JLabel syntax = Utilities.createDefaultLabel();
    private JLabel approximate = Utilities.createDefaultLabel();
    private JLabel equality = Utilities.createDefaultLabel();
    private JLabel ordering = Utilities.createDefaultLabel();
    private JLabel substring = Utilities.createDefaultLabel();
    private JLabel type = Utilities.createDefaultLabel();
    private JList requiredBy = new JList(new DefaultListModel());
    private JList optionalBy = new JList(new DefaultListModel());

    public StandardAttributePanel() {
        this.createLayout();
    }

    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_STANDARD_ATTRIBUTE_TITLE.get();
    }

    public Component getPreferredFocusComponent() {
        return this.requiredBy;
    }

    public void configurationChanged(ConfigurationChangeEvent ev) {
    }

    public void okClicked() {
    }

    protected void createLayout() {
        this.createBasicLayout(this, new GridBagConstraints());
        this.setBorder(this.PANEL_BORDER);
    }

    protected void createBasicLayout(Container c, GridBagConstraints gbc) {
        this.requiredBy.setVisibleRowCount(5);
        this.optionalBy.setVisibleRowCount(9);
        Message[] labels = new Message[]{AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_NAME_LABEL.get(), AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_PARENT_LABEL.get(), AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_OID_LABEL.get(), AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_ALIASES_LABEL.get(), AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_ORIGIN_LABEL.get(), AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_DESCRIPTION_LABEL.get(), AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_USAGE_LABEL.get(), AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_SYNTAX_LABEL.get(), AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_APPROXIMATE_MATCHING_RULE_LABEL.get(), AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_EQUALITY_MATCHING_RULE_LABEL.get(), AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_ORDERING_MATCHING_RULE_LABEL.get(), AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_SUBSTRING_MATCHING_RULE_LABEL.get()};
        JLabel[] values = new JLabel[]{this.name, this.parent, this.oid, this.aliases, this.origin, this.description, this.usage, this.syntax, this.approximate, this.equality, this.ordering, this.substring, this.type};
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        this.addErrorPane(c, gbc);
        ++gbc.gridy;
        gbc.anchor = 17;
        this.titlePanel.setTitle(AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_DETAILS.get());
        gbc.fill = 0;
        gbc.insets.top = 5;
        gbc.insets.bottom = 7;
        c.add((Component)this.titlePanel, gbc);
        gbc.insets.bottom = 0;
        gbc.insets.top = 8;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        for (int i = 0; i < labels.length; ++i) {
            gbc.insets.left = 0;
            gbc.gridx = 0;
            JLabel l = Utilities.createPrimaryLabel(labels[i]);
            c.add((Component)l, gbc);
            gbc.insets.left = 10;
            gbc.gridx = 1;
            c.add((Component)values[i], gbc);
            ++gbc.gridy;
        }
        labels = new Message[]{AdminToolMessages.INFO_CTRL_PANEL_REQUIRED_BY_LABEL.get(), AdminToolMessages.INFO_CTRL_PANEL_ALLOWED_BY_LABEL.get()};
        JList[] lists = new JList[]{this.requiredBy, this.optionalBy};
        gbc.anchor = 18;
        for (int i = 0; i < 2; ++i) {
            gbc.insets.left = 0;
            gbc.gridx = 0;
            JLabel l = Utilities.createPrimaryLabel(labels[i]);
            gbc.weightx = 0.0;
            gbc.fill = 2;
            c.add((Component)l, gbc);
            gbc.insets.left = 10;
            gbc.gridx = 1;
            gbc.weighty = i == 0 ? 0.35 : 0.65;
            gbc.weightx = 1.0;
            gbc.fill = 1;
            gbc.insets.top = 10;
            c.add((Component)Utilities.createScrollPane(lists[i]), gbc);
            ++gbc.gridy;
            final JList list = lists[i];
            MouseAdapter doubleClickListener = new MouseAdapter(){

                public void mouseClicked(MouseEvent ev) {
                    ObjectClass oc;
                    Schema schema;
                    String o;
                    if (ev.getClickCount() > 1 && (o = (String)list.getSelectedValue()) != null && (schema = StandardAttributePanel.this.getInfo().getServerDescriptor().getSchema()) != null && (oc = schema.getObjectClass(o.toLowerCase())) != null) {
                        StandardAttributePanel.this.notifySchemaSelectionListeners(oc);
                    }
                }
            };
            list.addMouseListener(doubleClickListener);
        }
    }

    public void update(AttributeType attr, Schema schema) {
        String n = attr.getPrimaryName();
        if (n == null) {
            n = NOT_APPLICABLE.toString();
        }
        this.titlePanel.setDetails(Message.raw(n, new Object[0]));
        this.name.setText(n);
        AttributeType superior = attr.getSuperiorType();
        n = superior == null ? null : superior.getPrimaryName();
        if (n == null) {
            n = NOT_APPLICABLE.toString();
        }
        this.parent.setText(n);
        this.oid.setText(attr.getOID());
        this.origin.setText(StandardObjectClassPanel.getOrigin(attr).toString());
        n = attr.getDescription();
        if (n == null) {
            n = NOT_APPLICABLE.toString();
        }
        this.description.setText(n);
        n = attr.getUsage() == null ? NOT_APPLICABLE.toString() : attr.getUsage().toString();
        this.usage.setText(n);
        ArrayList<String> otherNames = new ArrayList<String>();
        Iterable<String> ocNames = attr.getNormalizedNames();
        String primaryName = attr.getPrimaryName();
        if (primaryName == null) {
            primaryName = "";
        }
        for (String name : ocNames) {
            if (name.equalsIgnoreCase(primaryName)) continue;
            otherNames.add(name);
        }
        n = otherNames.size() > 0 ? Utilities.getStringFromCollection(otherNames, ", ") : NOT_APPLICABLE.toString();
        this.aliases.setText(n);
        this.syntax.setText(Utilities.getSyntaxText(attr.getSyntax()));
        JLabel[] labels = new JLabel[]{this.approximate, this.equality, this.ordering, this.substring};
        MatchingRule[] rules = new MatchingRule[]{attr.getApproximateMatchingRule(), attr.getEqualityMatchingRule(), attr.getOrderingMatchingRule(), attr.getSubstringMatchingRule()};
        for (int i = 0; i < labels.length; ++i) {
            if (rules[i] != null) {
                labels[i].setText(Utilities.getMatchingRuleText(rules[i]));
                continue;
            }
            labels[i].setText(NOT_APPLICABLE.toString());
        }
        this.type.setText(StandardAttributePanel.getTypeValue(attr).toString());
        LowerCaseComparator lowerCaseComparator = new LowerCaseComparator();
        TreeSet<String> requiredByOcs = new TreeSet<String>(lowerCaseComparator);
        for (ObjectClass oc : schema.getObjectClasses().values()) {
            if (!oc.getRequiredAttributeChain().contains(attr)) continue;
            requiredByOcs.add(oc.getNameOrOID());
        }
        DefaultListModel model = (DefaultListModel)this.requiredBy.getModel();
        model.clear();
        for (String oc : requiredByOcs) {
            model.addElement(oc);
        }
        TreeSet<String> optionalByOcs = new TreeSet<String>(lowerCaseComparator);
        for (ObjectClass objectClass : schema.getObjectClasses().values()) {
            if (!objectClass.getOptionalAttributeChain().contains(attr)) continue;
            optionalByOcs.add(objectClass.getNameOrOID());
        }
        model = (DefaultListModel)this.optionalBy.getModel();
        model.clear();
        for (String string : optionalByOcs) {
            model.addElement(string);
        }
    }

    static Message getTypeValue(AttributeType attr) {
        MessageBuilder mb = new MessageBuilder();
        Boolean[] props = new Boolean[]{attr.isOperational(), attr.isSingleValue(), attr.isNoUserModification(), attr.isCollective(), attr.isObsolete()};
        Message[][] values = new Message[][]{{AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_OPERATIONAL_LABEL.get(), null}, {AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_SINGLE_VALUED_LABEL.get(), AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_MULTI_VALUED_LABEL.get()}, {AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_NON_MODIFIABLE_LABEL.get(), null}, {AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_COLLECTIVE_LABEL.get(), null}, {AdminToolMessages.INFO_CTRL_PANEL_ATTRIBUTE_OBSOLETE_LABEL.get(), null}};
        int i = 0;
        for (Boolean prop : props) {
            Message value;
            Message message = value = prop != false ? values[i][0] : values[i][1];
            if (value != null) {
                if (mb.length() > 0) {
                    mb.append(", ");
                }
                mb.append(value);
            }
            ++i;
        }
        return mb.toMessage();
    }
}

