/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.ui.SchemaElementPanel;
import org.opends.guitools.controlpanel.ui.components.TitlePanel;
import org.opends.guitools.controlpanel.util.LowerCaseComparator;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.CommonSchemaElements;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.Schema;

public class StandardObjectClassPanel
extends SchemaElementPanel {
    private static final long serialVersionUID = 5561268287795223026L;
    private TitlePanel titlePanel = new TitlePanel(Message.EMPTY, Message.EMPTY);
    private JLabel name = Utilities.createDefaultLabel();
    private JLabel parent = Utilities.createDefaultLabel();
    private JLabel oid = Utilities.createDefaultLabel();
    private JLabel origin = Utilities.createDefaultLabel();
    private JLabel description = Utilities.createDefaultLabel();
    private JLabel aliases = Utilities.createDefaultLabel();
    private JLabel type = Utilities.createDefaultLabel();
    private JList requiredAttributes = new JList(new DefaultListModel());
    private JList optionalAttributes = new JList(new DefaultListModel());
    private static Message ABSTRACT_VALUE = AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_ABSTRACT_LABEL.get();
    private static Message STRUCTURAL_VALUE = AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_STRUCTURAL_LABEL.get();
    private static Message AUXILIARY_VALUE = AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_AUXILIARY_LABEL.get();
    private static Message OBSOLETE_VALUE = AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_OBSOLETE_LABEL.get();
    private Map<String, AttributeType> hmAttrs = new HashMap<String, AttributeType>();

    public StandardObjectClassPanel() {
        this.createLayout();
    }

    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_STANDARD_OBJECTCLASS_TITLE.get();
    }

    public Component getPreferredFocusComponent() {
        return this.requiredAttributes;
    }

    public void configurationChanged(ConfigurationChangeEvent ev) {
    }

    public void okClicked() {
    }

    protected void createLayout() {
        this.createBasicLayout(this, new GridBagConstraints());
        this.setBorder(this.PANEL_BORDER);
    }

    protected void createBasicLayout(Container c, GridBagConstraints gbc) {
        this.requiredAttributes.setVisibleRowCount(5);
        this.optionalAttributes.setVisibleRowCount(9);
        Message[] labels = new Message[]{AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_NAME_LABEL.get(), AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_PARENT_LABEL.get(), AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_OID_LABEL.get(), AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_ALIASES_LABEL.get(), AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_ORIGIN_LABEL.get(), AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_DESCRIPTION_LABEL.get(), AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_TYPE_LABEL.get()};
        JLabel[] values = new JLabel[]{this.name, this.parent, this.oid, this.aliases, this.origin, this.description, this.type};
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        this.addErrorPane(c, gbc);
        ++gbc.gridy;
        this.titlePanel.setTitle(AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_DETAILS.get());
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets.top = 5;
        gbc.insets.bottom = 7;
        c.add((Component)this.titlePanel, gbc);
        gbc.insets.bottom = 0;
        gbc.insets.top = 8;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        for (int i = 0; i < labels.length; ++i) {
            gbc.insets.left = 0;
            gbc.gridx = 0;
            JLabel l = Utilities.createPrimaryLabel(labels[i]);
            c.add((Component)l, gbc);
            gbc.insets.left = 10;
            gbc.gridx = 1;
            c.add((Component)values[i], gbc);
            ++gbc.gridy;
        }
        labels = new Message[]{AdminToolMessages.INFO_CTRL_PANEL_REQUIRED_ATTRIBUTES_LABEL.get(), AdminToolMessages.INFO_CTRL_PANEL_OPTIONAL_ATTRIBUTES_LABEL.get()};
        JList[] lists = new JList[]{this.requiredAttributes, this.optionalAttributes};
        gbc.anchor = 18;
        for (int i = 0; i < 2; ++i) {
            gbc.insets.left = 0;
            gbc.gridx = 0;
            JLabel l = Utilities.createPrimaryLabel(labels[i]);
            gbc.weightx = 0.0;
            gbc.fill = 2;
            c.add((Component)l, gbc);
            gbc.insets.left = 10;
            gbc.gridx = 1;
            gbc.weighty = i == 0 ? 0.35 : 0.65;
            gbc.weightx = 1.0;
            gbc.fill = 1;
            gbc.insets.top = 10;
            c.add((Component)Utilities.createScrollPane(lists[i]), gbc);
            ++gbc.gridy;
            gbc.weighty = 0.0;
            JLabel explanation = Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_INHERITED_ATTRIBUTES_HELP.get());
            gbc.insets.top = 3;
            c.add((Component)explanation, gbc);
            ++gbc.gridy;
            final JList list = lists[i];
            MouseAdapter doubleClickListener = new MouseAdapter(){

                public void mouseClicked(MouseEvent ev) {
                    AttributeType attr;
                    String o;
                    if (ev.getClickCount() > 1 && (o = (String)list.getSelectedValue()) != null && (attr = (AttributeType)StandardObjectClassPanel.this.hmAttrs.get(o)) != null) {
                        StandardObjectClassPanel.this.notifySchemaSelectionListeners(attr);
                    }
                }
            };
            list.addMouseListener(doubleClickListener);
        }
    }

    static Message getOrigin(CommonSchemaElements element) {
        Iterator<String> iterator;
        MessageBuilder returnValue = new MessageBuilder();
        String fileName = element.getSchemaFile();
        String xOrigin = null;
        Iterable<String> it = element.getExtraProperty("X-ORIGIN");
        if (it != null && (iterator = it.iterator()).hasNext()) {
            xOrigin = iterator.next();
        }
        if (xOrigin != null) {
            returnValue.append(xOrigin);
            if (fileName != null) {
                returnValue.append(" -");
                returnValue.append(AdminToolMessages.INFO_CTRL_PANEL_DEFINED_IN_SCHEMA_FILE.get(fileName));
            }
        } else if (fileName != null) {
            returnValue.append(AdminToolMessages.INFO_CTRL_PANEL_DEFINED_IN_SCHEMA_FILE.get(fileName));
        } else {
            returnValue.append(NOT_APPLICABLE);
        }
        return returnValue.toMessage();
    }

    /*
     * WARNING - void declaration
     */
    public void update(ObjectClass oc, Schema schema) {
        if (oc == null || schema == null) {
            return;
        }
        this.hmAttrs.clear();
        String n = oc.getPrimaryName();
        if (n == null) {
            n = NOT_APPLICABLE.toString();
        }
        this.titlePanel.setDetails(Message.raw(n, new Object[0]));
        this.name.setText(n);
        ObjectClass superior = oc.getSuperiorClass();
        n = superior == null ? null : superior.getPrimaryName();
        if (n == null) {
            n = NOT_APPLICABLE.toString();
        }
        this.parent.setText(n);
        this.oid.setText(oc.getOID());
        this.origin.setText(StandardObjectClassPanel.getOrigin(oc).toString());
        n = oc.getDescription();
        if (n == null) {
            n = NOT_APPLICABLE.toString();
        }
        this.description.setText(n);
        ArrayList<String> otherNames = new ArrayList<String>();
        Iterable<String> ocNames = oc.getNormalizedNames();
        String primaryName = oc.getPrimaryName();
        if (primaryName == null) {
            primaryName = "";
        }
        for (String name : ocNames) {
            if (name.equalsIgnoreCase(primaryName)) continue;
            otherNames.add(name);
        }
        n = otherNames.size() > 0 ? Utilities.getStringFromCollection(otherNames, ", ") : NOT_APPLICABLE.toString();
        this.aliases.setText(n);
        this.type.setText(StandardObjectClassPanel.getTypeValue(oc).toString());
        LowerCaseComparator lowerCaseComparator = new LowerCaseComparator();
        TreeSet<String> requiredAttrs = new TreeSet<String>(lowerCaseComparator);
        HashSet<String> inheritedAttrs = new HashSet<String>();
        for (AttributeType attr : oc.getRequiredAttributeChain()) {
            requiredAttrs.add(attr.getNameOrOID());
        }
        ObjectClass parent = oc.getSuperiorClass();
        if (parent != null) {
            for (AttributeType attr : parent.getRequiredAttributeChain()) {
                inheritedAttrs.add(attr.getNameOrOID());
            }
        }
        DefaultListModel model = (DefaultListModel)this.requiredAttributes.getModel();
        model.clear();
        for (String attr : requiredAttrs) {
            void var15_15;
            if (inheritedAttrs.contains(attr)) {
                String string = attr + " (*)";
            } else {
                String string = attr;
            }
            model.addElement(var15_15);
            this.hmAttrs.put((String)var15_15, schema.getAttributeType(attr.toLowerCase()));
        }
        TreeSet<String> optionalAttrs = new TreeSet<String>(lowerCaseComparator);
        inheritedAttrs = new HashSet();
        for (AttributeType attributeType : oc.getOptionalAttributeChain()) {
            optionalAttrs.add(attributeType.getNameOrOID());
        }
        parent = oc.getSuperiorClass();
        if (parent != null) {
            for (AttributeType attributeType : parent.getOptionalAttributeChain()) {
                inheritedAttrs.add(attributeType.getNameOrOID());
            }
        }
        model = (DefaultListModel)this.optionalAttributes.getModel();
        model.clear();
        for (String string : optionalAttrs) {
            String v = inheritedAttrs.contains(string) ? string + " (*)" : string;
            model.addElement(v);
            this.hmAttrs.put(v, schema.getAttributeType(string.toLowerCase()));
        }
    }

    static Message getTypeValue(ObjectClass oc) {
        MessageBuilder mb = new MessageBuilder();
        switch (oc.getObjectClassType()) {
            case ABSTRACT: {
                mb.append(ABSTRACT_VALUE);
                break;
            }
            case STRUCTURAL: {
                mb.append(STRUCTURAL_VALUE);
                break;
            }
            case AUXILIARY: {
                mb.append(AUXILIARY_VALUE);
            }
        }
        if (oc.isObsolete()) {
            if (mb.length() > 0) {
                mb.append(", ");
            }
            mb.append(OBSOLETE_VALUE);
        }
        return mb.toMessage();
    }
}

