/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.uninstaller;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import org.opends.admin.ads.ADSContext;
import org.opends.admin.ads.ServerDescriptor;
import org.opends.admin.ads.TopologyCache;
import org.opends.admin.ads.TopologyCacheException;
import org.opends.admin.ads.util.ApplicationTrustManager;
import org.opends.guitools.controlpanel.datamodel.ConnectionProtocolPolicy;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.uninstaller.UninstallData;
import org.opends.guitools.uninstaller.UninstallProgressStep;
import org.opends.guitools.uninstaller.UninstallUserData;
import org.opends.guitools.uninstaller.UninstallerArgumentParser;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.Application;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.Configuration;
import org.opends.quicksetup.Constants;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.ProgressStep;
import org.opends.quicksetup.ReturnCode;
import org.opends.quicksetup.Step;
import org.opends.quicksetup.UserDataException;
import org.opends.quicksetup.event.ProgressUpdateEvent;
import org.opends.quicksetup.event.ProgressUpdateListener;
import org.opends.quicksetup.util.PlainTextProgressMessageFormatter;
import org.opends.quicksetup.util.ServerController;
import org.opends.quicksetup.util.Utils;
import org.opends.server.admin.client.cli.DsFrameworkCliReturnCode;
import org.opends.server.admin.client.cli.SecureConnectionCliArgs;
import org.opends.server.tools.ClientException;
import org.opends.server.tools.dsconfig.LDAPManagementContextFactory;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.cli.CLIException;
import org.opends.server.util.cli.ConsoleApplication;
import org.opends.server.util.cli.LDAPConnectionConsoleInteraction;
import org.opends.server.util.cli.Menu;
import org.opends.server.util.cli.MenuBuilder;
import org.opends.server.util.cli.MenuResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UninstallCliHelper
extends ConsoleApplication {
    private static final Logger LOG = Logger.getLogger(UninstallCliHelper.class.getName());
    private UninstallerArgumentParser parser;
    private boolean forceNonInteractive;
    private LDAPConnectionConsoleInteraction ci = null;
    private ControlPanelInfo info;
    private final boolean alwaysSSL = true;
    private boolean useSSL = true;
    private boolean useStartTLS = false;

    public UninstallCliHelper() {
        super(System.in, (OutputStream)System.out, (OutputStream)System.err);
    }

    public UninstallUserData createUserData(UninstallerArgumentParser args, String[] rawArguments) throws UserDataException, ApplicationException {
        boolean somethingSpecifiedToDelete;
        Set<String> outsideLogs;
        Set<String> outsideDbs;
        this.parser = args;
        UninstallUserData userData = new UninstallUserData();
        boolean isCancelled = false;
        boolean isInteractive = args.isInteractive();
        boolean isQuiet = args.isQuiet();
        boolean isVerbose = args.isVerbose();
        userData.setQuiet(isQuiet);
        userData.setVerbose(isVerbose);
        userData.setForceOnError(args.isForceOnError());
        userData.setTrustManager(args.getTrustManager());
        MessageBuilder buf = new MessageBuilder();
        int v = args.validateGlobalOptions(buf);
        if (v != DsFrameworkCliReturnCode.SUCCESSFUL_NOP.getReturnCode()) {
            throw new UserDataException(null, buf.toMessage());
        }
        Configuration config = Installation.getLocal().getCurrentConfiguration();
        try {
            outsideDbs = config.getOutsideDbs();
        }
        catch (IOException ioe) {
            outsideDbs = Collections.emptySet();
            LOG.log(Level.INFO, "error determining outside databases", ioe);
        }
        try {
            outsideLogs = config.getOutsideLogs();
        }
        catch (IOException ioe) {
            outsideLogs = Collections.emptySet();
            LOG.log(Level.INFO, "error determining outside logs", ioe);
        }
        boolean bl = somethingSpecifiedToDelete = args.removeAll() || args.removeBackupFiles() || args.removeDatabases() || args.removeLDIFFiles() || args.removeConfigurationFiles() || args.removeLogFiles() || args.removeServerLibraries();
        if (somethingSpecifiedToDelete) {
            userData.setRemoveBackups(args.removeAll() || args.removeBackupFiles());
            userData.setRemoveConfigurationAndSchema(args.removeAll() || args.removeConfigurationFiles());
            userData.setRemoveDatabases(args.removeAll() || args.removeDatabases());
            userData.setRemoveLDIFs(args.removeAll() || args.removeLDIFFiles());
            userData.setRemoveLibrariesAndTools(args.removeAll() || args.removeServerLibraries());
            userData.setRemoveLogs(args.removeAll() || args.removeLogFiles());
            userData.setExternalDbsToRemove(outsideDbs);
            userData.setExternalLogsToRemove(outsideLogs);
        } else {
            if (!isInteractive) {
                throw new UserDataException(null, AdminToolMessages.ERR_CLI_UNINSTALL_NOTHING_TO_BE_UNINSTALLED_NON_INTERACTIVE.get());
            }
            isCancelled = this.askWhatToDelete(userData, outsideDbs, outsideLogs);
        }
        String adminUid = args.getAdministratorUID();
        if (adminUid == null && !args.isInteractive()) {
            adminUid = args.getDefaultAdministratorUID();
        }
        userData.setAdminUID(adminUid);
        userData.setAdminPwd(args.getBindPassword());
        String referencedHostName = args.getReferencedHostName();
        if (referencedHostName == null && !args.isInteractive()) {
            referencedHostName = args.getDefaultReferencedHostName();
        }
        try {
            UninstallData d = new UninstallData(Installation.getLocal());
            userData.setReplicationServer(referencedHostName + ":" + d.getReplicationServerPort());
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, "Could not create UninstallData: " + t, t);
            userData.setReplicationServer(referencedHostName + ":8989");
        }
        this.info = ControlPanelInfo.getInstance();
        this.info.setTrustManager(userData.getTrustManager());
        this.info.regenerateDescriptor();
        this.info.setConnectionPolicy(ConnectionProtocolPolicy.USE_ADMIN);
        String adminConnectorUrl = this.info.getAdminConnectorURL();
        if (adminConnectorUrl == null) {
            LOG.log(Level.WARNING, "Error retrieving a valid LDAP URL in conf file.");
            if (!this.parser.isInteractive()) {
                Message msg = AdminToolMessages.ERR_COULD_NOT_FIND_VALID_LDAPURL.get();
                throw new ApplicationException(ReturnCode.APPLICATION_ERROR, msg, null);
            }
        }
        userData.setLocalServerUrl(adminConnectorUrl);
        userData.setReferencedHostName(referencedHostName);
        if (!isCancelled) {
            isCancelled = this.checkServerState(userData);
        }
        if (isCancelled && !userData.isForceOnError()) {
            LOG.log(Level.INFO, "User cancelled uninstall.");
            userData = null;
        }
        if (userData != null && !args.isQuiet()) {
            this.println();
        }
        return userData;
    }

    private boolean askWhatToDelete(UninstallUserData userData, Set<String> outsideDbs, Set<String> outsideLogs) throws UserDataException {
        int choice;
        Message[] msgs;
        boolean cancelled;
        block24: {
            cancelled = false;
            boolean REMOVE_ALL = true;
            int SPECIFY_TO_REMOVE = 2;
            int[] indexes = new int[]{1, 2};
            msgs = new Message[]{AdminToolMessages.INFO_CLI_UNINSTALL_REMOVE_ALL.get(), AdminToolMessages.INFO_CLI_UNINSTALL_SPECIFY_WHAT_REMOVE.get()};
            MenuBuilder<Integer> builder = new MenuBuilder<Integer>(this);
            builder.setPrompt(AdminToolMessages.INFO_CLI_UNINSTALL_WHAT_TO_DELETE.get());
            for (int i = 0; i < indexes.length; ++i) {
                builder.addNumberedOption(msgs[i], MenuResult.success(indexes[i]), new Message[0]);
            }
            builder.addQuitOption();
            builder.setDefault(Message.raw(String.valueOf(1), new Object[0]), MenuResult.success(1));
            builder.setMaxTries(5);
            Menu menu = builder.toMenu();
            try {
                MenuResult m = menu.run();
                if (m.isSuccess()) {
                    choice = (Integer)m.getValue();
                    break block24;
                }
                if (m.isQuit()) {
                    choice = 1;
                    cancelled = true;
                    break block24;
                }
                throw new RuntimeException();
            }
            catch (CLIException ce) {
                LOG.log(Level.WARNING, "Error reading input: " + ce, ce);
                throw new UserDataException(null, ce.getMessageObject(), ce);
            }
        }
        if (!cancelled) {
            if (choice == 1) {
                userData.setRemoveBackups(true);
                userData.setRemoveConfigurationAndSchema(true);
                userData.setRemoveDatabases(true);
                userData.setRemoveLDIFs(true);
                userData.setRemoveLibrariesAndTools(true);
                userData.setRemoveLogs(true);
                userData.setExternalDbsToRemove(outsideDbs);
                userData.setExternalLogsToRemove(outsideLogs);
            } else {
                boolean somethingSelected = false;
                while (!somethingSelected && !cancelled) {
                    int i;
                    this.println();
                    msgs = new Message[]{AdminToolMessages.INFO_CLI_UNINSTALL_CONFIRM_LIBRARIES_BINARIES.get(), AdminToolMessages.INFO_CLI_UNINSTALL_CONFIRM_DATABASES.get(), AdminToolMessages.INFO_CLI_UNINSTALL_CONFIRM_LOGS.get(), AdminToolMessages.INFO_CLI_UNINSTALL_CONFIRM_CONFIGURATION_SCHEMA.get(), AdminToolMessages.INFO_CLI_UNINSTALL_CONFIRM_BACKUPS.get(), AdminToolMessages.INFO_CLI_UNINSTALL_CONFIRM_LDIFS.get(), AdminToolMessages.INFO_CLI_UNINSTALL_CONFIRM_OUTSIDEDBS.get(Utils.getStringFromCollection(outsideDbs, Constants.LINE_SEPARATOR)), AdminToolMessages.INFO_CLI_UNINSTALL_CONFIRM_OUTSIDELOGS.get(Utils.getStringFromCollection(outsideLogs, Constants.LINE_SEPARATOR))};
                    boolean[] answers = new boolean[msgs.length];
                    try {
                        for (i = 0; i < msgs.length; ++i) {
                            boolean ignore = i == 6 && outsideDbs.size() == 0 || i == 7 && outsideLogs.size() == 0;
                            answers[i] = !ignore ? this.askConfirmation(msgs[i], true, LOG) : false;
                        }
                    }
                    catch (CLIException ce) {
                        throw new UserDataException(null, ce.getMessageObject(), ce);
                    }
                    if (cancelled) continue;
                    block17: for (i = 0; i < answers.length; ++i) {
                        switch (i) {
                            case 0: {
                                userData.setRemoveLibrariesAndTools(answers[i]);
                                continue block17;
                            }
                            case 1: {
                                userData.setRemoveDatabases(answers[i]);
                                continue block17;
                            }
                            case 2: {
                                userData.setRemoveLogs(answers[i]);
                                continue block17;
                            }
                            case 3: {
                                userData.setRemoveConfigurationAndSchema(answers[i]);
                                continue block17;
                            }
                            case 4: {
                                userData.setRemoveBackups(answers[i]);
                                continue block17;
                            }
                            case 5: {
                                userData.setRemoveLDIFs(answers[i]);
                                continue block17;
                            }
                            case 6: {
                                if (!answers[i]) continue block17;
                                userData.setExternalDbsToRemove(outsideDbs);
                                continue block17;
                            }
                            case 7: {
                                if (!answers[i]) continue block17;
                                userData.setExternalLogsToRemove(outsideLogs);
                            }
                        }
                    }
                    if (!(userData.getExternalDbsToRemove().size() != 0 || userData.getExternalLogsToRemove().size() != 0 || userData.getRemoveLibrariesAndTools() || userData.getRemoveDatabases() || userData.getRemoveConfigurationAndSchema() || userData.getRemoveBackups() || userData.getRemoveLDIFs() || userData.getRemoveLogs())) {
                        somethingSelected = false;
                        this.println();
                        this.println(AdminToolMessages.ERR_CLI_UNINSTALL_NOTHING_TO_BE_UNINSTALLED.get());
                        continue;
                    }
                    somethingSelected = true;
                }
            }
        }
        return cancelled;
    }

    /*
     * Unable to fully structure code
     */
    private boolean checkServerState(UninstallUserData userData) throws UserDataException, ApplicationException {
        cancelled = false;
        interactive = this.parser.isInteractive();
        forceOnError = this.parser.isForceOnError();
        conf = null;
        try {
            conf = new UninstallData(Installation.getLocal());
        }
        catch (Throwable t) {
            UninstallCliHelper.LOG.log(Level.WARNING, "Error processing task: " + t, t);
            throw new UserDataException(Step.CONFIRM_UNINSTALL, Utils.getThrowableMsg(QuickSetupMessages.INFO_BUG_MSG.get(), t));
        }
        if (conf.isADS() && conf.isReplicationServer()) {
            if (conf.isServerRunning()) {
                if (interactive) {
                    try {
                        if (this.confirmToUpdateRemote()) {
                            this.println();
                            v0 = cancelled = this.askForAuthenticationIfNeeded(userData) == false;
                            if (cancelled) {
                                this.println();
                                cancelled = this.confirmToStopServer() == false;
                            }
                            v1 = cancelled = this.updateUserUninstallDataWithRemoteServers(userData) == false;
                            if (!cancelled) ** GOTO lbl68
                            this.println();
                            cancelled = this.confirmToStopServer() == false;
                        }
                        this.println();
                        cancelled = this.confirmToStopServer() == false;
                    }
                    catch (CLIException ce) {
                        throw new UserDataException(null, ce.getMessageObject(), ce);
                    }
                } else {
                    errorWithRemote = this.updateUserUninstallDataWithRemoteServers(userData) == false;
                    cancelled = errorWithRemote != false && this.parser.isForceOnError() == false;
                }
            } else if (interactive) {
                this.println();
                try {
                    if (this.confirmToUpdateRemoteAndStart()) {
                        startWorked = this.startServer(userData.isQuiet());
                        if (startWorked) {
                            v2 = cancelled = this.askForAuthenticationIfNeeded(userData) == false;
                            if (cancelled) {
                                this.println();
                                cancelled = this.confirmToStopServer() == false;
                            }
                            v3 = cancelled = this.updateUserUninstallDataWithRemoteServers(userData) == false;
                            if (!cancelled) ** GOTO lbl68
                            this.println();
                            cancelled = this.confirmToStopServer() == false;
                        }
                        userData.setStopServer(false);
                        this.println();
                        cancelled = this.confirmDeleteFiles() == false;
                    }
                    this.println();
                    cancelled = this.confirmDeleteFiles() == false;
                }
                catch (CLIException ce) {
                    throw new UserDataException(null, ce.getMessageObject(), ce);
                }
            } else {
                startWorked = this.startServer(userData.isQuiet());
                if (startWorked) {
                    userData.setStopServer(true);
                    errorWithRemote = this.updateUserUninstallDataWithRemoteServers(userData) == false;
                    cancelled = errorWithRemote != false && this.parser.isForceOnError() == false;
                } else {
                    cancelled = forceOnError == false;
                    userData.setStopServer(false);
                }
            }
lbl68:
            // 12 sources

            if (!cancelled || this.parser.isForceOnError()) {
                userData.setStopServer(Installation.getLocal().getStatus().isServerRunning());
            }
        } else if (conf.isServerRunning()) {
            try {
                if (interactive) {
                    this.println();
                    v4 = cancelled = this.confirmToStopServer() == false;
                }
                if (cancelled) ** GOTO lbl89
                userData.setStopServer(Installation.getLocal().getStatus().isServerRunning());
            }
            catch (CLIException ce) {
                throw new UserDataException(null, ce.getMessageObject(), ce);
            }
        } else {
            userData.setStopServer(false);
            if (interactive) {
                this.println();
                try {
                    cancelled = this.confirmDeleteFiles() == false;
                }
                catch (CLIException ce) {
                    throw new UserDataException(null, ce.getMessageObject(), ce);
                }
            }
        }
lbl89:
        // 6 sources

        return cancelled;
    }

    private boolean confirmToStopServer() throws CLIException {
        return this.askConfirmation(AdminToolMessages.INFO_CLI_UNINSTALL_CONFIRM_STOP.get(), true, LOG);
    }

    private boolean confirmDeleteFiles() throws CLIException {
        return this.askConfirmation(AdminToolMessages.INFO_CLI_UNINSTALL_CONFIRM_DELETE_FILES.get(), true, LOG);
    }

    private boolean confirmToUpdateRemote() throws CLIException {
        return this.askConfirmation(AdminToolMessages.INFO_CLI_UNINSTALL_CONFIRM_UPDATE_REMOTE.get(), true, LOG);
    }

    private boolean confirmToUpdateRemoteAndStart() throws CLIException {
        return this.askConfirmation(AdminToolMessages.INFO_CLI_UNINSTALL_CONFIRM_UPDATE_REMOTE_AND_START.get(), true, LOG);
    }

    private boolean promptToProvideAuthenticationAgain() throws CLIException {
        return this.askConfirmation(AdminToolMessages.INFO_UNINSTALL_CONFIRM_PROVIDE_AUTHENTICATION_AGAIN.get(), true, LOG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean askForAuthenticationIfNeeded(UninstallUserData userData) throws UserDataException, ApplicationException {
        boolean accepted = true;
        String uid = userData.getAdminUID();
        String pwd = userData.getAdminPwd();
        boolean couldConnect = false;
        while (!couldConnect && accepted) {
            SecureConnectionCliArgs secureArgsList = this.parser.getSecureArgsList();
            secureArgsList.hostNameArg.setPresent(true);
            secureArgsList.portArg.setPresent(true);
            secureArgsList.hostNameArg.clearValues();
            secureArgsList.hostNameArg.addValue(secureArgsList.hostNameArg.getDefaultValue());
            secureArgsList.portArg.clearValues();
            secureArgsList.portArg.addValue(secureArgsList.portArg.getDefaultValue());
            secureArgsList.bindDnArg.clearValues();
            if (uid != null) {
                secureArgsList.bindDnArg.addValue(ADSContext.getAdministratorDN(uid));
                secureArgsList.bindDnArg.setPresent(true);
            } else {
                secureArgsList.bindDnArg.setPresent(false);
            }
            secureArgsList.bindPasswordArg.clearValues();
            if (pwd != null) {
                secureArgsList.bindPasswordArg.addValue(pwd);
                secureArgsList.bindPasswordArg.setPresent(true);
            } else {
                secureArgsList.bindPasswordArg.setPresent(false);
            }
            if (this.ci == null) {
                this.ci = new LDAPConnectionConsoleInteraction(this, this.parser.getSecureArgsList());
                this.ci.setDisplayLdapIfSecureParameters(true);
            }
            InitialContext ctx = null;
            try {
                this.ci.run(true, false);
                userData.setAdminUID(this.ci.getAdministratorUID());
                userData.setAdminPwd(this.ci.getBindPassword());
                this.info.setConnectionPolicy(ConnectionProtocolPolicy.USE_ADMIN);
                String adminConnectorUrl = this.info.getAdminConnectorURL();
                if (adminConnectorUrl == null) {
                    LOG.log(Level.WARNING, "Error retrieving a valid Administration Connector URL in conf file.");
                    Message msg = AdminToolMessages.ERR_COULD_NOT_FIND_VALID_LDAPURL.get();
                    throw new ApplicationException(ReturnCode.APPLICATION_ERROR, msg, null);
                }
                try {
                    URI uri = new URI(adminConnectorUrl);
                    int port = uri.getPort();
                    secureArgsList.portArg.clearValues();
                    secureArgsList.portArg.addValue(String.valueOf(port));
                    this.ci.setPortNumber(port);
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, "Error parsing url: " + adminConnectorUrl);
                }
                LDAPManagementContextFactory factory = new LDAPManagementContextFactory(true);
                factory.getManagementContext(this, this.ci);
                this.updateTrustManager(userData, this.ci);
                this.info.setConnectionPolicy(ConnectionProtocolPolicy.USE_ADMIN);
                adminConnectorUrl = this.info.getAdminConnectorURL();
                if (adminConnectorUrl == null) {
                    LOG.log(Level.WARNING, "Error retrieving a valid Administration Connector URL in conf file.");
                    Message msg = AdminToolMessages.ERR_COULD_NOT_FIND_VALID_LDAPURL.get();
                    throw new ApplicationException(ReturnCode.APPLICATION_ERROR, msg, null);
                }
                userData.setLocalServerUrl(adminConnectorUrl);
                couldConnect = true;
            }
            catch (ArgumentException e) {
                this.println(e.getMessageObject());
                this.println();
            }
            catch (ClientException e) {
                this.println(e.getMessageObject());
                this.println();
            }
            finally {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (Throwable t) {
                        LOG.log(Level.INFO, "Error closing connection: " + t, t);
                    }
                }
            }
            if (couldConnect) continue;
            try {
                accepted = this.promptToProvideAuthenticationAgain();
                if (!accepted) continue;
                uid = null;
                pwd = null;
            }
            catch (CLIException ce) {
                throw new UserDataException(null, ce.getMessageObject(), ce);
            }
        }
        if (accepted) {
            String referencedHostName = this.parser.getReferencedHostName();
            while (referencedHostName == null) {
                this.println();
                referencedHostName = this.askForReferencedHostName(userData.getHostName());
            }
            try {
                UninstallData d = new UninstallData(Installation.getLocal());
                userData.setReplicationServer(referencedHostName + ":" + d.getReplicationServerPort());
                userData.setReferencedHostName(referencedHostName);
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Could not create UninstallData: " + t, t);
            }
        }
        userData.setUpdateRemoteReplication(accepted);
        return accepted;
    }

    private String askForReferencedHostName(String defaultHostName) {
        String s = defaultHostName;
        try {
            s = this.readInput(AdminToolMessages.INFO_UNINSTALL_CLI_REFERENCED_HOSTNAME_PROMPT.get(), defaultHostName);
        }
        catch (CLIException ce) {
            LOG.log(Level.WARNING, "Error reading input: " + ce, ce);
        }
        return s;
    }

    private boolean startServer(boolean supressOutput) {
        boolean serverStarted;
        block5: {
            serverStarted = false;
            Application application = new Application(){

                public String getInstallationPath() {
                    return Installation.getLocal().getRootDirectory().getAbsolutePath();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public String getInstancePath() {
                    BufferedReader reader;
                    String installPath = this.getInstallationPath();
                    String instancePathFileName = installPath + File.separator + "lib" + File.separator + "resource.loc";
                    File f = new File(instancePathFileName);
                    if (!f.exists()) {
                        return installPath;
                    }
                    try {
                        reader = new BufferedReader(new FileReader(instancePathFileName));
                    }
                    catch (Exception e) {
                        return installPath;
                    }
                    try {
                        String line = reader.readLine();
                        String string = new File(line).getAbsolutePath();
                        return string;
                    }
                    catch (Exception e) {
                        String string = installPath;
                        return string;
                    }
                    finally {
                        try {
                            reader.close();
                        }
                        catch (Exception e) {}
                    }
                }

                public ProgressStep getCurrentProgressStep() {
                    return UninstallProgressStep.NOT_STARTED;
                }

                public Integer getRatio(ProgressStep step) {
                    return 0;
                }

                public Message getSummary(ProgressStep step) {
                    return null;
                }

                public boolean isFinished() {
                    return false;
                }

                public boolean isCancellable() {
                    return false;
                }

                public void cancel() {
                }

                public void run() {
                }
            };
            application.setProgressMessageFormatter(new PlainTextProgressMessageFormatter());
            if (!supressOutput) {
                application.addProgressUpdateListener(new ProgressUpdateListener(){

                    public void progressUpdate(ProgressUpdateEvent ev) {
                        System.out.print(ev.getNewLogs().toString());
                        System.out.flush();
                    }
                });
            }
            ServerController controller = new ServerController(application, Installation.getLocal());
            try {
                if (!supressOutput) {
                    this.printlnProgress();
                }
                controller.startServer(supressOutput);
                if (!supressOutput) {
                    this.printlnProgress();
                }
                serverStarted = Installation.getLocal().getStatus().isServerRunning();
            }
            catch (ApplicationException ae) {
                if (supressOutput) break block5;
                this.println(ae.getMessageObject());
            }
        }
        return serverStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean updateUserUninstallDataWithRemoteServers(UninstallUserData userData) throws UserDataException, ApplicationException {
        boolean accepted = false;
        boolean interactive = this.parser.isInteractive();
        boolean forceOnError = this.parser.isForceOnError();
        boolean exceptionOccurred = true;
        InitialContext ctx = null;
        try {
            this.info.setTrustManager(userData.getTrustManager());
            String host = "localhost";
            int port = 389;
            String adminUid = userData.getAdminUID();
            String pwd = userData.getAdminPwd();
            String dn = ADSContext.getAdministratorDN(adminUid);
            this.info.setConnectionPolicy(ConnectionProtocolPolicy.USE_ADMIN);
            String adminConnectorUrl = this.info.getAdminConnectorURL();
            try {
                URI uri = new URI(adminConnectorUrl);
                host = uri.getHost();
                port = uri.getPort();
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Error parsing url: " + adminConnectorUrl);
            }
            ctx = this.createAdministrativeContext(host, port, this.useSSL, this.useStartTLS, dn, pwd, userData.getTrustManager());
            ADSContext adsContext = new ADSContext((InitialLdapContext)ctx);
            if (interactive && userData.getTrustManager() == null) {
                this.forceTrustManagerInitialization();
                this.updateTrustManager(userData, this.ci);
            }
            TopologyCache cache = new TopologyCache(adsContext, userData.getTrustManager());
            cache.getFilter().setSearchMonitoringInformation(false);
            cache.reloadTopology();
            accepted = this.handleTopologyCache(cache, userData);
            exceptionOccurred = false;
        }
        catch (NamingException ne) {
            LOG.log(Level.WARNING, "Error connecting to server: " + ne, ne);
            if (Utils.isCertificateException(ne)) {
                this.println();
                this.println(QuickSetupMessages.INFO_ERROR_READING_CONFIG_LDAP_CERTIFICATE.get(ne.getMessage()));
            } else {
                this.println();
                this.println(Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_CONNECTING_TO_LOCAL.get(), ne));
            }
        }
        catch (TopologyCacheException te) {
            LOG.log(Level.WARNING, "Error connecting to server: " + te, te);
            this.println();
            this.println(Utils.getMessage(te));
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Error connecting to server: " + t, t);
            this.println();
            this.println(Utils.getThrowableMsg(QuickSetupMessages.INFO_BUG_MSG.get(), t));
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (Throwable t) {
                    LOG.log(Level.INFO, "Error closing connection: " + t, t);
                }
            }
        }
        if (exceptionOccurred) {
            if (!interactive) {
                if (!forceOnError) throw new UserDataException(null, AdminToolMessages.ERR_UNINSTALL_ERROR_UPDATING_REMOTE_NO_FORCE.get("--" + this.parser.getSecureArgsList().adminUidArg.getLongIdentifier(), "--bindPassword", "--bindPasswordFile", "--" + this.parser.forceOnErrorArg.getLongIdentifier()));
                this.println(AdminToolMessages.ERR_UNINSTALL_ERROR_UPDATING_REMOTE_FORCE.get("--" + this.parser.getSecureArgsList().adminUidArg.getLongIdentifier(), "--bindPassword", "--bindPasswordFile"));
            } else {
                try {
                    accepted = this.askConfirmation(AdminToolMessages.ERR_UNINSTALL_NOT_UPDATE_REMOTE_PROMPT.get(), false, LOG);
                }
                catch (CLIException ce) {
                    throw new UserDataException(null, ce.getMessageObject(), ce);
                }
            }
        }
        userData.setUpdateRemoteReplication(accepted);
        return accepted;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean handleTopologyCache(TopologyCache cache, UninstallUserData userData) throws UserDataException, ApplicationException {
        boolean stopProcessing = false;
        boolean reloadTopologyCache = false;
        boolean interactive = this.parser.isInteractive();
        HashSet<TopologyCacheException> exceptions = new HashSet<TopologyCacheException>();
        Set<ServerDescriptor> servers = cache.getServers();
        userData.setRemoteServers(servers);
        for (ServerDescriptor server : servers) {
            TopologyCacheException e = server.getLastException();
            if (e == null) continue;
            exceptions.add(e);
        }
        LinkedHashSet<Message> exceptionMsgs = new LinkedHashSet<Message>();
        block7: for (TopologyCacheException e : exceptions) {
            if (stopProcessing) break;
            switch (e.getType()) {
                case NOT_GLOBAL_ADMINISTRATOR: {
                    this.println();
                    this.println(QuickSetupMessages.INFO_NOT_GLOBAL_ADMINISTRATOR_PROVIDED.get());
                    stopProcessing = true;
                    continue block7;
                }
                case GENERIC_CREATING_CONNECTION: {
                    if (e.getCause() != null && Utils.isCertificateException(e.getCause())) {
                        if (interactive) {
                            this.println();
                            if (this.ci.promptForCertificateConfirmation(e.getCause(), e.getTrustManager(), e.getLdapUrl(), true, LOG)) {
                                stopProcessing = true;
                                reloadTopologyCache = true;
                                this.updateTrustManager(userData, this.ci);
                                continue block7;
                            }
                            stopProcessing = true;
                            continue block7;
                        }
                        exceptionMsgs.add(QuickSetupMessages.INFO_ERROR_READING_CONFIG_LDAP_CERTIFICATE_SERVER.get(e.getHostPort(), e.getCause().getMessage()));
                        continue block7;
                    }
                    exceptionMsgs.add(Utils.getMessage(e));
                    continue block7;
                }
            }
            exceptionMsgs.add(Utils.getMessage(e));
        }
        if (interactive) {
            if (!stopProcessing && exceptionMsgs.size() > 0) {
                this.println();
                try {
                    return this.askConfirmation(AdminToolMessages.ERR_UNINSTALL_READING_REGISTERED_SERVERS_CONFIRM_UPDATE_REMOTE.get(Utils.getMessageFromCollection(exceptionMsgs, Constants.LINE_SEPARATOR).toString()), true, LOG);
                }
                catch (CLIException ce) {
                    throw new UserDataException(null, ce.getMessageObject(), ce);
                }
            }
            if (reloadTopologyCache) {
                return this.updateUserUninstallDataWithRemoteServers(userData);
            }
            if (stopProcessing) return false;
            return true;
        }
        if (exceptionMsgs.size() <= 0) return true;
        Message msg = Utils.getMessageFromCollection(exceptionMsgs, Constants.LINE_SEPARATOR);
        if (!this.parser.isForceOnError()) throw new ApplicationException(ReturnCode.APPLICATION_ERROR, msg, null);
        this.println();
        this.println(msg);
        return false;
    }

    @Override
    public boolean isAdvancedMode() {
        return false;
    }

    @Override
    public boolean isInteractive() {
        if (this.forceNonInteractive) {
            return false;
        }
        return this.parser.isInteractive();
    }

    @Override
    public boolean isMenuDrivenMode() {
        return true;
    }

    @Override
    public boolean isQuiet() {
        return false;
    }

    @Override
    public boolean isScriptFriendly() {
        return false;
    }

    @Override
    public boolean isVerbose() {
        return true;
    }

    private void updateTrustManager(UninstallUserData userData, LDAPConnectionConsoleInteraction ci) {
        ApplicationTrustManager trust = null;
        ApplicationTrustManager t = ci.getTrustManager();
        if (t != null) {
            trust = t instanceof ApplicationTrustManager ? t : new ApplicationTrustManager(ci.getKeyStore());
        }
        userData.setTrustManager(trust);
    }

    private void forceTrustManagerInitialization() {
        this.forceNonInteractive = true;
        try {
            this.ci.initializeTrustManagerIfRequired();
        }
        catch (ArgumentException ae) {
            LOG.log(Level.WARNING, "Error initializing trust store: " + ae, ae);
        }
        this.forceNonInteractive = false;
    }
}

