/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.installandupgrader;

import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.opends.admin.ads.util.ApplicationTrustManager;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ButtonName;
import org.opends.quicksetup.CurrentInstallStatus;
import org.opends.quicksetup.ProgressStep;
import org.opends.quicksetup.QuickSetupLog;
import org.opends.quicksetup.Step;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.UserDataException;
import org.opends.quicksetup.WizardStep;
import org.opends.quicksetup.event.ProgressUpdateListener;
import org.opends.quicksetup.installandupgrader.InstallAndUpgradeUserData;
import org.opends.quicksetup.installandupgrader.ui.WelcomePanel;
import org.opends.quicksetup.installer.offline.OfflineInstaller;
import org.opends.quicksetup.installer.webstart.WebStartInstaller;
import org.opends.quicksetup.ui.FieldName;
import org.opends.quicksetup.ui.GuiApplication;
import org.opends.quicksetup.ui.QuickSetup;
import org.opends.quicksetup.ui.QuickSetupDialog;
import org.opends.quicksetup.ui.QuickSetupStepPanel;
import org.opends.quicksetup.upgrader.UpgradeWizardStep;
import org.opends.quicksetup.upgrader.Upgrader;
import org.opends.quicksetup.util.ProgressMessageFormatter;
import org.opends.quicksetup.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallAndUpgrader
extends GuiApplication {
    private static final Logger LOG = Logger.getLogger(InstallAndUpgrader.class.getName());
    private GuiApplication installer;
    private GuiApplication upgrader;
    private InstallAndUpgradeUserData userData;

    public InstallAndUpgrader() {
        try {
            if (!QuickSetupLog.isInitialized()) {
                QuickSetupLog.initLogFileHandler(File.createTempFile("opends-setup-", ".log"));
            }
        }
        catch (IOException e) {
            System.err.println(QuickSetupMessages.INFO_ERROR_INITIALIZING_LOG.get());
            e.printStackTrace();
        }
        this.installer = Utils.isWebStart() ? new WebStartInstaller() : new OfflineInstaller();
        this.upgrader = new Upgrader();
    }

    @Override
    public void setProgressMessageFormatter(ProgressMessageFormatter formatter) {
        super.setProgressMessageFormatter(formatter);
        this.installer.setProgressMessageFormatter(formatter);
        this.upgrader.setProgressMessageFormatter(formatter);
    }

    @Override
    public void setCurrentInstallStatus(CurrentInstallStatus installStatus) {
        super.setCurrentInstallStatus(installStatus);
        this.installer.setCurrentInstallStatus(installStatus);
        this.upgrader.setCurrentInstallStatus(installStatus);
    }

    @Override
    public UserData getUserData() {
        return this.getDelegateApplication().getUserData();
    }

    @Override
    public Message getFrameTitle() {
        return QuickSetupMessages.INFO_FRAME_INSTALL_TITLE.get();
    }

    @Override
    public WizardStep getFirstWizardStep() {
        return Step.WELCOME;
    }

    @Override
    public WizardStep getFinishedStep() {
        return this.getDelegateApplication().getFinishedStep();
    }

    @Override
    public void run() {
        this.getDelegateApplication().run();
    }

    @Override
    public void addProgressUpdateListener(ProgressUpdateListener l) {
        this.installer.addProgressUpdateListener(l);
        this.upgrader.addProgressUpdateListener(l);
    }

    @Override
    public void removeProgressUpdateListener(ProgressUpdateListener l) {
        this.installer.removeProgressUpdateListener(l);
        this.upgrader.removeProgressUpdateListener(l);
    }

    @Override
    public boolean isCancellable() {
        return this.getDelegateApplication().isCancellable();
    }

    @Override
    public void setWizardDialogState(QuickSetupDialog dlg, UserData userData, WizardStep step) {
        if (this.getDelegateApplication() == this.upgrader && step == Step.WELCOME) {
            step = UpgradeWizardStep.WELCOME;
        }
        this.getDelegateApplication().setWizardDialogState(dlg, userData, step);
    }

    @Override
    public WizardStep getNextWizardStep(WizardStep step) {
        if (this.getDelegateApplication() == this.upgrader && step == Step.WELCOME) {
            step = UpgradeWizardStep.WELCOME;
        }
        return this.getDelegateApplication().getNextWizardStep(step);
    }

    @Override
    public QuickSetupStepPanel createWizardStepPanel(WizardStep step) {
        QuickSetupStepPanel p = null;
        if (step == Step.WELCOME) {
            p = new WelcomePanel(this);
        }
        if (p == null) {
            p = this.upgrader.createWizardStepPanel(step);
        }
        if (p == null) {
            p = this.installer.createWizardStepPanel(step);
        }
        return p;
    }

    @Override
    public WizardStep getPreviousWizardStep(WizardStep step) {
        WizardStep s = this.getDelegateApplication().getPreviousWizardStep(step);
        if (s == UpgradeWizardStep.WELCOME) {
            s = Step.WELCOME;
        }
        return s;
    }

    @Override
    public LinkedHashSet<WizardStep> getOrderedSteps() {
        LinkedHashSet<WizardStep> set = new LinkedHashSet<WizardStep>();
        set.addAll(this.installer.getOrderedSteps());
        set.addAll(this.upgrader.getOrderedSteps());
        set.remove(UpgradeWizardStep.WELCOME);
        return set;
    }

    @Override
    public ProgressStep getCurrentProgressStep() {
        return this.getDelegateApplication().getCurrentProgressStep();
    }

    @Override
    public Integer getRatio(ProgressStep step) {
        return this.getDelegateApplication().getRatio(step);
    }

    @Override
    public Message getSummary(ProgressStep step) {
        return this.getDelegateApplication().getSummary(step);
    }

    @Override
    public void windowClosing(QuickSetupDialog dlg, WindowEvent evt) {
        this.getDelegateApplication().windowClosing(dlg, evt);
    }

    @Override
    public ButtonName getInitialFocusButtonName() {
        return this.getDelegateApplication().getInitialFocusButtonName();
    }

    @Override
    public Set<? extends WizardStep> getWizardSteps() {
        HashSet<WizardStep> set = new HashSet<WizardStep>();
        set.addAll(this.installer.getWizardSteps());
        set.addAll(this.upgrader.getWizardSteps());
        set.remove(UpgradeWizardStep.WELCOME);
        return set;
    }

    @Override
    public boolean isVisible(WizardStep step, UserData userData) {
        boolean isVisible = step == Step.WELCOME ? true : this.getDelegateApplication().isVisible(step, this.getDelegateApplication().getUserData()) && this.getDelegateApplication().getWizardSteps().contains(step);
        return isVisible;
    }

    @Override
    public boolean isVisible(WizardStep step, QuickSetup qs) {
        boolean isVisible;
        if (step == Step.WELCOME) {
            isVisible = true;
        } else {
            Boolean isUpgrade = (Boolean)qs.getFieldValue(FieldName.IS_UPGRADE);
            GuiApplication appl = Boolean.TRUE.equals(isUpgrade) ? this.upgrader : this.installer;
            isVisible = appl.isVisible(step, qs) && appl.getWizardSteps().contains(step);
        }
        return isVisible;
    }

    @Override
    public boolean isSubStep(WizardStep step) {
        boolean isSubStep = step == Step.WELCOME ? false : this.getDelegateApplication().isSubStep(step);
        return isSubStep;
    }

    @Override
    public boolean canGoBack(WizardStep step) {
        boolean canGoBack = step == Step.WELCOME ? false : this.getDelegateApplication().canGoBack(step);
        return canGoBack;
    }

    @Override
    public boolean canGoForward(WizardStep step) {
        boolean canGoForward = step == Step.WELCOME ? true : this.getDelegateApplication().canGoForward(step);
        return canGoForward;
    }

    @Override
    public boolean canFinish(WizardStep step) {
        return this.getDelegateApplication().canFinish(step);
    }

    @Override
    public boolean canQuit(WizardStep step) {
        return this.getDelegateApplication().canQuit(step);
    }

    @Override
    public void previousClicked(WizardStep cStep, QuickSetup qs) {
        this.getDelegateApplication().previousClicked(cStep, qs);
    }

    @Override
    public void nextClicked(WizardStep cStep, QuickSetup qs) {
        this.getDelegateApplication().nextClicked(cStep, qs);
    }

    @Override
    public boolean finishClicked(WizardStep cStep, QuickSetup qs) {
        return this.getDelegateApplication().finishClicked(cStep, qs);
    }

    @Override
    public void closeClicked(WizardStep cStep, QuickSetup qs) {
        this.getDelegateApplication().closeClicked(cStep, qs);
    }

    @Override
    public void quitClicked(WizardStep cStep, QuickSetup qs) {
        this.getDelegateApplication().quitClicked(cStep, qs);
    }

    @Override
    public void updateUserData(WizardStep cStep, QuickSetup qs) throws UserDataException {
        if (cStep == Step.WELCOME) {
            Boolean isUpgrade = (Boolean)qs.getFieldValue(FieldName.IS_UPGRADE);
            this.getInstallAndUpgradeUserData().setUpgrade(isUpgrade);
            if (isUpgrade.booleanValue()) {
                this.upgrader.updateUserData(UpgradeWizardStep.WELCOME, qs);
                this.getUserData().setServerLocation(this.upgrader.getUserData().getServerLocation());
            } else {
                this.installer.updateUserData(cStep, qs);
            }
        } else {
            this.getDelegateApplication().updateUserData(cStep, qs);
        }
    }

    @Override
    public void cancel() {
        this.getDelegateApplication().cancel();
    }

    @Override
    public boolean isFinished() {
        return this.getDelegateApplication().isFinished();
    }

    @Override
    public String getInstallationPath() {
        return this.getDelegateApplication().getInstallationPath();
    }

    @Override
    public String getInstancePath() {
        return this.getDelegateApplication().getInstancePath();
    }

    @Override
    public void setQuickSetupDialog(QuickSetupDialog dialog) {
        this.installer.setQuickSetupDialog(dialog);
        this.upgrader.setQuickSetupDialog(dialog);
    }

    private GuiApplication getDelegateApplication() {
        GuiApplication application = this.getInstallAndUpgradeUserData().isUpgrade() ? this.upgrader : this.installer;
        return application;
    }

    public InstallAndUpgradeUserData getInstallAndUpgradeUserData() {
        if (this.userData == null) {
            this.userData = new InstallAndUpgradeUserData();
        }
        return this.userData;
    }

    @Override
    public ApplicationTrustManager getTrustManager() {
        return this.getDelegateApplication().getTrustManager();
    }
}

