/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb.importLDIF;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.StatsConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.opends.messages.JebMessages;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.LocalDBBackendCfg;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.JebException;
import org.opends.server.backends.jeb.RootContainer;
import org.opends.server.backends.jeb.importLDIF.BufferManager;
import org.opends.server.backends.jeb.importLDIF.DNContext;
import org.opends.server.backends.jeb.importLDIF.WorkElement;
import org.opends.server.backends.jeb.importLDIF.WorkThread;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.LDIFImportResult;
import org.opends.server.types.ResultCode;
import org.opends.server.util.LDIFException;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.RuntimeInformation;
import org.opends.server.util.StaticUtils;

public class Importer
implements Thread.UncaughtExceptionHandler {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private LocalDBBackendCfg config;
    private RootContainer rootContainer;
    private LDIFImportConfig ldifImportConfig;
    private LDIFReader reader;
    private LinkedHashMap<DN, DNContext> importMap = new LinkedHashMap();
    private int migratedCount;
    private int importedCount;
    private long progressInterval = 10000L;
    private Timer timer;
    private CopyOnWriteArrayList<WorkThread> threads;
    private ProgressTask pTask;
    private static final int entryCleanInterval = 250000;
    private static final long minBuffer = 0x100000L;
    private long totalAvailBufferMemory = 0L;
    private String dbCacheSizeStr;
    private boolean firstClean = false;
    private boolean unCaughtExceptionThrown = false;
    private boolean hasSubIndexes = false;
    private WorkThread workThread0;
    private int worker0Proc = 0;
    private static final int maxWorker0 = 20;

    public Importer(LDIFImportConfig ldifImportConfig, boolean hasSubIndexes) {
        this.ldifImportConfig = ldifImportConfig;
        this.threads = new CopyOnWriteArrayList();
        this.hasSubIndexes = hasSubIndexes;
        this.calcMemoryLimits();
    }

    private void startWorkerThreads() throws DatabaseException {
        ProgressTask progressTask;
        int importThreadCount = this.config.getImportThreadCount();
        int contextCount = this.importMap.size();
        long memoryPerContext = this.totalAvailBufferMemory / (long)contextCount;
        if (memoryPerContext < 0x100000L) {
            Message msg = JebMessages.NOTE_JEB_IMPORT_LDIF_BUFFER_CONTEXT_AVAILMEM.get(memoryPerContext, 0x100000L);
            ErrorLogger.logError(msg);
            memoryPerContext = 0x100000L;
        }
        for (DNContext context : this.importMap.values()) {
            BufferManager bufferManager = new BufferManager(memoryPerContext);
            context.setBufferManager(bufferManager);
            for (int i = 0; i < importThreadCount; ++i) {
                WorkThread t = new WorkThread(context.getWorkQueue(), i, bufferManager, this.rootContainer, this.importMap);
                t.setUncaughtExceptionHandler(this);
                this.threads.add(t);
                if (i == 0) {
                    this.workThread0 = t;
                }
                t.start();
            }
        }
        this.timer = new Timer();
        this.pTask = progressTask = new ProgressTask();
        this.timer.scheduleAtFixedRate((TimerTask)progressTask, this.progressInterval, this.progressInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LDIFImportResult processImport(RootContainer rootContainer) throws DatabaseException, IOException, JebException, DirectoryException, ConfigException {
        long startTime;
        this.reader = new LDIFReader(this.ldifImportConfig);
        this.rootContainer = rootContainer;
        this.config = rootContainer.getConfiguration();
        try {
            int importThreadCount = this.config.getImportThreadCount();
            Message message = JebMessages.NOTE_JEB_IMPORT_STARTING.get(DirectoryServer.getVersionString(), "20090127112532Z", 4920L);
            ErrorLogger.logError(message);
            message = JebMessages.NOTE_JEB_IMPORT_THREAD_COUNT.get(importThreadCount);
            ErrorLogger.logError(message);
            RuntimeInformation.logInfo();
            for (EntryContainer entryContainer : rootContainer.getEntryContainers()) {
                DNContext DNContext2 = this.getImportContext(entryContainer);
                if (DNContext2 == null) continue;
                this.importMap.put(entryContainer.getBaseDN(), DNContext2);
            }
            startTime = System.currentTimeMillis();
            this.startWorkerThreads();
            try {
                this.importedCount = 0;
                this.migratedCount = 0;
                this.migrateExistingEntries();
                this.processLDIF();
                this.migrateExcludedEntries();
            }
            finally {
                if (!this.unCaughtExceptionThrown) {
                    this.cleanUp();
                    this.switchContainers();
                }
            }
        }
        finally {
            this.reader.close();
        }
        this.importProlog(startTime);
        return new LDIFImportResult(this.reader.getEntriesRead(), this.reader.getEntriesRejected(), this.reader.getEntriesIgnored());
    }

    private void switchContainers() throws DatabaseException, JebException {
        for (DNContext importContext : this.importMap.values()) {
            EntryContainer unregEC;
            DN baseDN = importContext.getBaseDN();
            EntryContainer srcEntryContainer = importContext.getSrcEntryContainer();
            if (srcEntryContainer == null) continue;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Deleteing old entry container for base DN %s and renaming temp entry container", baseDN);
            }
            if ((unregEC = this.rootContainer.unregisterEntryContainer(baseDN)) != srcEntryContainer) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("Current entry container used for base DN %s is not the same as the source entry container used during the migration process.", baseDN);
                }
                this.rootContainer.registerEntryContainer(baseDN, unregEC);
                continue;
            }
            srcEntryContainer.lock();
            srcEntryContainer.delete();
            srcEntryContainer.unlock();
            EntryContainer newEC = importContext.getEntryContainer();
            newEC.lock();
            newEC.setDatabasePrefix(baseDN.toNormalizedString());
            newEC.unlock();
            this.rootContainer.registerEntryContainer(baseDN, newEC);
        }
    }

    private void importProlog(long startTime) {
        long finishTime = System.currentTimeMillis();
        long importTime = finishTime - startTime;
        float rate = 0.0f;
        if (importTime > 0L) {
            rate = 1000.0f * (float)this.importedCount / (float)importTime;
        }
        Message message = JebMessages.NOTE_JEB_IMPORT_FINAL_STATUS.get(this.reader.getEntriesRead(), this.importedCount, this.reader.getEntriesIgnored(), this.reader.getEntriesRejected(), this.migratedCount, importTime / 1000L, Float.valueOf(rate));
        ErrorLogger.logError(message);
        message = JebMessages.NOTE_JEB_IMPORT_ENTRY_LIMIT_EXCEEDED_COUNT.get(this.getEntryLimitExceededCount());
        ErrorLogger.logError(message);
    }

    private void runCleanerIfNeeded(long entriesRead, long evictEntryNumber) throws DatabaseException {
        if (!this.firstClean || entriesRead % evictEntryNumber == 0L) {
            this.drainWorkQueue();
            Message msg = JebMessages.NOTE_JEB_IMPORT_LDIF_CLEAN.get();
            this.runCleaner(msg);
            if (!this.firstClean) {
                this.firstClean = true;
            }
        }
    }

    private void runCleaner(Message header) throws DatabaseException {
        Message msg;
        long startTime = System.currentTimeMillis();
        this.rootContainer.importForceCheckPoint();
        ErrorLogger.logError(header);
        this.pTask.setPause(true);
        int cleaned = this.rootContainer.cleanedLogFiles();
        if (cleaned > 0) {
            msg = JebMessages.NOTE_JEB_IMPORT_LDIF_CLEANER_REMOVE_LOGS.get(cleaned);
            ErrorLogger.logError(msg);
            this.rootContainer.importForceCheckPoint();
        }
        this.pTask.setPause(false);
        long finishTime = System.currentTimeMillis();
        long cleanTime = (finishTime - startTime) / 1000L;
        msg = JebMessages.NOTE_JEB_IMPORT_LDIF_CLEANER_RUN_DONE.get(cleanTime, cleaned);
        ErrorLogger.logError(msg);
    }

    private void processLDIF() throws JebException, DatabaseException, IOException {
        Message message = JebMessages.NOTE_JEB_IMPORT_LDIF_START.get();
        ErrorLogger.logError(message);
        while (!this.ldifImportConfig.isCancelled()) {
            if (this.threads.size() <= 0) {
                message = JebMessages.ERR_JEB_IMPORT_NO_WORKER_THREADS.get();
                throw new JebException(message);
            }
            if (this.unCaughtExceptionThrown) {
                this.abortImport();
            }
            try {
                Entry entry = this.reader.readEntry();
                if (entry == null) {
                    message = JebMessages.NOTE_JEB_IMPORT_LDIF_END.get();
                    ErrorLogger.logError(message);
                    break;
                }
                DNContext DNContext2 = this.getImportConfig(entry.getDN());
                this.processEntry(DNContext2, entry);
                if (!this.pTask.isEvicting()) continue;
                this.runCleanerIfNeeded(this.reader.getEntriesRead(), 250000L);
            }
            catch (LDIFException e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            catch (DirectoryException e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            catch (DatabaseException e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    private void processEntry(DNContext DNContext2, Entry entry) throws DirectoryException, DatabaseException, JebException {
        if (this.worker0Proc < 20) {
            DNContext2.addPending(entry.getDN());
            WorkElement element = WorkElement.decode(entry, DNContext2);
            this.workThread0.process(element);
            ++this.worker0Proc;
        } else {
            DNContext2.addPending(entry.getDN());
            this.addEntryQueue(DNContext2, entry);
        }
    }

    private boolean addQueue(DNContext context, WorkElement item) {
        block3: {
            try {
                while (!context.getWorkQueue().offer(item, 1000L, TimeUnit.MILLISECONDS)) {
                    if (this.threads.size() > 0) continue;
                    return false;
                }
            }
            catch (InterruptedException e) {
                if (!DebugLogger.debugEnabled()) break block3;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        return true;
    }

    private void drainWorkQueue() {
        if (this.threads.size() > 0) {
            for (DNContext context : this.importMap.values()) {
                while (context.getWorkQueue().size() > 0) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private void abortImport() throws JebException {
        this.stopWorkThreads(false);
        this.timer.cancel();
        Message message = JebMessages.ERR_JEB_IMPORT_LDIF_ABORT.get();
        throw new JebException(message);
    }

    private void stopWorkThreads(boolean abort) throws JebException {
        for (WorkThread t : this.threads) {
            t.stopProcessing();
        }
        for (WorkThread t : this.threads) {
            try {
                if (!abort && this.unCaughtExceptionThrown) {
                    this.timer.cancel();
                    Message message = JebMessages.ERR_JEB_IMPORT_LDIF_ABORT.get();
                    throw new JebException(message);
                }
                t.join();
                this.importedCount += t.getImportedCount();
            }
            catch (InterruptedException ie) {}
        }
    }

    private void cleanUp() throws DatabaseException, JebException {
        this.drainWorkQueue();
        this.pTask.setPause(true);
        long startTime = System.currentTimeMillis();
        this.stopWorkThreads(true);
        for (DNContext context : this.importMap.values()) {
            context.getBufferManager().prepareFlush();
            context.getBufferManager().flushAll();
        }
        long finishTime = System.currentTimeMillis();
        long flushTime = (finishTime - startTime) / 1000L;
        Message msg = JebMessages.NOTE_JEB_IMPORT_LDIF_BUFFER_FLUSH_COMPLETED.get(flushTime);
        ErrorLogger.logError(msg);
        this.timer.cancel();
        for (DNContext context : this.importMap.values()) {
            context.setIndexesTrusted();
        }
        msg = JebMessages.NOTE_JEB_IMPORT_LDIF_FINAL_CLEAN.get();
        this.runCleaner(msg);
        this.closeIndexCursors();
    }

    private void closeIndexCursors() throws DatabaseException {
        for (DNContext ic : this.importMap.values()) {
            ic.getEntryContainer().closeIndexCursors();
        }
    }

    public void uncaughtException(Thread t, Throwable e) {
        this.unCaughtExceptionThrown = true;
        this.threads.remove(t);
        Message msg = JebMessages.ERR_JEB_IMPORT_THREAD_EXCEPTION.get(t.getName(), StaticUtils.stackTraceToSingleLineString(e.getCause()));
        ErrorLogger.logError(msg);
    }

    private int getEntryLimitExceededCount() {
        int count = 0;
        for (DNContext ic : this.importMap.values()) {
            count += ic.getEntryContainer().getEntryLimitExceededCount();
        }
        return count;
    }

    private DNContext getImportConfig(DN dn) throws DirectoryException {
        DNContext DNContext2 = null;
        DN nodeDN = dn;
        while (DNContext2 == null && nodeDN != null) {
            DNContext2 = this.importMap.get(nodeDN);
            if (DNContext2 != null) continue;
            nodeDN = nodeDN.getParentDNInSuffix();
        }
        if (nodeDN == null) {
            Message message = JebMessages.ERR_JEB_INCORRECT_ROUTING.get(String.valueOf(dn));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message);
        }
        return DNContext2;
    }

    private DNContext getImportContext(EntryContainer entryContainer) throws DatabaseException, JebException, ConfigException {
        DN baseDN = entryContainer.getBaseDN();
        EntryContainer srcEntryContainer = null;
        ArrayList<DN> includeBranches = new ArrayList<DN>();
        ArrayList<DN> excludeBranches = new ArrayList<DN>();
        if (!this.ldifImportConfig.appendToExistingData() && !this.ldifImportConfig.clearBackend()) {
            for (DN dn : this.ldifImportConfig.getExcludeBranches()) {
                if (baseDN.equals(dn)) {
                    return null;
                }
                if (!baseDN.isAncestorOf(dn)) continue;
                excludeBranches.add(dn);
            }
            if (!this.ldifImportConfig.getIncludeBranches().isEmpty()) {
                for (DN dn : this.ldifImportConfig.getIncludeBranches()) {
                    if (!baseDN.isAncestorOf(dn)) continue;
                    includeBranches.add(dn);
                }
                if (includeBranches.isEmpty()) {
                    return null;
                }
                Iterator includeBranchIterator = includeBranches.iterator();
                while (includeBranchIterator.hasNext()) {
                    DN includeDN = (DN)includeBranchIterator.next();
                    boolean keep = true;
                    for (DN dn : includeBranches) {
                        if (dn.equals(includeDN) || !dn.isAncestorOf(includeDN)) continue;
                        keep = false;
                        break;
                    }
                    if (keep) continue;
                    includeBranchIterator.remove();
                }
                Iterator excludeBranchIterator = excludeBranches.iterator();
                while (excludeBranchIterator.hasNext()) {
                    DN excludeDN = (DN)excludeBranchIterator.next();
                    boolean keep = false;
                    for (DN includeDN : includeBranches) {
                        if (!includeDN.isAncestorOf(excludeDN)) continue;
                        keep = true;
                        break;
                    }
                    if (keep) continue;
                    excludeBranchIterator.remove();
                }
                if (includeBranches.size() == 1 && excludeBranches.size() == 0 && ((DN)includeBranches.get(0)).equals(baseDN)) {
                    entryContainer.lock();
                    entryContainer.clear();
                    entryContainer.unlock();
                } else {
                    srcEntryContainer = entryContainer;
                    entryContainer = this.rootContainer.openEntryContainer(baseDN, baseDN.toNormalizedString() + "_importTmp");
                }
            }
        }
        DNContext DNContext2 = new DNContext();
        DNContext2.setConfig(this.config);
        DNContext2.setLDIFImportConfig(this.ldifImportConfig);
        DNContext2.setLDIFReader(this.reader);
        DNContext2.setBaseDN(baseDN);
        DNContext2.setEntryContainer(entryContainer);
        DNContext2.setSrcEntryContainer(srcEntryContainer);
        LinkedBlockingQueue<WorkElement> works = new LinkedBlockingQueue<WorkElement>(this.config.getImportQueueSize());
        DNContext2.setWorkQueue(works);
        DNContext2.setIncludeBranches(includeBranches);
        DNContext2.setExcludeBranches(excludeBranches);
        return DNContext2;
    }

    private boolean addEntryQueue(DNContext context, Entry entry) {
        WorkElement element = WorkElement.decode(entry, context);
        return this.addQueue(context, element);
    }

    private void calcMemoryLimits() {
        Message msg;
        Runtime runtime = Runtime.getRuntime();
        long freeMemory = runtime.freeMemory();
        long maxMemory = runtime.maxMemory();
        long totMemory = runtime.totalMemory();
        long totFreeMemory = freeMemory + (maxMemory - totMemory);
        long dbCacheLimit = totFreeMemory * 60L / 100L;
        if (!this.hasSubIndexes) {
            dbCacheLimit = totFreeMemory * 75L / 100L;
        }
        this.dbCacheSizeStr = Long.toString(dbCacheLimit);
        this.totalAvailBufferMemory = totFreeMemory * 10L / 100L;
        if (this.totalAvailBufferMemory < 0xA00000L) {
            msg = JebMessages.NOTE_JEB_IMPORT_LDIF_BUFFER_TOT_AVAILMEM.get(this.totalAvailBufferMemory, 0xA00000L);
            ErrorLogger.logError(msg);
            this.totalAvailBufferMemory = 0xA00000L;
        } else if (!this.hasSubIndexes) {
            this.totalAvailBufferMemory = 0xA00000L;
        }
        msg = JebMessages.NOTE_JEB_IMPORT_LDIF_MEMORY_INFO.get(dbCacheLimit, this.totalAvailBufferMemory);
        ErrorLogger.logError(msg);
    }

    public String getDBCacheSize() {
        return this.dbCacheSizeStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateExistingEntries() throws JebException, DatabaseException, DirectoryException {
        for (DNContext context : this.importMap.values()) {
            EntryContainer srcEntryContainer = context.getSrcEntryContainer();
            if (srcEntryContainer == null || context.getIncludeBranches().isEmpty()) continue;
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            LockMode lockMode = LockMode.DEFAULT;
            Message message = JebMessages.NOTE_JEB_IMPORT_MIGRATION_START.get("existing", String.valueOf(context.getBaseDN()));
            ErrorLogger.logError(message);
            Cursor cursor = srcEntryContainer.getDN2ID().openCursor(null, CursorConfig.READ_COMMITTED);
            try {
                OperationStatus status = cursor.getFirst(key, data, lockMode);
                while (status == OperationStatus.SUCCESS && !this.ldifImportConfig.isCancelled()) {
                    if (this.threads.size() <= 0) {
                        message = JebMessages.ERR_JEB_IMPORT_NO_WORKER_THREADS.get();
                        throw new JebException(message);
                    }
                    DN dn = DN.decode(new ASN1OctetString(key.getData()));
                    if (!context.getIncludeBranches().contains(dn)) {
                        EntryID id = new EntryID(data);
                        Entry entry = srcEntryContainer.getID2Entry().get(null, id, LockMode.DEFAULT);
                        this.processEntry(context, entry);
                        ++this.migratedCount;
                        status = cursor.getNext(key, data, lockMode);
                        continue;
                    }
                    byte[] begin = StaticUtils.getBytes("," + dn.toNormalizedString());
                    begin[0] = (byte)(begin[0] + 1);
                    key.setData(begin);
                    status = cursor.getSearchKeyRange(key, data, lockMode);
                }
            }
            finally {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateExcludedEntries() throws JebException, DatabaseException, DirectoryException {
        for (DNContext importContext : this.importMap.values()) {
            EntryContainer srcEntryContainer = importContext.getSrcEntryContainer();
            if (srcEntryContainer == null || importContext.getExcludeBranches().isEmpty()) continue;
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            LockMode lockMode = LockMode.DEFAULT;
            Message message = JebMessages.NOTE_JEB_IMPORT_MIGRATION_START.get("excluded", String.valueOf(importContext.getBaseDN()));
            ErrorLogger.logError(message);
            Cursor cursor = srcEntryContainer.getDN2ID().openCursor(null, CursorConfig.READ_COMMITTED);
            Comparator<byte[]> dn2idComparator = srcEntryContainer.getDN2ID().getComparator();
            try {
                for (DN excludedDN : importContext.getExcludeBranches()) {
                    byte[] suffix = StaticUtils.getBytes(excludedDN.toNormalizedString());
                    key.setData(suffix);
                    OperationStatus status = cursor.getSearchKeyRange(key, data, lockMode);
                    if (status != OperationStatus.SUCCESS || !Arrays.equals(key.getData(), suffix)) continue;
                    byte[] end = StaticUtils.getBytes("," + excludedDN.toNormalizedString());
                    end[0] = (byte)(end[0] + 1);
                    while (status == OperationStatus.SUCCESS && dn2idComparator.compare(key.getData(), end) < 0 && !this.ldifImportConfig.isCancelled()) {
                        if (this.threads.size() <= 0) {
                            message = JebMessages.ERR_JEB_IMPORT_NO_WORKER_THREADS.get();
                            throw new JebException(message);
                        }
                        EntryID id = new EntryID(data);
                        Entry entry = srcEntryContainer.getID2Entry().get(null, id, LockMode.DEFAULT);
                        this.processEntry(importContext, entry);
                        ++this.migratedCount;
                        status = cursor.getNext(key, data, lockMode);
                    }
                }
            }
            finally {
                cursor.close();
            }
        }
    }

    private final class ProgressTask
    extends TimerTask {
        private long previousCount = 0L;
        private long previousTime = System.currentTimeMillis();
        private EnvironmentStats prevEnvStats;
        public static final int bytesPerMegabyte = 0x100000;
        private boolean ldifRead = false;
        private boolean evicting = false;
        private long evictionEntryCount = 0L;
        private boolean pause = false;

        public ProgressTask() throws DatabaseException {
            this.prevEnvStats = Importer.this.rootContainer.getEnvironmentStats(new StatsConfig());
        }

        public void ldifRead() {
            this.ldifRead = true;
        }

        public boolean isEvicting() {
            return this.evicting;
        }

        public long getEvictionEntryCount() {
            return this.evictionEntryCount;
        }

        public void setPause(boolean v) {
            this.pause = v;
        }

        public void run() {
            Message message;
            long latestCount = Importer.this.reader.getEntriesRead() + 0L;
            long deltaCount = latestCount - this.previousCount;
            long latestTime = System.currentTimeMillis();
            long deltaTime = latestTime - this.previousTime;
            if (deltaTime == 0L) {
                return;
            }
            if (this.pause) {
                return;
            }
            if (!this.ldifRead) {
                long numRead = Importer.this.reader.getEntriesRead();
                long numIgnored = Importer.this.reader.getEntriesIgnored();
                long numRejected = Importer.this.reader.getEntriesRejected();
                float rate = 1000.0f * (float)deltaCount / (float)deltaTime;
                message = JebMessages.NOTE_JEB_IMPORT_PROGRESS_REPORT.get(numRead, numIgnored, numRejected, 0, Float.valueOf(rate));
                ErrorLogger.logError(message);
            }
            try {
                Runtime runtime = Runtime.getRuntime();
                long freeMemory = runtime.freeMemory() / 0x100000L;
                EnvironmentStats envStats = Importer.this.rootContainer.getEnvironmentStats(new StatsConfig());
                long nCacheMiss = envStats.getNCacheMiss() - this.prevEnvStats.getNCacheMiss();
                float cacheMissRate = 0.0f;
                if (deltaCount > 0L) {
                    cacheMissRate = (float)nCacheMiss / (float)deltaCount;
                }
                message = JebMessages.NOTE_JEB_IMPORT_CACHE_AND_MEMORY_REPORT.get(freeMemory, Float.valueOf(cacheMissRate));
                ErrorLogger.logError(message);
                long evictPasses = envStats.getNEvictPasses();
                long evictNodes = envStats.getNNodesExplicitlyEvicted();
                long evictBinsStrip = envStats.getNBINsStripped();
                long cleanerRuns = envStats.getNCleanerRuns();
                long cleanerDeletions = envStats.getNCleanerDeletions();
                long cleanerEntriesRead = envStats.getNCleanerEntriesRead();
                long cleanerINCleaned = envStats.getNINsCleaned();
                long checkPoints = envStats.getNCheckpoints();
                if (evictPasses != 0L) {
                    if (!this.evicting) {
                        this.evicting = true;
                        if (!this.ldifRead) {
                            this.evictionEntryCount = Importer.this.reader.getEntriesRead();
                            message = JebMessages.NOTE_JEB_IMPORT_LDIF_EVICTION_DETECTED.get(this.evictionEntryCount);
                            ErrorLogger.logError(message);
                        }
                    }
                    message = JebMessages.NOTE_JEB_IMPORT_LDIF_EVICTION_DETECTED_STATS.get(evictPasses, evictNodes, evictBinsStrip);
                    ErrorLogger.logError(message);
                }
                if (cleanerRuns != 0L) {
                    message = JebMessages.NOTE_JEB_IMPORT_LDIF_CLEANER_STATS.get(cleanerRuns, cleanerDeletions, cleanerEntriesRead, cleanerINCleaned);
                    ErrorLogger.logError(message);
                }
                if (checkPoints > 1L) {
                    message = JebMessages.NOTE_JEB_IMPORT_LDIF_BUFFER_CHECKPOINTS.get(checkPoints);
                    ErrorLogger.logError(message);
                }
                this.prevEnvStats = envStats;
            }
            catch (DatabaseException e) {
                // empty catch block
            }
            this.previousCount = latestCount;
            this.previousTime = latestTime;
        }
    }
}

