/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.task;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import javax.mail.MessagingException;
import org.opends.messages.BackendMessages;
import org.opends.messages.Message;
import org.opends.server.backends.task.FailedDependencyAction;
import org.opends.server.backends.task.TaskBackend;
import org.opends.server.backends.task.TaskScheduler;
import org.opends.server.backends.task.TaskState;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Attributes;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.Operation;
import org.opends.server.util.EMailMessage;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Task
implements Comparable<Task> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private DN taskEntryDN;
    private Entry taskEntry;
    private FailedDependencyAction failedDependencyAction;
    private int logMessageCounter;
    private LinkedList<String> dependencyIDs;
    private LinkedList<String> logMessages;
    private LinkedList<String> notifyOnCompletion;
    private LinkedList<String> notifyOnError;
    private long actualStartTime;
    private long completionTime;
    private long scheduledStartTime;
    private Operation operation;
    private String recurringTaskID;
    private String taskID;
    private TaskBackend taskBackend;
    private TaskState taskState;
    private TaskState taskInterruptState;
    private TaskScheduler taskScheduler;

    public Message getDisplayName() {
        return null;
    }

    public Message getAttributeDisplayName(String name) {
        return null;
    }

    public final void initializeTaskInternal(TaskScheduler taskScheduler, Entry taskEntry) throws InitializationException {
        SimpleDateFormat dateFormat;
        String stateString;
        this.taskScheduler = taskScheduler;
        this.taskEntry = taskEntry;
        this.taskEntryDN = taskEntry.getDN();
        String taskDN = this.taskEntryDN.toString();
        this.taskBackend = taskScheduler.getTaskBackend();
        this.taskID = this.getAttributeValue("ds-task-id", false);
        this.recurringTaskID = this.getAttributeValue("ds-recurring-task-id", false);
        if (this.taskID == null) {
            if (this.recurringTaskID == null) {
                Message message = BackendMessages.ERR_TASK_MISSING_ATTR.get(String.valueOf(taskEntry.getDN()), "ds-task-id");
                throw new InitializationException(message);
            }
            this.taskID = UUID.randomUUID().toString();
        }
        if ((stateString = this.getAttributeValue("ds-task-state", false)) == null) {
            this.taskState = TaskState.UNSCHEDULED;
        } else {
            this.taskState = TaskState.fromString(stateString);
            if (this.taskState == null) {
                Message message = BackendMessages.ERR_TASK_INVALID_STATE.get(taskDN, stateString);
                throw new InitializationException(message);
            }
        }
        this.scheduledStartTime = -1L;
        String timeString = this.getAttributeValue("ds-task-scheduled-start-time", false);
        if (timeString != null) {
            if (timeString.endsWith("Z")) {
                dateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
                dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            } else {
                dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            }
            try {
                this.scheduledStartTime = dateFormat.parse(timeString).getTime();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = BackendMessages.ERR_TASK_CANNOT_PARSE_SCHEDULED_START_TIME.get(timeString, taskDN);
                throw new InitializationException(message, (Throwable)e);
            }
        }
        this.actualStartTime = -1L;
        timeString = this.getAttributeValue("ds-task-actual-start-time", false);
        if (timeString != null) {
            if (timeString.endsWith("Z")) {
                dateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
                dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            } else {
                dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            }
            try {
                this.actualStartTime = dateFormat.parse(timeString).getTime();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = BackendMessages.ERR_TASK_CANNOT_PARSE_ACTUAL_START_TIME.get(timeString, taskDN);
                throw new InitializationException(message, (Throwable)e);
            }
        }
        this.completionTime = -1L;
        timeString = this.getAttributeValue("ds-task-completion-time", false);
        if (timeString != null) {
            if (timeString.endsWith("Z")) {
                dateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
                dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            } else {
                dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            }
            try {
                this.completionTime = dateFormat.parse(timeString).getTime();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = BackendMessages.ERR_TASK_CANNOT_PARSE_COMPLETION_TIME.get(timeString, taskDN);
                throw new InitializationException(message, (Throwable)e);
            }
        }
        this.dependencyIDs = this.getAttributeValues("ds-task-dependency-id");
        this.failedDependencyAction = FailedDependencyAction.CANCEL;
        String actionString = this.getAttributeValue("ds-task-failed-dependency-action", false);
        if (actionString != null) {
            this.failedDependencyAction = FailedDependencyAction.fromString(actionString);
            if (this.failedDependencyAction == null) {
                this.failedDependencyAction = FailedDependencyAction.defaultValue();
            }
        }
        this.notifyOnCompletion = this.getAttributeValues("ds-task-notify-on-completion");
        this.notifyOnError = this.getAttributeValues("ds-task-notify-on-error");
        this.logMessages = this.getAttributeValues("ds-task-log-message");
        if (this.logMessages != null) {
            this.logMessageCounter = this.logMessages.size();
        }
    }

    private String getAttributeValue(String attributeName, boolean isRequired) throws InitializationException {
        List<Attribute> attrList = this.taskEntry.getAttribute(attributeName.toLowerCase());
        if (attrList == null || attrList.isEmpty()) {
            if (isRequired) {
                Message message = BackendMessages.ERR_TASK_MISSING_ATTR.get(String.valueOf(this.taskEntry.getDN()), attributeName);
                throw new InitializationException(message);
            }
            return null;
        }
        if (attrList.size() > 1) {
            Message message = BackendMessages.ERR_TASK_MULTIPLE_ATTRS_FOR_TYPE.get(attributeName, String.valueOf(this.taskEntry.getDN()));
            throw new InitializationException(message);
        }
        Iterator<AttributeValue> iterator = attrList.get(0).iterator();
        if (!iterator.hasNext()) {
            if (isRequired) {
                Message message = BackendMessages.ERR_TASK_NO_VALUES_FOR_ATTR.get(attributeName, String.valueOf(this.taskEntry.getDN()));
                throw new InitializationException(message);
            }
            return null;
        }
        AttributeValue value = iterator.next();
        if (iterator.hasNext()) {
            Message message = BackendMessages.ERR_TASK_MULTIPLE_VALUES_FOR_ATTR.get(attributeName, String.valueOf(this.taskEntry.getDN()));
            throw new InitializationException(message);
        }
        return value.getStringValue();
    }

    private LinkedList<String> getAttributeValues(String attributeName) throws InitializationException {
        LinkedList<String> valueStrings = new LinkedList<String>();
        List<Attribute> attrList = this.taskEntry.getAttribute(attributeName.toLowerCase());
        if (attrList == null || attrList.isEmpty()) {
            return valueStrings;
        }
        if (attrList.size() > 1) {
            Message message = BackendMessages.ERR_TASK_MULTIPLE_ATTRS_FOR_TYPE.get(attributeName, String.valueOf(this.taskEntry.getDN()));
            throw new InitializationException(message);
        }
        Iterator<AttributeValue> iterator = attrList.get(0).iterator();
        while (iterator.hasNext()) {
            valueStrings.add(iterator.next().getStringValue());
        }
        return valueStrings;
    }

    public final DN getTaskEntryDN() {
        return this.taskEntryDN;
    }

    public final Entry getTaskEntry() {
        return this.taskEntry;
    }

    public final Operation getOperation() {
        return this.operation;
    }

    public final void setOperation(Operation operation) {
        this.operation = operation;
    }

    public final String getTaskID() {
        return this.taskID;
    }

    public final String getRecurringTaskID() {
        return this.recurringTaskID;
    }

    public final TaskState getTaskState() {
        return this.taskState;
    }

    public boolean isCancelled() {
        return this.taskInterruptState != null && TaskState.isCancelled(this.taskInterruptState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTaskState(TaskState taskState) {
        boolean needLock = !this.taskScheduler.holdsSchedulerLock();
        Lock lock = null;
        if (needLock) {
            lock = this.taskScheduler.writeLockEntry(this.taskEntryDN);
        }
        try {
            this.taskState = taskState;
            Attribute attr = Attributes.create("ds-task-state", taskState.toString());
            ArrayList<Attribute> attrList = new ArrayList<Attribute>(1);
            attrList.add(attr);
            this.taskEntry.putAttribute(attr.getAttributeType(), attrList);
        }
        finally {
            if (needLock) {
                this.taskScheduler.unlockEntry(this.taskEntryDN, lock);
            }
        }
    }

    protected void setTaskInterruptState(TaskState state) {
        this.taskInterruptState = state;
    }

    protected TaskState getTaskInterruptState() {
        return this.taskInterruptState;
    }

    protected TaskState getFinalTaskState() {
        if (this.taskInterruptState == null) {
            return TaskState.COMPLETED_SUCCESSFULLY;
        }
        return this.taskInterruptState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replaceAttributeValue(String name, String value) throws DirectoryException {
        boolean needLock = !this.taskScheduler.holdsSchedulerLock();
        Lock lock = null;
        if (needLock) {
            lock = this.taskScheduler.writeLockEntry(this.taskEntryDN);
        }
        try {
            Entry taskEntry = this.getTaskEntry();
            ArrayList<Modification> modifications = new ArrayList<Modification>();
            modifications.add(new Modification(ModificationType.REPLACE, Attributes.create(name, value)));
            taskEntry.applyModifications(modifications);
        }
        finally {
            if (needLock) {
                this.taskScheduler.unlockEntry(this.taskEntryDN, lock);
            }
        }
    }

    public final long getScheduledStartTime() {
        return this.scheduledStartTime;
    }

    public final long getActualStartTime() {
        return this.actualStartTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setActualStartTime(long actualStartTime) {
        boolean needLock = !this.taskScheduler.holdsSchedulerLock();
        Lock lock = null;
        if (needLock) {
            lock = this.taskScheduler.writeLockEntry(this.taskEntryDN);
        }
        try {
            this.actualStartTime = actualStartTime;
            Date d = new Date(actualStartTime);
            String startTimeStr = StaticUtils.formatDateTimeString(d);
            Attribute attr = Attributes.create("ds-task-actual-start-time", startTimeStr);
            ArrayList<Attribute> attrList = new ArrayList<Attribute>(1);
            attrList.add(attr);
            this.taskEntry.putAttribute(attr.getAttributeType(), attrList);
        }
        finally {
            if (needLock) {
                this.taskScheduler.unlockEntry(this.taskEntryDN, lock);
            }
        }
    }

    public final long getCompletionTime() {
        return this.completionTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCompletionTime(long completionTime) {
        boolean needLock = !this.taskScheduler.holdsSchedulerLock();
        Lock lock = null;
        if (needLock) {
            lock = this.taskScheduler.writeLockEntry(this.taskEntryDN);
        }
        try {
            this.completionTime = completionTime;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            Date d = new Date(completionTime);
            Attribute attr = Attributes.create("ds-task-completion-time", dateFormat.format(d));
            ArrayList<Attribute> attrList = new ArrayList<Attribute>(1);
            attrList.add(attr);
            this.taskEntry.putAttribute(attr.getAttributeType(), attrList);
        }
        finally {
            if (needLock) {
                this.taskScheduler.unlockEntry(this.taskEntryDN, lock);
            }
        }
    }

    public final LinkedList<String> getDependencyIDs() {
        return this.dependencyIDs;
    }

    public final FailedDependencyAction getFailedDependencyAction() {
        return this.failedDependencyAction;
    }

    public final LinkedList<String> getNotifyOnCompletionAddresses() {
        return this.notifyOnCompletion;
    }

    public final LinkedList<String> getNotifyOnErrorAddresses() {
        return this.notifyOnError;
    }

    public final List<Message> getLogMessages() {
        ArrayList<Message> msgList = new ArrayList<Message>();
        for (String logString : this.logMessages) {
            msgList.add(Message.raw(logString, new Object[0]));
        }
        return Collections.unmodifiableList(msgList);
    }

    protected void logError(Message message) {
        ErrorLogger.logError(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogMessage(Message message) {
        boolean needLock = !this.taskScheduler.holdsSchedulerLock();
        Lock lock = null;
        if (needLock) {
            lock = this.taskScheduler.writeLockEntry(this.taskEntryDN);
        }
        try {
            StringBuilder buffer = new StringBuilder();
            buffer.append("[");
            buffer.append(TimeThread.getLocalTime());
            buffer.append("] severity=\"");
            buffer.append(message.getDescriptor().getSeverity().name());
            buffer.append("\" msgCount=");
            buffer.append(this.logMessageCounter++);
            buffer.append(" msgID=");
            buffer.append(message.getDescriptor().getId());
            buffer.append(" message=\"");
            buffer.append(message.toString());
            buffer.append("\"");
            String messageString = buffer.toString();
            this.logMessages.add(messageString);
            AttributeType type = DirectoryServer.getAttributeType("ds-task-log-message".toLowerCase());
            if (type == null) {
                type = DirectoryServer.getDefaultAttributeType("ds-task-log-message");
            }
            List<Attribute> attrList = this.taskEntry.getAttribute(type);
            AttributeValue value = new AttributeValue(type, messageString);
            if (attrList == null) {
                attrList = new ArrayList<Attribute>();
                attrList.add(Attributes.create(type, value));
                this.taskEntry.putAttribute(type, attrList);
            } else if (attrList.isEmpty()) {
                attrList.add(Attributes.create(type, value));
            } else {
                AttributeBuilder builder = new AttributeBuilder(attrList.get(0));
                builder.add(value);
                attrList.set(0, builder.toAttribute());
            }
        }
        finally {
            if (needLock) {
                this.taskScheduler.unlockEntry(this.taskEntryDN, lock);
            }
        }
    }

    @Override
    public final int compareTo(Task task) {
        if (this.completionTime > 0L) {
            if (task.completionTime > 0L) {
                if (this.completionTime < task.completionTime) {
                    return -1;
                }
                if (this.completionTime > task.completionTime) {
                    return 1;
                }
                return this.taskID.compareTo(task.taskID);
            }
            return -1;
        }
        if (task.completionTime > 0L) {
            return 1;
        }
        if (this.actualStartTime > 0L) {
            if (task.actualStartTime > 0L) {
                if (this.actualStartTime < task.actualStartTime) {
                    return -1;
                }
                if (this.actualStartTime > task.actualStartTime) {
                    return 1;
                }
                return this.taskID.compareTo(task.taskID);
            }
            return -1;
        }
        if (task.actualStartTime > 0L) {
            return 1;
        }
        if (this.scheduledStartTime < task.scheduledStartTime) {
            return -1;
        }
        if (this.scheduledStartTime > task.scheduledStartTime) {
            return 1;
        }
        return this.taskID.compareTo(task.taskID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TaskState execute() {
        block9: {
            this.setActualStartTime(TimeThread.getTime());
            this.setTaskState(TaskState.RUNNING);
            this.taskScheduler.writeState();
            try {
                TaskState taskState = this.runTask();
                this.setTaskState(taskState);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                this.setTaskState(TaskState.STOPPED_BY_ERROR);
                Message message = BackendMessages.ERR_TASK_EXECUTE_FAILED.get(String.valueOf(this.taskEntry.getDN()), StaticUtils.stackTraceToSingleLineString(e));
                this.logError(message);
            }
            finally {
                this.setCompletionTime(TimeThread.getTime());
                this.taskScheduler.writeState();
            }
            try {
                this.sendNotificationEMailMessage();
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block9;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        return this.taskState;
    }

    private void sendNotificationEMailMessage() throws MessagingException {
        if (DirectoryServer.mailServerConfigured()) {
            LinkedHashSet<String> recipients = new LinkedHashSet<String>();
            recipients.addAll(this.notifyOnCompletion);
            if (!TaskState.isSuccessful(this.taskState)) {
                recipients.addAll(this.notifyOnError);
            }
            if (!recipients.isEmpty()) {
                EMailMessage message = new EMailMessage(this.taskBackend.getNotificationSenderAddress(), new ArrayList<String>(recipients), this.taskState.toString() + " " + this.taskID);
                String scheduledStartDate = this.scheduledStartTime <= 0L ? "" : new Date(this.scheduledStartTime).toString();
                String actualStartDate = new Date(this.actualStartTime).toString();
                String completionDate = new Date(this.completionTime).toString();
                message.setBody(BackendMessages.INFO_TASK_COMPLETION_BODY.get(this.taskID, String.valueOf((Object)this.taskState), scheduledStartDate, actualStartDate, completionDate));
                for (String logMessage : this.logMessages) {
                    message.appendToBody(logMessage);
                    message.appendToBody("\r\n");
                }
                message.send();
            }
        }
    }

    public void initializeTask() throws DirectoryException {
    }

    protected abstract TaskState runTask();

    public void interruptTask(TaskState interruptState, Message interruptReason) {
    }

    public boolean isInterruptable() {
        return false;
    }
}

