/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.AttributeTypeDescriptionAttributeSyntaxCfg;
import org.opends.server.config.ConfigException;
import org.opends.server.core.AttributeSyntaxConfigManager;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.MatchingRuleConfigManager;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.schema.AttributeTypeSyntax;
import org.opends.server.schema.DITContentRuleSyntax;
import org.opends.server.schema.DITStructureRuleSyntax;
import org.opends.server.schema.MatchingRuleUseSyntax;
import org.opends.server.schema.NameFormSyntax;
import org.opends.server.schema.ObjectClassSyntax;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DITContentRule;
import org.opends.server.types.DITStructureRule;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.MatchingRuleUse;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.NameForm;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.Schema;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaConfigManager {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private Schema schema = new Schema();

    public static String getSchemaDirectoryPath(boolean userSchema) {
        File schemaDir = DirectoryServer.getEnvironmentConfig().getSchemaDirectory(userSchema);
        if (schemaDir != null) {
            return schemaDir.getAbsolutePath();
        }
        return null;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void initializeMatchingRules() throws ConfigException, InitializationException {
        MatchingRuleConfigManager matchingRuleConfigManager = new MatchingRuleConfigManager();
        matchingRuleConfigManager.initializeMatchingRules();
    }

    public void initializeAttributeSyntaxes() throws ConfigException, InitializationException {
        AttributeSyntaxConfigManager syntaxConfigManager = new AttributeSyntaxConfigManager();
        syntaxConfigManager.initializeAttributeSyntaxes();
    }

    public void initializeSchemaFromFiles() throws ConfigException, InitializationException {
        Object[] fileNames;
        String schemaInstallDirPath = SchemaConfigManager.getSchemaDirectoryPath(false);
        String schemaInstanceDirPath = SchemaConfigManager.getSchemaDirectoryPath(true);
        File schemaInstallDir = new File(schemaInstallDirPath);
        File schemaInstanceDir = null;
        try {
            if (schemaInstanceDirPath != null) {
                schemaInstanceDir = new File(schemaInstanceDirPath);
                if (schemaInstallDir.getCanonicalPath().equals(schemaInstanceDir.getCanonicalPath())) {
                    schemaInstanceDir = null;
                }
            }
        }
        catch (Exception e) {
            schemaInstanceDir = null;
        }
        long oldestModificationTime = -1L;
        long youngestModificationTime = -1L;
        try {
            long modificationTime;
            if (schemaInstallDir == null || !schemaInstallDir.exists()) {
                Message message = ConfigMessages.ERR_CONFIG_SCHEMA_NO_SCHEMA_DIR.get(schemaInstallDirPath);
                throw new InitializationException(message);
            }
            if (!schemaInstallDir.isDirectory()) {
                Message message = ConfigMessages.ERR_CONFIG_SCHEMA_DIR_NOT_DIRECTORY.get(schemaInstallDirPath);
                throw new InitializationException(message);
            }
            if (schemaInstanceDir == null || !schemaInstanceDir.exists() || !schemaInstanceDir.isDirectory()) {
                schemaInstanceDir = null;
            }
            File[] schemaInstallDirFiles = schemaInstallDir.listFiles();
            int fileNumber = schemaInstallDirFiles.length;
            File[] schemaInstanceDirFiles = null;
            if (schemaInstanceDir != null) {
                schemaInstanceDirFiles = schemaInstanceDir.listFiles();
                fileNumber = schemaInstanceDirFiles.length;
            }
            ArrayList<String> fileList = new ArrayList<String>(fileNumber);
            for (File f : schemaInstallDirFiles) {
                if (f.isFile()) {
                    fileList.add(f.getName());
                }
                modificationTime = f.lastModified();
                if (oldestModificationTime <= 0L || modificationTime < oldestModificationTime) {
                    oldestModificationTime = modificationTime;
                }
                if (youngestModificationTime > 0L && modificationTime <= youngestModificationTime) continue;
                youngestModificationTime = modificationTime;
            }
            if (schemaInstanceDirFiles != null) {
                for (File f : schemaInstanceDirFiles) {
                    if (f.isFile()) {
                        fileList.add(f.getName());
                    }
                    modificationTime = f.lastModified();
                    if (oldestModificationTime <= 0L || modificationTime < oldestModificationTime) {
                        oldestModificationTime = modificationTime;
                    }
                    if (youngestModificationTime > 0L && modificationTime <= youngestModificationTime) continue;
                    youngestModificationTime = modificationTime;
                }
            }
            fileNames = new String[fileList.size()];
            fileList.toArray(fileNames);
            Arrays.sort(fileNames);
        }
        catch (InitializationException ie) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ie);
            }
            throw ie;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ConfigMessages.ERR_CONFIG_SCHEMA_CANNOT_LIST_FILES.get(schemaInstallDirPath, schemaInstanceDirPath, StaticUtils.getExceptionMessage(e));
            throw new InitializationException(message, (Throwable)e);
        }
        if (oldestModificationTime <= 0L) {
            oldestModificationTime = System.currentTimeMillis();
        }
        if (youngestModificationTime <= 0L) {
            youngestModificationTime = oldestModificationTime;
        }
        this.schema.setOldestModificationTime(oldestModificationTime);
        this.schema.setYoungestModificationTime(youngestModificationTime);
        for (Object schemaFile : fileNames) {
            SchemaConfigManager.loadSchemaFile(this.schema, (String)schemaFile, false);
        }
    }

    public static List<Modification> loadSchemaFile(Schema schema, String schemaFile) throws ConfigException, InitializationException {
        return SchemaConfigManager.loadSchemaFile(schema, schemaFile, true);
    }

    private static List<Modification> loadSchemaFile(Schema schema, String schemaFile, boolean failOnError) throws ConfigException, InitializationException {
        Message message;
        List<Attribute> mruList;
        MatchingRuleUseSyntax mruSyntax;
        List<Attribute> dsrList;
        DITStructureRuleSyntax dsrSyntax;
        List<Attribute> dcrList;
        DITContentRuleSyntax dcrSyntax;
        List<Attribute> nfList;
        NameFormSyntax nfSyntax;
        List<Attribute> ocList;
        ObjectClassSyntax ocSyntax;
        List<Attribute> attrList;
        AttributeTypeSyntax attrTypeSyntax;
        Entry entry;
        block149: {
            Message message2;
            LDIFReader reader;
            String schemaDirPath = null;
            schemaDirPath = SchemaConfigManager.getSchemaDirectoryPath(true);
            File f = new File(schemaDirPath, schemaFile);
            if (!f.exists()) {
                schemaDirPath = SchemaConfigManager.getSchemaDirectoryPath(false);
                f = new File(schemaDirPath, schemaFile);
            }
            try {
                reader = new LDIFReader(new LDIFImportConfig(f.getAbsolutePath()));
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message3 = ConfigMessages.WARN_CONFIG_SCHEMA_CANNOT_OPEN_FILE.get(schemaFile, schemaDirPath, StaticUtils.getExceptionMessage(e));
                if (failOnError) {
                    throw new ConfigException(message3);
                }
                ErrorLogger.logError(message3);
                return null;
            }
            try {
                entry = reader.readEntry(false);
                if (entry == null) {
                    reader.close();
                    return new LinkedList<Modification>();
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message4 = ConfigMessages.WARN_CONFIG_SCHEMA_CANNOT_READ_LDIF_ENTRY.get(schemaFile, schemaDirPath, StaticUtils.getExceptionMessage(e));
                if (failOnError) {
                    throw new InitializationException(message4, (Throwable)e);
                }
                ErrorLogger.logError(message4);
                return null;
            }
            try {
                Entry e = reader.readEntry(false);
                if (e != null) {
                    message2 = ConfigMessages.WARN_CONFIG_SCHEMA_MULTIPLE_ENTRIES_IN_FILE.get(schemaFile, schemaDirPath);
                    ErrorLogger.logError(message2);
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                message2 = ConfigMessages.WARN_CONFIG_SCHEMA_UNPARSEABLE_EXTRA_DATA_IN_FILE.get(schemaFile, schemaDirPath, StaticUtils.getExceptionMessage(e));
                ErrorLogger.logError(message2);
            }
            try {
                reader.close();
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block149;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        LinkedList<Modification> mods = new LinkedList<Modification>();
        try {
            attrTypeSyntax = (AttributeTypeSyntax)schema.getSyntax("1.3.6.1.4.1.1466.115.121.1.3");
            if (attrTypeSyntax == null) {
                attrTypeSyntax = new AttributeTypeSyntax();
                attrTypeSyntax.initializeSyntax((AttributeTypeDescriptionAttributeSyntaxCfg)null);
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            attrTypeSyntax = new AttributeTypeSyntax();
            attrTypeSyntax.initializeSyntax((AttributeTypeDescriptionAttributeSyntaxCfg)null);
        }
        AttributeType attributeAttrType = schema.getAttributeType("attributetypes");
        if (attributeAttrType == null) {
            attributeAttrType = DirectoryServer.getDefaultAttributeType("attributeTypes", attrTypeSyntax);
        }
        if ((attrList = entry.getAttribute(attributeAttrType)) != null && !attrList.isEmpty()) {
            for (Attribute a : attrList) {
                mods.add(new Modification(ModificationType.ADD, a));
            }
        }
        try {
            ocSyntax = (ObjectClassSyntax)schema.getSyntax("1.3.6.1.4.1.1466.115.121.1.37");
            if (ocSyntax == null) {
                ocSyntax = new ObjectClassSyntax();
                ocSyntax.initializeSyntax(null);
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            ocSyntax = new ObjectClassSyntax();
            ocSyntax.initializeSyntax(null);
        }
        AttributeType objectclassAttrType = schema.getAttributeType("objectclasses");
        if (objectclassAttrType == null) {
            objectclassAttrType = DirectoryServer.getDefaultAttributeType("objectClasses", ocSyntax);
        }
        if ((ocList = entry.getAttribute(objectclassAttrType)) != null && !ocList.isEmpty()) {
            for (Attribute a : ocList) {
                mods.add(new Modification(ModificationType.ADD, a));
            }
        }
        try {
            nfSyntax = (NameFormSyntax)schema.getSyntax("1.3.6.1.4.1.1466.115.121.1.35");
            if (nfSyntax == null) {
                nfSyntax = new NameFormSyntax();
                nfSyntax.initializeSyntax(null);
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            nfSyntax = new NameFormSyntax();
            nfSyntax.initializeSyntax(null);
        }
        AttributeType nameFormAttrType = schema.getAttributeType("nameforms");
        if (nameFormAttrType == null) {
            nameFormAttrType = DirectoryServer.getDefaultAttributeType("nameForms", nfSyntax);
        }
        if ((nfList = entry.getAttribute(nameFormAttrType)) != null && !nfList.isEmpty()) {
            for (Attribute a : nfList) {
                mods.add(new Modification(ModificationType.ADD, a));
            }
        }
        try {
            dcrSyntax = (DITContentRuleSyntax)schema.getSyntax("1.3.6.1.4.1.1466.115.121.1.16");
            if (dcrSyntax == null) {
                dcrSyntax = new DITContentRuleSyntax();
                dcrSyntax.initializeSyntax(null);
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            dcrSyntax = new DITContentRuleSyntax();
            dcrSyntax.initializeSyntax(null);
        }
        AttributeType dcrAttrType = schema.getAttributeType("ditcontentrules");
        if (dcrAttrType == null) {
            dcrAttrType = DirectoryServer.getDefaultAttributeType("dITContentRules", dcrSyntax);
        }
        if ((dcrList = entry.getAttribute(dcrAttrType)) != null && !dcrList.isEmpty()) {
            for (Attribute a : dcrList) {
                mods.add(new Modification(ModificationType.ADD, a));
            }
        }
        try {
            dsrSyntax = (DITStructureRuleSyntax)schema.getSyntax("1.3.6.1.4.1.1466.115.121.1.17");
            if (dsrSyntax == null) {
                dsrSyntax = new DITStructureRuleSyntax();
                dsrSyntax.initializeSyntax(null);
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            dsrSyntax = new DITStructureRuleSyntax();
            dsrSyntax.initializeSyntax(null);
        }
        AttributeType dsrAttrType = schema.getAttributeType("ditstructurerules");
        if (dsrAttrType == null) {
            dsrAttrType = DirectoryServer.getDefaultAttributeType("dITStructureRules", dsrSyntax);
        }
        if ((dsrList = entry.getAttribute(dsrAttrType)) != null && !dsrList.isEmpty()) {
            for (Attribute a : dsrList) {
                mods.add(new Modification(ModificationType.ADD, a));
            }
        }
        try {
            mruSyntax = (MatchingRuleUseSyntax)schema.getSyntax("1.3.6.1.4.1.1466.115.121.1.31");
            if (mruSyntax == null) {
                mruSyntax = new MatchingRuleUseSyntax();
                mruSyntax.initializeSyntax(null);
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            mruSyntax = new MatchingRuleUseSyntax();
            mruSyntax.initializeSyntax(null);
        }
        AttributeType mruAttrType = schema.getAttributeType("matchingruleuse");
        if (mruAttrType == null) {
            mruAttrType = DirectoryServer.getDefaultAttributeType("matchingRuleUse", mruSyntax);
        }
        if ((mruList = entry.getAttribute(mruAttrType)) != null && !mruList.isEmpty()) {
            for (Attribute a : mruList) {
                mods.add(new Modification(ModificationType.ADD, a));
            }
        }
        for (Attribute attribute : entry.getAttributes()) {
            if (SchemaConfigManager.isSchemaAttribute(attribute)) continue;
            schema.addExtraAttribute(attribute.getName(), attribute);
        }
        if (attrList != null) {
            for (Attribute a : attrList) {
                for (AttributeValue v : a) {
                    AttributeType attrType;
                    try {
                        attrType = AttributeTypeSyntax.decodeAttributeType(v.getValue(), schema, false);
                        attrType.setExtraProperty("X-SCHEMA-FILE", (String)null);
                        attrType.setSchemaFile(schemaFile);
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        message = ConfigMessages.WARN_CONFIG_SCHEMA_CANNOT_PARSE_ATTR_TYPE.get(schemaFile, de.getMessageObject());
                        if (failOnError) {
                            throw new ConfigException(message, (Throwable)de);
                        }
                        ErrorLogger.logError(message);
                        continue;
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        message = ConfigMessages.WARN_CONFIG_SCHEMA_CANNOT_PARSE_ATTR_TYPE.get(schemaFile, v.getStringValue() + ":  " + StaticUtils.getExceptionMessage(e));
                        if (failOnError) {
                            throw new ConfigException(message, (Throwable)e);
                        }
                        ErrorLogger.logError(message);
                        continue;
                    }
                    try {
                        schema.registerAttributeType(attrType, failOnError);
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        message = ConfigMessages.WARN_CONFIG_SCHEMA_CONFLICTING_ATTR_TYPE.get(schemaFile, de.getMessageObject());
                        ErrorLogger.logError(message);
                        try {
                            schema.registerAttributeType(attrType, true);
                        }
                        catch (Exception e) {
                            if (!DebugLogger.debugEnabled()) continue;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                    }
                }
            }
        }
        if (ocList != null) {
            for (Attribute a : ocList) {
                for (AttributeValue v : a) {
                    ObjectClass oc;
                    try {
                        oc = ObjectClassSyntax.decodeObjectClass(v.getValue(), schema, false);
                        oc.setExtraProperty("X-SCHEMA-FILE", (String)null);
                        oc.setSchemaFile(schemaFile);
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        message = ConfigMessages.WARN_CONFIG_SCHEMA_CANNOT_PARSE_OC.get(schemaFile, de.getMessageObject());
                        if (failOnError) {
                            throw new ConfigException(message, (Throwable)de);
                        }
                        ErrorLogger.logError(message);
                        continue;
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        message = ConfigMessages.WARN_CONFIG_SCHEMA_CANNOT_PARSE_OC.get(schemaFile, v.getStringValue() + ":  " + StaticUtils.getExceptionMessage(e));
                        if (failOnError) {
                            throw new ConfigException(message, (Throwable)e);
                        }
                        ErrorLogger.logError(message);
                        continue;
                    }
                    try {
                        schema.registerObjectClass(oc, failOnError);
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        message = ConfigMessages.WARN_CONFIG_SCHEMA_CONFLICTING_OC.get(schemaFile, de.getMessageObject());
                        ErrorLogger.logError(message);
                        try {
                            schema.registerObjectClass(oc, true);
                        }
                        catch (Exception e) {
                            if (!DebugLogger.debugEnabled()) continue;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                    }
                }
            }
        }
        if (nfList != null) {
            for (Attribute a : nfList) {
                for (AttributeValue v : a) {
                    NameForm nf;
                    try {
                        nf = NameFormSyntax.decodeNameForm(v.getValue(), schema, false);
                        nf.getExtraProperties().remove("X-SCHEMA-FILE");
                        nf.setSchemaFile(schemaFile);
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        message = ConfigMessages.WARN_CONFIG_SCHEMA_CANNOT_PARSE_NAME_FORM.get(schemaFile, de.getMessageObject());
                        if (failOnError) {
                            throw new ConfigException(message, (Throwable)de);
                        }
                        ErrorLogger.logError(message);
                        continue;
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        message = ConfigMessages.WARN_CONFIG_SCHEMA_CANNOT_PARSE_NAME_FORM.get(schemaFile, v.getStringValue() + ":  " + StaticUtils.getExceptionMessage(e));
                        if (failOnError) {
                            throw new ConfigException(message, (Throwable)e);
                        }
                        ErrorLogger.logError(message);
                        continue;
                    }
                    try {
                        schema.registerNameForm(nf, failOnError);
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        message = ConfigMessages.WARN_CONFIG_SCHEMA_CONFLICTING_NAME_FORM.get(schemaFile, de.getMessageObject());
                        ErrorLogger.logError(message);
                        try {
                            schema.registerNameForm(nf, true);
                        }
                        catch (Exception e) {
                            if (!DebugLogger.debugEnabled()) continue;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                    }
                }
            }
        }
        if (dcrList != null) {
            for (Attribute a : dcrList) {
                for (AttributeValue v : a) {
                    DITContentRule dcr;
                    try {
                        dcr = DITContentRuleSyntax.decodeDITContentRule(v.getValue(), schema, false);
                        dcr.getExtraProperties().remove("X-SCHEMA-FILE");
                        dcr.setSchemaFile(schemaFile);
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        message = ConfigMessages.WARN_CONFIG_SCHEMA_CANNOT_PARSE_DCR.get(schemaFile, de.getMessageObject());
                        if (failOnError) {
                            throw new ConfigException(message, (Throwable)de);
                        }
                        ErrorLogger.logError(message);
                        continue;
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        message = ConfigMessages.WARN_CONFIG_SCHEMA_CANNOT_PARSE_DCR.get(schemaFile, v.getStringValue() + ":  " + StaticUtils.getExceptionMessage(e));
                        if (failOnError) {
                            throw new ConfigException(message, (Throwable)e);
                        }
                        ErrorLogger.logError(message);
                        continue;
                    }
                    try {
                        schema.registerDITContentRule(dcr, failOnError);
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        message = ConfigMessages.WARN_CONFIG_SCHEMA_CONFLICTING_DCR.get(schemaFile, de.getMessageObject());
                        ErrorLogger.logError(message);
                        try {
                            schema.registerDITContentRule(dcr, true);
                        }
                        catch (Exception e) {
                            if (!DebugLogger.debugEnabled()) continue;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                    }
                }
            }
        }
        if (dsrList != null) {
            for (Attribute a : dsrList) {
                for (AttributeValue v : a) {
                    DITStructureRule dsr;
                    try {
                        dsr = DITStructureRuleSyntax.decodeDITStructureRule(v.getValue(), schema, false);
                        dsr.getExtraProperties().remove("X-SCHEMA-FILE");
                        dsr.setSchemaFile(schemaFile);
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        message = ConfigMessages.WARN_CONFIG_SCHEMA_CANNOT_PARSE_DSR.get(schemaFile, de.getMessageObject());
                        if (failOnError) {
                            throw new ConfigException(message, (Throwable)de);
                        }
                        ErrorLogger.logError(message);
                        continue;
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        message = ConfigMessages.WARN_CONFIG_SCHEMA_CANNOT_PARSE_DSR.get(schemaFile, v.getStringValue() + ":  " + StaticUtils.getExceptionMessage(e));
                        if (failOnError) {
                            throw new ConfigException(message, (Throwable)e);
                        }
                        ErrorLogger.logError(message);
                        continue;
                    }
                    try {
                        schema.registerDITStructureRule(dsr, failOnError);
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        message = ConfigMessages.WARN_CONFIG_SCHEMA_CONFLICTING_DSR.get(schemaFile, de.getMessageObject());
                        ErrorLogger.logError(message);
                        try {
                            schema.registerDITStructureRule(dsr, true);
                        }
                        catch (Exception e) {
                            if (!DebugLogger.debugEnabled()) continue;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                    }
                }
            }
        }
        if (mruList != null) {
            for (Attribute a : mruList) {
                for (AttributeValue v : a) {
                    MatchingRuleUse mru;
                    try {
                        mru = MatchingRuleUseSyntax.decodeMatchingRuleUse(v.getValue(), schema, false);
                        mru.getExtraProperties().remove("X-SCHEMA-FILE");
                        mru.setSchemaFile(schemaFile);
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        message = ConfigMessages.WARN_CONFIG_SCHEMA_CANNOT_PARSE_MRU.get(schemaFile, de.getMessageObject());
                        if (failOnError) {
                            throw new ConfigException(message, (Throwable)de);
                        }
                        ErrorLogger.logError(message);
                        continue;
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        message = ConfigMessages.WARN_CONFIG_SCHEMA_CANNOT_PARSE_MRU.get(schemaFile, v.getStringValue() + ":  " + StaticUtils.getExceptionMessage(e));
                        if (failOnError) {
                            throw new ConfigException(message, (Throwable)e);
                        }
                        ErrorLogger.logError(message);
                        continue;
                    }
                    try {
                        schema.registerMatchingRuleUse(mru, failOnError);
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        message = ConfigMessages.WARN_CONFIG_SCHEMA_CONFLICTING_MRU.get(schemaFile, de.getMessageObject());
                        ErrorLogger.logError(message);
                        try {
                            schema.registerMatchingRuleUse(mru, true);
                        }
                        catch (Exception e) {
                            if (!DebugLogger.debugEnabled()) continue;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                    }
                }
            }
        }
        return mods;
    }

    private static boolean isSchemaAttribute(Attribute attribute) {
        String attributeOid = attribute.getAttributeType().getOID();
        return attributeOid.equals("2.5.21.1") || attributeOid.equals("2.5.21.2") || attributeOid.equals("2.5.21.4") || attributeOid.equals("2.5.21.5") || attributeOid.equals("2.5.21.6") || attributeOid.equals("2.5.21.7") || attributeOid.equals("2.5.21.8") || attributeOid.equals("2.5.4.3") || attributeOid.equals("attributetypes-oid") || attributeOid.equals("objectclasses-oid") || attributeOid.equals("matchingRules-oid") || attributeOid.equals("matchingRuleUse-oid") || attributeOid.equals("NameFormDescription-oid") || attributeOid.equals("dITContentRules-oid") || attributeOid.equals("dITStructureRules");
    }
}

