/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core.networkgroups;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.std.meta.NetworkGroupResourceLimitsCfgDefn;
import org.opends.server.admin.std.server.NetworkGroupResourceLimitsCfg;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.networkgroups.ResourceLimitsStat;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.RawFilter;
import org.opends.server.types.ResultCode;
import org.opends.server.types.operation.PreParseOperation;
import org.opends.server.types.operation.PreParseSearchOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceLimits
implements ConfigurationAddListener<NetworkGroupResourceLimitsCfg>,
ConfigurationDeleteListener<NetworkGroupResourceLimitsCfg>,
ConfigurationChangeListener<NetworkGroupResourceLimitsCfg> {
    private boolean isConfigured = false;
    private int maxConnections;
    private int maxConnectionsFromSameIP;
    private int maxOpsPerConnection;
    private int maxConcurrentOpsPerConnection;
    private int searchSizeLimit;
    private int searchTimeLimit;
    private int minSearchSubstringLength;
    private NetworkGroupResourceLimitsCfgDefn.ReferralPolicy referralPolicy = NetworkGroupResourceLimitsCfgDefn.ReferralPolicy.FORWARD;
    private NetworkGroupResourceLimitsCfgDefn.ReferralBindPolicy referralBindPolicy = NetworkGroupResourceLimitsCfgDefn.ReferralBindPolicy.ANONYMOUS;
    private int referralHopLimit = 0;
    private int numConnections = 0;
    private int maxNumConnections = 0;
    private int totalNumConnections = 0;
    HashMap<String, Integer> connectionsPerIpMap = new HashMap();
    Object connMutex = new Object();
    private NetworkGroupResourceLimitsCfg config = null;

    public ResourceLimits(NetworkGroupResourceLimitsCfg resourceLimitsCfg) {
        this.createLimits(resourceLimitsCfg);
    }

    private void resetLimits() {
        this.maxConnections = 0;
        this.maxConnectionsFromSameIP = 0;
        this.maxOpsPerConnection = 0;
        this.maxConcurrentOpsPerConnection = 0;
        this.searchSizeLimit = -1;
        this.searchTimeLimit = -1;
        this.minSearchSubstringLength = 0;
        this.referralPolicy = NetworkGroupResourceLimitsCfgDefn.ReferralPolicy.FORWARD;
        this.referralBindPolicy = NetworkGroupResourceLimitsCfgDefn.ReferralBindPolicy.ANONYMOUS;
        this.referralHopLimit = 0;
        this.isConfigured = false;
        if (this.config != null) {
            this.config.removeChangeListener(this);
            this.config = null;
        }
    }

    private void createLimits(NetworkGroupResourceLimitsCfg resourcesCfg) {
        if (resourcesCfg != null) {
            this.maxConnections = resourcesCfg.getMaxConnections();
            this.maxConnectionsFromSameIP = resourcesCfg.getMaxConnectionsFromSameIP();
            this.maxOpsPerConnection = resourcesCfg.getMaxOpsPerConnection();
            this.maxConcurrentOpsPerConnection = resourcesCfg.getMaxConcurrentOpsPerConnection();
            Integer tmpSizeLimit = resourcesCfg.getSearchSizeLimit();
            this.searchSizeLimit = tmpSizeLimit != null ? tmpSizeLimit : -1;
            Long tmpTimeLimit = resourcesCfg.getSearchTimeLimit();
            this.searchTimeLimit = tmpTimeLimit != null ? tmpTimeLimit.intValue() : -1;
            this.minSearchSubstringLength = resourcesCfg.getMinSubstringLength();
            this.referralPolicy = resourcesCfg.getReferralPolicy();
            this.referralBindPolicy = resourcesCfg.getReferralBindPolicy();
            this.referralHopLimit = resourcesCfg.getReferralHopLimit();
            if (this.config == null) {
                resourcesCfg.addChangeListener(this);
            }
            this.config = resourcesCfg;
            this.isConfigured = true;
        } else {
            this.resetLimits();
        }
    }

    public void setMaxConnections(int maxConn) {
        this.maxConnections = maxConn;
    }

    public void setMaxConnectionsFromSameIP(int maxConnFromSameClient) {
        this.maxConnectionsFromSameIP = maxConnFromSameClient;
    }

    public void setMaxOpsPerConnection(int maxOpsPerConn) {
        this.maxOpsPerConnection = maxOpsPerConn;
    }

    public void setMaxConcurrentOpsPerConnection(int maxConcurrentOpsPerConn) {
        this.maxConcurrentOpsPerConnection = maxConcurrentOpsPerConn;
    }

    public void setSearchTimeLimit(int maxSearchTime) {
        this.searchTimeLimit = maxSearchTime;
    }

    public void setSearchSizeLimit(int maxSearchSize) {
        this.searchSizeLimit = maxSearchSize;
    }

    public void setMinSearchSubstringLength(int minLength) {
        this.minSearchSubstringLength = minLength;
    }

    public int getSizeLimit() {
        return this.searchSizeLimit;
    }

    public int getTimeLimit() {
        return this.searchTimeLimit;
    }

    public int getMinSubstring() {
        return this.minSearchSubstringLength;
    }

    public NetworkGroupResourceLimitsCfgDefn.ReferralPolicy getReferralPolicy() {
        return this.referralPolicy;
    }

    public NetworkGroupResourceLimitsCfgDefn.ReferralBindPolicy getReferralBindPolicy() {
        return this.referralBindPolicy;
    }

    public int getReferralHopLimit() {
        return this.referralHopLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(ClientConnection connection) {
        Object object = this.connMutex;
        synchronized (object) {
            String ip;
            Integer currentCount;
            ++this.numConnections;
            ++this.totalNumConnections;
            if (this.numConnections > this.maxNumConnections) {
                this.maxNumConnections = this.numConnections;
            }
            if ((currentCount = this.connectionsPerIpMap.get(ip = connection.getClientAddress())) == null) {
                currentCount = new Integer(0);
            }
            this.connectionsPerIpMap.put(ip, currentCount + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(ClientConnection connection) {
        Object object = this.connMutex;
        synchronized (object) {
            --this.numConnections;
            String ip = connection.getClientAddress();
            Integer currentCount = this.connectionsPerIpMap.get(ip);
            if (currentCount == null) {
                currentCount = new Integer(1);
            }
            if (currentCount == 1) {
                this.connectionsPerIpMap.remove(ip);
            } else {
                this.connectionsPerIpMap.put(ip, currentCount - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkLimits(ClientConnection connection, PreParseOperation operation, boolean fullCheck, List<Message> messages) {
        boolean result = true;
        if (fullCheck) {
            Object object = this.connMutex;
            synchronized (object) {
                if (this.maxConnections > 0 && this.numConnections > this.maxConnections) {
                    messages.add(CoreMessages.INFO_ERROR_MAX_CONNECTIONS_LIMIT_EXCEEDED.get());
                    result = false;
                }
            }
            if (!result) {
                return result;
            }
            object = this.connMutex;
            synchronized (object) {
                String ip = connection.getClientAddress();
                Integer currentCount = this.connectionsPerIpMap.get(ip);
                if (currentCount == null) {
                    currentCount = new Integer(0);
                }
                if (this.maxConnectionsFromSameIP > 0 && currentCount > this.maxConnectionsFromSameIP) {
                    messages.add(CoreMessages.INFO_ERROR_MAX_CONNECTIONS_FROM_SAME_IP_LIMIT_EXCEEDED.get());
                    result = false;
                }
            }
            if (!result) {
                return result;
            }
        }
        if (this.maxOpsPerConnection > 0 && connection.getNumberOfOperations() > (long)this.maxOpsPerConnection) {
            messages.add(CoreMessages.INFO_ERROR_MAX_OPERATIONS_PER_CONNECTION_LIMIT_EXCEEDED.get());
            return false;
        }
        if (this.maxConcurrentOpsPerConnection > 0 && connection.getOperationsInProgress().size() > this.maxConcurrentOpsPerConnection) {
            messages.add(CoreMessages.INFO_ERROR_MAX_CONCURRENT_OPERATIONS_PER_CONNECTION_LIMIT_EXCEEDED.get());
            return false;
        }
        if (operation != null && operation instanceof PreParseSearchOperation && !this.checkSubstringFilter(((PreParseSearchOperation)operation).getRawFilter())) {
            messages.add(CoreMessages.INFO_ERROR_MIN_SEARCH_SUBSTRING_LENGTH_LIMIT_EXCEEDED.get());
            return false;
        }
        return true;
    }

    private boolean checkSubstringFilter(RawFilter filter) {
        switch (filter.getFilterType()) {
            case AND: 
            case OR: {
                ArrayList<RawFilter> filterComponents = filter.getFilterComponents();
                if (filterComponents != null) {
                    for (RawFilter element : filterComponents) {
                        if (this.checkSubstringFilter(element)) continue;
                        return false;
                    }
                }
                return true;
            }
            case NOT: {
                return this.checkSubstringFilter(filter.getNOTComponent());
            }
            case SUBSTRING: {
                ByteString subFinalElement;
                ArrayList<ByteString> subAnyElements;
                int length = 0;
                ByteString subInitialElement = filter.getSubInitialElement();
                if (subInitialElement != null) {
                    length += subInitialElement.stringValue().length();
                }
                if ((subAnyElements = filter.getSubAnyElements()) != null) {
                    for (ByteString element : subAnyElements) {
                        length += element.stringValue().length();
                    }
                }
                if ((subFinalElement = filter.getSubFinalElement()) != null) {
                    length += subFinalElement.stringValue().length();
                }
                return length >= this.minSearchSubstringLength;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceLimitsStat getStat() {
        ResourceLimitsStat stat;
        Object object = this.connMutex;
        synchronized (object) {
            stat = new ResourceLimitsStat(this.numConnections, this.maxNumConnections, this.totalNumConnections);
        }
        return stat;
    }

    @Override
    public boolean isConfigurationAddAcceptable(NetworkGroupResourceLimitsCfg configuration, List<Message> unacceptableReasons) {
        return !this.isConfigured;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(NetworkGroupResourceLimitsCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        ConfigChangeResult configChangeResult = new ConfigChangeResult(resultCode, adminActionRequired, messages);
        this.createLimits(configuration);
        return configChangeResult;
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(NetworkGroupResourceLimitsCfg configuration, List<Message> unacceptableReasons) {
        return this.isConfigured;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(NetworkGroupResourceLimitsCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        ConfigChangeResult configChangeResult = new ConfigChangeResult(resultCode, adminActionRequired, messages);
        this.resetLimits();
        this.isConfigured = false;
        return configChangeResult;
    }

    @Override
    public boolean isConfigurationChangeAcceptable(NetworkGroupResourceLimitsCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(NetworkGroupResourceLimitsCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        ConfigChangeResult configChangeResult = new ConfigChangeResult(resultCode, adminActionRequired, messages);
        this.createLimits(configuration);
        return configChangeResult;
    }
}

