/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import org.opends.messages.ExtensionMessages;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConnectionSecurityProvider;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.InitializationException;
import org.opends.server.util.StaticUtils;

public class NullConnectionSecurityProvider
extends ConnectionSecurityProvider {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final int BUFFER_SIZE = 4096;
    private ByteBuffer clearBuffer;
    private ClientConnection clientConnection;
    private SocketChannel socketChannel;

    public NullConnectionSecurityProvider() {
    }

    protected NullConnectionSecurityProvider(ClientConnection clientConnection, SocketChannel socketChannel) {
        this.clientConnection = clientConnection;
        this.socketChannel = socketChannel;
        this.clearBuffer = ByteBuffer.allocate(4096);
    }

    public void initializeConnectionSecurityProvider(ConfigEntry configEntry) throws ConfigException, InitializationException {
        this.clearBuffer = null;
        this.clientConnection = null;
        this.socketChannel = null;
    }

    public void finalizeConnectionSecurityProvider() {
    }

    public String getSecurityMechanismName() {
        return "NULL";
    }

    public boolean isSecure() {
        return false;
    }

    public boolean isActive() {
        return true;
    }

    public ConnectionSecurityProvider newInstance(ClientConnection clientConnection, SocketChannel socketChannel) throws DirectoryException {
        return new NullConnectionSecurityProvider(clientConnection, socketChannel);
    }

    public void disconnect(boolean connectionValid) {
    }

    public int getClearBufferSize() {
        return 4096;
    }

    public int getEncodedBufferSize() {
        return 4096;
    }

    public boolean readData() {
        this.clearBuffer.clear();
        try {
            do {
                int bytesRead = this.socketChannel.read(this.clearBuffer);
                this.clearBuffer.flip();
                if (bytesRead < 0) {
                    this.clientConnection.disconnect(DisconnectReason.CLIENT_DISCONNECT, false, null);
                    return false;
                }
                if (bytesRead != 0) continue;
                return true;
            } while (this.clientConnection.processDataRead(this.clearBuffer));
            return false;
        }
        catch (IOException ioe) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ioe);
            }
            this.clientConnection.disconnect(DisconnectReason.IO_ERROR, false, null);
            return false;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            this.clientConnection.disconnect(DisconnectReason.SERVER_ERROR, true, ExtensionMessages.ERR_NULL_SECURITY_PROVIDER_READ_ERROR.get(StaticUtils.getExceptionMessage(e)));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeData(ByteBuffer clearData) {
        int position = clearData.position();
        int limit = clearData.limit();
        try {
            int bytesWritten;
            while (clearData.hasRemaining()) {
                bytesWritten = this.socketChannel.write(clearData);
                if (bytesWritten < 0) {
                    this.clientConnection.disconnect(DisconnectReason.CLIENT_DISCONNECT, false, null);
                    boolean bl = false;
                    return bl;
                }
                if (bytesWritten) continue;
                boolean bl = NullConnectionSecurityProvider.writeWithTimeout(this.clientConnection, this.socketChannel, clearData);
                return bl;
            }
            bytesWritten = 1;
            return bytesWritten != 0;
        }
        catch (IOException ioe) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ioe);
            }
            this.clientConnection.disconnect(DisconnectReason.IO_ERROR, false, null);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            this.clientConnection.disconnect(DisconnectReason.SERVER_ERROR, true, ExtensionMessages.ERR_NULL_SECURITY_PROVIDER_WRITE_ERROR.get(StaticUtils.getExceptionMessage(e)));
            boolean bl = false;
            return bl;
        }
        finally {
            clearData.position(position);
            clearData.limit(limit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeWithTimeout(ClientConnection clientConnection, SocketChannel socketChannel, ByteBuffer buffer) throws IOException {
        long startTime = System.currentTimeMillis();
        long waitTime = clientConnection.getMaxBlockedWriteTimeLimit();
        if (waitTime <= 0L) {
            waitTime = 300000L;
        }
        long stopTime = startTime + waitTime;
        Selector selector = clientConnection.getWriteSelector();
        if (selector == null) {
            while (buffer.hasRemaining() && System.currentTimeMillis() < stopTime) {
                if (socketChannel.write(buffer) >= 0) continue;
                clientConnection.disconnect(DisconnectReason.CLIENT_DISCONNECT, false, null);
                return false;
            }
            if (buffer.hasRemaining()) {
                clientConnection.disconnect(DisconnectReason.IO_TIMEOUT, false, null);
                return false;
            }
            return true;
        }
        SelectionKey key = socketChannel.register(selector, 4);
        try {
            selector.select(waitTime);
            while (buffer.hasRemaining()) {
                long currentTime = System.currentTimeMillis();
                if (currentTime >= stopTime) {
                    clientConnection.disconnect(DisconnectReason.IO_TIMEOUT, false, null);
                    boolean bl = false;
                    return bl;
                }
                waitTime = stopTime - currentTime;
                Iterator<SelectionKey> iterator = selector.selectedKeys().iterator();
                while (iterator.hasNext()) {
                    SelectionKey k = iterator.next();
                    if (!k.isWritable()) continue;
                    int bytesWritten = socketChannel.write(buffer);
                    if (bytesWritten < 0) {
                        clientConnection.disconnect(DisconnectReason.CLIENT_DISCONNECT, false, null);
                        boolean bl = false;
                        return bl;
                    }
                    iterator.remove();
                }
                if (!buffer.hasRemaining()) continue;
                selector.select(waitTime);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (key.isValid()) {
                key.cancel();
                selector.selectNow();
            }
        }
    }

    public int getSSF() {
        return 0;
    }
}

