/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.Lock;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.IdentityMapper;
import org.opends.server.core.AccessControlConfigManager;
import org.opends.server.core.BindOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PasswordPolicyState;
import org.opends.server.extensions.SASLSecurityProvider;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.ldap.LDAPClientConnection;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.LockManager;
import org.opends.server.types.Privilege;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SASLContext
implements CallbackHandler,
PrivilegedExceptionAction<Boolean> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private SaslServer saslServer = null;
    private final IdentityMapper<?> identityMapper;
    private HashMap<String, String> saslProps;
    private String serverFQDN;
    private final String mechanism;
    private Entry authEntry = null;
    private Entry authzEntry = null;
    private String userName;
    private Message cbMsg;
    private BindOperation bindOp;
    private final String confidentiality = "auth-conf";
    private final String integrity = "auth-int";

    private SASLContext(HashMap<String, String> saslProps, String serverFQDN, String mechanism, IdentityMapper<?> identityMapper) throws SaslException {
        this.identityMapper = identityMapper;
        this.mechanism = mechanism;
        this.saslProps = saslProps;
        this.serverFQDN = serverFQDN;
        if (mechanism.equals("DIGEST-MD5")) {
            this.initSASLServer();
        }
    }

    public static SASLContext createSASLContext(HashMap<String, String> saslProps, String serverFQDN, String mechanism, IdentityMapper<?> identityMapper) throws SaslException {
        return new SASLContext(saslProps, serverFQDN, mechanism, identityMapper);
    }

    private void initSASLServer() throws SaslException {
        this.saslServer = Sasl.createSaslServer(this.mechanism, "ldap", this.serverFQDN, this.saslProps, this);
    }

    byte[] wrap(byte[] clearBytes, int offset, int len) throws SaslException {
        return this.saslServer.wrap(clearBytes, offset, len);
    }

    byte[] unwrap(byte[] bytes, int offset, int len) throws SaslException {
        return this.saslServer.unwrap(bytes, offset, len);
    }

    void dispose() {
        block2: {
            try {
                this.saslServer.dispose();
            }
            catch (SaslException e) {
                if (!DebugLogger.debugEnabled()) break block2;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    int getBufSize(String prop) {
        String sizeStr = (String)this.saslServer.getNegotiatedProperty(prop);
        return Integer.parseInt(sizeStr);
    }

    int getSSF() {
        String negStrength;
        int ssf = 0;
        String qop = (String)this.saslServer.getNegotiatedProperty("javax.security.sasl.qop");
        ssf = qop.equalsIgnoreCase("auth-int") ? 1 : ((negStrength = (String)this.saslServer.getNegotiatedProperty("javax.security.sasl.strength")).equalsIgnoreCase("low") ? 40 : (negStrength.equalsIgnoreCase("medium") ? 56 : 128));
        return ssf;
    }

    boolean isBindComplete() {
        return this.saslServer.isComplete();
    }

    private boolean isConfidentialIntegrity() {
        boolean ret = false;
        String qop = (String)this.saslServer.getNegotiatedProperty("javax.security.sasl.qop");
        if (qop.equalsIgnoreCase("auth-conf") || qop.equalsIgnoreCase("auth-int")) {
            ret = true;
        }
        return ret;
    }

    private byte[] evaluateResponse(byte[] bytes) throws SaslException {
        return this.saslServer.evaluateResponse(bytes);
    }

    private void handleError(Message msg) {
        this.dispose();
        ClientConnection clientConn = this.bindOp.getClientConnection();
        clientConn.setSASLAuthStateInfo(null);
        if (this.cbMsg != null) {
            this.bindOp.setAuthFailureReason(this.cbMsg);
        } else {
            this.bindOp.setAuthFailureReason(msg);
        }
        this.bindOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
    }

    private boolean hasPrivilege(AuthenticationInfo authInfo) {
        boolean ret = true;
        InternalClientConnection tempConn = new InternalClientConnection(authInfo);
        if (!tempConn.hasPrivilege(Privilege.PROXIED_AUTH, this.bindOp)) {
            this.setCallbackMsg(ExtensionMessages.ERR_SASL_AUTHZID_INSUFFICIENT_PRIVILEGES.get(String.valueOf(this.authEntry.getDN())));
            ret = false;
        }
        return ret;
    }

    private boolean hasPermission(AuthenticationInfo authInfo) {
        boolean ret = true;
        Entry e = this.authzEntry;
        if (e == null) {
            try {
                e = DirectoryServer.getEntry(DN.nullDN());
            }
            catch (DirectoryException ex) {
                return false;
            }
        }
        if (!AccessControlConfigManager.getInstance().getAccessControlHandler().mayProxy(authInfo.getAuthenticationEntry(), e, this.bindOp)) {
            this.setCallbackMsg(ExtensionMessages.ERR_SASL_AUTHZID_INSUFFICIENT_ACCESS.get(String.valueOf(this.authEntry.getDN())));
            ret = false;
        }
        return ret;
    }

    private void setCallbackMsg(Message cbMsg) {
        this.cbMsg = cbMsg;
    }

    @Override
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                this.nameCallback((NameCallback)callback);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                this.passwordCallback((PasswordCallback)callback);
                continue;
            }
            if (callback instanceof RealmCallback) {
                this.realmCallback((RealmCallback)callback);
                continue;
            }
            if (callback instanceof AuthorizeCallback) {
                this.authorizeCallback((AuthorizeCallback)callback);
                continue;
            }
            Message message = ExtensionMessages.INFO_SASL_UNSUPPORTED_CALLBACK.get(this.mechanism, String.valueOf(callback));
            throw new UnsupportedCallbackException(callback, message.toString());
        }
    }

    private void realmCallback(RealmCallback callback) {
    }

    private void authorizeCallback(AuthorizeCallback callback) {
        String responseAuthzID = callback.getAuthorizationID();
        if (this.authEntry == null) {
            String authid = callback.getAuthenticationID();
            try {
                this.authEntry = this.identityMapper.getEntryForID(authid);
                if (this.authEntry == null) {
                    this.setCallbackMsg(ExtensionMessages.ERR_SASL_AUTHENTRY_NO_MAPPED_ENTRY.get(authid));
                    callback.setAuthorized(false);
                    return;
                }
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                this.setCallbackMsg(ExtensionMessages.ERR_SASL_CANNOT_MAP_AUTHENTRY.get(authid, de.getMessage()));
                callback.setAuthorized(false);
                return;
            }
            this.userName = authid;
        }
        if (responseAuthzID.length() == 0) {
            this.setCallbackMsg(ExtensionMessages.ERR_SASLDIGESTMD5_EMPTY_AUTHZID.get());
            callback.setAuthorized(false);
            return;
        }
        if (!responseAuthzID.equals(this.userName)) {
            String lowerAuthzID = StaticUtils.toLowerCase(responseAuthzID);
            if (lowerAuthzID.startsWith("dn:")) {
                this.authzDNCheck(callback);
            } else {
                this.authzIDCheck(callback);
            }
        } else {
            this.authzEntry = this.authEntry;
            callback.setAuthorized(true);
        }
    }

    private void authzIDCheck(AuthorizeCallback callback) {
        String authzid = callback.getAuthorizationID();
        String lowerAuthzID = StaticUtils.toLowerCase(authzid);
        callback.setAuthorized(true);
        String idStr = lowerAuthzID.startsWith("u:") ? authzid.substring(2) : authzid;
        if (idStr.length() == 0) {
            this.authzEntry = null;
        } else {
            try {
                this.authzEntry = this.identityMapper.getEntryForID(idStr);
                if (this.authzEntry == null) {
                    this.setCallbackMsg(ExtensionMessages.ERR_SASL_AUTHZID_NO_MAPPED_ENTRY.get(authzid));
                    callback.setAuthorized(false);
                    return;
                }
            }
            catch (DirectoryException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                this.setCallbackMsg(ExtensionMessages.ERR_SASL_AUTHZID_NO_MAPPED_ENTRY.get(authzid));
                callback.setAuthorized(false);
                return;
            }
        }
        if (this.authzEntry == null || !this.authzEntry.getDN().equals(this.authEntry.getDN())) {
            AuthenticationInfo authInfo = new AuthenticationInfo(this.authEntry, DirectoryServer.isRootDN(this.authEntry.getDN()));
            if (!this.hasPrivilege(authInfo)) {
                callback.setAuthorized(false);
            } else {
                callback.setAuthorized(this.hasPermission(authInfo));
            }
        }
    }

    private void authzDNCheck(AuthorizeCallback callback) {
        DN authzDN;
        String responseAuthzID = callback.getAuthorizationID();
        callback.setAuthorized(true);
        try {
            authzDN = DN.decode(responseAuthzID.substring(3));
        }
        catch (DirectoryException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            this.setCallbackMsg(ExtensionMessages.ERR_SASL_AUTHZID_INVALID_DN.get(responseAuthzID, e.getMessageObject()));
            callback.setAuthorized(false);
            return;
        }
        DN actualAuthzDN = DirectoryServer.getActualRootBindDN(authzDN);
        if (actualAuthzDN != null) {
            authzDN = actualAuthzDN;
        }
        if (!authzDN.equals(this.authEntry.getDN())) {
            if (authzDN.isNullDN()) {
                this.authzEntry = null;
            } else {
                try {
                    this.authzEntry = DirectoryServer.getEntry(authzDN);
                    if (this.authzEntry == null) {
                        this.setCallbackMsg(ExtensionMessages.ERR_SASL_AUTHZID_NO_SUCH_ENTRY.get(String.valueOf(authzDN)));
                        callback.setAuthorized(false);
                        return;
                    }
                }
                catch (DirectoryException e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    this.setCallbackMsg(ExtensionMessages.ERR_SASL_AUTHZID_CANNOT_GET_ENTRY.get(String.valueOf(authzDN), e.getMessageObject()));
                    callback.setAuthorized(false);
                    return;
                }
            }
            AuthenticationInfo authInfo = new AuthenticationInfo(this.authEntry, DirectoryServer.isRootDN(this.authEntry.getDN()));
            if (!this.hasPrivilege(authInfo)) {
                callback.setAuthorized(false);
            } else {
                callback.setAuthorized(this.hasPermission(authInfo));
            }
        }
    }

    private void passwordCallback(PasswordCallback passwordCallback) {
        List<ByteString> clearPasswords;
        if (this.authEntry == null) {
            this.setCallbackMsg(ExtensionMessages.ERR_SASL_NO_MATCHING_ENTRIES.get(this.userName));
            return;
        }
        try {
            PasswordPolicyState pwPolicyState = new PasswordPolicyState(this.authEntry, false);
            clearPasswords = pwPolicyState.getClearPasswords();
            if (clearPasswords == null || clearPasswords.isEmpty()) {
                this.setCallbackMsg(ExtensionMessages.ERR_SASL_NO_REVERSIBLE_PASSWORDS.get(this.mechanism, String.valueOf(this.authEntry.getDN())));
                return;
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            this.setCallbackMsg(ExtensionMessages.ERR_SASL_CANNOT_GET_REVERSIBLE_PASSWORDS.get(String.valueOf(this.authEntry.getDN()), this.mechanism, String.valueOf(e)));
            return;
        }
        char[] password = ((Object)clearPasswords.get(0)).toString().toCharArray();
        passwordCallback.setPassword(password);
    }

    private void nameCallback(NameCallback nameCallback) {
        this.userName = nameCallback.getDefaultName();
        String lowerUserName = StaticUtils.toLowerCase(this.userName);
        if (lowerUserName.startsWith("dn:")) {
            DN userDN;
            try {
                userDN = DN.decode(this.userName.substring(3));
            }
            catch (DirectoryException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                this.setCallbackMsg(ExtensionMessages.ERR_SASL_CANNOT_DECODE_USERNAME_AS_DN.get(this.mechanism, this.userName, e.getMessageObject()));
                return;
            }
            if (userDN.isNullDN()) {
                this.setCallbackMsg(ExtensionMessages.ERR_SASL_USERNAME_IS_NULL_DN.get(this.mechanism));
                return;
            }
            DN rootDN = DirectoryServer.getActualRootBindDN(userDN);
            if (rootDN != null) {
                userDN = rootDN;
            }
            this.getAuthEntry(userDN);
        } else {
            String entryID = this.userName;
            if (lowerUserName.startsWith("u:")) {
                if (lowerUserName.equals("u:")) {
                    this.setCallbackMsg(ExtensionMessages.ERR_SASL_ZERO_LENGTH_USERNAME.get(this.mechanism, this.mechanism));
                    return;
                }
                entryID = this.userName.substring(2);
            }
            try {
                this.authEntry = this.identityMapper.getEntryForID(entryID);
            }
            catch (DirectoryException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                this.setCallbackMsg(ExtensionMessages.ERR_SASLDIGESTMD5_CANNOT_MAP_USERNAME.get(String.valueOf(this.userName), e.getMessageObject()));
                return;
            }
        }
        if (this.authEntry == null) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAuthEntry(DN userDN) {
        Lock readLock = null;
        for (int i = 0; i < 3 && (readLock = LockManager.lockRead(userDN)) == null; ++i) {
        }
        if (readLock == null) {
            this.setCallbackMsg(ExtensionMessages.INFO_SASL_CANNOT_LOCK_ENTRY.get(String.valueOf(userDN)));
            return;
        }
        try {
            this.authEntry = DirectoryServer.getEntry(userDN);
        }
        catch (DirectoryException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            this.setCallbackMsg(ExtensionMessages.ERR_SASL_CANNOT_GET_ENTRY_BY_DN.get(String.valueOf(userDN), "DIGEST-MD5", e.getMessageObject()));
            return;
        }
        finally {
            LockManager.unlock(userDN, readLock);
        }
    }

    @Override
    public Boolean run() {
        ClientConnection clientConn = this.bindOp.getClientConnection();
        if (this.saslServer == null) {
            try {
                this.initSASLServer();
            }
            catch (SaslException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message msg = ExtensionMessages.ERR_SASL_CONTEXT_CREATE_ERROR.get("DIGEST-MD5", StaticUtils.getExceptionMessage(e));
                clientConn.setSASLAuthStateInfo(null);
                this.bindOp.setAuthFailureReason(msg);
                this.bindOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                return false;
            }
        }
        byte[] clientCredBytes = new byte[]{};
        ASN1OctetString clientCredentials = this.bindOp.getSASLCredentials();
        if (clientCredentials != null) {
            clientCredBytes = clientCredentials.value();
        }
        clientConn.setSASLAuthStateInfo(null);
        try {
            byte[] responseBytes = this.evaluateResponse(clientCredBytes);
            ASN1OctetString responseAuthStr = new ASN1OctetString(responseBytes);
            if (this.isBindComplete()) {
                this.bindOp.setResultCode(ResultCode.SUCCESS);
                this.bindOp.setSASLAuthUserEntry(this.authEntry);
                AuthenticationInfo authInfo = new AuthenticationInfo(this.authEntry, this.authzEntry, this.mechanism, DirectoryServer.isRootDN(this.authEntry.getDN()));
                this.bindOp.setAuthenticationInfo(authInfo);
                if (this.isConfidentialIntegrity()) {
                    SASLSecurityProvider secProvider = new SASLSecurityProvider(clientConn, this.mechanism, this);
                    LDAPClientConnection ldapConn = (LDAPClientConnection)clientConn;
                    ldapConn.setSASLConnectionSecurityProvider(secProvider);
                } else {
                    this.dispose();
                    clientConn.setSASLAuthStateInfo(null);
                }
            } else {
                this.bindOp.setServerSASLCredentials(responseAuthStr);
                clientConn.setSASLAuthStateInfo(this);
                this.bindOp.setResultCode(ResultCode.SASL_BIND_IN_PROGRESS);
            }
        }
        catch (SaslException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message msg = ExtensionMessages.ERR_SASL_PROTOCOL_ERROR.get(this.mechanism, StaticUtils.getExceptionMessage(e));
            this.handleError(msg);
            return false;
        }
        return true;
    }

    void performAuthentication(LoginContext loginContext, BindOperation bindOp) {
        this.bindOp = bindOp;
        try {
            Subject.doAs(loginContext.getSubject(), this);
        }
        catch (PrivilegedActionException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message msg = ExtensionMessages.ERR_SASL_PROTOCOL_ERROR.get(this.mechanism, StaticUtils.getExceptionMessage(e));
            this.handleError(msg);
        }
    }

    void evaluateInitialStage(BindOperation bindOp) {
        this.bindOp = bindOp;
        ClientConnection clientConn = bindOp.getClientConnection();
        try {
            byte[] challengeBuffer = this.evaluateResponse(new byte[0]);
            ASN1OctetString challenge = new ASN1OctetString(challengeBuffer);
            bindOp.setResultCode(ResultCode.SASL_BIND_IN_PROGRESS);
            bindOp.setServerSASLCredentials(challenge);
            clientConn.setSASLAuthStateInfo(this);
        }
        catch (SaslException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message msg = ExtensionMessages.ERR_SASL_PROTOCOL_ERROR.get(this.mechanism, StaticUtils.getExceptionMessage(e));
            this.handleError(msg);
        }
    }

    void evaluateFinalStage(BindOperation bindOp) {
        this.bindOp = bindOp;
        ASN1OctetString clientCredentials = bindOp.getSASLCredentials();
        if (clientCredentials == null || clientCredentials.value().length == 0) {
            Message msg = ExtensionMessages.ERR_SASL_NO_CREDENTIALS.get(this.mechanism, this.mechanism);
            this.handleError(msg);
            return;
        }
        ClientConnection clientConn = bindOp.getClientConnection();
        clientConn.setSASLAuthStateInfo(null);
        try {
            byte[] responseBytes = this.evaluateResponse(clientCredentials.value());
            ASN1OctetString responseAuthStr = new ASN1OctetString(responseBytes);
            bindOp.setResultCode(ResultCode.SUCCESS);
            bindOp.setServerSASLCredentials(responseAuthStr);
            bindOp.setSASLAuthUserEntry(this.authEntry);
            AuthenticationInfo authInfo = new AuthenticationInfo(this.authEntry, this.authzEntry, this.mechanism, DirectoryServer.isRootDN(this.authEntry.getDN()));
            bindOp.setAuthenticationInfo(authInfo);
            if (this.isConfidentialIntegrity()) {
                SASLSecurityProvider secProvider = new SASLSecurityProvider(clientConn, this.mechanism, this);
                LDAPClientConnection ldapConn = (LDAPClientConnection)clientConn;
                ldapConn.setSASLConnectionSecurityProvider(secProvider);
            } else {
                this.dispose();
                clientConn.setSASLAuthStateInfo(null);
            }
        }
        catch (SaslException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message msg = ExtensionMessages.ERR_SASL_PROTOCOL_ERROR.get(this.mechanism, StaticUtils.getExceptionMessage(e));
            this.handleError(msg);
        }
    }
}

