/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import javax.security.sasl.SaslException;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConnectionSecurityProvider;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.extensions.SASLContext;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.ldap.LDAPClientConnection;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.InitializationException;

public class SASLSecurityProvider
extends ConnectionSecurityProvider {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ClientConnection connection;
    private SocketChannel sockChannel;
    private SASLContext saslContext;
    private final int lengthSize = 4;
    private ByteBuffer lengthBuf = ByteBuffer.allocate(4);
    private String name;

    public SASLSecurityProvider(ClientConnection connection, String name, SASLContext saslContext) {
        this.connection = connection;
        this.name = name;
        this.saslContext = saslContext;
        this.sockChannel = ((LDAPClientConnection)connection).getSocketChannel();
    }

    public void disconnect(boolean connectionValid) {
        this.saslContext.dispose();
    }

    public void finalizeConnectionSecurityProvider() {
    }

    public int getClearBufferSize() {
        return 0;
    }

    public int getEncodedBufferSize() {
        return 0;
    }

    public String getSecurityMechanismName() {
        return this.name;
    }

    public void initializeConnectionSecurityProvider(ConfigEntry configEntry) throws ConfigException, InitializationException {
        this.connection = null;
        this.sockChannel = null;
    }

    public boolean isSecure() {
        return true;
    }

    public ConnectionSecurityProvider newInstance(ClientConnection clientConn, SocketChannel socketChannel) {
        return new SASLSecurityProvider(clientConn, null, null);
    }

    private int getBufLength(ByteBuffer byteBuf) {
        int answer = 0;
        byte[] buf = byteBuf.array();
        for (int i = 0; i < 4; ++i) {
            answer <<= 8;
            answer |= buf[i] & 0xFF;
        }
        return answer;
    }

    private int readAll(ByteBuffer byteBuf, int total) throws IOException {
        int count = 0;
        while (this.sockChannel.isOpen() && total > 0) {
            count = this.sockChannel.read(byteBuf);
            if (count == -1) {
                return -1;
            }
            if (count == 0) {
                return 0;
            }
            total -= count;
        }
        if (total > 0) {
            return -1;
        }
        return byteBuf.position();
    }

    public boolean readData() throws DirectoryException {
        int recvBufSize = this.saslContext.getBufSize("javax.security.sasl.maxbuffer");
        try {
            ByteBuffer readBuf;
            byte[] inBytes;
            byte[] clearBytes;
            ByteBuffer clearBuffer;
            do {
                this.lengthBuf.clear();
                int readResult = this.readAll(this.lengthBuf, 4);
                if (readResult == -1) {
                    this.connection.disconnect(DisconnectReason.CLIENT_DISCONNECT, false, null);
                    return false;
                }
                if (readResult == 0) {
                    return true;
                }
                int bufLength = this.getBufLength(this.lengthBuf);
                if (bufLength > recvBufSize) {
                    this.connection.disconnect(DisconnectReason.CLIENT_DISCONNECT, false, null);
                    return false;
                }
                readBuf = ByteBuffer.allocate(bufLength);
                readResult = this.readAll(readBuf, bufLength);
                if (readResult == -1) {
                    this.connection.disconnect(DisconnectReason.CLIENT_DISCONNECT, false, null);
                    return false;
                }
                if (readResult != 0) continue;
                return true;
            } while (this.connection.processDataRead(clearBuffer = ByteBuffer.wrap(clearBytes = this.saslContext.unwrap(inBytes = readBuf.array(), 0, inBytes.length))));
            return false;
        }
        catch (SaslException saslEx) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, saslEx);
            }
            this.connection.disconnect(DisconnectReason.IO_ERROR, false, null);
            return false;
        }
        catch (IOException ioe) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ioe);
            }
            this.connection.disconnect(DisconnectReason.IO_ERROR, false, null);
            return false;
        }
    }

    private ByteBuffer createSendBuffer(byte[] clearBytes, int offSet, int len) throws SaslException {
        byte[] wrapBytes = this.saslContext.wrap(clearBytes, offSet, len);
        byte[] outBuf = new byte[wrapBytes.length + 4];
        this.writeBufLen(outBuf, wrapBytes.length);
        System.arraycopy(wrapBytes, 0, outBuf, 4, wrapBytes.length);
        return ByteBuffer.wrap(outBuf);
    }

    private void writeBufLen(byte[] buf, int len) {
        for (int i = 3; i >= 0; --i) {
            buf[i] = (byte)(len & 0xFF);
            len >>>= 8;
        }
    }

    public boolean writeData(ByteBuffer clearData) {
        int maxSendBufSize = this.saslContext.getBufSize("javax.security.sasl.rawsendsize");
        int clearLength = clearData.limit();
        try {
            if (clearLength < maxSendBufSize) {
                ByteBuffer sendBuffer = this.createSendBuffer(clearData.array(), 0, clearLength);
                return this.writeChannel(sendBuffer);
            }
            byte[] clearBytes = clearData.array();
            for (int i = 0; i < clearLength; i += maxSendBufSize) {
                int totLength = clearLength - i < maxSendBufSize ? clearLength - i : maxSendBufSize;
                ByteBuffer sendBuffer = this.createSendBuffer(clearBytes, i, totLength);
                if (this.writeChannel(sendBuffer)) continue;
                return false;
            }
        }
        catch (SaslException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            this.connection.disconnect(DisconnectReason.IO_ERROR, false, null);
            return false;
        }
        return true;
    }

    private boolean writeChannel(ByteBuffer buffer) {
        try {
            while (buffer.hasRemaining()) {
                int bytesWritten = this.sockChannel.write(buffer);
                if (bytesWritten < 0) {
                    this.connection.disconnect(DisconnectReason.CLIENT_DISCONNECT, false, null);
                    return false;
                }
                if (bytesWritten != 0) continue;
                return this.writeWithTimeout(buffer);
            }
        }
        catch (IOException ioe) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ioe);
            }
            this.connection.disconnect(DisconnectReason.IO_ERROR, false, null);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeWithTimeout(ByteBuffer buffer) throws IOException {
        long startTime = System.currentTimeMillis();
        long waitTime = this.connection.getMaxBlockedWriteTimeLimit();
        if (waitTime <= 0L) {
            waitTime = 300000L;
        }
        long stopTime = startTime + waitTime;
        Selector selector = this.connection.getWriteSelector();
        if (selector == null) {
            while (buffer.hasRemaining() && System.currentTimeMillis() < stopTime) {
                if (this.sockChannel.write(buffer) >= 0) continue;
                this.connection.disconnect(DisconnectReason.CLIENT_DISCONNECT, false, null);
                return false;
            }
            if (buffer.hasRemaining()) {
                this.connection.disconnect(DisconnectReason.IO_TIMEOUT, false, null);
                return false;
            }
            return true;
        }
        SelectionKey key = this.sockChannel.register(selector, 4);
        try {
            selector.select(waitTime);
            while (buffer.hasRemaining()) {
                long currentTime = System.currentTimeMillis();
                if (currentTime >= stopTime) {
                    this.connection.disconnect(DisconnectReason.IO_TIMEOUT, false, null);
                    boolean bl = false;
                    return bl;
                }
                waitTime = stopTime - currentTime;
                Iterator<SelectionKey> iterator = selector.selectedKeys().iterator();
                while (iterator.hasNext()) {
                    SelectionKey k = iterator.next();
                    if (!k.isWritable()) continue;
                    int bytesWritten = this.sockChannel.write(buffer);
                    if (bytesWritten < 0) {
                        this.connection.disconnect(DisconnectReason.CLIENT_DISCONNECT, false, null);
                        boolean bl = false;
                        return bl;
                    }
                    iterator.remove();
                }
                if (!buffer.hasRemaining()) continue;
                selector.select(waitTime);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (key.isValid()) {
                key.cancel();
                selector.selectNow();
            }
        }
    }

    public boolean isActive() {
        return this.saslContext.isBindComplete();
    }

    public int getSSF() {
        return this.saslContext.getSSF();
    }
}

