/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.std.meta.AccessLogPublisherCfgDefn;
import org.opends.server.admin.std.server.AccessLogPublisherCfg;
import org.opends.server.api.AccessLogPublisher;
import org.opends.server.api.ClientConnection;
import org.opends.server.config.ConfigException;
import org.opends.server.core.AbandonOperation;
import org.opends.server.core.AddOperation;
import org.opends.server.core.BindOperation;
import org.opends.server.core.CompareOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.core.UnbindOperation;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchResultReference;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessLogger
implements ConfigurationAddListener<AccessLogPublisherCfg>,
ConfigurationDeleteListener<AccessLogPublisherCfg>,
ConfigurationChangeListener<AccessLogPublisherCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    static CopyOnWriteArrayList<AccessLogPublisher<?>> accessPublishers = new CopyOnWriteArrayList();
    static final AccessLogger instance = new AccessLogger();

    public static AccessLogger getInstance() {
        return instance;
    }

    public static synchronized void addAccessLogPublisher(AccessLogPublisher<?> publisher) {
        accessPublishers.add(publisher);
    }

    public static synchronized boolean removeAccessLogPublisher(AccessLogPublisher<?> publisher) {
        boolean removed = accessPublishers.remove(publisher);
        if (removed) {
            publisher.close();
        }
        return removed;
    }

    public static synchronized void removeAllAccessLogPublishers() {
        for (AccessLogPublisher<?> publisher : accessPublishers) {
            publisher.close();
        }
        accessPublishers.clear();
    }

    public void initializeAccessLogger(List<AccessLogPublisherCfg> configs) throws ConfigException, InitializationException {
        for (AccessLogPublisherCfg config : configs) {
            config.addAccessChangeListener(this);
            if (!config.isEnabled()) continue;
            AccessLogPublisher<?> AccessLogPublisher2 = this.getAccessPublisher(config);
            AccessLogger.addAccessLogPublisher(AccessLogPublisher2);
        }
    }

    @Override
    public boolean isConfigurationAddAcceptable(AccessLogPublisherCfg config, List<Message> unacceptableReasons) {
        return !config.isEnabled() || this.isJavaClassAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(AccessLogPublisherCfg config, List<Message> unacceptableReasons) {
        return !config.isEnabled() || this.isJavaClassAcceptable(config, unacceptableReasons);
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(AccessLogPublisherCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        config.addAccessChangeListener(this);
        if (config.isEnabled()) {
            try {
                AccessLogPublisher<?> AccessLogPublisher2 = this.getAccessPublisher(config);
                AccessLogger.addAccessLogPublisher(AccessLogPublisher2);
            }
            catch (ConfigException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                messages.add(e.getMessageObject());
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                messages.add(ConfigMessages.ERR_CONFIG_LOGGER_CANNOT_CREATE_LOGGER.get(String.valueOf(config.dn().toString()), StaticUtils.stackTraceToSingleLineString(e)));
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(AccessLogPublisherCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        DN dn = config.dn();
        AccessLogPublisher<?> accessLogPublisher = null;
        for (AccessLogPublisher<?> publisher : accessPublishers) {
            if (!publisher.getDN().equals(dn)) continue;
            accessLogPublisher = publisher;
            break;
        }
        if (accessLogPublisher == null) {
            if (config.isEnabled()) {
                return this.applyConfigurationAdd(config);
            }
        } else if (config.isEnabled()) {
            String className = config.getJavaClass();
            if (!className.equals(accessLogPublisher.getClass().getName())) {
                adminActionRequired = true;
            }
        } else {
            AccessLogger.removeAccessLogPublisher(accessLogPublisher);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(AccessLogPublisherCfg config, List<Message> unacceptableReasons) {
        DN dn = config.dn();
        AccessLogPublisher<?> accessLogPublisher = null;
        for (AccessLogPublisher<?> publisher : accessPublishers) {
            if (!publisher.getDN().equals(dn)) continue;
            accessLogPublisher = publisher;
            break;
        }
        return accessLogPublisher != null;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(AccessLogPublisherCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        AccessLogPublisher<?> accessLogPublisher = null;
        for (AccessLogPublisher<?> publisher : accessPublishers) {
            if (!publisher.getDN().equals(config.dn())) continue;
            accessLogPublisher = publisher;
            break;
        }
        if (accessLogPublisher != null) {
            AccessLogger.removeAccessLogPublisher(accessLogPublisher);
        } else {
            resultCode = ResultCode.NO_SUCH_OBJECT;
        }
        return new ConfigChangeResult(resultCode, adminActionRequired);
    }

    private boolean isJavaClassAcceptable(AccessLogPublisherCfg config, List<Message> unacceptableReasons) {
        Class<AccessLogPublisher> theClass;
        String className = config.getJavaClass();
        AccessLogPublisherCfgDefn d = AccessLogPublisherCfgDefn.getInstance();
        ClassPropertyDefinition pd = d.getJavaClassPropertyDefinition();
        AccessLogPublisher publisher = null;
        try {
            theClass = pd.loadClass(className, AccessLogPublisher.class);
            publisher = theClass.newInstance();
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_LOGGER_INVALID_ACCESS_LOGGER_CLASS.get(className, config.dn().toString(), String.valueOf(e));
            unacceptableReasons.add(message);
            return false;
        }
        try {
            Method method = theClass.getMethod("isConfigurationAcceptable", AccessLogPublisherCfg.class, List.class);
            Boolean acceptable = (Boolean)method.invoke((Object)publisher, config, unacceptableReasons);
            if (!acceptable.booleanValue()) {
                return false;
            }
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_LOGGER_INVALID_ACCESS_LOGGER_CLASS.get(className, config.dn().toString(), String.valueOf(e));
            unacceptableReasons.add(message);
            return false;
        }
        return true;
    }

    private AccessLogPublisher<?> getAccessPublisher(AccessLogPublisherCfg config) throws ConfigException {
        AccessLogPublisher AccessLogPublisher2;
        String className = config.getJavaClass();
        AccessLogPublisherCfgDefn d = AccessLogPublisherCfgDefn.getInstance();
        ClassPropertyDefinition pd = d.getJavaClassPropertyDefinition();
        try {
            Class<AccessLogPublisher> theClass = pd.loadClass(className, AccessLogPublisher.class);
            AccessLogPublisher2 = theClass.newInstance();
            Method method = theClass.getMethod("initializeAccessLogPublisher", config.configurationClass());
            method.invoke((Object)AccessLogPublisher2, config);
        }
        catch (InvocationTargetException ite) {
            Throwable e = ite.getTargetException();
            Message message = ConfigMessages.ERR_CONFIG_LOGGER_INVALID_ACCESS_LOGGER_CLASS.get(className, config.dn().toString(), StaticUtils.stackTraceToSingleLineString(e));
            throw new ConfigException(message, e);
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_LOGGER_INVALID_ACCESS_LOGGER_CLASS.get(className, config.dn().toString(), String.valueOf(e));
            throw new ConfigException(message, (Throwable)e);
        }
        return AccessLogPublisher2;
    }

    public static void logConnect(ClientConnection clientConnection) {
        for (AccessLogPublisher<?> publisher : accessPublishers) {
            publisher.logConnect(clientConnection);
        }
    }

    public static void logDisconnect(ClientConnection clientConnection, DisconnectReason disconnectReason, Message message) {
        for (AccessLogPublisher<?> publisher : accessPublishers) {
            publisher.logDisconnect(clientConnection, disconnectReason, message);
        }
    }

    public static void logAbandonRequest(AbandonOperation abandonOperation) {
        for (AccessLogPublisher<?> publisher : accessPublishers) {
            publisher.logAbandonRequest(abandonOperation);
        }
    }

    public static void logAbandonIntermediateMessage(AbandonOperation abandonOperation, String category, Map<String, String> content) {
        for (AccessLogPublisher<?> publisher : accessPublishers) {
            publisher.logAbandonIntermediateMessage(abandonOperation, category, content);
        }
    }

    public static void logAbandonResult(AbandonOperation abandonOperation) {
        for (AccessLogPublisher<?> publisher : accessPublishers) {
            publisher.logAbandonResult(abandonOperation);
        }
    }

    public static void logAddRequest(AddOperation addOperation) {
        for (AccessLogPublisher<?> publisher : accessPublishers) {
            publisher.logAddRequest(addOperation);
        }
    }

    public static void logAddIntermediateMessage(AddOperation addOperation, String category, Map<String, String> content) {
        for (AccessLogPublisher<?> publisher : accessPublishers) {
            publisher.logAddIntermediateMessage(addOperation, category, content);
        }
    }

    public static void logAddResponse(AddOperation addOperation) {
        for (AccessLogPublisher<?> publisher : accessPublishers) {
            publisher.logAddResponse(addOperation);
        }
    }

    public static void logBindRequest(BindOperation bindOperation) {
        for (AccessLogPublisher<?> publisher : accessPublishers) {
            publisher.logBindRequest(bindOperation);
        }
    }

    public static void logBindIntermediateMessage(BindOperation bindOperation, String category, Map<String, String> content) {
        for (AccessLogPublisher<?> publisher : accessPublishers) {
            publisher.logBindIntermediateMessage(bindOperation, category, content);
        }
    }

    public static void logBindResponse(BindOperation bindOperation) {
        for (AccessLogPublisher<?> publisher : accessPublishers) {
            publisher.logBindResponse(bindOperation);
        }
    }

    public static void logCompareRequest(CompareOperation compareOperation) {
        for (AccessLogPublisher<?> publisher : accessPublishers) {
            publisher.logCompareRequest(compareOperation);
        }
    }

    public static void logCompareIntermediateMessage(CompareOperation compareOperation, String category, Map<String, String> content) {
        for (AccessLogPublisher<?> publisher : accessPublishers) {
            publisher.logCompareIntermediateMessage(compareOperation, category, content);
        }
    }

    public static void logCompareResponse(CompareOperation compareOperation) {
        for (AccessLogPublisher<?> publisher : accessPublishers) {
            publisher.logCompareResponse(compareOperation);
        }
    }

    public static void logDeleteRequest(DeleteOperation deleteOperation) {
        for (AccessLogPublisher<?> publisher : accessPublishers) {
            publisher.logDeleteRequest(deleteOperation);
        }
    }

    public static void logDeleteIntermediateMessage(DeleteOperation deleteOperation, String category, Map<String, String> content) {
        for (AccessLogPublisher<?> publisher : accessPublishers) {
            publisher.logDeleteIntermediateMessage(deleteOperation, category, content);
        }
    }

    public static void logDeleteResponse(DeleteOperation deleteOperation) {
        for (AccessLogPublisher<?> publisher : accessPublishers) {
            publisher.logDeleteResponse(deleteOperation);
        }
    }

    public static void logExtendedRequest(ExtendedOperation extendedOperation) {
        for (AccessLogPublisher<?> publisher : accessPublishers) {
            publisher.logExtendedRequest(extendedOperation);
        }
    }

    public static void logExtendedIntermediateMessage(ExtendedOperation extendedOperation, String category, Map<String, String> content) {
        for (AccessLogPublisher<?> publisher : accessPublishers) {
            publisher.logExtendedIntermediateMessage(extendedOperation, category, content);
        }
    }

    public static void logExtendedResponse(ExtendedOperation extendedOperation) {
        for (AccessLogPublisher<?> publisher : accessPublishers) {
            publisher.logExtendedResponse(extendedOperation);
        }
    }

    public static void logModifyRequest(ModifyOperation modifyOperation) {
        for (AccessLogPublisher<?> publisher : accessPublishers) {
            publisher.logModifyRequest(modifyOperation);
        }
    }

    public static void logModifyIntermediateMessage(ModifyOperation modifyOperation, String category, Map<String, String> content) {
        for (AccessLogPublisher<?> publisher : accessPublishers) {
            publisher.logModifyIntermediateMessage(modifyOperation, category, content);
        }
    }

    public static void logModifyResponse(ModifyOperation modifyOperation) {
        for (AccessLogPublisher<?> publisher : accessPublishers) {
            publisher.logModifyResponse(modifyOperation);
        }
    }

    public static void logModifyDNRequest(ModifyDNOperation modifyDNOperation) {
        for (AccessLogPublisher<?> publisher : accessPublishers) {
            publisher.logModifyDNRequest(modifyDNOperation);
        }
    }

    public static void logModifyDNIntermediateMessage(ModifyDNOperation modifyDNOperation, String category, Map<String, String> content) {
        for (AccessLogPublisher<?> publisher : accessPublishers) {
            publisher.logModifyDNIntermediateMessage(modifyDNOperation, category, content);
        }
    }

    public static void logModifyDNResponse(ModifyDNOperation modifyDNOperation) {
        for (AccessLogPublisher<?> publisher : accessPublishers) {
            publisher.logModifyDNResponse(modifyDNOperation);
        }
    }

    public static void logSearchRequest(SearchOperation searchOperation) {
        for (AccessLogPublisher<?> publisher : accessPublishers) {
            publisher.logSearchRequest(searchOperation);
        }
    }

    public static void logSearchIntermediateMessage(SearchOperation searchOperation, String category, Map<String, String> content) {
        for (AccessLogPublisher<?> publisher : accessPublishers) {
            publisher.logSearchIntermediateMessage(searchOperation, category, content);
        }
    }

    public static void logSearchResultEntry(SearchOperation searchOperation, SearchResultEntry searchEntry) {
        for (AccessLogPublisher<?> publisher : accessPublishers) {
            publisher.logSearchResultEntry(searchOperation, searchEntry);
        }
    }

    public static void logSearchResultReference(SearchOperation searchOperation, SearchResultReference searchReference) {
        for (AccessLogPublisher<?> publisher : accessPublishers) {
            publisher.logSearchResultReference(searchOperation, searchReference);
        }
    }

    public static void logSearchResultDone(SearchOperation searchOperation) {
        for (AccessLogPublisher<?> publisher : accessPublishers) {
            publisher.logSearchResultDone(searchOperation);
        }
    }

    public static void logUnbind(UnbindOperation unbindOperation) {
        for (AccessLogPublisher<?> publisher : accessPublishers) {
            publisher.logUnbind(unbindOperation);
        }
    }
}

