/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.monitors;

import java.util.LinkedList;
import java.util.List;
import org.opends.server.admin.std.server.ConnectionHandlerCfg;
import org.opends.server.admin.std.server.MonitorProviderCfg;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConnectionHandler;
import org.opends.server.api.MonitorProvider;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Attributes;
import org.opends.server.types.DirectoryConfig;
import org.opends.server.types.HostPort;
import org.opends.server.types.ObjectClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionHandlerMonitor
extends MonitorProvider<MonitorProviderCfg> {
    private AttributeType connectionsType;
    private AttributeType listenerType;
    private AttributeType numConnectionsType;
    private AttributeType protocolType;
    private ConnectionHandler<?> connectionHandler;
    private String monitorName;

    public ConnectionHandlerMonitor(ConnectionHandler<? extends ConnectionHandlerCfg> connectionHandler) {
        super(connectionHandler.getConnectionHandlerName());
        this.connectionHandler = connectionHandler;
    }

    @Override
    public void initializeMonitorProvider(MonitorProviderCfg configuration) {
        this.monitorName = this.connectionHandler.getConnectionHandlerName();
        this.connectionsType = DirectoryConfig.getAttributeType("ds-connectionhandler-connection", true);
        this.listenerType = DirectoryConfig.getAttributeType("ds-connectionhandler-listener", true);
        this.numConnectionsType = DirectoryConfig.getAttributeType("ds-connectionhandler-num-connections", true);
        this.protocolType = DirectoryConfig.getAttributeType("ds-connectionhandler-protocol", true);
    }

    @Override
    public String getMonitorInstanceName() {
        return this.monitorName;
    }

    @Override
    public ObjectClass getMonitorObjectClass() {
        return DirectoryConfig.getObjectClass("ds-connectionhandler-monitor-entry", true);
    }

    @Override
    public long getUpdateInterval() {
        return 0L;
    }

    @Override
    public void updateMonitorData() {
    }

    @Override
    public List<Attribute> getMonitorData() {
        AttributeBuilder builder;
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        int numConnections = 0;
        LinkedList<ClientConnection> conns = new LinkedList<ClientConnection>(this.connectionHandler.getClientConnections());
        LinkedList<HostPort> listeners = new LinkedList<HostPort>(this.connectionHandler.getListeners());
        attrs.add(Attributes.create(this.protocolType, this.connectionHandler.getProtocol()));
        if (!listeners.isEmpty()) {
            builder = new AttributeBuilder(this.listenerType);
            for (HostPort hp : listeners) {
                builder.add(new AttributeValue(this.listenerType, hp.toString()));
            }
            attrs.add(builder.toAttribute());
        }
        if (!conns.isEmpty()) {
            builder = new AttributeBuilder(this.connectionsType);
            for (ClientConnection c : conns) {
                ++numConnections;
                builder.add(new AttributeValue(this.connectionsType, c.getMonitorSummary()));
            }
            attrs.add(builder.toAttribute());
        }
        attrs.add(Attributes.create(this.numConnectionsType, String.valueOf(numConnections)));
        return attrs;
    }
}

