/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.plugins;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.opends.messages.Message;
import org.opends.messages.PluginMessages;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.meta.PluginCfgDefn;
import org.opends.server.admin.std.server.LastModPluginCfg;
import org.opends.server.admin.std.server.PluginCfg;
import org.opends.server.api.plugin.DirectoryServerPlugin;
import org.opends.server.api.plugin.PluginResult;
import org.opends.server.api.plugin.PluginType;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Attributes;
import org.opends.server.types.ByteStringFactory;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryConfig;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.ResultCode;
import org.opends.server.types.operation.PreOperationAddOperation;
import org.opends.server.types.operation.PreOperationModifyDNOperation;
import org.opends.server.types.operation.PreOperationModifyOperation;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LastModPlugin
extends DirectoryServerPlugin<LastModPluginCfg>
implements ConfigurationChangeListener<LastModPluginCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final AttributeType createTimestampType = DirectoryConfig.getAttributeType("createtimestamp", true);
    private final AttributeType creatorsNameType = DirectoryConfig.getAttributeType("creatorsname", true);
    private final AttributeType modifiersNameType = DirectoryConfig.getAttributeType("modifiersname", true);
    private final AttributeType modifyTimestampType = DirectoryConfig.getAttributeType("modifytimestamp", true);
    private LastModPluginCfg currentConfig;

    @Override
    public final void initializePlugin(Set<PluginType> pluginTypes, LastModPluginCfg configuration) throws ConfigException {
        this.currentConfig = configuration;
        configuration.addLastModChangeListener(this);
        block3: for (PluginType t : pluginTypes) {
            switch (t) {
                case PRE_OPERATION_ADD: 
                case PRE_OPERATION_MODIFY: 
                case PRE_OPERATION_MODIFY_DN: {
                    continue block3;
                }
            }
            Message message = PluginMessages.ERR_PLUGIN_LASTMOD_INVALID_PLUGIN_TYPE.get(t.toString());
            throw new ConfigException(message);
        }
    }

    @Override
    public final void finalizePlugin() {
        this.currentConfig.removeLastModChangeListener(this);
    }

    @Override
    public final PluginResult.PreOperation doPreOperation(PreOperationAddOperation addOperation) {
        AttributeBuilder builder = new AttributeBuilder(this.creatorsNameType, "creatorsName");
        DN creatorDN = addOperation.getAuthorizationDN();
        if (creatorDN == null) {
            builder.add(new AttributeValue(this.creatorsNameType, ByteStringFactory.create()));
        } else {
            builder.add(new AttributeValue(this.creatorsNameType, ByteStringFactory.create(creatorDN.toString())));
        }
        Attribute nameAttr = builder.toAttribute();
        ArrayList<Attribute> nameList = new ArrayList<Attribute>(1);
        nameList.add(nameAttr);
        addOperation.setAttribute(this.creatorsNameType, nameList);
        Attribute timeAttr = Attributes.create(this.createTimestampType, "createTimestamp", new AttributeValue(this.createTimestampType, ByteStringFactory.create(TimeThread.getGMTTime())));
        ArrayList<Attribute> timeList = new ArrayList<Attribute>(1);
        timeList.add(timeAttr);
        addOperation.setAttribute(this.createTimestampType, timeList);
        return PluginResult.PreOperation.continueOperationProcessing();
    }

    @Override
    public final PluginResult.PreOperation doPreOperation(PreOperationModifyOperation modifyOperation) {
        AttributeBuilder builder = new AttributeBuilder(this.modifiersNameType, "modifiersName");
        DN modifierDN = modifyOperation.getAuthorizationDN();
        if (modifierDN == null) {
            builder.add(new AttributeValue(this.modifiersNameType, ByteStringFactory.create()));
        } else {
            builder.add(new AttributeValue(this.modifiersNameType, ByteStringFactory.create(modifierDN.toString())));
        }
        Attribute nameAttr = builder.toAttribute();
        try {
            modifyOperation.addModification(new Modification(ModificationType.REPLACE, nameAttr, true));
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            return PluginResult.PreOperation.stopProcessing(DirectoryConfig.getServerErrorResultCode(), de.getMessageObject());
        }
        Attribute timeAttr = Attributes.create(this.modifyTimestampType, "modifyTimestamp", new AttributeValue(this.modifyTimestampType, ByteStringFactory.create(TimeThread.getGMTTime())));
        try {
            modifyOperation.addModification(new Modification(ModificationType.REPLACE, timeAttr, true));
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            return PluginResult.PreOperation.stopProcessing(DirectoryConfig.getServerErrorResultCode(), de.getMessageObject());
        }
        return PluginResult.PreOperation.continueOperationProcessing();
    }

    @Override
    public final PluginResult.PreOperation doPreOperation(PreOperationModifyDNOperation modifyDNOperation) {
        AttributeBuilder builder = new AttributeBuilder(this.modifiersNameType, "modifiersName");
        DN modifierDN = modifyDNOperation.getAuthorizationDN();
        if (modifierDN == null) {
            builder.add(new AttributeValue(this.modifiersNameType, ByteStringFactory.create()));
        } else {
            builder.add(new AttributeValue(this.modifiersNameType, ByteStringFactory.create(modifierDN.toString())));
        }
        Attribute nameAttr = builder.toAttribute();
        modifyDNOperation.addModification(new Modification(ModificationType.REPLACE, nameAttr, true));
        Attribute timeAttr = Attributes.create(this.modifyTimestampType, "modifyTimestamp", new AttributeValue(this.modifyTimestampType, ByteStringFactory.create(TimeThread.getGMTTime())));
        modifyDNOperation.addModification(new Modification(ModificationType.REPLACE, timeAttr, true));
        return PluginResult.PreOperation.continueOperationProcessing();
    }

    @Override
    public boolean isConfigurationAcceptable(PluginCfg configuration, List<Message> unacceptableReasons) {
        LastModPluginCfg cfg = (LastModPluginCfg)configuration;
        return this.isConfigurationChangeAcceptable(cfg, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(LastModPluginCfg configuration, List<Message> unacceptableReasons) {
        boolean configAcceptable = true;
        block3: for (PluginCfgDefn.PluginType pluginType : configuration.getPluginType()) {
            switch (pluginType) {
                case PREOPERATIONADD: 
                case PREOPERATIONMODIFY: 
                case PREOPERATIONMODIFYDN: {
                    continue block3;
                }
            }
            Message message = PluginMessages.ERR_PLUGIN_LASTMOD_INVALID_PLUGIN_TYPE.get(pluginType.toString());
            unacceptableReasons.add(message);
            configAcceptable = false;
        }
        return configAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(LastModPluginCfg configuration) {
        this.currentConfig = configuration;
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }
}

