/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.plugins;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opends.messages.Message;
import org.opends.messages.PluginMessages;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.meta.PluginCfgDefn;
import org.opends.server.admin.std.server.PasswordPolicyImportPluginCfg;
import org.opends.server.admin.std.server.PluginCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.ImportTaskListener;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.api.plugin.DirectoryServerPlugin;
import org.opends.server.api.plugin.PluginResult;
import org.opends.server.api.plugin.PluginType;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PasswordPolicy;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.schema.AuthPasswordSyntax;
import org.opends.server.schema.UserPasswordSyntax;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PasswordPolicyImportPlugin
extends DirectoryServerPlugin<PasswordPolicyImportPluginCfg>
implements ConfigurationChangeListener<PasswordPolicyImportPluginCfg>,
ImportTaskListener {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private AttributeType customPolicyAttribute;
    private AttributeType[] authPasswordTypes;
    private AttributeType[] userPasswordTypes;
    private HashMap<DN, PasswordStorageScheme<?>[]> schemesByPolicy;
    private PasswordStorageScheme<?>[] defaultAuthPasswordSchemes;
    private PasswordStorageScheme<?>[] defaultUserPasswordSchemes;

    @Override
    public final void initializePlugin(Set<PluginType> pluginTypes, PasswordPolicyImportPluginCfg configuration) throws ConfigException {
        configuration.addPasswordPolicyImportChangeListener(this);
        this.customPolicyAttribute = DirectoryServer.getAttributeType("ds-pwp-password-policy-dn", true);
        block3: for (PluginType t : pluginTypes) {
            switch (t) {
                case LDIF_IMPORT: {
                    continue block3;
                }
            }
            Message message = PluginMessages.ERR_PLUGIN_PWPIMPORT_INVALID_PLUGIN_TYPE.get(t.toString());
            throw new ConfigException(message);
        }
        PasswordPolicy defaultPolicy = DirectoryServer.getDefaultPasswordPolicy();
        SortedSet<DN> authSchemeDNs = configuration.getDefaultAuthPasswordStorageSchemeDNs();
        if (authSchemeDNs.isEmpty()) {
            if (defaultPolicy.usesAuthPasswordSyntax()) {
                CopyOnWriteArrayList<PasswordStorageScheme<?>> schemeList = defaultPolicy.getDefaultStorageSchemes();
                this.defaultAuthPasswordSchemes = new PasswordStorageScheme[schemeList.size()];
                schemeList.toArray(this.defaultAuthPasswordSchemes);
            } else {
                this.defaultAuthPasswordSchemes = new PasswordStorageScheme[1];
                this.defaultAuthPasswordSchemes[0] = DirectoryServer.getAuthPasswordStorageScheme("SHA1");
                if (this.defaultAuthPasswordSchemes[0] == null) {
                    Message message = PluginMessages.ERR_PLUGIN_PWIMPORT_NO_DEFAULT_AUTH_SCHEMES.get("SHA1");
                    throw new ConfigException(message);
                }
            }
        } else {
            this.defaultAuthPasswordSchemes = new PasswordStorageScheme[authSchemeDNs.size()];
            int i = 0;
            for (DN schemeDN : authSchemeDNs) {
                this.defaultAuthPasswordSchemes[i] = DirectoryServer.getPasswordStorageScheme(schemeDN);
                if (this.defaultAuthPasswordSchemes[i] == null) {
                    Message message = PluginMessages.ERR_PLUGIN_PWIMPORT_NO_SUCH_DEFAULT_AUTH_SCHEME.get(String.valueOf(schemeDN));
                    throw new ConfigException(message);
                }
                if (!this.defaultAuthPasswordSchemes[i].supportsAuthPasswordSyntax()) {
                    Message message = PluginMessages.ERR_PLUGIN_PWIMPORT_INVALID_DEFAULT_AUTH_SCHEME.get(String.valueOf(schemeDN));
                    throw new ConfigException(message);
                }
                ++i;
            }
        }
        SortedSet<DN> userSchemeDNs = configuration.getDefaultUserPasswordStorageSchemeDNs();
        if (userSchemeDNs.isEmpty()) {
            if (!defaultPolicy.usesAuthPasswordSyntax()) {
                CopyOnWriteArrayList<PasswordStorageScheme<?>> schemeList = defaultPolicy.getDefaultStorageSchemes();
                this.defaultUserPasswordSchemes = new PasswordStorageScheme[schemeList.size()];
                schemeList.toArray(this.defaultUserPasswordSchemes);
            } else {
                this.defaultUserPasswordSchemes = new PasswordStorageScheme[1];
                this.defaultUserPasswordSchemes[0] = DirectoryServer.getPasswordStorageScheme(StaticUtils.toLowerCase("SSHA"));
                if (this.defaultUserPasswordSchemes[0] == null) {
                    Message message = PluginMessages.ERR_PLUGIN_PWIMPORT_NO_DEFAULT_USER_SCHEMES.get("SSHA");
                    throw new ConfigException(message);
                }
            }
        } else {
            this.defaultUserPasswordSchemes = new PasswordStorageScheme[userSchemeDNs.size()];
            int i = 0;
            for (DN schemeDN : userSchemeDNs) {
                this.defaultUserPasswordSchemes[i] = DirectoryServer.getPasswordStorageScheme(schemeDN);
                if (this.defaultUserPasswordSchemes[i] == null) {
                    Message message = PluginMessages.ERR_PLUGIN_PWIMPORT_INVALID_DEFAULT_USER_SCHEME.get(String.valueOf(schemeDN));
                    throw new ConfigException(message);
                }
                ++i;
            }
        }
        this.processImportBegin(null, null);
    }

    @Override
    public void processImportBegin(Backend backend, LDIFImportConfig config) {
        HashSet<AttributeType> authPWTypes = new HashSet<AttributeType>();
        HashSet<AttributeType> userPWTypes = new HashSet<AttributeType>();
        for (AttributeType t : DirectoryServer.getAttributeTypes().values()) {
            if (t.getSyntaxOID().equals("1.3.6.1.4.1.4203.1.1.2")) {
                authPWTypes.add(t);
                continue;
            }
            if (!t.getSyntaxOID().equals("1.3.6.1.4.1.26027.1.3.1")) continue;
            userPWTypes.add(t);
        }
        HashMap<DN, PasswordStorageScheme[]> schemeMap = new HashMap<DN, PasswordStorageScheme[]>();
        for (PasswordPolicy p : DirectoryServer.getPasswordPolicies()) {
            CopyOnWriteArrayList<PasswordStorageScheme<?>> schemeList = p.getDefaultStorageSchemes();
            PasswordStorageScheme[] schemeArray = new PasswordStorageScheme[schemeList.size()];
            schemeList.toArray(schemeArray);
            schemeMap.put(p.getConfigEntryDN(), schemeArray);
        }
        AttributeType[] authTypesArray = new AttributeType[authPWTypes.size()];
        AttributeType[] userTypesArray = new AttributeType[userPWTypes.size()];
        authPWTypes.toArray(authTypesArray);
        userPWTypes.toArray(userTypesArray);
        this.schemesByPolicy = schemeMap;
        this.authPasswordTypes = authTypesArray;
        this.userPasswordTypes = userTypesArray;
    }

    @Override
    public void processImportEnd(Backend backend, LDIFImportConfig config, boolean successful) {
    }

    @Override
    public final PluginResult.ImportLDIF doLDIFImport(LDIFImportConfig importConfig, Entry entry) {
        ByteString nv;
        ByteString value;
        AttributeBuilder builder;
        List<Attribute> attrList = entry.getAttribute(this.customPolicyAttribute);
        if (attrList != null) {
            PasswordStorageScheme<?>[] schemes;
            DN policyDN = null;
            PasswordPolicy policy = null;
            for (Attribute a : attrList) {
                Iterator<Object> i$ = a.iterator();
                if (!i$.hasNext()) continue;
                AttributeValue v = i$.next();
                try {
                    policyDN = DN.decode(v.getValue());
                    policy = DirectoryServer.getPasswordPolicy(policyDN);
                    if (policy != null) break;
                    Message message = PluginMessages.WARN_PLUGIN_PWIMPORT_NO_SUCH_POLICY.get(String.valueOf(entry.getDN()), String.valueOf(policyDN));
                    ErrorLogger.logError(message);
                }
                catch (DirectoryException de) {
                    Message message = PluginMessages.WARN_PLUGIN_PWIMPORT_CANNOT_DECODE_POLICY_DN.get(String.valueOf(entry.getDN()), de.getMessageObject());
                    ErrorLogger.logError(message);
                }
                break;
            }
            if (policy != null && (schemes = this.schemesByPolicy.get(policyDN)) != null) {
                attrList = entry.getAttribute(policy.getPasswordAttribute());
                if (attrList == null) {
                    return PluginResult.ImportLDIF.continueEntryProcessing();
                }
                for (Attribute a : attrList) {
                    AttributeBuilder builder2 = new AttributeBuilder(a, true);
                    boolean gotError = false;
                    for (AttributeValue v : a) {
                        ByteString nv2;
                        ByteString value2 = v.getValue();
                        if (policy.usesAuthPasswordSyntax()) {
                            if (!AuthPasswordSyntax.isEncoded(value2)) {
                                try {
                                    for (PasswordStorageScheme<?> s : schemes) {
                                        nv2 = s.encodeAuthPassword(value2);
                                        builder2.add(new AttributeValue(policy.getPasswordAttribute(), nv2));
                                    }
                                    continue;
                                }
                                catch (Exception e) {
                                    if (DebugLogger.debugEnabled()) {
                                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                                    }
                                    Message message = PluginMessages.ERR_PLUGIN_PWPIMPORT_ERROR_ENCODING_PASSWORD.get(policy.getPasswordAttribute().getNameOrOID(), String.valueOf(entry.getDN()), StaticUtils.stackTraceToSingleLineString(e));
                                    ErrorLogger.logError(message);
                                    gotError = true;
                                    break;
                                }
                            }
                            builder2.add(v);
                            continue;
                        }
                        if (!UserPasswordSyntax.isEncoded(value2)) {
                            try {
                                for (PasswordStorageScheme<?> s : schemes) {
                                    nv2 = s.encodePasswordWithScheme(value2);
                                    builder2.add(new AttributeValue(policy.getPasswordAttribute(), nv2));
                                }
                                continue;
                            }
                            catch (Exception e) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                                }
                                Message message = PluginMessages.ERR_PLUGIN_PWPIMPORT_ERROR_ENCODING_PASSWORD.get(policy.getPasswordAttribute().getNameOrOID(), String.valueOf(entry.getDN()), StaticUtils.stackTraceToSingleLineString(e));
                                ErrorLogger.logError(message);
                                gotError = true;
                                break;
                            }
                        }
                        builder2.add(v);
                    }
                    if (gotError) continue;
                    entry.replaceAttribute(builder2.toAttribute());
                }
                return PluginResult.ImportLDIF.continueEntryProcessing();
            }
        }
        for (AttributeType t : this.authPasswordTypes) {
            attrList = entry.getAttribute(t);
            if (attrList == null || attrList.isEmpty()) continue;
            for (Attribute a : attrList) {
                builder = new AttributeBuilder(a, true);
                boolean gotError = false;
                for (AttributeValue v : a) {
                    value = v.getValue();
                    if (!AuthPasswordSyntax.isEncoded(value)) {
                        try {
                            for (PasswordStorageScheme<?> s : this.defaultAuthPasswordSchemes) {
                                nv = s.encodeAuthPassword(value);
                                builder.add(new AttributeValue(t, nv));
                            }
                            continue;
                        }
                        catch (Exception e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            Message message = PluginMessages.ERR_PLUGIN_PWPIMPORT_ERROR_ENCODING_PASSWORD.get(t.getNameOrOID(), String.valueOf(entry.getDN()), StaticUtils.stackTraceToSingleLineString(e));
                            ErrorLogger.logError(message);
                            gotError = true;
                            break;
                        }
                    }
                    builder.add(v);
                }
                if (gotError) continue;
                entry.replaceAttribute(builder.toAttribute());
            }
        }
        for (AttributeType t : this.userPasswordTypes) {
            attrList = entry.getAttribute(t);
            if (attrList == null || attrList.isEmpty()) continue;
            for (Attribute a : attrList) {
                builder = new AttributeBuilder(a, true);
                boolean gotError = false;
                for (AttributeValue v : a) {
                    value = v.getValue();
                    if (!UserPasswordSyntax.isEncoded(value)) {
                        try {
                            for (PasswordStorageScheme<?> s : this.defaultUserPasswordSchemes) {
                                nv = s.encodePasswordWithScheme(value);
                                builder.add(new AttributeValue(t, nv));
                            }
                            continue;
                        }
                        catch (Exception e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            Message message = PluginMessages.ERR_PLUGIN_PWPIMPORT_ERROR_ENCODING_PASSWORD.get(t.getNameOrOID(), String.valueOf(entry.getDN()), StaticUtils.stackTraceToSingleLineString(e));
                            ErrorLogger.logError(message);
                            gotError = true;
                            break;
                        }
                    }
                    builder.add(v);
                }
                if (gotError) continue;
                entry.replaceAttribute(builder.toAttribute());
            }
        }
        return PluginResult.ImportLDIF.continueEntryProcessing();
    }

    @Override
    public boolean isConfigurationAcceptable(PluginCfg configuration, List<Message> unacceptableReasons) {
        PasswordPolicyImportPluginCfg config = (PasswordPolicyImportPluginCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(PasswordPolicyImportPluginCfg configuration, List<Message> unacceptableReasons) {
        PasswordStorageScheme[] defaultAuthSchemes;
        Message message;
        boolean configAcceptable = true;
        block3: for (PluginCfgDefn.PluginType pluginType : configuration.getPluginType()) {
            switch (pluginType) {
                case LDIFIMPORT: {
                    continue block3;
                }
            }
            message = PluginMessages.ERR_PLUGIN_PWPIMPORT_INVALID_PLUGIN_TYPE.get(pluginType.toString());
            unacceptableReasons.add(message);
            configAcceptable = false;
        }
        SortedSet<DN> authSchemeDNs = configuration.getDefaultAuthPasswordStorageSchemeDNs();
        if (authSchemeDNs.isEmpty()) {
            defaultAuthSchemes = new PasswordStorageScheme[]{DirectoryServer.getAuthPasswordStorageScheme("SHA1")};
            if (defaultAuthSchemes[0] == null) {
                message = PluginMessages.ERR_PLUGIN_PWIMPORT_NO_DEFAULT_AUTH_SCHEMES.get("SHA1");
                unacceptableReasons.add(message);
                configAcceptable = false;
            }
        } else {
            defaultAuthSchemes = new PasswordStorageScheme[authSchemeDNs.size()];
            int i = 0;
            for (DN schemeDN : authSchemeDNs) {
                Message message2;
                defaultAuthSchemes[i] = DirectoryServer.getPasswordStorageScheme(schemeDN);
                if (defaultAuthSchemes[i] == null) {
                    message2 = PluginMessages.ERR_PLUGIN_PWIMPORT_NO_SUCH_DEFAULT_AUTH_SCHEME.get(String.valueOf(schemeDN));
                    unacceptableReasons.add(message2);
                    configAcceptable = false;
                } else if (!defaultAuthSchemes[i].supportsAuthPasswordSyntax()) {
                    message2 = PluginMessages.ERR_PLUGIN_PWIMPORT_INVALID_DEFAULT_AUTH_SCHEME.get(String.valueOf(schemeDN));
                    unacceptableReasons.add(message2);
                    configAcceptable = false;
                }
                ++i;
            }
        }
        SortedSet<DN> userSchemeDNs = configuration.getDefaultUserPasswordStorageSchemeDNs();
        if (userSchemeDNs.isEmpty()) {
            PasswordStorageScheme[] defaultUserSchemes = new PasswordStorageScheme[]{DirectoryServer.getPasswordStorageScheme(StaticUtils.toLowerCase("SSHA"))};
            if (defaultUserSchemes[0] == null) {
                Message message3 = PluginMessages.ERR_PLUGIN_PWIMPORT_NO_DEFAULT_USER_SCHEMES.get("SSHA");
                unacceptableReasons.add(message3);
                configAcceptable = false;
            }
        } else {
            PasswordStorageScheme[] defaultUserSchemes = new PasswordStorageScheme[userSchemeDNs.size()];
            int i = 0;
            for (DN schemeDN : userSchemeDNs) {
                defaultUserSchemes[i] = DirectoryServer.getPasswordStorageScheme(schemeDN);
                if (defaultUserSchemes[i] == null) {
                    Message message4 = PluginMessages.ERR_PLUGIN_PWIMPORT_INVALID_DEFAULT_USER_SCHEME.get(String.valueOf(schemeDN));
                    unacceptableReasons.add(message4);
                    configAcceptable = false;
                }
                ++i;
            }
        }
        return configAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(PasswordPolicyImportPluginCfg configuration) {
        PasswordStorageScheme[] defaultUserSchemes;
        PasswordStorageScheme[] defaultAuthSchemes;
        ArrayList<Message> messages;
        boolean adminActionRequired;
        ResultCode resultCode;
        block12: {
            SortedSet<DN> userSchemeDNs;
            block10: {
                block11: {
                    PasswordPolicy defaultPolicy;
                    block9: {
                        SortedSet<DN> authSchemeDNs;
                        block7: {
                            block8: {
                                resultCode = ResultCode.SUCCESS;
                                adminActionRequired = false;
                                messages = new ArrayList<Message>();
                                defaultPolicy = DirectoryServer.getDefaultPasswordPolicy();
                                authSchemeDNs = configuration.getDefaultAuthPasswordStorageSchemeDNs();
                                if (!authSchemeDNs.isEmpty()) break block7;
                                if (!defaultPolicy.usesAuthPasswordSyntax()) break block8;
                                CopyOnWriteArrayList<PasswordStorageScheme<?>> schemeList = defaultPolicy.getDefaultStorageSchemes();
                                defaultAuthSchemes = new PasswordStorageScheme[schemeList.size()];
                                schemeList.toArray(defaultAuthSchemes);
                                break block9;
                            }
                            defaultAuthSchemes = new PasswordStorageScheme[]{DirectoryServer.getAuthPasswordStorageScheme("SHA1")};
                            if (defaultAuthSchemes[0] != null) break block9;
                            resultCode = DirectoryServer.getServerErrorResultCode();
                            messages.add(PluginMessages.ERR_PLUGIN_PWIMPORT_NO_DEFAULT_AUTH_SCHEMES.get("SHA1"));
                            break block9;
                        }
                        defaultAuthSchemes = new PasswordStorageScheme[authSchemeDNs.size()];
                        int i = 0;
                        for (DN schemeDN : authSchemeDNs) {
                            defaultAuthSchemes[i] = DirectoryServer.getPasswordStorageScheme(schemeDN);
                            if (defaultAuthSchemes[i] == null) {
                                resultCode = DirectoryServer.getServerErrorResultCode();
                                messages.add(PluginMessages.ERR_PLUGIN_PWIMPORT_NO_SUCH_DEFAULT_AUTH_SCHEME.get(String.valueOf(schemeDN)));
                            } else if (!defaultAuthSchemes[i].supportsAuthPasswordSyntax()) {
                                resultCode = DirectoryServer.getServerErrorResultCode();
                                messages.add(PluginMessages.ERR_PLUGIN_PWIMPORT_INVALID_DEFAULT_AUTH_SCHEME.get(String.valueOf(schemeDN)));
                            }
                            ++i;
                        }
                    }
                    userSchemeDNs = configuration.getDefaultUserPasswordStorageSchemeDNs();
                    if (!userSchemeDNs.isEmpty()) break block10;
                    if (defaultPolicy.usesAuthPasswordSyntax()) break block11;
                    CopyOnWriteArrayList<PasswordStorageScheme<?>> schemeList = defaultPolicy.getDefaultStorageSchemes();
                    defaultUserSchemes = new PasswordStorageScheme[schemeList.size()];
                    schemeList.toArray(defaultUserSchemes);
                    break block12;
                }
                defaultUserSchemes = new PasswordStorageScheme[]{DirectoryServer.getPasswordStorageScheme(StaticUtils.toLowerCase("SSHA"))};
                if (defaultUserSchemes[0] != null) break block12;
                resultCode = DirectoryServer.getServerErrorResultCode();
                messages.add(PluginMessages.ERR_PLUGIN_PWIMPORT_NO_DEFAULT_USER_SCHEMES.get("SSHA"));
                break block12;
            }
            defaultUserSchemes = new PasswordStorageScheme[userSchemeDNs.size()];
            int i = 0;
            for (DN schemeDN : userSchemeDNs) {
                defaultUserSchemes[i] = DirectoryServer.getPasswordStorageScheme(schemeDN);
                if (defaultUserSchemes[i] == null) {
                    resultCode = DirectoryServer.getServerErrorResultCode();
                    messages.add(PluginMessages.ERR_PLUGIN_PWIMPORT_INVALID_DEFAULT_USER_SCHEME.get(String.valueOf(schemeDN)));
                }
                ++i;
            }
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.defaultAuthPasswordSchemes = defaultAuthSchemes;
            this.defaultUserPasswordSchemes = defaultUserSchemes;
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }
}

