/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.plugins;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.opends.messages.Message;
import org.opends.messages.PluginMessages;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.meta.PluginCfgDefn;
import org.opends.server.admin.std.server.PluginCfg;
import org.opends.server.admin.std.server.UniqueAttributePluginCfg;
import org.opends.server.api.AlertGenerator;
import org.opends.server.api.Backend;
import org.opends.server.api.plugin.DirectoryServerPlugin;
import org.opends.server.api.plugin.PluginResult;
import org.opends.server.api.plugin.PluginType;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.IndexType;
import org.opends.server.types.Modification;
import org.opends.server.types.RDN;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchScope;
import org.opends.server.types.operation.PostSynchronizationAddOperation;
import org.opends.server.types.operation.PostSynchronizationModifyDNOperation;
import org.opends.server.types.operation.PostSynchronizationModifyOperation;
import org.opends.server.types.operation.PreOperationAddOperation;
import org.opends.server.types.operation.PreOperationModifyDNOperation;
import org.opends.server.types.operation.PreOperationModifyOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueAttributePlugin
extends DirectoryServerPlugin<UniqueAttributePluginCfg>
implements ConfigurationChangeListener<UniqueAttributePluginCfg>,
AlertGenerator {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final LinkedHashSet<String> SEARCH_ATTRS = new LinkedHashSet(1);
    private UniqueAttributePluginCfg currentConfiguration;

    @Override
    public final void initializePlugin(Set<PluginType> pluginTypes, UniqueAttributePluginCfg configuration) throws ConfigException {
        configuration.addUniqueAttributeChangeListener(this);
        this.currentConfiguration = configuration;
        DirectoryServer.registerAlertGenerator(this);
        block3: for (PluginType t : pluginTypes) {
            switch (t) {
                case PRE_OPERATION_ADD: 
                case PRE_OPERATION_MODIFY: 
                case PRE_OPERATION_MODIFY_DN: 
                case POST_SYNCHRONIZATION_ADD: 
                case POST_SYNCHRONIZATION_MODIFY: 
                case POST_SYNCHRONIZATION_MODIFY_DN: {
                    continue block3;
                }
            }
            Message message = PluginMessages.ERR_PLUGIN_UNIQUEATTR_INVALID_PLUGIN_TYPE.get(t.toString());
            throw new ConfigException(message);
        }
        Set<DN> cfgBaseDNs = configuration.getBaseDN();
        if (cfgBaseDNs == null || cfgBaseDNs.isEmpty()) {
            cfgBaseDNs = DirectoryServer.getPublicNamingContexts().keySet();
        }
        for (AttributeType t : configuration.getType()) {
            for (DN baseDN : cfgBaseDNs) {
                Backend b = DirectoryServer.getBackend(baseDN);
                if (b == null || b.isIndexed(t, IndexType.EQUALITY)) continue;
                throw new ConfigException(PluginMessages.ERR_PLUGIN_UNIQUEATTR_ATTR_UNINDEXED.get(configuration.dn().toString(), t.getNameOrOID(), b.getBackendID()));
            }
        }
    }

    @Override
    public final void finalizePlugin() {
        this.currentConfiguration.removeUniqueAttributeChangeListener(this);
        DirectoryServer.deregisterAlertGenerator(this);
    }

    @Override
    public final PluginResult.PreOperation doPreOperation(PreOperationAddOperation addOperation) {
        UniqueAttributePluginCfg config = this.currentConfiguration;
        Entry entry = addOperation.getEntryToAdd();
        Set<DN> baseDNs = this.getBaseDNs(config, entry.getDN());
        if (baseDNs == null) {
            return PluginResult.PreOperation.continueOperationProcessing();
        }
        for (AttributeType t : config.getType()) {
            List<Attribute> attrList = entry.getAttribute(t);
            if (attrList == null) continue;
            for (Attribute a : attrList) {
                for (AttributeValue v : a) {
                    try {
                        DN conflictDN = this.getConflictingEntryDN(baseDNs, entry.getDN(), config, v);
                        if (conflictDN == null) continue;
                        Message msg = PluginMessages.ERR_PLUGIN_UNIQUEATTR_ATTR_NOT_UNIQUE.get(t.getNameOrOID(), v.getStringValue(), conflictDN.toString());
                        return PluginResult.PreOperation.stopProcessing(ResultCode.CONSTRAINT_VIOLATION, msg);
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        Message m = PluginMessages.ERR_PLUGIN_UNIQUEATTR_INTERNAL_ERROR.get(de.getResultCode().toString(), de.getMessageObject());
                        return PluginResult.PreOperation.stopProcessing(DirectoryServer.getServerErrorResultCode(), m);
                    }
                }
            }
        }
        return PluginResult.PreOperation.continueOperationProcessing();
    }

    @Override
    public final PluginResult.PreOperation doPreOperation(PreOperationModifyOperation modifyOperation) {
        UniqueAttributePluginCfg config = this.currentConfiguration;
        DN entryDN = modifyOperation.getEntryDN();
        Set<DN> baseDNs = this.getBaseDNs(config, entryDN);
        if (baseDNs == null) {
            return PluginResult.PreOperation.continueOperationProcessing();
        }
        block8: for (Modification m : modifyOperation.getModifications()) {
            Attribute a = m.getAttribute();
            AttributeType t = a.getAttributeType();
            if (!config.getType().contains(t)) continue;
            switch (m.getModificationType()) {
                case ADD: 
                case REPLACE: {
                    for (AttributeValue v : a) {
                        try {
                            DN conflictDN = this.getConflictingEntryDN(baseDNs, entryDN, config, v);
                            if (conflictDN == null) continue;
                            Message msg = PluginMessages.ERR_PLUGIN_UNIQUEATTR_ATTR_NOT_UNIQUE.get(t.getNameOrOID(), v.getStringValue(), conflictDN.toString());
                            return PluginResult.PreOperation.stopProcessing(ResultCode.CONSTRAINT_VIOLATION, msg);
                        }
                        catch (DirectoryException de) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, de);
                            }
                            Message message = PluginMessages.ERR_PLUGIN_UNIQUEATTR_INTERNAL_ERROR.get(de.getResultCode().toString(), de.getMessageObject());
                            return PluginResult.PreOperation.stopProcessing(DirectoryServer.getServerErrorResultCode(), message);
                        }
                    }
                    continue block8;
                }
                case INCREMENT: {
                    List<Attribute> attrList = modifyOperation.getModifiedEntry().getAttribute(t, a.getOptions());
                    if (attrList == null) continue block8;
                    for (Attribute updatedAttr : attrList) {
                        if (!updatedAttr.optionsEqual(a.getOptions())) continue;
                        for (AttributeValue v : updatedAttr) {
                            try {
                                DN conflictDN = this.getConflictingEntryDN(baseDNs, entryDN, config, v);
                                if (conflictDN == null) continue;
                                Message msg = PluginMessages.ERR_PLUGIN_UNIQUEATTR_ATTR_NOT_UNIQUE.get(t.getNameOrOID(), v.getStringValue(), conflictDN.toString());
                                return PluginResult.PreOperation.stopProcessing(ResultCode.CONSTRAINT_VIOLATION, msg);
                            }
                            catch (DirectoryException de) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                }
                                Message message = PluginMessages.ERR_PLUGIN_UNIQUEATTR_INTERNAL_ERROR.get(de.getResultCode().toString(), de.getMessageObject());
                                return PluginResult.PreOperation.stopProcessing(DirectoryServer.getServerErrorResultCode(), message);
                            }
                        }
                    }
                    continue block8;
                }
                default: {
                    continue block8;
                }
            }
        }
        return PluginResult.PreOperation.continueOperationProcessing();
    }

    @Override
    public final PluginResult.PreOperation doPreOperation(PreOperationModifyDNOperation modifyDNOperation) {
        UniqueAttributePluginCfg config = this.currentConfiguration;
        Set<DN> baseDNs = this.getBaseDNs(config, modifyDNOperation.getUpdatedEntry().getDN());
        if (baseDNs == null) {
            return PluginResult.PreOperation.continueOperationProcessing();
        }
        RDN newRDN = modifyDNOperation.getNewRDN();
        for (int i = 0; i < newRDN.getNumValues(); ++i) {
            AttributeType t = newRDN.getAttributeType(i);
            if (!config.getType().contains(t)) continue;
            try {
                AttributeValue v = newRDN.getAttributeValue(i);
                DN conflictDN = this.getConflictingEntryDN(baseDNs, modifyDNOperation.getEntryDN(), config, v);
                if (conflictDN == null) continue;
                Message msg = PluginMessages.ERR_PLUGIN_UNIQUEATTR_ATTR_NOT_UNIQUE.get(t.getNameOrOID(), v.getStringValue(), conflictDN.toString());
                return PluginResult.PreOperation.stopProcessing(ResultCode.CONSTRAINT_VIOLATION, msg);
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                Message m = PluginMessages.ERR_PLUGIN_UNIQUEATTR_INTERNAL_ERROR.get(de.getResultCode().toString(), de.getMessageObject());
                return PluginResult.PreOperation.stopProcessing(DirectoryServer.getServerErrorResultCode(), m);
            }
        }
        return PluginResult.PreOperation.continueOperationProcessing();
    }

    @Override
    public final void doPostSynchronization(PostSynchronizationAddOperation addOperation) {
        UniqueAttributePluginCfg config = this.currentConfiguration;
        Entry entry = addOperation.getEntryToAdd();
        Set<DN> baseDNs = this.getBaseDNs(config, entry.getDN());
        if (baseDNs == null) {
            return;
        }
        for (AttributeType t : config.getType()) {
            List<Attribute> attrList = entry.getAttribute(t);
            if (attrList == null) continue;
            for (Attribute a : attrList) {
                for (AttributeValue v : a) {
                    Message m;
                    try {
                        DN conflictDN = this.getConflictingEntryDN(baseDNs, entry.getDN(), config, v);
                        if (conflictDN == null) continue;
                        m = PluginMessages.ERR_PLUGIN_UNIQUEATTR_SYNC_NOT_UNIQUE.get(t.getNameOrOID(), addOperation.getConnectionID(), addOperation.getOperationID(), v.getStringValue(), entry.getDN().toString(), conflictDN.toString());
                        DirectoryServer.sendAlertNotification(this, "org.opends.server.UniqueAttributeSynchronizationConflict", m);
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        m = PluginMessages.ERR_PLUGIN_UNIQUEATTR_INTERNAL_ERROR_SYNC.get(addOperation.getConnectionID(), addOperation.getOperationID(), entry.getDN().toString(), de.getResultCode().toString(), de.getMessageObject());
                        DirectoryServer.sendAlertNotification(this, "org.opends.server.UniqueAttributeSynchronizationError", m);
                    }
                }
            }
        }
    }

    @Override
    public final void doPostSynchronization(PostSynchronizationModifyOperation modifyOperation) {
        UniqueAttributePluginCfg config = this.currentConfiguration;
        DN entryDN = modifyOperation.getEntryDN();
        Set<DN> baseDNs = this.getBaseDNs(config, entryDN);
        if (baseDNs == null) {
            return;
        }
        block8: for (Modification m : modifyOperation.getModifications()) {
            Attribute a = m.getAttribute();
            AttributeType t = a.getAttributeType();
            if (!config.getType().contains(t)) continue;
            switch (m.getModificationType()) {
                case ADD: 
                case REPLACE: {
                    for (AttributeValue v : a) {
                        Message message;
                        try {
                            DN conflictDN = this.getConflictingEntryDN(baseDNs, entryDN, config, v);
                            if (conflictDN == null) continue;
                            message = PluginMessages.ERR_PLUGIN_UNIQUEATTR_SYNC_NOT_UNIQUE.get(t.getNameOrOID(), modifyOperation.getConnectionID(), modifyOperation.getOperationID(), v.getStringValue(), entryDN.toString(), conflictDN.toString());
                            DirectoryServer.sendAlertNotification(this, "org.opends.server.UniqueAttributeSynchronizationConflict", message);
                        }
                        catch (DirectoryException de) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, de);
                            }
                            message = PluginMessages.ERR_PLUGIN_UNIQUEATTR_INTERNAL_ERROR_SYNC.get(modifyOperation.getConnectionID(), modifyOperation.getOperationID(), entryDN.toString(), de.getResultCode().toString(), de.getMessageObject());
                            DirectoryServer.sendAlertNotification(this, "org.opends.server.UniqueAttributeSynchronizationError", message);
                        }
                    }
                    continue block8;
                }
                case INCREMENT: {
                    List<Attribute> attrList = modifyOperation.getModifiedEntry().getAttribute(t, a.getOptions());
                    if (attrList == null) continue block8;
                    for (Attribute updatedAttr : attrList) {
                        if (!updatedAttr.optionsEqual(a.getOptions())) continue;
                        for (AttributeValue v : updatedAttr) {
                            Message message;
                            try {
                                DN conflictDN = this.getConflictingEntryDN(baseDNs, entryDN, config, v);
                                if (conflictDN == null) continue;
                                message = PluginMessages.ERR_PLUGIN_UNIQUEATTR_SYNC_NOT_UNIQUE.get(t.getNameOrOID(), modifyOperation.getConnectionID(), modifyOperation.getOperationID(), v.getStringValue(), entryDN.toString(), conflictDN.toString());
                                DirectoryServer.sendAlertNotification(this, "org.opends.server.UniqueAttributeSynchronizationConflict", message);
                            }
                            catch (DirectoryException de) {
                                if (DebugLogger.debugEnabled()) {
                                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                }
                                message = PluginMessages.ERR_PLUGIN_UNIQUEATTR_INTERNAL_ERROR_SYNC.get(modifyOperation.getConnectionID(), modifyOperation.getOperationID(), entryDN.toString(), de.getResultCode().toString(), de.getMessageObject());
                                DirectoryServer.sendAlertNotification(this, "org.opends.server.UniqueAttributeSynchronizationError", message);
                            }
                        }
                    }
                    continue block8;
                }
                default: {
                    continue block8;
                }
            }
        }
    }

    @Override
    public final void doPostSynchronization(PostSynchronizationModifyDNOperation modifyDNOperation) {
        UniqueAttributePluginCfg config = this.currentConfiguration;
        Set<DN> baseDNs = this.getBaseDNs(config, modifyDNOperation.getUpdatedEntry().getDN());
        if (baseDNs == null) {
            return;
        }
        RDN newRDN = modifyDNOperation.getNewRDN();
        for (int i = 0; i < newRDN.getNumValues(); ++i) {
            AttributeType t = newRDN.getAttributeType(i);
            if (!config.getType().contains(t)) continue;
            try {
                AttributeValue v = newRDN.getAttributeValue(i);
                DN conflictDN = this.getConflictingEntryDN(baseDNs, modifyDNOperation.getEntryDN(), config, v);
                if (conflictDN == null) continue;
                Message m = PluginMessages.ERR_PLUGIN_UNIQUEATTR_SYNC_NOT_UNIQUE.get(t.getNameOrOID(), modifyDNOperation.getConnectionID(), modifyDNOperation.getOperationID(), v.getStringValue(), modifyDNOperation.getUpdatedEntry().getDN().toString(), conflictDN.toString());
                DirectoryServer.sendAlertNotification(this, "org.opends.server.UniqueAttributeSynchronizationConflict", m);
                continue;
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                Message m = PluginMessages.ERR_PLUGIN_UNIQUEATTR_INTERNAL_ERROR_SYNC.get(modifyDNOperation.getConnectionID(), modifyDNOperation.getOperationID(), modifyDNOperation.getUpdatedEntry().getDN().toString(), de.getResultCode().toString(), de.getMessageObject());
                DirectoryServer.sendAlertNotification(this, "org.opends.server.UniqueAttributeSynchronizationError", m);
            }
        }
    }

    private Set<DN> getBaseDNs(UniqueAttributePluginCfg config, DN entryDN) {
        Set<DN> baseDNs = config.getBaseDN();
        if (baseDNs == null || baseDNs.isEmpty()) {
            baseDNs = DirectoryServer.getPublicNamingContexts().keySet();
        }
        for (DN baseDN : baseDNs) {
            if (!entryDN.isDescendantOf(baseDN)) continue;
            return baseDNs;
        }
        return null;
    }

    private DN getConflictingEntryDN(Set<DN> baseDNs, DN targetDN, UniqueAttributePluginCfg config, AttributeValue value) throws DirectoryException {
        SearchFilter filter;
        SortedSet<AttributeType> attrTypes = config.getType();
        if (attrTypes.size() == 1) {
            filter = SearchFilter.createEqualityFilter((AttributeType)attrTypes.iterator().next(), value);
        } else {
            ArrayList<SearchFilter> equalityFilters = new ArrayList<SearchFilter>(attrTypes.size());
            for (AttributeType t : attrTypes) {
                equalityFilters.add(SearchFilter.createEqualityFilter(t, value));
            }
            filter = SearchFilter.createORFilter(equalityFilters);
        }
        InternalClientConnection conn = InternalClientConnection.getRootConnection();
        block4: for (DN baseDN : baseDNs) {
            InternalSearchOperation searchOperation = conn.processSearch(baseDN, SearchScope.WHOLE_SUBTREE, DereferencePolicy.NEVER_DEREF_ALIASES, 2, 0, false, filter, SEARCH_ATTRS);
            for (SearchResultEntry e : searchOperation.getSearchEntries()) {
                if (e.getDN().equals(targetDN)) continue;
                return e.getDN();
            }
            switch (searchOperation.getResultCode()) {
                case SUCCESS: 
                case NO_SUCH_OBJECT: {
                    continue block4;
                }
            }
            throw new DirectoryException(searchOperation.getResultCode(), searchOperation.getErrorMessage().toMessage());
        }
        return null;
    }

    @Override
    public boolean isConfigurationAcceptable(PluginCfg configuration, List<Message> unacceptableReasons) {
        UniqueAttributePluginCfg cfg = (UniqueAttributePluginCfg)configuration;
        return this.isConfigurationChangeAcceptable(cfg, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(UniqueAttributePluginCfg configuration, List<Message> unacceptableReasons) {
        boolean configAcceptable = true;
        block3: for (PluginCfgDefn.PluginType pluginType : configuration.getPluginType()) {
            switch (pluginType) {
                case PREOPERATIONADD: 
                case PREOPERATIONMODIFY: 
                case PREOPERATIONMODIFYDN: 
                case POSTSYNCHRONIZATIONADD: 
                case POSTSYNCHRONIZATIONMODIFY: 
                case POSTSYNCHRONIZATIONMODIFYDN: {
                    continue block3;
                }
            }
            Message message = PluginMessages.ERR_PLUGIN_UNIQUEATTR_INVALID_PLUGIN_TYPE.get(pluginType.toString());
            unacceptableReasons.add(message);
            configAcceptable = false;
        }
        Set<DN> cfgBaseDNs = configuration.getBaseDN();
        if (cfgBaseDNs == null || cfgBaseDNs.isEmpty()) {
            cfgBaseDNs = DirectoryServer.getPublicNamingContexts().keySet();
        }
        for (AttributeType t : configuration.getType()) {
            for (DN baseDN : cfgBaseDNs) {
                Backend b = DirectoryServer.getBackend(baseDN);
                if (b == null || b.isIndexed(t, IndexType.EQUALITY)) continue;
                unacceptableReasons.add(PluginMessages.ERR_PLUGIN_UNIQUEATTR_ATTR_UNINDEXED.get(configuration.dn().toString(), t.getNameOrOID(), b.getBackendID()));
                configAcceptable = false;
            }
        }
        return configAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(UniqueAttributePluginCfg newConfiguration) {
        this.currentConfiguration = newConfiguration;
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }

    @Override
    public DN getComponentEntryDN() {
        return this.currentConfiguration.dn();
    }

    @Override
    public String getClassName() {
        return UniqueAttributePlugin.class.getName();
    }

    @Override
    public LinkedHashMap<String, String> getAlerts() {
        LinkedHashMap<String, String> alerts = new LinkedHashMap<String, String>(2);
        alerts.put("org.opends.server.UniqueAttributeSynchronizationConflict", "This alert type will be used to provide notification that a unique attribute conflict has been detected during synchronization processing.");
        alerts.put("org.opends.server.UniqueAttributeSynchronizationError", "This alert type will be used to provide notification that an error occurred while attempting to perform unique attribute conflict detection during synchronization processing.");
        return alerts;
    }

    static {
        SEARCH_ATTRS.add("1.1");
    }
}

