/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.internal;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConnectionHandler;
import org.opends.server.api.ConnectionSecurityProvider;
import org.opends.server.core.AddOperation;
import org.opends.server.core.AddOperationBasis;
import org.opends.server.core.BindOperation;
import org.opends.server.core.BindOperationBasis;
import org.opends.server.core.CompareOperation;
import org.opends.server.core.CompareOperationBasis;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DeleteOperationBasis;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.core.ExtendedOperationBasis;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyDNOperationBasis;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.ModifyOperationBasis;
import org.opends.server.core.SearchOperation;
import org.opends.server.core.networkgroups.NetworkGroup;
import org.opends.server.extensions.InternalConnectionSecurityProvider;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.internal.InternalConnectionHandler;
import org.opends.server.protocols.internal.InternalSearchListener;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.types.AbstractOperation;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Attributes;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.ByteString;
import org.opends.server.types.CancelRequest;
import org.opends.server.types.CancelResult;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.Entry;
import org.opends.server.types.IntermediateResponse;
import org.opends.server.types.LDAPException;
import org.opends.server.types.Modification;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.Operation;
import org.opends.server.types.Privilege;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.RDN;
import org.opends.server.types.RawAttribute;
import org.opends.server.types.RawFilter;
import org.opends.server.types.RawModification;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchResultReference;
import org.opends.server.types.SearchScope;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.AddChangeRecordEntry;
import org.opends.server.util.DeleteChangeRecordEntry;
import org.opends.server.util.ModifyChangeRecordEntry;
import org.opends.server.util.ModifyDNChangeRecordEntry;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class InternalClientConnection
extends ClientConnection {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public static final String PROTOCOL_VERSION = "3";
    private static AtomicInteger nextMessageID = new AtomicInteger(1);
    private static AtomicLong nextConnectionID = new AtomicLong(-1L);
    private static AtomicLong nextOperationID = new AtomicLong(0L);
    private ConnectionSecurityProvider securityProvider;
    private static InternalClientConnection rootConnection;
    private AuthenticationInfo authenticationInfo;
    private LinkedList<Operation> operationList;
    private long connectionID;

    private InternalClientConnection() {
        block6: {
            this.setNetworkGroup(NetworkGroup.getInternalNetworkGroup());
            String commonName = "Internal Client";
            String shortDNString = "cn=" + commonName;
            String fullDNString = shortDNString + ",cn=Root DNs,cn=config";
            try {
                LinkedHashMap<ObjectClass, String> objectClasses = new LinkedHashMap<ObjectClass, String>();
                ObjectClass topOC = DirectoryServer.getTopObjectClass();
                ObjectClass personOC = DirectoryServer.getObjectClass("person", true);
                ObjectClass rootOC = DirectoryServer.getObjectClass("ds-cfg-root-dn-user", true);
                objectClasses.put(topOC, topOC.getPrimaryName());
                objectClasses.put(personOC, personOC.getPrimaryName());
                objectClasses.put(rootOC, rootOC.getPrimaryName());
                LinkedHashMap<AttributeType, List<Attribute>> userAttrs = new LinkedHashMap<AttributeType, List<Attribute>>();
                AttributeType cnAT = DirectoryServer.getAttributeType("cn", true);
                AttributeType snAT = DirectoryServer.getAttributeType("sn", true);
                AttributeType altDNAT = DirectoryServer.getAttributeType("ds-cfg-alternate-bind-dn", true);
                LinkedList<Attribute> attrList = new LinkedList<Attribute>();
                attrList.add(Attributes.create("cn", commonName));
                userAttrs.put(cnAT, attrList);
                attrList = new LinkedList();
                attrList.add(Attributes.create("sn", commonName));
                userAttrs.put(snAT, attrList);
                attrList = new LinkedList();
                attrList.add(Attributes.create("ds-cfg-alternate-bind-dn", shortDNString));
                userAttrs.put(altDNAT, attrList);
                LinkedHashMap<AttributeType, List<Attribute>> operationalAttrs = new LinkedHashMap<AttributeType, List<Attribute>>();
                AttributeType privType = DirectoryServer.getAttributeType("ds-privilege-name", true);
                AttributeBuilder builder = new AttributeBuilder(privType);
                for (Privilege p : Privilege.getDefaultRootPrivileges()) {
                    builder.add(new AttributeValue(privType, p.getName()));
                }
                attrList = new LinkedList();
                attrList.add(builder.toAttribute());
                operationalAttrs.put(privType, attrList);
                DN internalUserDN = DN.decode(fullDNString);
                Entry internalUserEntry = new Entry(internalUserDN, objectClasses, userAttrs, operationalAttrs);
                this.authenticationInfo = new AuthenticationInfo(internalUserEntry, true);
                super.setAuthenticationInfo(this.authenticationInfo);
                super.setSizeLimit(0);
                super.setTimeLimit(0);
                super.setIdleTimeLimit(0L);
                super.setLookthroughLimit(0);
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                ErrorLogger.logError(ProtocolMessages.ERR_INTERNAL_CANNOT_DECODE_DN.get(fullDNString, StaticUtils.getExceptionMessage(de)));
            }
            this.connectionID = nextConnectionID.getAndDecrement();
            this.operationList = new LinkedList();
            try {
                this.securityProvider = new InternalConnectionSecurityProvider();
                this.securityProvider.initializeConnectionSecurityProvider(null);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block6;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    public InternalClientConnection(AuthenticationInfo authInfo) {
        block2: {
            this.setNetworkGroup(NetworkGroup.getInternalNetworkGroup());
            this.authenticationInfo = authInfo;
            super.setAuthenticationInfo(authInfo);
            super.setSizeLimit(0);
            super.setTimeLimit(0);
            super.setIdleTimeLimit(0L);
            super.setLookthroughLimit(0);
            this.connectionID = nextConnectionID.getAndDecrement();
            this.operationList = new LinkedList();
            try {
                this.securityProvider = new InternalConnectionSecurityProvider();
                this.securityProvider.initializeConnectionSecurityProvider(null);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block2;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    public InternalClientConnection(DN userDN) throws DirectoryException {
        this(InternalClientConnection.getAuthInfoForDN(userDN));
    }

    private static AuthenticationInfo getAuthInfoForDN(DN userDN) throws DirectoryException {
        Entry userEntry;
        if (userDN == null || userDN.isNullDN()) {
            return new AuthenticationInfo();
        }
        DN rootUserDN = DirectoryServer.getActualRootBindDN(userDN);
        if (rootUserDN != null) {
            userDN = rootUserDN;
        }
        if ((userEntry = DirectoryServer.getEntry(userDN)) == null) {
            Message m = ProtocolMessages.ERR_INTERNALCONN_NO_SUCH_USER.get(String.valueOf(userDN));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, m);
        }
        boolean isRoot = DirectoryServer.isRootDN(userDN);
        return new AuthenticationInfo(userEntry, isRoot);
    }

    public static InternalClientConnection getRootConnection() {
        if (rootConnection == null) {
            rootConnection = new InternalClientConnection();
        }
        return rootConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long nextOperationID() {
        long opID = nextOperationID.getAndIncrement();
        if (opID < 0L) {
            AtomicLong atomicLong = nextOperationID;
            synchronized (atomicLong) {
                if (nextOperationID.get() < 0L) {
                    nextOperationID.set(1L);
                    return 0L;
                }
                return nextOperationID.getAndIncrement();
            }
        }
        return opID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int nextMessageID() {
        int msgID = nextMessageID.getAndIncrement();
        if (msgID < 0) {
            AtomicInteger atomicInteger = nextMessageID;
            synchronized (atomicInteger) {
                if (nextMessageID.get() < 0) {
                    nextMessageID.set(2);
                    return 1;
                }
                return nextMessageID.getAndIncrement();
            }
        }
        return msgID;
    }

    @Override
    public long getConnectionID() {
        return this.connectionID;
    }

    @Override
    @PublicAPI(stability=StabilityLevel.PRIVATE, mayInstantiate=false, mayExtend=false, mayInvoke=false)
    public ConnectionHandler<?> getConnectionHandler() {
        return InternalConnectionHandler.getInstance();
    }

    @Override
    public String getProtocol() {
        return "internal";
    }

    @Override
    public String getClientAddress() {
        return "internal";
    }

    @Override
    public int getClientPort() {
        return -1;
    }

    @Override
    public String getServerAddress() {
        return "internal";
    }

    @Override
    public int getServerPort() {
        return -1;
    }

    @Override
    public InetAddress getRemoteAddress() {
        return null;
    }

    @Override
    public InetAddress getLocalAddress() {
        return null;
    }

    @Override
    public void setSizeLimit(int sizeLimit) {
    }

    @Override
    public void setLookthroughLimit(int lookthroughLimit) {
    }

    @Override
    public void setIdleTimeLimit(long idleTimeLimit) {
    }

    @Override
    public void setTimeLimit(int timeLimit) {
    }

    @Override
    public boolean isSecure() {
        return this.securityProvider.isSecure();
    }

    @Override
    public ConnectionSecurityProvider getConnectionSecurityProvider() {
        return this.securityProvider;
    }

    @Override
    @PublicAPI(stability=StabilityLevel.PRIVATE, mayInstantiate=false, mayExtend=false, mayInvoke=false)
    public void setConnectionSecurityProvider(ConnectionSecurityProvider securityProvider) {
        this.securityProvider = securityProvider;
    }

    @Override
    public String getSecurityMechanism() {
        return this.securityProvider.getSecurityMechanismName();
    }

    @Override
    @PublicAPI(stability=StabilityLevel.PRIVATE, mayInstantiate=false, mayExtend=false, mayInvoke=false)
    public boolean processDataRead(ByteBuffer buffer) {
        return false;
    }

    @Override
    @PublicAPI(stability=StabilityLevel.PRIVATE, mayInstantiate=false, mayExtend=false, mayInvoke=false)
    public void sendResponse(Operation operation) {
    }

    @Override
    public AuthenticationInfo getAuthenticationInfo() {
        return this.authenticationInfo;
    }

    @Override
    @PublicAPI(stability=StabilityLevel.PRIVATE, mayInstantiate=false, mayExtend=false, mayInvoke=false)
    public void setAuthenticationInfo(AuthenticationInfo authenticationInfo) {
    }

    @Override
    @PublicAPI(stability=StabilityLevel.PRIVATE, mayInstantiate=false, mayExtend=false, mayInvoke=false)
    public void setUnauthenticated() {
    }

    public AddOperation processAdd(String rawEntryDN, List<RawAttribute> rawAttributes) {
        return this.processAdd(new ASN1OctetString(rawEntryDN), rawAttributes, null);
    }

    public AddOperation processAdd(ByteString rawEntryDN, List<RawAttribute> rawAttributes) {
        return this.processAdd(rawEntryDN, rawAttributes, null);
    }

    public AddOperation processAdd(ByteString rawEntryDN, List<RawAttribute> rawAttributes, List<Control> controls) {
        if (controls == null) {
            controls = new ArrayList<Control>(0);
        }
        AddOperationBasis addOperation = new AddOperationBasis(this, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), controls, rawEntryDN, rawAttributes);
        addOperation.setInternalOperation(true);
        addOperation.run();
        return addOperation;
    }

    public AddOperation processAdd(DN entryDN, Map<ObjectClass, String> objectClasses, Map<AttributeType, List<Attribute>> userAttributes, Map<AttributeType, List<Attribute>> operationalAttributes) {
        return this.processAdd(entryDN, objectClasses, userAttributes, operationalAttributes, null);
    }

    public AddOperation processAdd(DN entryDN, Map<ObjectClass, String> objectClasses, Map<AttributeType, List<Attribute>> userAttributes, Map<AttributeType, List<Attribute>> operationalAttributes, List<Control> controls) {
        if (controls == null) {
            controls = new ArrayList<Control>(0);
        }
        AddOperationBasis addOperation = new AddOperationBasis(this, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), controls, entryDN, objectClasses, userAttributes, operationalAttributes);
        addOperation.setInternalOperation(true);
        addOperation.run();
        return addOperation;
    }

    public AddOperation processAdd(Entry entry) {
        return this.processAdd(entry, null);
    }

    public AddOperation processAdd(Entry entry, List<Control> controls) {
        if (controls == null) {
            controls = new ArrayList<Control>(0);
        }
        return this.processAdd(entry.getDN(), entry.getObjectClasses(), entry.getUserAttributes(), entry.getOperationalAttributes());
    }

    public AddOperation processAdd(AddChangeRecordEntry addRecord) {
        LinkedHashMap<ObjectClass, String> objectClasses = new LinkedHashMap<ObjectClass, String>();
        LinkedHashMap<AttributeType, List<Attribute>> userAttrs = new LinkedHashMap<AttributeType, List<Attribute>>();
        LinkedHashMap<AttributeType, List<Attribute>> opAttrs = new LinkedHashMap<AttributeType, List<Attribute>>();
        Entry e = new Entry(addRecord.getDN(), objectClasses, userAttrs, opAttrs);
        ArrayList<AttributeValue> duplicateValues = new ArrayList<AttributeValue>();
        for (Attribute a : addRecord.getAttributes()) {
            if (a.getAttributeType().isObjectClassType()) {
                for (AttributeValue v : a) {
                    String ocName = v.getStringValue();
                    String lowerName = StaticUtils.toLowerCase(ocName);
                    ObjectClass oc = DirectoryServer.getObjectClass(lowerName, true);
                    objectClasses.put(oc, ocName);
                }
                continue;
            }
            e.addAttribute(a, duplicateValues);
        }
        return this.processAdd(addRecord.getDN(), objectClasses, userAttrs, opAttrs);
    }

    public BindOperation processSimpleBind(String rawBindDN, String password) {
        return this.processSimpleBind(new ASN1OctetString(rawBindDN), (ByteString)new ASN1OctetString(password), null);
    }

    public BindOperation processSimpleBind(String rawBindDN, String password, List<Control> controls) {
        return this.processSimpleBind(new ASN1OctetString(rawBindDN), (ByteString)new ASN1OctetString(password), controls);
    }

    public BindOperation processSimpleBind(ByteString rawBindDN, ByteString password) {
        return this.processSimpleBind(rawBindDN, password, null);
    }

    public BindOperation processSimpleBind(ByteString rawBindDN, ByteString password, List<Control> controls) {
        if (controls == null) {
            controls = new ArrayList<Control>(0);
        }
        BindOperationBasis bindOperation = new BindOperationBasis((ClientConnection)this, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), controls, PROTOCOL_VERSION, rawBindDN, password);
        bindOperation.setInternalOperation(true);
        bindOperation.run();
        return bindOperation;
    }

    public BindOperation processSimpleBind(DN bindDN, ByteString password) {
        return this.processSimpleBind(bindDN, password, null);
    }

    public BindOperation processSimpleBind(DN bindDN, ByteString password, List<Control> controls) {
        if (controls == null) {
            controls = new ArrayList<Control>(0);
        }
        BindOperationBasis bindOperation = new BindOperationBasis((ClientConnection)this, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), controls, PROTOCOL_VERSION, bindDN, password);
        bindOperation.setInternalOperation(true);
        bindOperation.run();
        return bindOperation;
    }

    public BindOperation processSASLBind(ByteString rawBindDN, String saslMechanism, ASN1OctetString saslCredentials) {
        return this.processSASLBind(rawBindDN, saslMechanism, saslCredentials, null);
    }

    public BindOperation processSASLBind(ByteString rawBindDN, String saslMechanism, ASN1OctetString saslCredentials, List<Control> controls) {
        if (controls == null) {
            controls = new ArrayList<Control>(0);
        }
        BindOperationBasis bindOperation = new BindOperationBasis((ClientConnection)this, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), controls, PROTOCOL_VERSION, rawBindDN, saslMechanism, saslCredentials);
        bindOperation.setInternalOperation(true);
        bindOperation.run();
        return bindOperation;
    }

    public BindOperation processSASLBind(DN bindDN, String saslMechanism, ASN1OctetString saslCredentials) {
        return this.processSASLBind(bindDN, saslMechanism, saslCredentials, null);
    }

    public BindOperation processSASLBind(DN bindDN, String saslMechanism, ASN1OctetString saslCredentials, List<Control> controls) {
        if (controls == null) {
            controls = new ArrayList<Control>(0);
        }
        BindOperationBasis bindOperation = new BindOperationBasis((ClientConnection)this, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), controls, PROTOCOL_VERSION, bindDN, saslMechanism, saslCredentials);
        bindOperation.setInternalOperation(true);
        bindOperation.run();
        return bindOperation;
    }

    public CompareOperation processCompare(String rawEntryDN, String attributeType, String assertionValue) {
        return this.processCompare(new ASN1OctetString(rawEntryDN), attributeType, (ByteString)new ASN1OctetString(assertionValue), null);
    }

    public CompareOperation processCompare(String rawEntryDN, String attributeType, String assertionValue, List<Control> controls) {
        return this.processCompare(new ASN1OctetString(rawEntryDN), attributeType, (ByteString)new ASN1OctetString(assertionValue), controls);
    }

    public CompareOperation processCompare(ByteString rawEntryDN, String attributeType, ByteString assertionValue) {
        return this.processCompare(rawEntryDN, attributeType, assertionValue, null);
    }

    public CompareOperation processCompare(ByteString rawEntryDN, String attributeType, ByteString assertionValue, List<Control> controls) {
        if (controls == null) {
            controls = new ArrayList<Control>(0);
        }
        CompareOperationBasis compareOperation = new CompareOperationBasis((ClientConnection)this, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), controls, rawEntryDN, attributeType, assertionValue);
        compareOperation.setInternalOperation(true);
        compareOperation.run();
        return compareOperation;
    }

    public CompareOperation processCompare(DN entryDN, AttributeType attributeType, ByteString assertionValue) {
        return this.processCompare(entryDN, attributeType, assertionValue, null);
    }

    public CompareOperation processCompare(DN entryDN, AttributeType attributeType, ByteString assertionValue, List<Control> controls) {
        if (controls == null) {
            controls = new ArrayList<Control>(0);
        }
        CompareOperationBasis compareOperation = new CompareOperationBasis((ClientConnection)this, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), controls, entryDN, attributeType, assertionValue);
        compareOperation.setInternalOperation(true);
        compareOperation.run();
        return compareOperation;
    }

    public DeleteOperation processDelete(String rawEntryDN) {
        return this.processDelete(new ASN1OctetString(rawEntryDN), null);
    }

    public DeleteOperation processDelete(String rawEntryDN, List<Control> controls) {
        return this.processDelete(new ASN1OctetString(rawEntryDN), controls);
    }

    public DeleteOperation processDelete(ByteString rawEntryDN) {
        return this.processDelete(rawEntryDN, null);
    }

    public DeleteOperation processDelete(ByteString rawEntryDN, List<Control> controls) {
        if (controls == null) {
            controls = new ArrayList<Control>(0);
        }
        DeleteOperationBasis deleteOperation = new DeleteOperationBasis((ClientConnection)this, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), controls, rawEntryDN);
        deleteOperation.setInternalOperation(true);
        deleteOperation.run();
        return deleteOperation;
    }

    public DeleteOperation processDelete(DN entryDN) {
        return this.processDelete(entryDN, null);
    }

    public DeleteOperation processDelete(DN entryDN, List<Control> controls) {
        if (controls == null) {
            controls = new ArrayList<Control>(0);
        }
        DeleteOperationBasis deleteOperation = new DeleteOperationBasis((ClientConnection)this, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), controls, entryDN);
        deleteOperation.setInternalOperation(true);
        deleteOperation.run();
        return deleteOperation;
    }

    public DeleteOperation processDelete(DeleteChangeRecordEntry deleteRecord) {
        return this.processDelete(deleteRecord.getDN());
    }

    public ExtendedOperation processExtendedOperation(String requestOID, ASN1OctetString requestValue) {
        return this.processExtendedOperation(requestOID, requestValue, null);
    }

    public ExtendedOperation processExtendedOperation(String requestOID, ASN1OctetString requestValue, List<Control> controls) {
        if (controls == null) {
            controls = new ArrayList<Control>(0);
        }
        ExtendedOperationBasis extendedOperation = new ExtendedOperationBasis(this, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), controls, requestOID, requestValue);
        extendedOperation.setInternalOperation(true);
        extendedOperation.run();
        return extendedOperation;
    }

    public ModifyOperation processModify(String rawEntryDN, List<RawModification> rawModifications) {
        return this.processModify(new ASN1OctetString(rawEntryDN), rawModifications, null);
    }

    public ModifyOperation processModify(String rawEntryDN, List<RawModification> rawModifications, List<Control> controls) {
        return this.processModify(new ASN1OctetString(rawEntryDN), rawModifications, controls);
    }

    public ModifyOperation processModify(ByteString rawEntryDN, List<RawModification> rawModifications) {
        return this.processModify(rawEntryDN, rawModifications, null);
    }

    public ModifyOperation processModify(ByteString rawEntryDN, List<RawModification> rawModifications, List<Control> controls) {
        if (controls == null) {
            controls = new ArrayList<Control>(0);
        }
        ModifyOperationBasis modifyOperation = new ModifyOperationBasis((ClientConnection)this, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), controls, rawEntryDN, rawModifications);
        modifyOperation.setInternalOperation(true);
        modifyOperation.run();
        return modifyOperation;
    }

    public ModifyOperation processModify(DN entryDN, List<Modification> modifications) {
        return this.processModify(entryDN, modifications, null);
    }

    public ModifyOperation processModify(DN entryDN, List<Modification> modifications, List<Control> controls) {
        if (controls == null) {
            controls = new ArrayList<Control>(0);
        }
        ModifyOperationBasis modifyOperation = new ModifyOperationBasis((ClientConnection)this, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), controls, entryDN, modifications);
        modifyOperation.setInternalOperation(true);
        modifyOperation.run();
        return modifyOperation;
    }

    public ModifyOperation processModify(ModifyChangeRecordEntry modifyRecord) {
        return this.processModify(modifyRecord.getDN().toString(), modifyRecord.getModifications());
    }

    public ModifyDNOperation processModifyDN(String rawEntryDN, String rawNewRDN, boolean deleteOldRDN) {
        return this.processModifyDN(new ASN1OctetString(rawEntryDN), new ASN1OctetString(rawNewRDN), deleteOldRDN, null, null);
    }

    public ModifyDNOperation processModifyDN(String rawEntryDN, String rawNewRDN, boolean deleteOldRDN, List<Control> controls) {
        return this.processModifyDN(new ASN1OctetString(rawEntryDN), new ASN1OctetString(rawNewRDN), deleteOldRDN, null, controls);
    }

    public ModifyDNOperation processModifyDN(ByteString rawEntryDN, ByteString rawNewRDN, boolean deleteOldRDN) {
        return this.processModifyDN(rawEntryDN, rawNewRDN, deleteOldRDN, null, null);
    }

    public ModifyDNOperation processModifyDN(String rawEntryDN, String rawNewRDN, boolean deleteOldRDN, String rawNewSuperior) {
        return this.processModifyDN(new ASN1OctetString(rawEntryDN), new ASN1OctetString(rawNewRDN), deleteOldRDN, new ASN1OctetString(rawNewSuperior), null);
    }

    public ModifyDNOperation processModifyDN(String rawEntryDN, String rawNewRDN, boolean deleteOldRDN, String rawNewSuperior, List<Control> controls) {
        return this.processModifyDN(new ASN1OctetString(rawEntryDN), new ASN1OctetString(rawNewRDN), deleteOldRDN, new ASN1OctetString(rawNewSuperior), controls);
    }

    public ModifyDNOperation processModifyDN(ByteString rawEntryDN, ByteString rawNewRDN, boolean deleteOldRDN, ByteString rawNewSuperior) {
        return this.processModifyDN(rawEntryDN, rawNewRDN, deleteOldRDN, rawNewSuperior, null);
    }

    public ModifyDNOperation processModifyDN(ByteString rawEntryDN, ByteString rawNewRDN, boolean deleteOldRDN, ByteString rawNewSuperior, List<Control> controls) {
        if (controls == null) {
            controls = new ArrayList<Control>(0);
        }
        ModifyDNOperationBasis modifyDNOperation = new ModifyDNOperationBasis((ClientConnection)this, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), controls, rawEntryDN, rawNewRDN, deleteOldRDN, rawNewSuperior);
        modifyDNOperation.setInternalOperation(true);
        modifyDNOperation.run();
        return modifyDNOperation;
    }

    public ModifyDNOperation processModifyDN(DN entryDN, RDN newRDN, boolean deleteOldRDN) {
        return this.processModifyDN(entryDN, newRDN, deleteOldRDN, null, null);
    }

    public ModifyDNOperation processModifyDN(DN entryDN, RDN newRDN, boolean deleteOldRDN, DN newSuperior) {
        return this.processModifyDN(entryDN, newRDN, deleteOldRDN, newSuperior, null);
    }

    public ModifyDNOperation processModifyDN(DN entryDN, RDN newRDN, boolean deleteOldRDN, DN newSuperior, List<Control> controls) {
        if (controls == null) {
            controls = new ArrayList<Control>(0);
        }
        ModifyDNOperationBasis modifyDNOperation = new ModifyDNOperationBasis((ClientConnection)this, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), controls, entryDN, newRDN, deleteOldRDN, newSuperior);
        modifyDNOperation.setInternalOperation(true);
        modifyDNOperation.run();
        return modifyDNOperation;
    }

    public ModifyDNOperation processModifyDN(ModifyDNChangeRecordEntry modifyDNRecord) {
        return this.processModifyDN(modifyDNRecord.getDN(), modifyDNRecord.getNewRDN(), modifyDNRecord.deleteOldRDN(), modifyDNRecord.getNewSuperiorDN());
    }

    public InternalSearchOperation processSearch(String rawBaseDN, SearchScope scope, String filterString) throws DirectoryException {
        RawFilter rawFilter;
        try {
            rawFilter = RawFilter.create(filterString);
        }
        catch (LDAPException le) {
            throw new DirectoryException(ResultCode.valueOf(le.getResultCode()), le.getErrorMessage(), le);
        }
        return this.processSearch(new ASN1OctetString(rawBaseDN), scope, rawFilter);
    }

    public InternalSearchOperation processSearch(String rawBaseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, String filterString, LinkedHashSet<String> attributes) throws DirectoryException {
        return this.processSearch(rawBaseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filterString, attributes, null, null);
    }

    public InternalSearchOperation processSearch(String rawBaseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, String filterString, LinkedHashSet<String> attributes, InternalSearchListener searchListener) throws DirectoryException {
        return this.processSearch(rawBaseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filterString, attributes, null, searchListener);
    }

    public InternalSearchOperation processSearch(String rawBaseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, String filterString, LinkedHashSet<String> attributes, List<Control> controls, InternalSearchListener searchListener) throws DirectoryException {
        RawFilter rawFilter;
        try {
            rawFilter = RawFilter.create(filterString);
        }
        catch (LDAPException le) {
            throw new DirectoryException(ResultCode.valueOf(le.getResultCode()), le.getErrorMessage(), le);
        }
        return this.processSearch(new ASN1OctetString(rawBaseDN), scope, derefPolicy, sizeLimit, timeLimit, typesOnly, rawFilter, attributes, controls, searchListener);
    }

    public InternalSearchOperation processSearch(ByteString rawBaseDN, SearchScope scope, RawFilter filter) {
        return this.processSearch(rawBaseDN, scope, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, filter, new LinkedHashSet<String>(0));
    }

    public InternalSearchOperation processSearch(ByteString rawBaseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, RawFilter filter, LinkedHashSet<String> attributes) {
        return this.processSearch(rawBaseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes, null, null);
    }

    public InternalSearchOperation processSearch(ByteString rawBaseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, RawFilter filter, LinkedHashSet<String> attributes, InternalSearchListener searchListener) {
        return this.processSearch(rawBaseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes, null, searchListener);
    }

    public InternalSearchOperation processSearch(ByteString rawBaseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, RawFilter filter, LinkedHashSet<String> attributes, List<Control> controls, InternalSearchListener searchListener) {
        if (controls == null) {
            controls = new ArrayList<Control>(0);
        }
        InternalSearchOperation searchOperation = new InternalSearchOperation((ClientConnection)this, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), controls, rawBaseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes, searchListener);
        searchOperation.run();
        return searchOperation;
    }

    public InternalSearchOperation processSearch(DN baseDN, SearchScope scope, SearchFilter filter) {
        return this.processSearch(baseDN, scope, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, filter, new LinkedHashSet<String>(0));
    }

    public InternalSearchOperation processSearch(DN baseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, SearchFilter filter, LinkedHashSet<String> attributes) {
        return this.processSearch(baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes, null, null);
    }

    public InternalSearchOperation processSearch(DN baseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, SearchFilter filter, LinkedHashSet<String> attributes, InternalSearchListener searchListener) {
        return this.processSearch(baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes, null, searchListener);
    }

    public InternalSearchOperation processSearch(DN baseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, SearchFilter filter, LinkedHashSet<String> attributes, List<Control> controls, InternalSearchListener searchListener) {
        if (controls == null) {
            controls = new ArrayList<Control>(0);
        }
        InternalSearchOperation searchOperation = new InternalSearchOperation((ClientConnection)this, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), controls, baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes, searchListener);
        searchOperation.run();
        return searchOperation;
    }

    @Override
    @PublicAPI(stability=StabilityLevel.PRIVATE, mayInstantiate=false, mayExtend=false, mayInvoke=false)
    public void sendSearchEntry(SearchOperation searchOperation, SearchResultEntry searchEntry) throws DirectoryException {
        ((InternalSearchOperation)searchOperation).addSearchEntry(searchEntry);
    }

    @Override
    @PublicAPI(stability=StabilityLevel.PRIVATE, mayInstantiate=false, mayExtend=false, mayInvoke=false)
    public boolean sendSearchReference(SearchOperation searchOperation, SearchResultReference searchReference) throws DirectoryException {
        ((InternalSearchOperation)searchOperation).addSearchReference(searchReference);
        return true;
    }

    @Override
    @PublicAPI(stability=StabilityLevel.PRIVATE, mayInstantiate=false, mayExtend=false, mayInvoke=false)
    protected boolean sendIntermediateResponseMessage(IntermediateResponse intermediateResponse) {
        return false;
    }

    @Override
    @PublicAPI(stability=StabilityLevel.PRIVATE, mayInstantiate=false, mayExtend=false, mayInvoke=false)
    public void disconnect(DisconnectReason disconnectReason, boolean sendNotification, Message message) {
    }

    @Override
    public boolean bindInProgress() {
        return false;
    }

    @Override
    @PublicAPI(stability=StabilityLevel.PRIVATE, mayInstantiate=false, mayExtend=false, mayInvoke=false)
    public void setBindInProgress(boolean bindInProgress) {
    }

    @Override
    @PublicAPI(stability=StabilityLevel.PRIVATE, mayInstantiate=false, mayExtend=false, mayInvoke=false)
    public Collection<Operation> getOperationsInProgress() {
        return this.operationList;
    }

    @Override
    @PublicAPI(stability=StabilityLevel.PRIVATE, mayInstantiate=false, mayExtend=false, mayInvoke=false)
    public AbstractOperation getOperationInProgress(int messageID) {
        return null;
    }

    @Override
    @PublicAPI(stability=StabilityLevel.PRIVATE, mayInstantiate=false, mayExtend=false, mayInvoke=false)
    public boolean removeOperationInProgress(int messageID) {
        return false;
    }

    @Override
    @PublicAPI(stability=StabilityLevel.PRIVATE, mayInstantiate=false, mayExtend=false, mayInvoke=false)
    public CancelResult cancelOperation(int messageID, CancelRequest cancelRequest) {
        return new CancelResult(ResultCode.CANNOT_CANCEL, Message.raw("Internal operations cannot be cancelled", new Object[0]));
    }

    @Override
    @PublicAPI(stability=StabilityLevel.PRIVATE, mayInstantiate=false, mayExtend=false, mayInvoke=false)
    public void cancelAllOperations(CancelRequest cancelRequest) {
    }

    @Override
    @PublicAPI(stability=StabilityLevel.PRIVATE, mayInstantiate=false, mayExtend=false, mayInvoke=false)
    public void cancelAllOperationsExcept(CancelRequest cancelRequest, int messageID) {
    }

    @Override
    public String getMonitorSummary() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("connID=\"");
        buffer.append(this.connectionID);
        buffer.append("\" authDN=\"");
        buffer.append(this.getAuthenticationInfo().getAuthenticationDN());
        buffer.append("\"");
        return buffer.toString();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("InternalClientConnection(connID=");
        buffer.append(this.connectionID);
        buffer.append(", authDN=\"");
        if (this.getAuthenticationInfo() != null) {
            buffer.append(this.getAuthenticationInfo().getAuthenticationDN());
        }
        buffer.append("\")");
    }

    static void clearRootClientConnectionAtShutdown() {
        rootConnection = null;
    }

    @Override
    public long getNumberOfOperations() {
        return 0L;
    }
}

