/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ProtocolMessages;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConnectionHandler;
import org.opends.server.api.ConnectionSecurityProvider;
import org.opends.server.core.AbandonOperationBasis;
import org.opends.server.core.AddOperationBasis;
import org.opends.server.core.BindOperationBasis;
import org.opends.server.core.CompareOperationBasis;
import org.opends.server.core.DeleteOperationBasis;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ExtendedOperationBasis;
import org.opends.server.core.ModifyDNOperationBasis;
import org.opends.server.core.ModifyOperationBasis;
import org.opends.server.core.PersistentSearch;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.core.SearchOperation;
import org.opends.server.core.SearchOperationBasis;
import org.opends.server.core.UnbindOperationBasis;
import org.opends.server.core.networkgroups.NetworkGroup;
import org.opends.server.extensions.NullConnectionSecurityProvider;
import org.opends.server.extensions.TLSCapableConnection;
import org.opends.server.extensions.TLSConnectionSecurityProvider;
import org.opends.server.loggers.AccessLogger;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.AbandonRequestProtocolOp;
import org.opends.server.protocols.ldap.AddRequestProtocolOp;
import org.opends.server.protocols.ldap.AddResponseProtocolOp;
import org.opends.server.protocols.ldap.BindRequestProtocolOp;
import org.opends.server.protocols.ldap.BindResponseProtocolOp;
import org.opends.server.protocols.ldap.CompareRequestProtocolOp;
import org.opends.server.protocols.ldap.CompareResponseProtocolOp;
import org.opends.server.protocols.ldap.DeleteRequestProtocolOp;
import org.opends.server.protocols.ldap.DeleteResponseProtocolOp;
import org.opends.server.protocols.ldap.ExtendedRequestProtocolOp;
import org.opends.server.protocols.ldap.ExtendedResponseProtocolOp;
import org.opends.server.protocols.ldap.IntermediateResponseProtocolOp;
import org.opends.server.protocols.ldap.LDAPConnectionHandler;
import org.opends.server.protocols.ldap.LDAPControl;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.protocols.ldap.LDAPRequestHandler;
import org.opends.server.protocols.ldap.LDAPStatistics;
import org.opends.server.protocols.ldap.ModifyDNRequestProtocolOp;
import org.opends.server.protocols.ldap.ModifyDNResponseProtocolOp;
import org.opends.server.protocols.ldap.ModifyRequestProtocolOp;
import org.opends.server.protocols.ldap.ModifyResponseProtocolOp;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.protocols.ldap.SearchRequestProtocolOp;
import org.opends.server.protocols.ldap.SearchResultDoneProtocolOp;
import org.opends.server.protocols.ldap.SearchResultEntryProtocolOp;
import org.opends.server.protocols.ldap.SearchResultReferenceProtocolOp;
import org.opends.server.types.AbstractOperation;
import org.opends.server.types.ByteString;
import org.opends.server.types.CancelRequest;
import org.opends.server.types.CancelResult;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.IntermediateResponse;
import org.opends.server.types.Operation;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchResultReference;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPClientConnection
extends ClientConnection
implements TLSCapableConnection {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private AtomicLong lastCompletionTime;
    private AtomicLong nextOperationID;
    private AtomicReference<Selector> writeSelector;
    private boolean connectionValid;
    private boolean disconnectRequested;
    private boolean keepStats;
    private byte elementType;
    private byte[] elementValue;
    private ConcurrentHashMap<Integer, Operation> operationsInProgress;
    private long operationsPerformed;
    private Object operationsPerformedLock;
    private ConnectionSecurityProvider clearSecurityProvider;
    private ConnectionSecurityProvider securityProvider;
    private int clientPort;
    private int elementLength;
    private int elementLengthBytesNeeded;
    private int elementReadState;
    private int elementValueBytesRead;
    private int elementValueBytesNeeded;
    private int ldapVersion;
    private int serverPort;
    private LDAPConnectionHandler connectionHandler;
    private LDAPRequestHandler requestHandler;
    private LDAPStatistics statTracker;
    private long connectionID;
    private Object opsInProgressLock;
    private Object transmitLock;
    private SocketChannel clientChannel;
    private String clientAddress;
    private String protocol;
    private String serverAddress;
    private TLSConnectionSecurityProvider tlsSecurityProvider;
    private ConnectionSecurityProvider saslSecurityProvider;

    public LDAPClientConnection(LDAPConnectionHandler connectionHandler, SocketChannel clientChannel) {
        this.connectionHandler = connectionHandler;
        if (connectionHandler.isAdminConnectionHandler()) {
            this.setNetworkGroup(NetworkGroup.getAdminNetworkGroup());
        }
        this.clientChannel = clientChannel;
        this.securityProvider = null;
        this.clearSecurityProvider = null;
        this.opsInProgressLock = new Object();
        this.transmitLock = new Object();
        this.elementReadState = 0;
        this.elementType = 0;
        this.elementLength = 0;
        this.elementLengthBytesNeeded = 0;
        this.elementValue = null;
        this.elementValueBytesRead = 0;
        this.elementValueBytesNeeded = 0;
        this.ldapVersion = 3;
        this.requestHandler = null;
        this.lastCompletionTime = new AtomicLong(TimeThread.getTime());
        this.nextOperationID = new AtomicLong(0L);
        this.connectionValid = true;
        this.disconnectRequested = false;
        this.operationsInProgress = new ConcurrentHashMap();
        this.operationsPerformed = 0L;
        this.operationsPerformedLock = new Object();
        this.keepStats = connectionHandler.keepStats();
        this.protocol = "LDAP";
        this.writeSelector = new AtomicReference();
        this.clientAddress = clientChannel.socket().getInetAddress().getHostAddress();
        this.clientPort = clientChannel.socket().getPort();
        this.serverAddress = clientChannel.socket().getLocalAddress().getHostAddress();
        this.serverPort = clientChannel.socket().getLocalPort();
        LDAPStatistics parentTracker = connectionHandler.getStatTracker();
        String instanceName = parentTracker.getMonitorInstanceName() + " for " + this.toString();
        this.statTracker = new LDAPStatistics(instanceName, parentTracker);
        if (this.keepStats) {
            this.statTracker.updateConnect();
        }
        this.connectionID = DirectoryServer.newConnectionAccepted(this);
        if (this.connectionID < 0L) {
            this.disconnect(DisconnectReason.ADMIN_LIMIT_EXCEEDED, true, ProtocolMessages.ERR_LDAP_CONNHANDLER_REJECTED_BY_SERVER.get());
        }
    }

    @Override
    public long getConnectionID() {
        return this.connectionID;
    }

    @Override
    public ConnectionHandler<?> getConnectionHandler() {
        return this.connectionHandler;
    }

    public LDAPRequestHandler getRequestHandler() {
        return this.requestHandler;
    }

    public void setRequestHandler(LDAPRequestHandler requestHandler) {
        this.requestHandler = requestHandler;
    }

    public SocketChannel getSocketChannel() {
        return this.clientChannel;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public String getClientAddress() {
        return this.clientAddress;
    }

    @Override
    public int getClientPort() {
        return this.clientPort;
    }

    @Override
    public String getServerAddress() {
        return this.serverAddress;
    }

    @Override
    public int getServerPort() {
        return this.serverPort;
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this.clientChannel.socket().getInetAddress();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.clientChannel.socket().getLocalAddress();
    }

    @Override
    public boolean isSecure() {
        return this.securityProvider.isSecure();
    }

    @Override
    public ConnectionSecurityProvider getConnectionSecurityProvider() {
        if (this.saslSecurityProvider != null && this.saslSecurityProvider.isActive()) {
            this.securityProvider = this.saslSecurityProvider;
        }
        return this.securityProvider;
    }

    public void setSASLConnectionSecurityProvider(ConnectionSecurityProvider secProvider) {
        this.saslSecurityProvider = secProvider;
    }

    @Override
    public void setConnectionSecurityProvider(ConnectionSecurityProvider securityProvider) {
        this.securityProvider = securityProvider;
        this.protocol = securityProvider.isSecure() ? "LDAP+" + securityProvider.getSecurityMechanismName() : "LDAP";
    }

    @Override
    public String getSecurityMechanism() {
        return this.securityProvider.getSecurityMechanismName();
    }

    public long nextOperationID() {
        return this.nextOperationID.getAndIncrement();
    }

    @Override
    public void sendResponse(Operation operation) {
        this.removeOperationInProgress(operation.getMessageID());
        LDAPMessage message = this.operationToResponseLDAPMessage(operation);
        if (message != null) {
            this.sendLDAPMessage(this.securityProvider, message);
        }
    }

    private LDAPMessage operationToResponseLDAPMessage(Operation operation) {
        ArrayList<LDAPControl> controls;
        ProtocolOp protocolOp;
        List<String> referralURLs;
        ResultCode resultCode = operation.getResultCode();
        if (resultCode == null) {
            ErrorLogger.logError(ProtocolMessages.ERR_LDAP_CLIENT_SEND_RESPONSE_NO_RESULT_CODE.get(operation.getOperationType().toString(), operation.getConnectionID(), operation.getOperationID()));
            resultCode = DirectoryServer.getServerErrorResultCode();
        }
        MessageBuilder errorMessage = operation.getErrorMessage();
        DN matchedDN = operation.getMatchedDN();
        if (this.ldapVersion == 2) {
            List<String> opReferrals;
            referralURLs = null;
            if (resultCode == ResultCode.REFERRAL) {
                resultCode = ResultCode.CONSTRAINT_VIOLATION;
                errorMessage.append(ProtocolMessages.ERR_LDAPV2_REFERRAL_RESULT_CHANGED.get());
            }
            if ((opReferrals = operation.getReferralURLs()) != null && !opReferrals.isEmpty()) {
                StringBuilder referralsStr = new StringBuilder();
                Iterator<String> iterator = opReferrals.iterator();
                referralsStr.append(iterator.next());
                while (iterator.hasNext()) {
                    referralsStr.append(", ");
                    referralsStr.append(iterator.next());
                }
                errorMessage.append(ProtocolMessages.ERR_LDAPV2_REFERRALS_OMITTED.get(String.valueOf(referralsStr)));
            }
        } else {
            referralURLs = operation.getReferralURLs();
        }
        switch (operation.getOperationType()) {
            case ADD: {
                protocolOp = new AddResponseProtocolOp(resultCode.getIntValue(), errorMessage.toMessage(), matchedDN, referralURLs);
                break;
            }
            case BIND: {
                ASN1OctetString serverSASLCredentials = ((BindOperationBasis)operation).getServerSASLCredentials();
                protocolOp = new BindResponseProtocolOp(resultCode.getIntValue(), errorMessage.toMessage(), matchedDN, referralURLs, serverSASLCredentials);
                break;
            }
            case COMPARE: {
                protocolOp = new CompareResponseProtocolOp(resultCode.getIntValue(), errorMessage.toMessage(), matchedDN, referralURLs);
                break;
            }
            case DELETE: {
                protocolOp = new DeleteResponseProtocolOp(resultCode.getIntValue(), errorMessage.toMessage(), matchedDN, referralURLs);
                break;
            }
            case EXTENDED: {
                if (this.ldapVersion == 2) {
                    ErrorLogger.logError(ProtocolMessages.ERR_LDAPV2_SKIPPING_EXTENDED_RESPONSE.get(this.getConnectionID(), operation.getOperationID(), String.valueOf(operation)));
                    return null;
                }
                ExtendedOperationBasis extOp = (ExtendedOperationBasis)operation;
                protocolOp = new ExtendedResponseProtocolOp(resultCode.getIntValue(), errorMessage.toMessage(), matchedDN, referralURLs, extOp.getResponseOID(), extOp.getResponseValue());
                break;
            }
            case MODIFY: {
                protocolOp = new ModifyResponseProtocolOp(resultCode.getIntValue(), errorMessage.toMessage(), matchedDN, referralURLs);
                break;
            }
            case MODIFY_DN: {
                protocolOp = new ModifyDNResponseProtocolOp(resultCode.getIntValue(), errorMessage.toMessage(), matchedDN, referralURLs);
                break;
            }
            case SEARCH: {
                protocolOp = new SearchResultDoneProtocolOp(resultCode.getIntValue(), errorMessage.toMessage(), matchedDN, referralURLs);
                break;
            }
            default: {
                ErrorLogger.logError(ProtocolMessages.ERR_LDAP_CLIENT_SEND_RESPONSE_INVALID_OP.get(String.valueOf((Object)operation.getOperationType()), this.getConnectionID(), operation.getOperationID(), String.valueOf(operation)));
                return null;
            }
        }
        if (this.ldapVersion == 2) {
            controls = null;
        } else {
            List<Control> responseControls = operation.getResponseControls();
            if (responseControls == null || responseControls.isEmpty()) {
                controls = null;
            } else {
                controls = new ArrayList<LDAPControl>(responseControls.size());
                for (Control c : responseControls) {
                    controls.add(new LDAPControl(c));
                }
            }
        }
        return new LDAPMessage(operation.getMessageID(), protocolOp, controls);
    }

    @Override
    public void sendSearchEntry(SearchOperation searchOperation, SearchResultEntry searchEntry) {
        ArrayList<LDAPControl> controls;
        SearchResultEntryProtocolOp protocolOp = new SearchResultEntryProtocolOp(searchEntry, this.ldapVersion);
        List<Control> entryControls = searchEntry.getControls();
        if (entryControls == null || entryControls.isEmpty()) {
            controls = null;
        } else {
            controls = new ArrayList<LDAPControl>(entryControls.size());
            for (Control c : entryControls) {
                controls.add(new LDAPControl(c));
            }
        }
        this.sendLDAPMessage(this.securityProvider, new LDAPMessage(searchOperation.getMessageID(), protocolOp, controls));
    }

    @Override
    public boolean sendSearchReference(SearchOperation searchOperation, SearchResultReference searchReference) {
        ArrayList<LDAPControl> controls;
        if (this.ldapVersion == 2) {
            Message message = ProtocolMessages.ERR_LDAPV2_SKIPPING_SEARCH_REFERENCE.get(this.getConnectionID(), searchOperation.getOperationID(), String.valueOf(searchReference));
            ErrorLogger.logError(message);
            return false;
        }
        SearchResultReferenceProtocolOp protocolOp = new SearchResultReferenceProtocolOp(searchReference);
        List<Control> referenceControls = searchReference.getControls();
        if (referenceControls == null || referenceControls.isEmpty()) {
            controls = null;
        } else {
            controls = new ArrayList<LDAPControl>(referenceControls.size());
            for (Control c : referenceControls) {
                controls.add(new LDAPControl(c));
            }
        }
        this.sendLDAPMessage(this.securityProvider, new LDAPMessage(searchOperation.getMessageID(), protocolOp, controls));
        return true;
    }

    @Override
    protected boolean sendIntermediateResponseMessage(IntermediateResponse intermediateResponse) {
        IntermediateResponseProtocolOp protocolOp = new IntermediateResponseProtocolOp(intermediateResponse.getOID(), intermediateResponse.getValue());
        Operation operation = intermediateResponse.getOperation();
        List<Control> controls = intermediateResponse.getControls();
        ArrayList<LDAPControl> ldapControls = new ArrayList<LDAPControl>(controls.size());
        for (Control c : controls) {
            ldapControls.add(new LDAPControl(c));
        }
        LDAPMessage message = new LDAPMessage(operation.getMessageID(), protocolOp, ldapControls);
        this.sendLDAPMessage(this.securityProvider, message);
        return this.connectionValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendLDAPMessage(ConnectionSecurityProvider secProvider, LDAPMessage message) {
        ASN1Element messageElement = message.encode();
        ByteBuffer messageBuffer = ByteBuffer.wrap(messageElement.encode());
        Object object = this.transmitLock;
        synchronized (object) {
            try {
                try {
                    int bytesWritten = messageBuffer.limit() - messageBuffer.position();
                    if (!secProvider.writeData(messageBuffer)) {
                        return;
                    }
                    TRACER.debugProtocolElement(DebugLogLevel.VERBOSE, message);
                    TRACER.debugProtocolElement(DebugLogLevel.VERBOSE, messageElement);
                    messageBuffer.rewind();
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugData(DebugLogLevel.VERBOSE, messageBuffer);
                    }
                    if (this.keepStats) {
                        this.statTracker.updateMessageWritten(message, bytesWritten);
                    }
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    this.disconnect(DisconnectReason.SERVER_ERROR, true, null);
                    return;
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                this.disconnect(DisconnectReason.SERVER_ERROR, true, null);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect(DisconnectReason disconnectReason, boolean sendNotification, Message message) {
        block31: {
            block30: {
                block29: {
                    Object object = this.opsInProgressLock;
                    synchronized (object) {
                        if (this.disconnectRequested) {
                            return;
                        }
                        this.disconnectRequested = true;
                    }
                    if (this.keepStats) {
                        this.statTracker.updateDisconnect();
                    }
                    if (this.connectionID >= 0L) {
                        DirectoryServer.connectionClosed(this);
                    }
                    this.connectionValid = false;
                    if (message != null) {
                        MessageBuilder msgBuilder = new MessageBuilder();
                        msgBuilder.append(disconnectReason.getClosureMessage());
                        msgBuilder.append(": ");
                        msgBuilder.append(message);
                        this.cancelAllOperations(new CancelRequest(true, msgBuilder.toMessage()));
                    } else {
                        this.cancelAllOperations(new CancelRequest(true, disconnectReason.getClosureMessage()));
                    }
                    this.finalizeConnectionInternal();
                    Selector selector = this.writeSelector.get();
                    if (selector != null) {
                        try {
                            selector.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (sendNotification && this.ldapVersion != 2) {
                        try {
                            int resultCode;
                            switch (disconnectReason) {
                                case PROTOCOL_ERROR: {
                                    resultCode = 2;
                                    break;
                                }
                                case SERVER_SHUTDOWN: {
                                    resultCode = 52;
                                    break;
                                }
                                case SERVER_ERROR: {
                                    resultCode = DirectoryServer.getServerErrorResultCode().getIntValue();
                                    break;
                                }
                                case ADMIN_LIMIT_EXCEEDED: 
                                case IDLE_TIME_LIMIT_EXCEEDED: 
                                case MAX_REQUEST_SIZE_EXCEEDED: 
                                case IO_TIMEOUT: {
                                    resultCode = 11;
                                    break;
                                }
                                case CONNECTION_REJECTED: {
                                    resultCode = 19;
                                    break;
                                }
                                default: {
                                    resultCode = 80;
                                }
                            }
                            Message errMsg = message == null ? ProtocolMessages.INFO_LDAP_CLIENT_GENERIC_NOTICE_OF_DISCONNECTION.get() : message;
                            ExtendedResponseProtocolOp notificationOp = new ExtendedResponseProtocolOp(resultCode, errMsg, null, null, "1.3.6.1.4.1.1466.20036", null);
                            byte[] messageBytes = new LDAPMessage(0, notificationOp, null).encode().encode();
                            ByteBuffer buffer = ByteBuffer.wrap(messageBytes);
                            try {
                                this.securityProvider.writeData(buffer);
                            }
                            catch (Exception e) {}
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    try {
                        this.securityProvider.disconnect(sendNotification);
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block29;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                try {
                    this.clientChannel.close();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block30;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            AccessLogger.logDisconnect(this, disconnectReason, message);
            try {
                PluginConfigManager pluginManager = DirectoryServer.getPluginConfigManager();
                pluginManager.invokePostDisconnectPlugins(this, disconnectReason, message);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block31;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    @Override
    public Collection<Operation> getOperationsInProgress() {
        return this.operationsInProgress.values();
    }

    @Override
    public Operation getOperationInProgress(int messageID) {
        return this.operationsInProgress.get(messageID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOperationInProgress(AbstractOperation operation) throws DirectoryException {
        int messageID = operation.getMessageID();
        Object object = this.opsInProgressLock;
        synchronized (object) {
            try {
                if (this.disconnectRequested) {
                    Message message = ProtocolMessages.WARN_LDAP_CLIENT_DISCONNECT_IN_PROGRESS.get();
                    throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
                }
                Operation op = this.operationsInProgress.get(messageID);
                if (op != null) {
                    Message message = ProtocolMessages.WARN_LDAP_CLIENT_DUPLICATE_MESSAGE_ID.get(messageID);
                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
                }
                this.operationsInProgress.put(messageID, operation);
                this.connectionHandler.getQueueingStrategy().enqueueRequest(operation);
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                this.operationsInProgress.remove(messageID);
                this.lastCompletionTime.set(TimeThread.getTime());
                throw de;
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ProtocolMessages.WARN_LDAP_CLIENT_CANNOT_ENQUEUE.get(StaticUtils.getExceptionMessage(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
            }
        }
    }

    @Override
    public boolean removeOperationInProgress(int messageID) {
        Operation operation = this.operationsInProgress.remove(messageID);
        if (operation == null) {
            return false;
        }
        this.lastCompletionTime.set(TimeThread.getTime());
        return true;
    }

    @Override
    public CancelResult cancelOperation(int messageID, CancelRequest cancelRequest) {
        Operation op = this.operationsInProgress.get(messageID);
        if (op == null) {
            for (PersistentSearch ps : this.getPersistentSearches()) {
                if (ps.getMessageID() != messageID) continue;
                CancelResult cancelResult = ps.cancel();
                return cancelResult;
            }
            return new CancelResult(ResultCode.NO_SUCH_OPERATION, null);
        }
        CancelResult cancelResult = op.cancel(cancelRequest);
        return cancelResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelAllOperations(CancelRequest cancelRequest) {
        Object object = this.opsInProgressLock;
        synchronized (object) {
            block10: {
                try {
                    for (Operation o : this.operationsInProgress.values()) {
                        try {
                            o.abort(cancelRequest);
                            if (!this.keepStats) continue;
                            this.statTracker.updateAbandonedOperation();
                        }
                        catch (Exception e) {
                            if (!DebugLogger.debugEnabled()) continue;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                    }
                    if (!this.operationsInProgress.isEmpty() || !this.getPersistentSearches().isEmpty()) {
                        this.lastCompletionTime.set(TimeThread.getTime());
                    }
                    this.operationsInProgress.clear();
                    for (PersistentSearch persistentSearch : this.getPersistentSearches()) {
                        persistentSearch.cancel();
                    }
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block10;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelAllOperationsExcept(CancelRequest cancelRequest, int messageID) {
        Object object = this.opsInProgressLock;
        synchronized (object) {
            block12: {
                try {
                    Iterator<Object> i$ = this.operationsInProgress.keySet().iterator();
                    while (i$.hasNext()) {
                        int msgID;
                        block11: {
                            msgID = (Integer)i$.next();
                            if (msgID == messageID) continue;
                            Operation o = this.operationsInProgress.get(msgID);
                            if (o != null) {
                                try {
                                    o.abort(cancelRequest);
                                    if (this.keepStats) {
                                        this.statTracker.updateAbandonedOperation();
                                    }
                                }
                                catch (Exception e) {
                                    if (!DebugLogger.debugEnabled()) break block11;
                                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                                }
                            }
                        }
                        this.operationsInProgress.remove(msgID);
                        this.lastCompletionTime.set(TimeThread.getTime());
                    }
                    for (PersistentSearch persistentSearch : this.getPersistentSearches()) {
                        if (persistentSearch.getMessageID() == messageID) continue;
                        persistentSearch.cancel();
                        this.lastCompletionTime.set(TimeThread.getTime());
                    }
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block12;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
    }

    @Override
    public Selector getWriteSelector() {
        Selector selector;
        block4: {
            selector = this.writeSelector.get();
            if (selector == null) {
                try {
                    selector = Selector.open();
                    if (!this.writeSelector.compareAndSet(null, selector)) {
                        selector.close();
                        selector = this.writeSelector.get();
                    }
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block4;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
        return selector;
    }

    @Override
    public long getMaxBlockedWriteTimeLimit() {
        return this.connectionHandler.getMaxBlockedWriteTimeLimit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumberOfOperations() {
        long tmpNumberOfOperations;
        Object object = this.operationsPerformedLock;
        synchronized (object) {
            tmpNumberOfOperations = this.operationsPerformed;
        }
        return tmpNumberOfOperations;
    }

    @Override
    public boolean processDataRead(ByteBuffer buffer) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugData(DebugLogLevel.VERBOSE, buffer);
        }
        int bytesAvailable = buffer.limit() - buffer.position();
        if (this.keepStats) {
            this.statTracker.updateBytesRead(bytesAvailable);
        }
        block10: while (bytesAvailable > 0) {
            switch (this.elementReadState) {
                case 0: {
                    this.elementType = buffer.get();
                    --bytesAvailable;
                    this.elementReadState = 1;
                    continue block10;
                }
                case 1: {
                    Message m;
                    byte firstLengthByte = buffer.get();
                    --bytesAvailable;
                    this.elementLengthBytesNeeded = firstLengthByte & 0x7F;
                    if (this.elementLengthBytesNeeded == firstLengthByte) {
                        this.elementLength = firstLengthByte;
                        if (this.elementLength == 0) {
                            this.disconnect(DisconnectReason.PROTOCOL_ERROR, true, ProtocolMessages.ERR_LDAP_CLIENT_DECODE_ZERO_BYTE_VALUE.get());
                            return false;
                        }
                        if (this.connectionHandler.getMaxRequestSize() > 0 && this.elementLength > this.connectionHandler.getMaxRequestSize()) {
                            m = ProtocolMessages.ERR_LDAP_CLIENT_DECODE_MAX_REQUEST_SIZE_EXCEEDED.get(this.elementLength, this.connectionHandler.getMaxRequestSize());
                            this.disconnect(DisconnectReason.MAX_REQUEST_SIZE_EXCEEDED, true, m);
                            return false;
                        }
                        this.elementValue = new byte[this.elementLength];
                        this.elementValueBytesRead = 0;
                        this.elementValueBytesNeeded = this.elementLength;
                        this.elementReadState = 3;
                        continue block10;
                    }
                    if (this.elementLengthBytesNeeded > 4) {
                        m = ProtocolMessages.ERR_LDAP_CLIENT_DECODE_INVALID_MULTIBYTE_LENGTH.get(this.elementLengthBytesNeeded);
                        this.disconnect(DisconnectReason.PROTOCOL_ERROR, true, m);
                        return false;
                    }
                    this.elementLength = 0;
                    if (this.elementLengthBytesNeeded <= bytesAvailable) {
                        while (this.elementLengthBytesNeeded > 0) {
                            this.elementLength = this.elementLength << 8 | buffer.get() & 0xFF;
                            --bytesAvailable;
                            --this.elementLengthBytesNeeded;
                        }
                        if (this.elementLength == 0) {
                            this.disconnect(DisconnectReason.PROTOCOL_ERROR, true, ProtocolMessages.ERR_LDAP_CLIENT_DECODE_ZERO_BYTE_VALUE.get());
                            return false;
                        }
                        if (this.connectionHandler.getMaxRequestSize() > 0 && this.elementLength > this.connectionHandler.getMaxRequestSize()) {
                            this.disconnect(DisconnectReason.MAX_REQUEST_SIZE_EXCEEDED, true, ProtocolMessages.ERR_LDAP_CLIENT_DECODE_MAX_REQUEST_SIZE_EXCEEDED.get(this.elementLength, this.connectionHandler.getMaxRequestSize()));
                            return false;
                        }
                        this.elementValue = new byte[this.elementLength];
                        this.elementValueBytesRead = 0;
                        this.elementValueBytesNeeded = this.elementLength;
                        this.elementReadState = 3;
                        continue block10;
                    }
                    while (bytesAvailable > 0) {
                        this.elementLength = this.elementLength << 8 | buffer.get() & 0xFF;
                        --bytesAvailable;
                        --this.elementLengthBytesNeeded;
                    }
                    return true;
                }
                case 2: {
                    if (bytesAvailable >= this.elementLengthBytesNeeded) {
                        while (this.elementLengthBytesNeeded > 0) {
                            this.elementLength = this.elementLength << 8 | buffer.get() & 0xFF;
                            --bytesAvailable;
                            --this.elementLengthBytesNeeded;
                        }
                        if (this.elementLength == 0) {
                            this.disconnect(DisconnectReason.PROTOCOL_ERROR, true, ProtocolMessages.ERR_LDAP_CLIENT_DECODE_ZERO_BYTE_VALUE.get());
                            return false;
                        }
                        if (this.connectionHandler.getMaxRequestSize() > 0 && this.elementLength > this.connectionHandler.getMaxRequestSize()) {
                            this.disconnect(DisconnectReason.MAX_REQUEST_SIZE_EXCEEDED, true, ProtocolMessages.ERR_LDAP_CLIENT_DECODE_MAX_REQUEST_SIZE_EXCEEDED.get(this.elementLength, this.connectionHandler.getMaxRequestSize()));
                            return false;
                        }
                        this.elementValue = new byte[this.elementLength];
                        this.elementValueBytesRead = 0;
                        this.elementValueBytesNeeded = this.elementLength;
                        this.elementReadState = 3;
                        continue block10;
                    }
                    while (bytesAvailable > 0) {
                        this.elementLength = this.elementLength << 8 | buffer.get() & 0xFF;
                        --bytesAvailable;
                        --this.elementLengthBytesNeeded;
                    }
                    return true;
                }
                case 3: {
                    if (bytesAvailable >= this.elementValueBytesNeeded) {
                        LDAPMessage requestMessage;
                        ASN1Sequence requestSequence;
                        buffer.get(this.elementValue, this.elementValueBytesRead, this.elementValueBytesNeeded);
                        this.elementValueBytesRead += this.elementValueBytesNeeded;
                        bytesAvailable -= this.elementValueBytesNeeded;
                        this.elementReadState = 0;
                        try {
                            requestSequence = ASN1Sequence.decodeAsSequence(this.elementType, this.elementValue);
                            TRACER.debugProtocolElement(DebugLogLevel.VERBOSE, requestSequence);
                        }
                        catch (Exception e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            Message m = ProtocolMessages.ERR_LDAP_CLIENT_DECODE_ASN1_FAILED.get(String.valueOf(e));
                            this.disconnect(DisconnectReason.PROTOCOL_ERROR, true, m);
                            return false;
                        }
                        try {
                            requestMessage = LDAPMessage.decode(requestSequence);
                            TRACER.debugProtocolElement(DebugLogLevel.VERBOSE, requestMessage);
                        }
                        catch (Exception e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            Message m = ProtocolMessages.ERR_LDAP_CLIENT_DECODE_LDAP_MESSAGE_FAILED.get(String.valueOf(e));
                            this.disconnect(DisconnectReason.PROTOCOL_ERROR, true, m);
                            return false;
                        }
                        if (this.processLDAPMessage(requestMessage)) continue block10;
                        return false;
                    }
                    buffer.get(this.elementValue, this.elementValueBytesRead, bytesAvailable);
                    this.elementValueBytesRead += bytesAvailable;
                    this.elementValueBytesNeeded -= bytesAvailable;
                    return true;
                }
            }
            Message message = ProtocolMessages.ERR_LDAP_CLIENT_INVALID_DECODE_STATE.get(this.elementReadState);
            ErrorLogger.logError(message);
            this.disconnect(DisconnectReason.SERVER_ERROR, true, message);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processLDAPMessage(LDAPMessage message) {
        ArrayList<Control> opControls;
        if (this.keepStats) {
            this.statTracker.updateMessageRead(message);
            this.getNetworkGroup().updateMessageRead(message);
        }
        Object object = this.operationsPerformedLock;
        synchronized (object) {
            ++this.operationsPerformed;
        }
        ArrayList<LDAPControl> ldapControls = message.getControls();
        if (ldapControls == null || ldapControls.isEmpty()) {
            opControls = null;
        } else {
            opControls = new ArrayList<Control>(ldapControls.size());
            for (LDAPControl c : ldapControls) {
                opControls.add(c.getControl());
            }
        }
        try {
            switch (message.getProtocolOpType()) {
                case 80: {
                    return this.processAbandonRequest(message, opControls);
                }
                case 104: {
                    return this.processAddRequest(message, opControls);
                }
                case 96: {
                    return this.processBindRequest(message, opControls);
                }
                case 110: {
                    return this.processCompareRequest(message, opControls);
                }
                case 74: {
                    return this.processDeleteRequest(message, opControls);
                }
                case 119: {
                    return this.processExtendedRequest(message, opControls);
                }
                case 102: {
                    return this.processModifyRequest(message, opControls);
                }
                case 108: {
                    return this.processModifyDNRequest(message, opControls);
                }
                case 99: {
                    return this.processSearchRequest(message, opControls);
                }
                case 66: {
                    return this.processUnbindRequest(message, opControls);
                }
            }
            Message msg = ProtocolMessages.ERR_LDAP_DISCONNECT_DUE_TO_INVALID_REQUEST_TYPE.get(message.getProtocolOpName(), message.getMessageID());
            this.disconnect(DisconnectReason.PROTOCOL_ERROR, true, msg);
            return false;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message msg = ProtocolMessages.ERR_LDAP_DISCONNECT_DUE_TO_PROCESSING_FAILURE.get(message.getProtocolOpName(), message.getMessageID(), String.valueOf(e));
            this.disconnect(DisconnectReason.SERVER_ERROR, true, msg);
            return false;
        }
    }

    private boolean processAbandonRequest(LDAPMessage message, ArrayList<Control> controls) {
        AbandonRequestProtocolOp protocolOp = message.getAbandonRequestProtocolOp();
        AbandonOperationBasis abandonOp = new AbandonOperationBasis(this, this.nextOperationID.getAndIncrement(), message.getMessageID(), controls, protocolOp.getIDToAbandon());
        abandonOp.run();
        if (this.keepStats && abandonOp.getResultCode() == ResultCode.CANCELED) {
            this.statTracker.updateAbandonedOperation();
        }
        return this.connectionValid;
    }

    private boolean processAddRequest(LDAPMessage message, ArrayList<Control> controls) {
        if (this.ldapVersion == 2 && controls != null && !controls.isEmpty()) {
            AddResponseProtocolOp responseOp = new AddResponseProtocolOp(2, ProtocolMessages.ERR_LDAPV2_CONTROLS_NOT_ALLOWED.get());
            this.sendLDAPMessage(this.securityProvider, new LDAPMessage(message.getMessageID(), responseOp));
            this.disconnect(DisconnectReason.PROTOCOL_ERROR, false, ProtocolMessages.ERR_LDAPV2_CONTROLS_NOT_ALLOWED.get());
            return false;
        }
        AddRequestProtocolOp protocolOp = message.getAddRequestProtocolOp();
        AddOperationBasis addOp = new AddOperationBasis(this, this.nextOperationID.getAndIncrement(), message.getMessageID(), controls, protocolOp.getDN(), protocolOp.getAttributes());
        try {
            this.addOperationInProgress(addOp);
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            AddResponseProtocolOp responseOp = new AddResponseProtocolOp(de.getResultCode().getIntValue(), de.getMessageObject(), de.getMatchedDN(), de.getReferralURLs());
            List responseControls = addOp.getResponseControls();
            ArrayList<LDAPControl> responseLDAPControls = new ArrayList<LDAPControl>(responseControls.size());
            for (Control c : responseControls) {
                responseLDAPControls.add(new LDAPControl(c));
            }
            this.sendLDAPMessage(this.securityProvider, new LDAPMessage(message.getMessageID(), responseOp, responseLDAPControls));
        }
        return this.connectionValid;
    }

    private boolean processBindRequest(LDAPMessage message, ArrayList<Control> controls) {
        block13: {
            BindOperationBasis bindOp;
            String versionString;
            BindRequestProtocolOp protocolOp = message.getBindRequestProtocolOp();
            this.ldapVersion = protocolOp.getProtocolVersion();
            switch (this.ldapVersion) {
                case 2: {
                    versionString = "2";
                    if (!this.connectionHandler.allowLDAPv2()) {
                        BindResponseProtocolOp responseOp = new BindResponseProtocolOp(48, ProtocolMessages.ERR_LDAPV2_CLIENTS_NOT_ALLOWED.get());
                        this.sendLDAPMessage(this.securityProvider, new LDAPMessage(message.getMessageID(), responseOp));
                        this.disconnect(DisconnectReason.PROTOCOL_ERROR, false, ProtocolMessages.ERR_LDAPV2_CLIENTS_NOT_ALLOWED.get());
                        return false;
                    }
                    if (controls == null || controls.isEmpty()) break;
                    BindResponseProtocolOp responseOp = new BindResponseProtocolOp(2, ProtocolMessages.ERR_LDAPV2_CONTROLS_NOT_ALLOWED.get());
                    this.sendLDAPMessage(this.securityProvider, new LDAPMessage(message.getMessageID(), responseOp));
                    this.disconnect(DisconnectReason.PROTOCOL_ERROR, false, ProtocolMessages.ERR_LDAPV2_CONTROLS_NOT_ALLOWED.get());
                    return false;
                }
                case 3: {
                    versionString = "3";
                    break;
                }
                default: {
                    versionString = String.valueOf(this.ldapVersion);
                }
            }
            ASN1OctetString bindDN = protocolOp.getDN();
            switch (protocolOp.getAuthenticationType()) {
                case SIMPLE: {
                    bindOp = new BindOperationBasis((ClientConnection)this, this.nextOperationID.getAndIncrement(), message.getMessageID(), controls, versionString, bindDN, (ByteString)protocolOp.getSimplePassword());
                    break;
                }
                case SASL: {
                    bindOp = new BindOperationBasis((ClientConnection)this, this.nextOperationID.getAndIncrement(), message.getMessageID(), controls, versionString, bindDN, protocolOp.getSASLMechanism(), protocolOp.getSASLCredentials());
                    break;
                }
                default: {
                    Message msg = ProtocolMessages.ERR_LDAP_INVALID_BIND_AUTH_TYPE.get(message.getMessageID(), String.valueOf((Object)protocolOp.getAuthenticationType()));
                    this.disconnect(DisconnectReason.PROTOCOL_ERROR, true, msg);
                    return false;
                }
            }
            try {
                this.addOperationInProgress(bindOp);
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                BindResponseProtocolOp responseOp = new BindResponseProtocolOp(de.getResultCode().getIntValue(), de.getMessageObject(), de.getMatchedDN(), de.getReferralURLs());
                List<Control> responseControls = bindOp.getResponseControls();
                ArrayList<LDAPControl> responseLDAPControls = new ArrayList<LDAPControl>(responseControls.size());
                for (Control c : responseControls) {
                    responseLDAPControls.add(new LDAPControl(c));
                }
                this.sendLDAPMessage(this.securityProvider, new LDAPMessage(message.getMessageID(), responseOp, responseLDAPControls));
                if (de.getResultCode() != ResultCode.PROTOCOL_ERROR) break block13;
                Message msg = ProtocolMessages.ERR_LDAP_DISCONNECT_DUE_TO_BIND_PROTOCOL_ERROR.get(message.getMessageID(), de.getMessageObject());
                this.disconnect(DisconnectReason.PROTOCOL_ERROR, true, msg);
            }
        }
        return this.connectionValid;
    }

    private boolean processCompareRequest(LDAPMessage message, ArrayList<Control> controls) {
        if (this.ldapVersion == 2 && controls != null && !controls.isEmpty()) {
            CompareResponseProtocolOp responseOp = new CompareResponseProtocolOp(2, ProtocolMessages.ERR_LDAPV2_CONTROLS_NOT_ALLOWED.get());
            this.sendLDAPMessage(this.securityProvider, new LDAPMessage(message.getMessageID(), responseOp));
            this.disconnect(DisconnectReason.PROTOCOL_ERROR, false, ProtocolMessages.ERR_LDAPV2_CONTROLS_NOT_ALLOWED.get());
            return false;
        }
        CompareRequestProtocolOp protocolOp = message.getCompareRequestProtocolOp();
        CompareOperationBasis compareOp = new CompareOperationBasis((ClientConnection)this, this.nextOperationID.getAndIncrement(), message.getMessageID(), controls, protocolOp.getDN(), protocolOp.getAttributeType(), (ByteString)protocolOp.getAssertionValue());
        try {
            this.addOperationInProgress(compareOp);
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            CompareResponseProtocolOp responseOp = new CompareResponseProtocolOp(de.getResultCode().getIntValue(), de.getMessageObject(), de.getMatchedDN(), de.getReferralURLs());
            List<Control> responseControls = compareOp.getResponseControls();
            ArrayList<LDAPControl> responseLDAPControls = new ArrayList<LDAPControl>(responseControls.size());
            for (Control c : responseControls) {
                responseLDAPControls.add(new LDAPControl(c));
            }
            this.sendLDAPMessage(this.securityProvider, new LDAPMessage(message.getMessageID(), responseOp, responseLDAPControls));
        }
        return this.connectionValid;
    }

    private boolean processDeleteRequest(LDAPMessage message, ArrayList<Control> controls) {
        if (this.ldapVersion == 2 && controls != null && !controls.isEmpty()) {
            DeleteResponseProtocolOp responseOp = new DeleteResponseProtocolOp(2, ProtocolMessages.ERR_LDAPV2_CONTROLS_NOT_ALLOWED.get());
            this.sendLDAPMessage(this.securityProvider, new LDAPMessage(message.getMessageID(), responseOp));
            this.disconnect(DisconnectReason.PROTOCOL_ERROR, false, ProtocolMessages.ERR_LDAPV2_CONTROLS_NOT_ALLOWED.get());
            return false;
        }
        DeleteRequestProtocolOp protocolOp = message.getDeleteRequestProtocolOp();
        DeleteOperationBasis deleteOp = new DeleteOperationBasis((ClientConnection)this, this.nextOperationID.getAndIncrement(), message.getMessageID(), controls, protocolOp.getDN());
        try {
            this.addOperationInProgress(deleteOp);
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            DeleteResponseProtocolOp responseOp = new DeleteResponseProtocolOp(de.getResultCode().getIntValue(), de.getMessageObject(), de.getMatchedDN(), de.getReferralURLs());
            List<Control> responseControls = deleteOp.getResponseControls();
            ArrayList<LDAPControl> responseLDAPControls = new ArrayList<LDAPControl>(responseControls.size());
            for (Control c : responseControls) {
                responseLDAPControls.add(new LDAPControl(c));
            }
            this.sendLDAPMessage(this.securityProvider, new LDAPMessage(message.getMessageID(), responseOp, responseLDAPControls));
        }
        return this.connectionValid;
    }

    private boolean processExtendedRequest(LDAPMessage message, ArrayList<Control> controls) {
        if (this.ldapVersion == 2) {
            Message msg = ProtocolMessages.ERR_LDAPV2_EXTENDED_REQUEST_NOT_ALLOWED.get(this.getConnectionID(), message.getMessageID());
            ErrorLogger.logError(msg);
            this.disconnect(DisconnectReason.PROTOCOL_ERROR, false, msg);
            return false;
        }
        ExtendedRequestProtocolOp protocolOp = message.getExtendedRequestProtocolOp();
        ExtendedOperationBasis extendedOp = new ExtendedOperationBasis(this, this.nextOperationID.getAndIncrement(), message.getMessageID(), controls, protocolOp.getOID(), protocolOp.getValue());
        try {
            this.addOperationInProgress(extendedOp);
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            ExtendedResponseProtocolOp responseOp = new ExtendedResponseProtocolOp(de.getResultCode().getIntValue(), de.getMessageObject(), de.getMatchedDN(), de.getReferralURLs());
            List<Control> responseControls = extendedOp.getResponseControls();
            ArrayList<LDAPControl> responseLDAPControls = new ArrayList<LDAPControl>(responseControls.size());
            for (Control c : responseControls) {
                responseLDAPControls.add(new LDAPControl(c));
            }
            this.sendLDAPMessage(this.securityProvider, new LDAPMessage(message.getMessageID(), responseOp, responseLDAPControls));
        }
        return this.connectionValid;
    }

    private boolean processModifyRequest(LDAPMessage message, ArrayList<Control> controls) {
        if (this.ldapVersion == 2 && controls != null && !controls.isEmpty()) {
            ModifyResponseProtocolOp responseOp = new ModifyResponseProtocolOp(2, ProtocolMessages.ERR_LDAPV2_CONTROLS_NOT_ALLOWED.get());
            this.sendLDAPMessage(this.securityProvider, new LDAPMessage(message.getMessageID(), responseOp));
            this.disconnect(DisconnectReason.PROTOCOL_ERROR, false, ProtocolMessages.ERR_LDAPV2_CONTROLS_NOT_ALLOWED.get());
            return false;
        }
        ModifyRequestProtocolOp protocolOp = message.getModifyRequestProtocolOp();
        ModifyOperationBasis modifyOp = new ModifyOperationBasis((ClientConnection)this, this.nextOperationID.getAndIncrement(), message.getMessageID(), controls, protocolOp.getDN(), protocolOp.getModifications());
        try {
            this.addOperationInProgress(modifyOp);
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            ModifyResponseProtocolOp responseOp = new ModifyResponseProtocolOp(de.getResultCode().getIntValue(), de.getMessageObject(), de.getMatchedDN(), de.getReferralURLs());
            List<Control> responseControls = modifyOp.getResponseControls();
            ArrayList<LDAPControl> responseLDAPControls = new ArrayList<LDAPControl>(responseControls.size());
            for (Control c : responseControls) {
                responseLDAPControls.add(new LDAPControl(c));
            }
            this.sendLDAPMessage(this.securityProvider, new LDAPMessage(message.getMessageID(), responseOp, responseLDAPControls));
        }
        return this.connectionValid;
    }

    private boolean processModifyDNRequest(LDAPMessage message, ArrayList<Control> controls) {
        if (this.ldapVersion == 2 && controls != null && !controls.isEmpty()) {
            ModifyDNResponseProtocolOp responseOp = new ModifyDNResponseProtocolOp(2, ProtocolMessages.ERR_LDAPV2_CONTROLS_NOT_ALLOWED.get());
            this.sendLDAPMessage(this.securityProvider, new LDAPMessage(message.getMessageID(), responseOp));
            this.disconnect(DisconnectReason.PROTOCOL_ERROR, false, ProtocolMessages.ERR_LDAPV2_CONTROLS_NOT_ALLOWED.get());
            return false;
        }
        ModifyDNRequestProtocolOp protocolOp = message.getModifyDNRequestProtocolOp();
        ModifyDNOperationBasis modifyDNOp = new ModifyDNOperationBasis((ClientConnection)this, this.nextOperationID.getAndIncrement(), message.getMessageID(), controls, protocolOp.getEntryDN(), protocolOp.getNewRDN(), protocolOp.deleteOldRDN(), protocolOp.getNewSuperior());
        try {
            this.addOperationInProgress(modifyDNOp);
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            ModifyDNResponseProtocolOp responseOp = new ModifyDNResponseProtocolOp(de.getResultCode().getIntValue(), de.getMessageObject(), de.getMatchedDN(), de.getReferralURLs());
            List<Control> responseControls = modifyDNOp.getResponseControls();
            ArrayList<LDAPControl> responseLDAPControls = new ArrayList<LDAPControl>(responseControls.size());
            for (Control c : responseControls) {
                responseLDAPControls.add(new LDAPControl(c));
            }
            this.sendLDAPMessage(this.securityProvider, new LDAPMessage(message.getMessageID(), responseOp, responseLDAPControls));
        }
        return this.connectionValid;
    }

    private boolean processSearchRequest(LDAPMessage message, ArrayList<Control> controls) {
        if (this.ldapVersion == 2 && controls != null && !controls.isEmpty()) {
            SearchResultDoneProtocolOp responseOp = new SearchResultDoneProtocolOp(2, ProtocolMessages.ERR_LDAPV2_CONTROLS_NOT_ALLOWED.get());
            this.sendLDAPMessage(this.securityProvider, new LDAPMessage(message.getMessageID(), responseOp));
            this.disconnect(DisconnectReason.PROTOCOL_ERROR, false, ProtocolMessages.ERR_LDAPV2_CONTROLS_NOT_ALLOWED.get());
            return false;
        }
        SearchRequestProtocolOp protocolOp = message.getSearchRequestProtocolOp();
        SearchOperationBasis searchOp = new SearchOperationBasis((ClientConnection)this, this.nextOperationID.getAndIncrement(), message.getMessageID(), controls, protocolOp.getBaseDN(), protocolOp.getScope(), protocolOp.getDereferencePolicy(), protocolOp.getSizeLimit(), protocolOp.getTimeLimit(), protocolOp.getTypesOnly(), protocolOp.getFilter(), protocolOp.getAttributes());
        try {
            this.addOperationInProgress(searchOp);
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            SearchResultDoneProtocolOp responseOp = new SearchResultDoneProtocolOp(de.getResultCode().getIntValue(), de.getMessageObject(), de.getMatchedDN(), de.getReferralURLs());
            List<Control> responseControls = searchOp.getResponseControls();
            ArrayList<LDAPControl> responseLDAPControls = new ArrayList<LDAPControl>(responseControls.size());
            for (Control c : responseControls) {
                responseLDAPControls.add(new LDAPControl(c));
            }
            this.sendLDAPMessage(this.securityProvider, new LDAPMessage(message.getMessageID(), responseOp, responseLDAPControls));
        }
        return this.connectionValid;
    }

    private boolean processUnbindRequest(LDAPMessage message, ArrayList<Control> controls) {
        UnbindOperationBasis unbindOp = new UnbindOperationBasis((ClientConnection)this, this.nextOperationID.getAndIncrement(), message.getMessageID(), controls);
        unbindOp.run();
        return false;
    }

    @Override
    public String getMonitorSummary() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("connID=\"");
        buffer.append(this.connectionID);
        buffer.append("\" connectTime=\"");
        buffer.append(this.getConnectTimeString());
        buffer.append("\" source=\"");
        buffer.append(this.clientAddress);
        buffer.append(":");
        buffer.append(this.clientPort);
        buffer.append("\" destination=\"");
        buffer.append(this.serverAddress);
        buffer.append(":");
        buffer.append(this.connectionHandler.getListenPort());
        buffer.append("\" ldapVersion=\"");
        buffer.append(this.ldapVersion);
        buffer.append("\" authDN=\"");
        DN authDN = this.getAuthenticationInfo().getAuthenticationDN();
        if (authDN != null) {
            authDN.toString(buffer);
        }
        buffer.append("\" security=\"");
        if (this.securityProvider.isSecure()) {
            buffer.append(this.securityProvider.getSecurityMechanismName());
        } else {
            buffer.append("none");
        }
        buffer.append("\" opsInProgress=\"");
        buffer.append(this.operationsInProgress.size());
        buffer.append("\"");
        return buffer.toString();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("LDAP client connection from ");
        buffer.append(this.clientAddress);
        buffer.append(":");
        buffer.append(this.clientPort);
        buffer.append(" to ");
        buffer.append(this.serverAddress);
        buffer.append(":");
        buffer.append(this.serverPort);
    }

    @Override
    public boolean tlsProtectionAvailable(MessageBuilder unavailableReason) {
        if (!(this.securityProvider instanceof NullConnectionSecurityProvider)) {
            unavailableReason.append(ProtocolMessages.ERR_LDAP_TLS_EXISTING_SECURITY_PROVIDER.get(this.securityProvider.getSecurityMechanismName()));
            return false;
        }
        if (!this.connectionHandler.allowStartTLS()) {
            unavailableReason.append(ProtocolMessages.ERR_LDAP_TLS_STARTTLS_NOT_ALLOWED.get());
            return false;
        }
        if (this.tlsSecurityProvider == null) {
            try {
                TLSConnectionSecurityProvider tlsProvider = new TLSConnectionSecurityProvider();
                tlsProvider.initializeConnectionSecurityProvider(null);
                tlsProvider.setSSLClientAuthPolicy(this.connectionHandler.getSSLClientAuthPolicy());
                tlsProvider.setEnabledProtocols(this.connectionHandler.getEnabledSSLProtocols());
                tlsProvider.setEnabledCipherSuites(this.connectionHandler.getEnabledSSLCipherSuites());
                this.tlsSecurityProvider = (TLSConnectionSecurityProvider)tlsProvider.newInstance(this, this.clientChannel);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                this.tlsSecurityProvider = null;
                unavailableReason.append(ProtocolMessages.ERR_LDAP_TLS_CANNOT_CREATE_TLS_PROVIDER.get(StaticUtils.stackTraceToSingleLineString(e)));
                return false;
            }
        }
        return true;
    }

    @Override
    public void enableTLSConnectionSecurityProvider() throws DirectoryException {
        if (this.tlsSecurityProvider == null) {
            Message message = ProtocolMessages.ERR_LDAP_TLS_NO_PROVIDER.get();
            this.disconnect(DisconnectReason.OTHER, false, message);
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        this.clearSecurityProvider = this.securityProvider;
        this.setConnectionSecurityProvider(this.tlsSecurityProvider);
    }

    @Override
    public void disableTLSConnectionSecurityProvider() throws DirectoryException {
        Message message = ProtocolMessages.ERR_LDAP_TLS_CLOSURE_NOT_ALLOWED.get();
        this.disconnect(DisconnectReason.OTHER, false, message);
        throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
    }

    @Override
    public void sendClearResponse(Operation operation) throws DirectoryException {
        if (this.clearSecurityProvider == null) {
            Message message = ProtocolMessages.ERR_LDAP_NO_CLEAR_SECURITY_PROVIDER.get(this.toString());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        this.sendLDAPMessage(this.clearSecurityProvider, this.operationToResponseLDAPMessage(operation));
    }

    @Override
    public DN getKeyManagerProviderDN() {
        return this.connectionHandler.getKeyManagerProviderDN();
    }

    @Override
    public DN getTrustManagerProviderDN() {
        return this.connectionHandler.getTrustManagerProviderDN();
    }

    @Override
    public String getCertificateAlias() {
        return this.connectionHandler.getSSLServerCertNickname();
    }

    @Override
    public long getIdleTime() {
        if (this.operationsInProgress.isEmpty() && this.getPersistentSearches().isEmpty()) {
            return TimeThread.getTime() - this.lastCompletionTime.get();
        }
        return 0L;
    }
}

