/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.plugin;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.opends.messages.Message;
import org.opends.messages.ReplicationMessages;
import org.opends.server.api.DirectoryThread;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.plugin.ReplicationDomain;
import org.opends.server.replication.plugin.UpdateToReplay;
import org.opends.server.replication.protocol.UpdateMsg;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerThread
extends DirectoryThread {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ReplicationDomain repDomain;
    private boolean shutdown = false;
    private boolean done = false;
    private LinkedBlockingQueue<UpdateToReplay> updateToReplayQueue;

    public ListenerThread(ReplicationDomain repDomain, LinkedBlockingQueue<UpdateToReplay> updateToReplayQueue) {
        super("Replication Listener for server id " + repDomain.getServerId() + " and domain " + repDomain.getBaseDN());
        this.repDomain = repDomain;
        this.updateToReplayQueue = updateToReplayQueue;
    }

    public void shutdown() {
        this.shutdown = true;
    }

    @Override
    public void run() {
        UpdateMsg updateMsg = null;
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Replication Listener thread starting.");
        }
        while (!this.shutdown) {
            try {
                while (!this.shutdown && (updateMsg = this.repDomain.receive()) != null) {
                    UpdateToReplay updateToReplay = new UpdateToReplay(updateMsg, this.repDomain);
                    boolean queued = false;
                    while (!queued && !this.shutdown) {
                        queued = this.updateToReplayQueue.offer(updateToReplay, 1L, TimeUnit.SECONDS);
                    }
                    if (queued) continue;
                    this.updateToReplayQueue.offer(updateToReplay);
                }
                if (updateMsg != null) continue;
                this.shutdown = true;
            }
            catch (Exception e) {
                Message message = ReplicationMessages.ERR_EXCEPTION_RECEIVING_REPLICATION_MESSAGE.get(StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
            }
        }
        this.repDomain.getBroker().stopHeartBeat();
        this.done = true;
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Replication Listener thread stopping.");
        }
    }

    public void waitForShutdown() {
        try {
            int FACTOR = 40;
            int n = 0;
            while (!this.done && this.isAlive()) {
                Thread.sleep(50L);
                if (++n < FACTOR) continue;
                TRACER.debugInfo("Interrupting listener thread for dn " + this.repDomain.getBaseDN() + " in DS " + this.repDomain.getServerId());
                this.interrupt();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

