/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.plugin;

import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.common.ChangeNumberGenerator;
import org.opends.server.replication.common.ServerState;
import org.opends.server.replication.plugin.PendingChange;
import org.opends.server.replication.plugin.ReplicationBroker;
import org.opends.server.replication.protocol.UpdateMsg;
import org.opends.server.types.operation.PluginOperation;

public class PendingChanges {
    private SortedMap<ChangeNumber, PendingChange> pendingChanges = new TreeMap<ChangeNumber, PendingChange>();
    private ChangeNumberGenerator changeNumberGenerator;
    private ReplicationBroker broker;
    private ServerState state;

    public PendingChanges(ChangeNumberGenerator changeNumberGenerator, ReplicationBroker broker, ServerState state) {
        this.changeNumberGenerator = changeNumberGenerator;
        this.broker = broker;
        this.state = state;
    }

    public synchronized UpdateMsg remove(ChangeNumber changeNumber) {
        return ((PendingChange)this.pendingChanges.remove(changeNumber)).getMsg();
    }

    public int size() {
        return this.pendingChanges.size();
    }

    public synchronized void commit(ChangeNumber changeNumber, UpdateMsg msg) {
        PendingChange curChange = (PendingChange)this.pendingChanges.get(changeNumber);
        if (curChange == null) {
            throw new NoSuchElementException();
        }
        curChange.setCommitted(true);
        curChange.setMsg(msg);
    }

    public synchronized void commit(ChangeNumber changeNumber) {
        PendingChange curChange = (PendingChange)this.pendingChanges.get(changeNumber);
        if (curChange == null) {
            throw new NoSuchElementException();
        }
        curChange.setCommitted(true);
    }

    public synchronized ChangeNumber putLocalOperation(PluginOperation operation) {
        ChangeNumber changeNumber = this.changeNumberGenerator.newChangeNumber();
        PendingChange change = new PendingChange(changeNumber, operation, null);
        this.pendingChanges.put(changeNumber, change);
        return changeNumber;
    }

    public synchronized int pushCommittedChanges() {
        int numSentUpdates = 0;
        if (this.pendingChanges.isEmpty()) {
            return numSentUpdates;
        }
        ChangeNumber firstChangeNumber = this.pendingChanges.firstKey();
        PendingChange firstChange = (PendingChange)this.pendingChanges.get(firstChangeNumber);
        while (firstChange != null && firstChange.isCommitted()) {
            if (firstChange.getOp() != null && !firstChange.getOp().isSynchronizationOperation()) {
                ++numSentUpdates;
                this.broker.publish(firstChange.getMsg());
            }
            this.state.update(firstChangeNumber);
            this.pendingChanges.remove(firstChangeNumber);
            if (this.pendingChanges.isEmpty()) {
                firstChange = null;
                continue;
            }
            firstChangeNumber = this.pendingChanges.firstKey();
            firstChange = (PendingChange)this.pendingChanges.get(firstChangeNumber);
        }
        return numSentUpdates;
    }
}

