/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.plugin;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.opends.messages.Category;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ReplicationMessages;
import org.opends.messages.Severity;
import org.opends.server.api.DirectoryThread;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchListener;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.common.RSInfo;
import org.opends.server.replication.common.ServerState;
import org.opends.server.replication.common.ServerStatus;
import org.opends.server.replication.plugin.FakeOperation;
import org.opends.server.replication.plugin.FakeOperationComparator;
import org.opends.server.replication.plugin.HeartbeatMonitor;
import org.opends.server.replication.plugin.Historical;
import org.opends.server.replication.plugin.ReplicationDomain;
import org.opends.server.replication.protocol.ChangeStatusMsg;
import org.opends.server.replication.protocol.ProtocolSession;
import org.opends.server.replication.protocol.ProtocolVersion;
import org.opends.server.replication.protocol.ReplServerStartMsg;
import org.opends.server.replication.protocol.ReplSessionSecurity;
import org.opends.server.replication.protocol.ReplicationMsg;
import org.opends.server.replication.protocol.ServerStartMsg;
import org.opends.server.replication.protocol.StartSessionMsg;
import org.opends.server.replication.protocol.TopologyMsg;
import org.opends.server.replication.protocol.UpdateMsg;
import org.opends.server.replication.protocol.WindowMsg;
import org.opends.server.replication.protocol.WindowProbeMsg;
import org.opends.server.types.DN;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchResultReference;
import org.opends.server.types.SearchScope;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationBroker
implements InternalSearchListener {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private boolean shutdown = false;
    private Collection<String> servers;
    private boolean connected = false;
    private String replicationServer = "Not connected";
    private TreeSet<FakeOperation> replayOperations;
    private ProtocolSession session = null;
    private final ServerState state;
    private final DN baseDn;
    private final short serverId;
    private int maxSendDelay;
    private int maxReceiveDelay;
    private int maxSendQueue;
    private int maxReceiveQueue;
    private Semaphore sendWindow;
    private int maxSendWindow;
    private int rcvWindow;
    private int halfRcvWindow;
    private int maxRcvWindow;
    private int timeout = 0;
    private short protocolVersion;
    private long generationId = -1L;
    private ReplSessionSecurity replSessionSecurity;
    private byte groupId = (byte)-1;
    private byte rsGroupId = (byte)-1;
    private short rsServerId = (short)-1;
    private String rsServerUrl = null;
    private ReplicationDomain replicationDomain = null;
    private String tmpReadableServerName = null;
    private long heartbeatInterval = 0L;
    private HeartbeatMonitor heartbeatMonitor = null;
    private int numLostConnections = 0;
    private boolean connectionError = false;
    private final Object connectPhaseLock = new Object();
    private SameGroupIdPoller sameGroupIdPoller = null;

    public ReplicationBroker(ReplicationDomain replicationDomain, ServerState state, DN baseDn, short serverId, int maxReceiveQueue, int maxReceiveDelay, int maxSendQueue, int maxSendDelay, int window, long heartbeatInterval, long generationId, ReplSessionSecurity replSessionSecurity, byte groupId) {
        this.replicationDomain = replicationDomain;
        this.baseDn = baseDn;
        this.serverId = serverId;
        this.maxReceiveDelay = maxReceiveDelay;
        this.maxSendDelay = maxSendDelay;
        this.maxReceiveQueue = maxReceiveQueue;
        this.maxSendQueue = maxSendQueue;
        this.state = state;
        this.replayOperations = new TreeSet<FakeOperation>(new FakeOperationComparator());
        this.rcvWindow = window;
        this.maxRcvWindow = window;
        this.halfRcvWindow = window / 2;
        this.heartbeatInterval = heartbeatInterval;
        this.protocolVersion = ProtocolVersion.getCurrentVersion();
        this.generationId = generationId;
        this.replSessionSecurity = replSessionSecurity;
        this.groupId = groupId;
    }

    public void start(Collection<String> servers) {
        this.shutdown = false;
        this.servers = servers;
        if (servers.size() < 1) {
            Message message = ReplicationMessages.NOTE_NEED_MORE_THAN_ONE_CHANGELOG_SERVER.get();
            ErrorLogger.logError(message);
        }
        this.rcvWindow = this.maxRcvWindow;
        this.connect();
    }

    public byte getRsGroupId() {
        return this.rsGroupId;
    }

    public short getRsServerId() {
        return this.rsServerId;
    }

    public short getServerId() {
        return this.serverId;
    }

    public String getRsServerUrl() {
        return this.rsServerUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() {
        HashMap<String, ServerInfo> rsInfos = new HashMap<String, ServerInfo>();
        if (this.replicationDomain != null) {
            this.replicationDomain.toNotConnectedStatus();
        }
        this.stopSameGroupIdPoller();
        this.stopHeartBeat();
        boolean newServerWithSameGroupId = false;
        Object object = this.connectPhaseLock;
        synchronized (object) {
            Message message;
            String bestServer;
            for (String server : this.servers) {
                ReplServerStartMsg replServerStartMsg = this.performPhaseOneHandshake(server, false);
                if (replServerStartMsg == null) continue;
                ServerInfo serverInfo = new ServerInfo(replServerStartMsg.getServerState(), replServerStartMsg.getGroupId());
                rsInfos.put(server, serverInfo);
            }
            ReplServerStartMsg replServerStartMsg = null;
            if (rsInfos.size() > 0 && (replServerStartMsg = this.performPhaseOneHandshake(bestServer = ReplicationBroker.computeBestReplicationServer(this.state, rsInfos, this.serverId, this.baseDn, this.groupId), true)) != null) {
                ServerInfo bestServerInfo = rsInfos.get(bestServer);
                ServerStatus initStatus = this.computeInitialServerStatus(replServerStartMsg.getGenerationId(), bestServerInfo.getServerState(), replServerStartMsg.getDegradedStatusThreshold(), this.generationId);
                TopologyMsg topologyMsg = this.performPhaseTwoHandshake(bestServer, initStatus);
                if (topologyMsg != null) {
                    try {
                        byte tmpRsGroupId = bestServerInfo.getGroupId();
                        boolean someServersWithSameGroupId = this.hasSomeServerWithSameGroupId(topologyMsg.getRsList());
                        if (tmpRsGroupId == this.groupId || tmpRsGroupId != this.groupId && !someServersWithSameGroupId) {
                            Message message2;
                            ChangeNumber ourMaxChangeNumber;
                            ChangeNumber replServerMaxChangeNumber = replServerStartMsg.getServerState().getMaxChangeNumber(this.serverId);
                            if (replServerMaxChangeNumber == null) {
                                replServerMaxChangeNumber = new ChangeNumber(0L, 0, this.serverId);
                            }
                            if ((ourMaxChangeNumber = this.state.getMaxChangeNumber(this.serverId)) != null && !ourMaxChangeNumber.olderOrEqual(replServerMaxChangeNumber).booleanValue()) {
                                message2 = ReplicationMessages.DEBUG_GOING_TO_SEARCH_FOR_CHANGES.get();
                                ErrorLogger.logError(message2);
                                InternalSearchOperation op = ReplicationBroker.searchForChangedEntries(this.baseDn, replServerMaxChangeNumber, this);
                                if (op.getResultCode() != ResultCode.SUCCESS) {
                                    message2 = ReplicationMessages.ERR_CANNOT_RECOVER_CHANGES.get(this.baseDn.toNormalizedString());
                                    ErrorLogger.logError(message2);
                                } else {
                                    for (FakeOperation replayOp : this.replayOperations) {
                                        ChangeNumber cn = replayOp.getChangeNumber();
                                        if (!cn.newer(replServerMaxChangeNumber)) continue;
                                        message2 = ReplicationMessages.DEBUG_SENDING_CHANGE.get(replayOp.getChangeNumber().toString());
                                        ErrorLogger.logError(message2);
                                        this.session.publish(replayOp.generateMessage());
                                    }
                                    message2 = ReplicationMessages.DEBUG_CHANGES_SENT.get();
                                    ErrorLogger.logError(message2);
                                }
                                this.replayOperations.clear();
                            }
                            this.replicationServer = this.tmpReadableServerName;
                            this.maxSendWindow = replServerStartMsg.getWindowSize();
                            this.rsGroupId = replServerStartMsg.getGroupId();
                            this.rsServerId = replServerStartMsg.getServerId();
                            this.rsServerUrl = bestServer;
                            if (this.replicationDomain != null) {
                                this.replicationDomain.setInitialStatus(initStatus);
                                this.replicationDomain.receiveTopo(topologyMsg);
                            }
                            this.connected = true;
                            if (this.getRsGroupId() != this.groupId) {
                                message2 = ReplicationMessages.WARN_CONNECTED_TO_SERVER_WITH_WRONG_GROUP_ID.get(Byte.toString(this.groupId), Short.toString(this.rsServerId), bestServer, Byte.toString(this.getRsGroupId()), this.baseDn.toString(), Short.toString(this.serverId));
                                ErrorLogger.logError(message2);
                                this.startSameGroupIdPoller();
                            }
                            this.startHeartBeat();
                        } else {
                            Message message3 = ReplicationMessages.NOTE_NEW_SERVER_WITH_SAME_GROUP_ID.get(Byte.toString(this.groupId), this.baseDn.toString(), Short.toString(this.serverId));
                            ErrorLogger.logError(message3);
                            newServerWithSameGroupId = true;
                        }
                    }
                    catch (IOException e) {
                        Message message4 = ReplicationMessages.ERR_PUBLISHING_FAKE_OPS.get(this.baseDn.toNormalizedString(), bestServer, e.getLocalizedMessage() + StaticUtils.stackTraceToSingleLineString(e));
                        ErrorLogger.logError(message4);
                    }
                    catch (Exception e) {
                        Message message5 = ReplicationMessages.ERR_COMPUTING_FAKE_OPS.get(this.baseDn.toNormalizedString(), bestServer, e.getLocalizedMessage() + StaticUtils.stackTraceToSingleLineString(e));
                        ErrorLogger.logError(message5);
                    }
                    finally {
                        if (!this.connected && this.session != null) {
                            try {
                                this.session.close();
                            }
                            catch (IOException e) {}
                            this.session = null;
                        }
                    }
                }
            }
            if (this.connected) {
                this.connectionError = false;
                if (this.sendWindow != null) {
                    this.sendWindow.release(Integer.MAX_VALUE);
                }
                this.sendWindow = new Semaphore(this.maxSendWindow);
                this.connectPhaseLock.notify();
                if (replServerStartMsg.getGenerationId() == this.generationId || replServerStartMsg.getGenerationId() == -1L) {
                    message = ReplicationMessages.NOTE_NOW_FOUND_SAME_GENERATION_CHANGELOG.get(this.baseDn.toString(), Short.toString(this.rsServerId), this.replicationServer, Short.toString(this.serverId), Long.toString(this.generationId));
                    ErrorLogger.logError(message);
                } else {
                    message = ReplicationMessages.NOTE_NOW_FOUND_BAD_GENERATION_CHANGELOG.get(this.baseDn.toString(), this.replicationServer, Long.toString(this.generationId), Long.toString(replServerStartMsg.getGenerationId()));
                    ErrorLogger.logError(message);
                }
            } else if (!this.connectionError && !newServerWithSameGroupId) {
                this.connectionError = true;
                this.connectPhaseLock.notify();
                message = ReplicationMessages.NOTE_COULD_NOT_FIND_CHANGELOG.get(this.baseDn.toString());
                ErrorLogger.logError(message);
            }
        }
    }

    private boolean hasSomeServerWithSameGroupId(List<RSInfo> rsInfos) {
        for (RSInfo rsInfo : rsInfos) {
            if (rsInfo.getGroupId() != this.groupId) continue;
            return true;
        }
        return false;
    }

    public ServerStatus computeInitialServerStatus(long rsGenId, ServerState rsState, int degradedStatusThreshold, long dsGenId) {
        if (rsGenId == -1L) {
            return ServerStatus.NORMAL_STATUS;
        }
        if (rsGenId == dsGenId) {
            ServerStatus initStatus = ServerStatus.INVALID_STATUS;
            int nChanges = ServerState.diffChanges(rsState, this.state);
            if (this.debugEnabled()) {
                TRACER.debugInfo("RB for dn " + this.baseDn.toNormalizedString() + " and with server id " + Short.toString(this.serverId) + " computed " + Integer.toString(nChanges) + " changes late.");
            }
            initStatus = degradedStatusThreshold > 0 ? (nChanges >= degradedStatusThreshold ? ServerStatus.DEGRADED_STATUS : ServerStatus.NORMAL_STATUS) : ServerStatus.NORMAL_STATUS;
            return initStatus;
        }
        return ServerStatus.BAD_GEN_ID_STATUS;
    }

    private ReplServerStartMsg performPhaseOneHandshake(String server, boolean keepConnection) {
        ReplServerStartMsg replServerStartMsg = null;
        int separator = server.lastIndexOf(58);
        String port = server.substring(separator + 1);
        String hostname = server.substring(0, separator);
        ProtocolSession localSession = null;
        boolean error = false;
        try {
            DN repDn;
            int intPort = Integer.parseInt(port);
            InetSocketAddress serverAddr = new InetSocketAddress(InetAddress.getByName(hostname), intPort);
            if (keepConnection) {
                this.tmpReadableServerName = serverAddr.toString();
            }
            Socket socket = new Socket();
            socket.setReceiveBufferSize(1000000);
            socket.setTcpNoDelay(true);
            socket.connect(serverAddr, 500);
            localSession = this.replSessionSecurity.createClientSession(server, socket, 4000);
            boolean isSslEncryption = this.replSessionSecurity.isSslEncryption(server);
            ServerStartMsg serverStartMsg = new ServerStartMsg(this.serverId, this.baseDn, this.maxReceiveDelay, this.maxReceiveQueue, this.maxSendDelay, this.maxSendQueue, this.halfRcvWindow * 2, this.heartbeatInterval, this.state, ProtocolVersion.getCurrentVersion(), this.generationId, isSslEncryption, this.groupId);
            localSession.publish(serverStartMsg);
            replServerStartMsg = (ReplServerStartMsg)localSession.receive();
            if (this.debugEnabled()) {
                TRACER.debugInfo("In RB for " + this.baseDn + "\nRB HANDSHAKE SENT:\n" + serverStartMsg.toString() + "\nAND RECEIVED:\n" + replServerStartMsg.toString());
            }
            if (!this.baseDn.equals(repDn = replServerStartMsg.getBaseDn())) {
                Message message = ReplicationMessages.ERR_DS_DN_DOES_NOT_MATCH.get(repDn.toString(), this.baseDn.toString());
                ErrorLogger.logError(message);
                error = true;
            }
            if (keepConnection) {
                this.protocolVersion = ProtocolVersion.minWithCurrent(replServerStartMsg.getVersion());
            }
            if (!isSslEncryption) {
                localSession.stopEncryption();
            }
        }
        catch (ConnectException e) {
            if (!this.connectionError) {
                Message message = ReplicationMessages.NOTE_NO_CHANGELOG_SERVER_LISTENING.get(server);
                if (keepConnection) {
                    ErrorLogger.logError(message);
                } else if (this.debugEnabled()) {
                    TRACER.debugInfo(message.toString());
                }
            }
            error = true;
        }
        catch (Exception e) {
            if (e instanceof SocketTimeoutException && this.debugEnabled()) {
                TRACER.debugInfo("Timeout trying to connect to RS " + server + " for dn: " + this.baseDn.toNormalizedString());
            }
            Message message = ReplicationMessages.ERR_EXCEPTION_STARTING_SESSION_PHASE.get("1", this.baseDn.toNormalizedString(), server, e.getLocalizedMessage() + StaticUtils.stackTraceToSingleLineString(e));
            if (keepConnection) {
                ErrorLogger.logError(message);
            } else if (this.debugEnabled()) {
                TRACER.debugInfo(message.toString());
            }
            error = true;
        }
        if (!keepConnection || error) {
            if (localSession != null) {
                try {
                    localSession.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                localSession = null;
            }
            if (error) {
                replServerStartMsg = null;
            }
        }
        if (keepConnection) {
            this.session = localSession;
        }
        return replServerStartMsg;
    }

    private TopologyMsg performPhaseTwoHandshake(String server, ServerStatus initStatus) {
        TopologyMsg topologyMsg = null;
        try {
            StartSessionMsg startSessionMsg = null;
            startSessionMsg = this.replicationDomain != null ? new StartSessionMsg(initStatus, this.replicationDomain.getRefUrls(), this.replicationDomain.isAssured(), this.replicationDomain.getAssuredMode(), this.replicationDomain.getAssuredSdLevel()) : new StartSessionMsg(initStatus, new ArrayList<String>());
            this.session.publish(startSessionMsg);
            topologyMsg = (TopologyMsg)this.session.receive();
            if (this.debugEnabled()) {
                TRACER.debugInfo("In RB for " + this.baseDn + "\nRB HANDSHAKE SENT:\n" + startSessionMsg.toString() + "\nAND RECEIVED:\n" + topologyMsg.toString());
            }
            this.session.setSoTimeout(this.timeout);
        }
        catch (Exception e) {
            Message message = ReplicationMessages.ERR_EXCEPTION_STARTING_SESSION_PHASE.get("2", this.baseDn.toNormalizedString(), server, e.getLocalizedMessage() + StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(message);
            if (this.session != null) {
                try {
                    this.session.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                this.session = null;
            }
            topologyMsg = null;
        }
        return topologyMsg;
    }

    public static String computeBestReplicationServer(ServerState myState, HashMap<String, ServerInfo> rsInfos, short serverId, DN baseDn, byte groupId) {
        HashMap<String, ServerInfo> sameGroupIdRsInfos = new HashMap<String, ServerInfo>();
        for (String repServer : rsInfos.keySet()) {
            ServerInfo serverInfo = rsInfos.get(repServer);
            if (serverInfo.getGroupId() != groupId) continue;
            sameGroupIdRsInfos.put(repServer, serverInfo);
        }
        if (sameGroupIdRsInfos.size() > 0) {
            return ReplicationBroker.searchForBestReplicationServer(myState, sameGroupIdRsInfos, serverId, baseDn);
        }
        return ReplicationBroker.searchForBestReplicationServer(myState, rsInfos, serverId, baseDn);
    }

    private static String searchForBestReplicationServer(ServerState myState, HashMap<String, ServerInfo> rsInfos, short serverId, DN baseDn) {
        Message message;
        Iterator<String> i$;
        if (myState == null || rsInfos == null || rsInfos.size() < 1 || baseDn == null) {
            return null;
        }
        if (rsInfos.size() == 1 && (i$ = rsInfos.keySet().iterator()).hasNext()) {
            String repServer = i$.next();
            return repServer;
        }
        String bestServer = null;
        HashMap<String, ServerState> upToDateServers = new HashMap<String, ServerState>();
        HashMap<String, ServerState> lateOnes = new HashMap<String, ServerState>();
        ChangeNumber myChangeNumber = myState.getMaxChangeNumber(serverId);
        if (myChangeNumber == null) {
            myChangeNumber = new ChangeNumber(0L, 0, serverId);
        }
        for (String repServer : rsInfos.keySet()) {
            ServerState rsState = rsInfos.get(repServer).getServerState();
            ChangeNumber rsChangeNumber = rsState.getMaxChangeNumber(serverId);
            if (rsChangeNumber == null) {
                rsChangeNumber = new ChangeNumber(0L, 0, serverId);
            }
            if (myChangeNumber.olderOrEqual(rsChangeNumber).booleanValue()) {
                upToDateServers.put(repServer, rsState);
                continue;
            }
            lateOnes.put(repServer, rsState);
        }
        if (upToDateServers.size() > 0) {
            message = ReplicationMessages.NOTE_FOUND_CHANGELOGS_WITH_MY_CHANGES.get(upToDateServers.size(), baseDn.toNormalizedString(), Short.toString(serverId));
            ErrorLogger.logError(message);
            ServerState topoState = new ServerState();
            for (ServerState curState : upToDateServers.values()) {
                for (Short sId : curState) {
                    ChangeNumber curSidCn = curState.getMaxChangeNumber(sId);
                    if (curSidCn == null) {
                        curSidCn = new ChangeNumber(0L, 0, sId);
                    }
                    topoState.update(curSidCn);
                }
            }
            long minShift = -1L;
            for (String upServer : upToDateServers.keySet()) {
                long shift = -1L;
                ServerState curState = (ServerState)upToDateServers.get(upServer);
                for (Short sId : curState) {
                    ChangeNumber topoCurSidCn;
                    long tmpShift;
                    ChangeNumber curSidCn = curState.getMaxChangeNumber(sId);
                    if (curSidCn == null) {
                        curSidCn = new ChangeNumber(0L, 0, sId);
                    }
                    if ((tmpShift = (topoCurSidCn = topoState.getMaxChangeNumber(sId)).getTime() - curSidCn.getTime()) <= shift) continue;
                    shift = tmpShift;
                }
                if (minShift >= 0L && shift >= minShift) continue;
                bestServer = upServer;
                minShift = shift;
            }
        } else {
            message = ReplicationMessages.NOTE_COULD_NOT_FIND_CHANGELOG_WITH_MY_CHANGES.get(baseDn.toNormalizedString(), lateOnes.size());
            ErrorLogger.logError(message);
            long minShift = -1L;
            for (String lateServer : lateOnes.keySet()) {
                ServerState curState = (ServerState)lateOnes.get(lateServer);
                ChangeNumber ourSidCn = curState.getMaxChangeNumber(serverId);
                if (ourSidCn == null) {
                    ourSidCn = new ChangeNumber(0L, 0, serverId);
                }
                long tmpShift = myChangeNumber.getTime() - ourSidCn.getTime();
                if (minShift >= 0L && tmpShift >= minShift) continue;
                bestServer = lateServer;
                minShift = tmpShift;
            }
        }
        return bestServer;
    }

    public static InternalSearchOperation searchForChangedEntries(DN baseDn, ChangeNumber fromChangeNumber, InternalSearchListener resultListener) throws Exception {
        InternalClientConnection conn = InternalClientConnection.getRootConnection();
        Short serverId = fromChangeNumber.getServerId();
        String maxValueForId = "ffffffffffffffff" + String.format("%04x", serverId) + "ffffffff";
        LDAPFilter filter = LDAPFilter.decode("(&(ds-sync-hist>=dummy:" + fromChangeNumber + ")(" + "ds-sync-hist" + "<=dummy:" + maxValueForId + "))");
        LinkedHashSet<String> attrs = new LinkedHashSet<String>(1);
        attrs.add("ds-sync-hist");
        attrs.add("entryuuid");
        attrs.add("*");
        return conn.processSearch(new ASN1OctetString(baseDn.toString()), SearchScope.WHOLE_SUBTREE, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, filter, attrs, resultListener);
    }

    private void startHeartBeat() {
        if (this.heartbeatInterval > 0L) {
            this.heartbeatMonitor = new HeartbeatMonitor("Replication Heartbeat Monitor on RS " + this.getReplicationServer() + " " + this.rsServerId + " for " + this.baseDn + " in DS " + this.serverId, this.session, this.heartbeatInterval);
            this.heartbeatMonitor.start();
        }
    }

    private void startSameGroupIdPoller() {
        this.sameGroupIdPoller = new SameGroupIdPoller();
        this.sameGroupIdPoller.start();
    }

    private void stopSameGroupIdPoller() {
        if (this.sameGroupIdPoller != null) {
            this.sameGroupIdPoller.shutdown();
            this.sameGroupIdPoller.waitForShutdown();
            this.sameGroupIdPoller = null;
        }
    }

    void stopHeartBeat() {
        if (this.heartbeatMonitor != null) {
            this.heartbeatMonitor.shutdown();
            this.heartbeatMonitor = null;
        }
    }

    public void reStart() {
        this.reStart(this.session);
    }

    public void reStart(ProtocolSession failingSession) {
        try {
            if (failingSession != null) {
                failingSession.close();
                ++this.numLostConnections;
            }
        }
        catch (IOException e1) {
            // empty catch block
        }
        if (failingSession == this.session) {
            this.connected = false;
            this.rsGroupId = (byte)-1;
            this.rsServerId = (short)-1;
            this.rsServerUrl = null;
        }
        while (!this.connected && !this.shutdown) {
            try {
                this.connect();
            }
            catch (Exception e) {
                MessageBuilder mb = new MessageBuilder();
                mb.append(ReplicationMessages.NOTE_EXCEPTION_RESTARTING_SESSION.get(this.baseDn.toNormalizedString(), e.getLocalizedMessage()));
                mb.append(StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(mb.toMessage());
            }
            if (this.connected || this.shutdown) continue;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(ReplicationMsg msg) {
        boolean done = false;
        while (!done && !this.shutdown) {
            if (this.connectionError) {
                if (this.debugEnabled()) {
                    ReplicationBroker.debugInfo("ReplicationBroker.publish() Publishing a message is not possible due to existing connection error.");
                }
                return;
            }
            try {
                Semaphore currentWindowSemaphore;
                ProtocolSession current_session;
                Object object = this.connectPhaseLock;
                synchronized (object) {
                    current_session = this.session;
                    currentWindowSemaphore = this.sendWindow;
                }
                boolean credit = msg instanceof UpdateMsg ? currentWindowSemaphore.tryAcquire(500L, TimeUnit.MILLISECONDS) : true;
                if (credit) {
                    object = this.connectPhaseLock;
                    synchronized (object) {
                        if (this.session == current_session) {
                            this.session.publish(msg);
                            done = true;
                        }
                    }
                }
                if (credit) continue;
                this.session.publish(new WindowProbeMsg());
            }
            catch (IOException e) {
                Object object = this.connectPhaseLock;
                synchronized (object) {
                    block19: {
                        try {
                            this.connectPhaseLock.wait(100L);
                        }
                        catch (InterruptedException e1) {
                            if (!this.debugEnabled()) break block19;
                            ReplicationBroker.debugInfo("ReplicationBroker.publish() IO exception raised : " + e.getLocalizedMessage());
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                if (!this.debugEnabled()) continue;
                ReplicationBroker.debugInfo("ReplicationBroker.publish() Interrupted exception raised." + e.getLocalizedMessage());
            }
        }
    }

    public ReplicationMsg receive() throws SocketTimeoutException {
        while (!this.shutdown) {
            if (!this.connected) {
                this.reStart(null);
            }
            ProtocolSession failingSession = this.session;
            try {
                ReplicationMsg msg = this.session.receive();
                if (msg instanceof WindowMsg) {
                    WindowMsg windowMsg = (WindowMsg)msg;
                    this.sendWindow.release(windowMsg.getNumAck());
                    continue;
                }
                return msg;
            }
            catch (SocketTimeoutException e) {
                throw e;
            }
            catch (Exception e) {
                if (this.shutdown) continue;
                Message message = ReplicationMessages.NOTE_DISCONNECTED_FROM_CHANGELOG.get(this.replicationServer, Short.toString(this.rsServerId), this.baseDn.toString(), Short.toString(this.serverId));
                ErrorLogger.logError(message);
                ReplicationBroker.debugInfo("ReplicationBroker.receive() " + this.baseDn + " Exception raised: " + e.getLocalizedMessage());
                this.reStart(failingSession);
            }
        }
        return null;
    }

    public synchronized void updateWindowAfterReplay() {
        try {
            --this.rcvWindow;
            if (this.rcvWindow < this.halfRcvWindow && this.session != null) {
                this.session.publish(new WindowMsg(this.halfRcvWindow));
                this.rcvWindow += this.halfRcvWindow;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void stop() {
        if (this.debugEnabled()) {
            ReplicationBroker.debugInfo("ReplicationBroker " + this.serverId + " is stopping and will" + " close the connection to replication server " + this.rsServerId + " for" + " domain " + this.baseDn);
        }
        this.stopSameGroupIdPoller();
        this.stopHeartBeat();
        this.replicationServer = "stopped";
        this.shutdown = true;
        this.connected = false;
        this.rsGroupId = (byte)-1;
        this.rsServerId = (short)-1;
        this.rsServerUrl = null;
        try {
            if (this.session != null) {
                this.session.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.timeout = timeout;
        if (this.session != null) {
            this.session.setSoTimeout(timeout);
        }
    }

    public void setGenerationId(long generationId) {
        this.generationId = generationId;
    }

    public String getReplicationServer() {
        return this.replicationServer;
    }

    @Override
    public void handleInternalSearchEntry(InternalSearchOperation searchOperation, SearchResultEntry searchEntry) {
        Iterable<FakeOperation> updates = Historical.generateFakeOperations(searchEntry);
        for (FakeOperation op : updates) {
            this.replayOperations.add(op);
        }
    }

    @Override
    public void handleInternalSearchReference(InternalSearchOperation searchOperation, SearchResultReference searchReference) {
    }

    public int getMaxRcvWindow() {
        return this.maxRcvWindow;
    }

    public int getCurrentRcvWindow() {
        return this.rcvWindow;
    }

    public int getMaxSendWindow() {
        return this.maxSendWindow;
    }

    public int getCurrentSendWindow() {
        if (this.connected) {
            return this.sendWindow.availablePermits();
        }
        return 0;
    }

    public int getNumLostConnections() {
        return this.numLostConnections;
    }

    public void changeConfig(Collection<String> replicationServers, int maxReceiveQueue, int maxReceiveDelay, int maxSendQueue, int maxSendDelay, int window, long heartbeatInterval) {
        this.servers = replicationServers;
        this.maxRcvWindow = window;
        this.heartbeatInterval = heartbeatInterval;
        this.maxReceiveDelay = maxReceiveDelay;
        this.maxReceiveQueue = maxReceiveQueue;
        this.maxSendDelay = maxSendDelay;
        this.maxSendQueue = maxSendQueue;
    }

    public short getProtocolVersion() {
        return this.protocolVersion;
    }

    public boolean isConnected() {
        return this.connected;
    }

    private boolean debugEnabled() {
        return true;
    }

    private static final void debugInfo(String s) {
        ErrorLogger.logError(Message.raw(Category.SYNC, Severity.NOTICE, s, new Object[0]));
        TRACER.debugInfo(s);
    }

    public boolean isSessionEncrypted() {
        boolean isEncrypted = false;
        if (this.session != null) {
            return this.session.isEncrypted();
        }
        return isEncrypted;
    }

    public void signalStatusChange(ServerStatus newStatus) {
        try {
            ChangeStatusMsg csMsg = new ChangeStatusMsg(ServerStatus.INVALID_STATUS, newStatus);
            this.session.publish(csMsg);
        }
        catch (IOException ex) {
            Message message = ReplicationMessages.ERR_EXCEPTION_SENDING_CS.get(this.baseDn.toNormalizedString(), Short.toString(this.serverId), ex.getLocalizedMessage() + StaticUtils.stackTraceToSingleLineString(ex));
            ErrorLogger.logError(message);
        }
    }

    public void setGroupId(byte groupId) {
        this.groupId = groupId;
    }

    private class SameGroupIdPoller
    extends DirectoryThread {
        private boolean sameGroupIdPollershutdown;
        private boolean terminated;
        private static final int SAME_GROUP_ID_POLLER_PERIOD = 5000;

        public SameGroupIdPoller() {
            super("Replication Broker Same Group Id Poller for " + ReplicationBroker.this.baseDn.toString() + " and group id " + ReplicationBroker.this.groupId + " in server id " + ReplicationBroker.this.serverId);
            this.sameGroupIdPollershutdown = false;
            this.terminated = false;
        }

        public void waitForShutdown() {
            try {
                while (!this.terminated) {
                    Thread.sleep(50L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void shutdown() {
            this.sameGroupIdPollershutdown = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean done = false;
            while (!done && !this.sameGroupIdPollershutdown) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    this.sameGroupIdPollershutdown = true;
                }
                Object object = ReplicationBroker.this.connectPhaseLock;
                synchronized (object) {
                    if (ReplicationBroker.this.debugEnabled()) {
                        TRACER.debugInfo("Running SameGroupIdPoller for: " + ReplicationBroker.this.baseDn.toString());
                    }
                    if (ReplicationBroker.this.session != null) {
                        for (String server : ReplicationBroker.this.servers) {
                            ReplServerStartMsg replServerStartMsg;
                            if (server.equals(ReplicationBroker.this.rsServerUrl) || (replServerStartMsg = ReplicationBroker.this.performPhaseOneHandshake(server, false)) == null || ReplicationBroker.this.groupId != replServerStartMsg.getGroupId()) continue;
                            Message message = ReplicationMessages.NOTE_NEW_SERVER_WITH_SAME_GROUP_ID.get(Byte.toString(ReplicationBroker.this.groupId), ReplicationBroker.this.baseDn.toString(), Short.toString(ReplicationBroker.this.serverId));
                            ErrorLogger.logError(message);
                            try {
                                ReplicationBroker.this.session.close();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            ReplicationBroker.this.session = null;
                            done = true;
                            break;
                        }
                    }
                }
            }
            this.terminated = true;
            if (ReplicationBroker.this.debugEnabled()) {
                TRACER.debugInfo("SameGroupIdPoller for: " + ReplicationBroker.this.baseDn.toString() + " terminated.");
            }
        }
    }

    public static class ServerInfo {
        private ServerState serverState = null;
        private byte groupId = (byte)-1;

        public ServerInfo(ServerState serverState, byte groupId) {
            this.serverState = serverState;
            this.groupId = groupId;
        }

        public ServerState getServerState() {
            return this.serverState;
        }

        public byte getGroupId() {
            return this.groupId;
        }
    }
}

