/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import org.opends.server.replication.common.ServerState;
import org.opends.server.replication.protocol.ProtocolVersion;
import org.opends.server.replication.protocol.StartMsg;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;

public class ReplServerStartMsg
extends StartMsg {
    private short serverId;
    private String serverURL;
    private String baseDn = null;
    private int windowSize;
    private ServerState serverState;
    private boolean sslEncryption;
    private int degradedStatusThreshold = -1;

    public ReplServerStartMsg(short serverId, String serverURL, DN baseDn, int windowSize, ServerState serverState, short protocolVersion, long generationId, boolean sslEncryption, byte groupId, int degradedStatusThreshold) {
        super(protocolVersion, generationId);
        this.serverId = serverId;
        this.serverURL = serverURL;
        this.baseDn = baseDn != null ? baseDn.toNormalizedString() : null;
        this.windowSize = windowSize;
        this.serverState = serverState;
        this.sslEncryption = sslEncryption;
        this.groupId = groupId;
        this.degradedStatusThreshold = degradedStatusThreshold;
    }

    public ReplServerStartMsg(byte[] in) throws DataFormatException {
        byte[] allowedPduTypes = new byte[]{21, 7};
        this.headerLength = this.decodeHeader(allowedPduTypes, in);
        try {
            int pos = this.headerLength;
            int length = this.getNextLength(in, pos);
            this.baseDn = new String(in, pos, length, "UTF-8");
            pos += length + 1;
            length = this.getNextLength(in, pos);
            String serverIdString = new String(in, pos, length, "UTF-8");
            this.serverId = Short.valueOf(serverIdString);
            pos += length + 1;
            length = this.getNextLength(in, pos);
            this.serverURL = new String(in, pos, length, "UTF-8");
            pos += length + 1;
            length = this.getNextLength(in, pos);
            this.windowSize = Integer.valueOf(new String(in, pos, length, "UTF-8"));
            pos += length + 1;
            length = this.getNextLength(in, pos);
            this.sslEncryption = Boolean.valueOf(new String(in, pos, length, "UTF-8"));
            pos += length + 1;
            if (in[0] == 21) {
                length = this.getNextLength(in, pos);
                this.degradedStatusThreshold = Integer.valueOf(new String(in, pos, length, "UTF-8"));
                pos += length + 1;
            }
            this.serverState = new ServerState(in, pos, in.length - 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
    }

    public short getServerId() {
        return this.serverId;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public DN getBaseDn() {
        if (this.baseDn == null) {
            return null;
        }
        try {
            return DN.decode(this.baseDn);
        }
        catch (DirectoryException e) {
            return null;
        }
    }

    public ServerState getServerState() {
        return this.serverState;
    }

    public byte[] getBytes() {
        try {
            byte[] byteDn = this.baseDn.getBytes("UTF-8");
            byte[] byteServerId = String.valueOf(this.serverId).getBytes("UTF-8");
            byte[] byteServerUrl = this.serverURL.getBytes("UTF-8");
            byte[] byteServerState = this.serverState.getBytes();
            byte[] byteWindowSize = String.valueOf(this.windowSize).getBytes("UTF-8");
            byte[] byteSSLEncryption = String.valueOf(this.sslEncryption).getBytes("UTF-8");
            byte[] byteDegradedStatusThreshold = String.valueOf(this.degradedStatusThreshold).getBytes("UTF-8");
            int length = byteDn.length + 1 + byteServerId.length + 1 + byteServerUrl.length + 1 + byteWindowSize.length + 1 + byteSSLEncryption.length + 1 + byteDegradedStatusThreshold.length + 1 + byteServerState.length + 1;
            byte[] resultByteArray = this.encodeHeader((byte)21, length);
            int pos = this.headerLength;
            pos = this.addByteArray(byteDn, resultByteArray, pos);
            pos = this.addByteArray(byteServerId, resultByteArray, pos);
            pos = this.addByteArray(byteServerUrl, resultByteArray, pos);
            pos = this.addByteArray(byteWindowSize, resultByteArray, pos);
            pos = this.addByteArray(byteSSLEncryption, resultByteArray, pos);
            pos = this.addByteArray(byteDegradedStatusThreshold, resultByteArray, pos);
            pos = this.addByteArray(byteServerState, resultByteArray, pos);
            return resultByteArray;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public boolean getSSLEncryption() {
        return this.sslEncryption;
    }

    public int getDegradedStatusThreshold() {
        return this.degradedStatusThreshold;
    }

    public void setDegradedStatusThreshold(int degradedStatusThreshold) {
        this.degradedStatusThreshold = degradedStatusThreshold;
    }

    public String toString() {
        return "ReplServerStartMsg content: \nprotocolVersion: " + this.protocolVersion + "\ngenerationId: " + this.generationId + "\ngroupId: " + this.groupId + "\nbaseDn: " + this.baseDn.toString() + "\nserverId: " + this.serverId + "\nserverState: " + this.serverState + "\nserverURL: " + this.serverURL + "\nsslEncryption: " + this.sslEncryption + "\ndegradedStatusThreshold: " + this.degradedStatusThreshold + "\nwindowSize: " + this.windowSize;
    }

    public byte[] getBytes(short reqProtocolVersion) throws UnsupportedEncodingException {
        if (reqProtocolVersion == ProtocolVersion.getCurrentVersion()) {
            return this.getBytes();
        }
        switch (reqProtocolVersion) {
            case 1: {
                return this.getBytes_V1();
            }
        }
        throw new UnsupportedEncodingException(this.getClass().getSimpleName() + " PDU does not support requested protocol version serialization: " + reqProtocolVersion);
    }

    public byte[] getBytes_V1() throws UnsupportedEncodingException {
        try {
            byte[] byteDn = this.baseDn.getBytes("UTF-8");
            byte[] byteServerId = String.valueOf(this.serverId).getBytes("UTF-8");
            byte[] byteServerUrl = this.serverURL.getBytes("UTF-8");
            byte[] byteServerState = this.serverState.getBytes();
            byte[] byteWindowSize = String.valueOf(this.windowSize).getBytes("UTF-8");
            byte[] byteSSLEncryption = String.valueOf(this.sslEncryption).getBytes("UTF-8");
            int length = byteDn.length + 1 + byteServerId.length + 1 + byteServerUrl.length + 1 + byteWindowSize.length + 1 + byteSSLEncryption.length + 1 + byteServerState.length + 1;
            byte[] resultByteArray = this.encodeHeader_V1((byte)7, length);
            int pos = this.headerLength;
            pos = this.addByteArray(byteDn, resultByteArray, pos);
            pos = this.addByteArray(byteServerId, resultByteArray, pos);
            pos = this.addByteArray(byteServerUrl, resultByteArray, pos);
            pos = this.addByteArray(byteWindowSize, resultByteArray, pos);
            pos = this.addByteArray(byteSSLEncryption, resultByteArray, pos);
            pos = this.addByteArray(byteServerState, resultByteArray, pos);
            return resultByteArray;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}

