/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.SortedSet;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.opends.messages.Message;
import org.opends.messages.ReplicationMessages;
import org.opends.server.admin.std.server.ReplicationDomainCfg;
import org.opends.server.admin.std.server.ReplicationServerCfg;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.replication.protocol.ProtocolSession;
import org.opends.server.replication.protocol.SocketSession;
import org.opends.server.replication.protocol.TLSSocketSession;
import org.opends.server.types.CryptoManager;
import org.opends.server.types.DirectoryConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplSessionSecurity {
    private static boolean useSSL = true;
    private boolean sslEncryption;
    private String sslCertNickname;
    private String[] sslProtocols;
    private String[] sslCipherSuites;
    public static final int HANDSHAKE_TIMEOUT = 4000;

    public ReplSessionSecurity(String sslCertNickname, SortedSet<String> sslProtocols, SortedSet<String> sslCipherSuites, boolean sslEncryption) throws ConfigException {
        if (sslProtocols == null || sslProtocols.size() == 0) {
            this.sslProtocols = null;
        } else {
            this.sslProtocols = new String[sslProtocols.size()];
            sslProtocols.toArray(this.sslProtocols);
        }
        if (sslCipherSuites == null || sslCipherSuites.size() == 0) {
            this.sslCipherSuites = null;
        } else {
            this.sslCipherSuites = new String[sslProtocols.size()];
            sslProtocols.toArray(this.sslCipherSuites);
        }
        this.sslEncryption = sslEncryption;
        this.sslCertNickname = sslCertNickname;
    }

    public ReplSessionSecurity(ReplicationServerCfg replServerCfg) throws ConfigException {
        this(DirectoryConfig.getCryptoManager().getSslCertNickname(), DirectoryConfig.getCryptoManager().getSslProtocols(), DirectoryConfig.getCryptoManager().getSslCipherSuites(), DirectoryConfig.getCryptoManager().isSslEncryption());
    }

    public ReplSessionSecurity(ReplicationDomainCfg multimasterDomainCfg) throws ConfigException {
        this(DirectoryConfig.getCryptoManager().getSslCertNickname(), DirectoryConfig.getCryptoManager().getSslProtocols(), DirectoryConfig.getCryptoManager().getSslCipherSuites(), DirectoryConfig.getCryptoManager().isSslEncryption());
    }

    private boolean isSecurePort(String serverURL) {
        return useSSL;
    }

    public boolean isSslEncryption(String serverURL) {
        return this.sslEncryption;
    }

    public ProtocolSession createClientSession(String serverURL, Socket socket, int soTimeout) throws ConfigException, IOException {
        boolean useSSL = this.isSecurePort(serverURL);
        if (useSSL) {
            CryptoManager cryptoManager = DirectoryConfig.getCryptoManager();
            SSLContext sslContext = cryptoManager.getSslContext(this.sslCertNickname);
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            SSLSocket secureSocket = (SSLSocket)sslSocketFactory.createSocket(socket, socket.getInetAddress().getHostName(), socket.getPort(), false);
            secureSocket.setUseClientMode(true);
            secureSocket.setSoTimeout(soTimeout);
            if (this.sslProtocols != null) {
                secureSocket.setEnabledProtocols(this.sslProtocols);
            }
            if (this.sslCipherSuites != null) {
                secureSocket.setEnabledCipherSuites(this.sslCipherSuites);
            }
            secureSocket.startHandshake();
            return new TLSSocketSession(socket, secureSocket);
        }
        return new SocketSession(socket);
    }

    public ProtocolSession createServerSession(Socket socket, int soTimeout) throws ConfigException, IOException {
        if (useSSL) {
            try {
                CryptoManager cryptoManager = DirectoryConfig.getCryptoManager();
                SSLContext sslContext = cryptoManager.getSslContext(this.sslCertNickname);
                SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
                SSLSocket secureSocket = (SSLSocket)sslSocketFactory.createSocket(socket, socket.getInetAddress().getHostName(), socket.getPort(), false);
                secureSocket.setUseClientMode(false);
                secureSocket.setNeedClientAuth(true);
                secureSocket.setSoTimeout(soTimeout);
                if (this.sslProtocols != null) {
                    secureSocket.setEnabledProtocols(this.sslProtocols);
                }
                if (this.sslCipherSuites != null) {
                    secureSocket.setEnabledCipherSuites(this.sslCipherSuites);
                }
                secureSocket.startHandshake();
                return new TLSSocketSession(socket, secureSocket);
            }
            catch (SSLException e) {
                InetAddress remHost = socket.getInetAddress();
                Message message = ReplicationMessages.NOTE_SSL_SERVER_CON_ATTEMPT_ERROR.get(remHost.getHostName(), remHost.getHostAddress(), e.getLocalizedMessage());
                ErrorLogger.logError(message);
                return null;
            }
        }
        return new SocketSession(socket);
    }
}

