/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.messages.MessageBuilder;
import org.opends.messages.SchemaMessages;
import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.schema.PrintableString;
import org.opends.server.types.ByteString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OtherMailboxSyntax
extends AttributeSyntax<AttributeSyntaxCfg> {
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    @Override
    public void initializeSyntax(AttributeSyntaxCfg configuration) throws ConfigException {
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.11");
        if (this.defaultEqualityMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_EQUALITY_MATCHING_RULE.get("2.5.13.11", "OtherMailbox"));
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.12");
        if (this.defaultSubstringMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_SUBSTRING_MATCHING_RULE.get("2.5.13.12", "OtherMailbox"));
        }
    }

    @Override
    public String getSyntaxName() {
        return "OtherMailbox";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.115.121.1.39";
    }

    @Override
    public String getDescription() {
        return "Other Mailbox";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return null;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteString value, MessageBuilder invalidReason) {
        char c;
        int pos;
        if (value == null) {
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_OTHER_MAILBOX_EMPTY_VALUE.get());
            return false;
        }
        String valueString = value.stringValue();
        int valueLength = valueString.length();
        if (valueLength == 0) {
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_OTHER_MAILBOX_EMPTY_VALUE.get());
            return false;
        }
        for (pos = 0; pos < valueLength; ++pos) {
            c = valueString.charAt(pos);
            if (c == '$') {
                if (pos == 0) {
                    invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_OTHER_MAILBOX_NO_MBTYPE.get(valueString));
                    return false;
                }
                ++pos;
                break;
            }
            if (PrintableString.isPrintableCharacter(c)) continue;
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_OTHER_MAILBOX_ILLEGAL_MBTYPE_CHAR.get(valueString, String.valueOf(c), pos));
            return false;
        }
        if (pos >= valueLength) {
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_OTHER_MAILBOX_NO_MAILBOX.get(valueString));
            return false;
        }
        while (pos < valueLength) {
            c = valueString.charAt(pos);
            if (c != (c & 0x7F)) {
                invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_OTHER_MAILBOX_ILLEGAL_MB_CHAR.get(valueString, String.valueOf(c), pos));
                return false;
            }
            ++pos;
        }
        return true;
    }

    @Override
    public boolean isBinary() {
        return false;
    }
}

