/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.controls.AccountUsableResponseControl;
import org.opends.server.controls.EntryChangeNotificationControl;
import org.opends.server.controls.MatchedValuesControl;
import org.opends.server.controls.MatchedValuesFilter;
import org.opends.server.controls.PagedResultsControl;
import org.opends.server.controls.PersistentSearchChangeType;
import org.opends.server.controls.PersistentSearchControl;
import org.opends.server.controls.ServerSideSortRequestControl;
import org.opends.server.controls.ServerSideSortResponseControl;
import org.opends.server.controls.VLVRequestControl;
import org.opends.server.controls.VLVResponseControl;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPControl;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.protocols.ldap.LDAPResultCode;
import org.opends.server.protocols.ldap.SearchRequestProtocolOp;
import org.opends.server.protocols.ldap.SearchResultDoneProtocolOp;
import org.opends.server.protocols.ldap.SearchResultEntryProtocolOp;
import org.opends.server.protocols.ldap.SearchResultReferenceProtocolOp;
import org.opends.server.tools.LDAPConnection;
import org.opends.server.tools.LDAPConnectionException;
import org.opends.server.tools.LDAPConnectionOptions;
import org.opends.server.tools.LDAPSearchOptions;
import org.opends.server.tools.LDAPToolUtils;
import org.opends.server.tools.SSLConnectionFactory;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.LDAPException;
import org.opends.server.types.NullOutputStream;
import org.opends.server.util.Base64;
import org.opends.server.util.EmbeddedUtils;
import org.opends.server.util.PasswordReader;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPSearch {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String CLASS_NAME = "org.opends.server.tools.LDAPSearch";
    private ArrayList<LDAPControl> responseControls;
    private AtomicInteger nextMessageID;
    private PrintStream err;
    private PrintStream out;

    public LDAPSearch(AtomicInteger nextMessageID, PrintStream out, PrintStream err) {
        this.nextMessageID = nextMessageID;
        this.out = out;
        this.err = err;
        this.responseControls = new ArrayList();
    }

    public int executeSearch(LDAPConnection connection, String baseDN, ArrayList<LDAPFilter> filters, LinkedHashSet<String> attributes, LDAPSearchOptions searchOptions, int wrapColumn) throws IOException, LDAPException {
        int matchingEntries = 0;
        for (LDAPFilter filter : filters) {
            ASN1OctetString asn1OctetStr = new ASN1OctetString(baseDN);
            SearchRequestProtocolOp protocolOp = new SearchRequestProtocolOp(asn1OctetStr, searchOptions.getSearchScope(), searchOptions.getDereferencePolicy(), searchOptions.getSizeLimit(), searchOptions.getTimeLimit(), searchOptions.getTypesOnly(), filter, attributes);
            if (searchOptions.showOperations()) continue;
            try {
                byte opType;
                boolean typesOnly = searchOptions.getTypesOnly();
                LDAPMessage message = new LDAPMessage(this.nextMessageID.getAndIncrement(), protocolOp, searchOptions.getControls());
                connection.getLDAPWriter().writeMessage(message);
                do {
                    int resultCode = 0;
                    Message errorMessage = null;
                    DN matchedDN = null;
                    LDAPMessage responseMessage = connection.getLDAPReader().readMessage();
                    this.responseControls = responseMessage.getControls();
                    opType = responseMessage.getProtocolOpType();
                    switch (opType) {
                        case 100: {
                            for (LDAPControl c : this.responseControls) {
                                if (c.getOID().equals("2.16.840.1.113730.3.4.7")) {
                                    try {
                                        EntryChangeNotificationControl ecn = EntryChangeNotificationControl.decodeControl(c.getControl());
                                        this.out.println(ToolMessages.INFO_LDAPSEARCH_PSEARCH_CHANGE_TYPE.get(ecn.getChangeType().toString()));
                                        DN previousDN = ecn.getPreviousDN();
                                        if (previousDN == null) continue;
                                        this.out.println(ToolMessages.INFO_LDAPSEARCH_PSEARCH_PREVIOUS_DN.get(previousDN.toString()));
                                    }
                                    catch (Exception e) {}
                                    continue;
                                }
                                if (!c.getOID().equals("1.3.6.1.4.1.42.2.27.9.5.8")) continue;
                                try {
                                    AccountUsableResponseControl acrc = AccountUsableResponseControl.decodeControl(c.getControl());
                                    this.out.println(ToolMessages.INFO_LDAPSEARCH_ACCTUSABLE_HEADER.get());
                                    if (acrc.isUsable()) {
                                        this.out.println(ToolMessages.INFO_LDAPSEARCH_ACCTUSABLE_IS_USABLE.get());
                                        if (acrc.getSecondsBeforeExpiration() <= 0) continue;
                                        int timeToExp = acrc.getSecondsBeforeExpiration();
                                        Message timeToExpStr = StaticUtils.secondsToTimeString(timeToExp);
                                        this.out.println(ToolMessages.INFO_LDAPSEARCH_ACCTUSABLE_TIME_UNTIL_EXPIRATION.get(timeToExpStr));
                                        continue;
                                    }
                                    this.out.println(ToolMessages.INFO_LDAPSEARCH_ACCTUSABLE_NOT_USABLE.get());
                                    if (acrc.isInactive()) {
                                        this.out.println(ToolMessages.INFO_LDAPSEARCH_ACCTUSABLE_ACCT_INACTIVE.get());
                                    }
                                    if (acrc.isReset()) {
                                        this.out.println(ToolMessages.INFO_LDAPSEARCH_ACCTUSABLE_PW_RESET.get());
                                    }
                                    if (acrc.isExpired()) {
                                        this.out.println(ToolMessages.INFO_LDAPSEARCH_ACCTUSABLE_PW_EXPIRED.get());
                                        if (acrc.getRemainingGraceLogins() > 0) {
                                            this.out.println(ToolMessages.INFO_LDAPSEARCH_ACCTUSABLE_REMAINING_GRACE.get(acrc.getRemainingGraceLogins()));
                                        }
                                    }
                                    if (!acrc.isLocked()) continue;
                                    this.out.println(ToolMessages.INFO_LDAPSEARCH_ACCTUSABLE_LOCKED.get());
                                    if (acrc.getSecondsBeforeUnlock() <= 0) continue;
                                    int timeToUnlock = acrc.getSecondsBeforeUnlock();
                                    Message timeToUnlockStr = StaticUtils.secondsToTimeString(timeToUnlock);
                                    this.out.println(ToolMessages.INFO_LDAPSEARCH_ACCTUSABLE_TIME_UNTIL_UNLOCK.get(timeToUnlockStr));
                                }
                                catch (Exception e) {}
                            }
                            SearchResultEntryProtocolOp searchEntryOp = responseMessage.getSearchResultEntryProtocolOp();
                            StringBuilder sb = new StringBuilder();
                            this.toLDIF(searchEntryOp, sb, wrapColumn, typesOnly);
                            this.out.print(sb.toString());
                            ++matchingEntries;
                            break;
                        }
                        case 115: {
                            SearchResultReferenceProtocolOp searchRefOp = responseMessage.getSearchResultReferenceProtocolOp();
                            this.out.println(searchRefOp.toString());
                            break;
                        }
                        case 101: {
                            SearchResultDoneProtocolOp searchOp = responseMessage.getSearchResultDoneProtocolOp();
                            resultCode = searchOp.getResultCode();
                            errorMessage = searchOp.getErrorMessage();
                            matchedDN = searchOp.getMatchedDN();
                            for (LDAPControl c : responseMessage.getControls()) {
                                Message msg;
                                if (c.getOID().equals("1.2.840.113556.1.4.474")) {
                                    try {
                                        ServerSideSortResponseControl sortResponse = ServerSideSortResponseControl.decodeControl(c.getControl());
                                        int rc = sortResponse.getResultCode();
                                        if (rc == 0) continue;
                                        msg = ToolMessages.WARN_LDAPSEARCH_SORT_ERROR.get(LDAPResultCode.toString(rc));
                                        this.err.println(msg);
                                    }
                                    catch (Exception e) {
                                        Message msg2 = ToolMessages.WARN_LDAPSEARCH_CANNOT_DECODE_SORT_RESPONSE.get(StaticUtils.getExceptionMessage(e));
                                        this.err.println(msg2);
                                    }
                                    continue;
                                }
                                if (!c.getOID().equals("2.16.840.1.113730.3.4.10")) continue;
                                try {
                                    VLVResponseControl vlvResponse = VLVResponseControl.decodeControl(c.getControl());
                                    int rc = vlvResponse.getVLVResultCode();
                                    if (rc == 0) {
                                        msg = ToolMessages.INFO_LDAPSEARCH_VLV_TARGET_OFFSET.get(vlvResponse.getTargetPosition());
                                        this.out.println(msg);
                                        msg = ToolMessages.INFO_LDAPSEARCH_VLV_CONTENT_COUNT.get(vlvResponse.getContentCount());
                                        this.out.println(msg);
                                        continue;
                                    }
                                    msg = ToolMessages.WARN_LDAPSEARCH_VLV_ERROR.get(LDAPResultCode.toString(rc));
                                    this.err.println(msg);
                                }
                                catch (Exception e) {
                                    Message msg3 = ToolMessages.WARN_LDAPSEARCH_CANNOT_DECODE_VLV_RESPONSE.get(StaticUtils.getExceptionMessage(e));
                                    this.err.println(msg3);
                                }
                            }
                            break;
                        }
                        default: {
                            Message msg = ToolMessages.INFO_SEARCH_OPERATION_INVALID_PROTOCOL.get(String.valueOf(opType));
                            this.err.println(StaticUtils.wrapText(msg, ServerConstants.MAX_LINE_WIDTH));
                        }
                    }
                    if (resultCode != 0 && resultCode != 10) {
                        Message msg = ToolMessages.INFO_OPERATION_FAILED.get("SEARCH");
                        throw new LDAPException(resultCode, errorMessage, msg, matchedDN, null);
                    }
                    if (errorMessage == null) continue;
                    this.out.println();
                    this.out.println(StaticUtils.wrapText(errorMessage, ServerConstants.MAX_LINE_WIDTH));
                } while (opType != 101);
            }
            catch (ASN1Exception ae) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ae);
                }
                throw new IOException(ae.getMessage());
            }
        }
        if (searchOptions.countMatchingEntries()) {
            Message message = ToolMessages.INFO_LDAPSEARCH_MATCHING_ENTRY_COUNT.get(matchingEntries);
            this.out.println(message);
            this.out.println();
        }
        return matchingEntries;
    }

    public void toLDIF(SearchResultEntryProtocolOp entry, StringBuilder buffer, int wrapColumn, boolean typesOnly) {
        int colsRemaining;
        String dnString = entry.getDN().toString();
        if (StaticUtils.needsBase64Encoding(dnString)) {
            dnString = Base64.encode(StaticUtils.getBytes(dnString));
            buffer.append("dn:: ");
            colsRemaining = wrapColumn - 5;
        } else {
            buffer.append("dn: ");
            colsRemaining = wrapColumn - 4;
        }
        int dnLength = dnString.length();
        if (dnLength <= colsRemaining || colsRemaining <= 0) {
            buffer.append(dnString);
            buffer.append(ServerConstants.EOL);
        } else {
            buffer.append(dnString.substring(0, colsRemaining));
            buffer.append(ServerConstants.EOL);
            int startPos = colsRemaining;
            while (dnLength - startPos > wrapColumn - 1) {
                buffer.append(" ");
                buffer.append(dnString.substring(startPos, startPos + wrapColumn - 1));
                buffer.append(ServerConstants.EOL);
                startPos += wrapColumn - 1;
            }
            if (startPos < dnLength) {
                buffer.append(" ");
                buffer.append(dnString.substring(startPos));
                buffer.append(ServerConstants.EOL);
            }
        }
        LinkedList<LDAPAttribute> attributes = entry.getAttributes();
        for (LDAPAttribute a : attributes) {
            String name = a.getAttributeType();
            int nameLength = name.length();
            if (typesOnly) {
                buffer.append(name);
                buffer.append(ServerConstants.EOL);
                continue;
            }
            for (ASN1OctetString v : a.getValues()) {
                String valueString;
                if (StaticUtils.needsBase64Encoding(v.value())) {
                    valueString = Base64.encode(v.value());
                    buffer.append(name);
                    buffer.append(":: ");
                    colsRemaining = wrapColumn - nameLength - 3;
                } else {
                    valueString = v.stringValue();
                    buffer.append(name);
                    buffer.append(": ");
                    colsRemaining = wrapColumn - nameLength - 2;
                }
                int valueLength = valueString.length();
                if (valueLength <= colsRemaining || colsRemaining <= 0) {
                    buffer.append(valueString);
                    buffer.append(ServerConstants.EOL);
                    continue;
                }
                buffer.append(valueString.substring(0, colsRemaining));
                buffer.append(ServerConstants.EOL);
                int startPos = colsRemaining;
                while (valueLength - startPos > wrapColumn - 1) {
                    buffer.append(" ");
                    buffer.append(valueString.substring(startPos, startPos + wrapColumn - 1));
                    buffer.append(ServerConstants.EOL);
                    startPos += wrapColumn - 1;
                }
                if (startPos >= valueLength) continue;
                buffer.append(" ");
                buffer.append(valueString.substring(startPos));
                buffer.append(ServerConstants.EOL);
            }
        }
        buffer.append(ServerConstants.EOL);
    }

    public ArrayList<LDAPControl> getResponseControls() {
        return this.responseControls;
    }

    public static void main(String[] args) {
        int retCode = LDAPSearch.mainSearch(args, true, System.out, System.err);
        if (retCode != 0) {
            System.exit(StaticUtils.filterExitCode(retCode));
        }
    }

    public static int mainSearch(String[] args) {
        return LDAPSearch.mainSearch(args, true, System.out, System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int mainSearch(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream) {
        Message message;
        Message message2;
        Message message3;
        Message message4;
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        LDAPConnectionOptions connectionOptions = new LDAPConnectionOptions();
        LDAPSearchOptions searchOptions = new LDAPSearchOptions();
        LDAPConnection connection = null;
        ArrayList<LDAPFilter> filters = new ArrayList<LDAPFilter>();
        LinkedHashSet<String> attributes = new LinkedHashSet<String>();
        BooleanArgument continueOnError = null;
        BooleanArgument countEntries = null;
        BooleanArgument dontWrap = null;
        BooleanArgument noop = null;
        BooleanArgument reportAuthzID = null;
        BooleanArgument saslExternal = null;
        BooleanArgument showUsage = null;
        BooleanArgument trustAll = null;
        BooleanArgument usePasswordPolicyControl = null;
        BooleanArgument useSSL = null;
        BooleanArgument startTLS = null;
        BooleanArgument typesOnly = null;
        BooleanArgument verbose = null;
        FileBasedArgument bindPasswordFile = null;
        FileBasedArgument keyStorePasswordFile = null;
        FileBasedArgument trustStorePasswordFile = null;
        IntegerArgument port = null;
        IntegerArgument simplePageSize = null;
        IntegerArgument sizeLimit = null;
        IntegerArgument timeLimit = null;
        IntegerArgument version = null;
        StringArgument assertionFilter = null;
        StringArgument baseDN = null;
        StringArgument bindDN = null;
        StringArgument bindPassword = null;
        StringArgument certNickname = null;
        StringArgument controlStr = null;
        StringArgument dereferencePolicy = null;
        StringArgument encodingStr = null;
        StringArgument filename = null;
        StringArgument hostName = null;
        StringArgument keyStorePath = null;
        StringArgument keyStorePassword = null;
        StringArgument matchedValuesFilter = null;
        StringArgument proxyAuthzID = null;
        StringArgument pSearchInfo = null;
        StringArgument saslOptions = null;
        StringArgument searchScope = null;
        StringArgument sortOrder = null;
        StringArgument trustStorePath = null;
        StringArgument trustStorePassword = null;
        StringArgument vlvDescriptor = null;
        StringArgument effectiveRightsUser = null;
        StringArgument effectiveRightsAttrs = null;
        StringArgument propertiesFileArgument = null;
        BooleanArgument noPropertiesFileArgument = null;
        Message toolDescription = ToolMessages.INFO_LDAPSEARCH_TOOL_DESCRIPTION.get();
        ArgumentParser argParser = new ArgumentParser(CLASS_NAME, toolDescription, false, true, 0, 0, "[filter] [attributes ...]");
        try {
            propertiesFileArgument = new StringArgument("propertiesFilePath", null, "propertiesFilePath", false, false, true, ToolMessages.INFO_PROP_FILE_PATH_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_PROP_FILE_PATH.get());
            argParser.addArgument(propertiesFileArgument);
            argParser.setFilePropertiesArgument(propertiesFileArgument);
            noPropertiesFileArgument = new BooleanArgument("noPropertiesFileArgument", null, "noPropertiesFile", ToolMessages.INFO_DESCRIPTION_NO_PROP_FILE.get());
            argParser.addArgument(noPropertiesFileArgument);
            argParser.setNoPropertiesFileArgument(noPropertiesFileArgument);
            hostName = new StringArgument("host", Character.valueOf('h'), "hostname", false, false, true, ToolMessages.INFO_HOST_PLACEHOLDER.get(), "localhost", null, ToolMessages.INFO_DESCRIPTION_HOST.get());
            hostName.setPropertyName("hostname");
            argParser.addArgument(hostName);
            port = new IntegerArgument("port", Character.valueOf('p'), "port", false, false, true, ToolMessages.INFO_PORT_PLACEHOLDER.get(), 389, null, ToolMessages.INFO_DESCRIPTION_PORT.get());
            port.setPropertyName("port");
            argParser.addArgument(port);
            useSSL = new BooleanArgument("useSSL", Character.valueOf('Z'), "useSSL", ToolMessages.INFO_DESCRIPTION_USE_SSL.get());
            useSSL.setPropertyName("useSSL");
            argParser.addArgument(useSSL);
            startTLS = new BooleanArgument("startTLS", Character.valueOf('q'), "useStartTLS", ToolMessages.INFO_DESCRIPTION_START_TLS.get());
            startTLS.setPropertyName("useStartTLS");
            argParser.addArgument(startTLS);
            bindDN = new StringArgument("bindDN", Character.valueOf('D'), "bindDN", false, false, true, ToolMessages.INFO_BINDDN_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_BINDDN.get());
            bindDN.setPropertyName("bindDN");
            argParser.addArgument(bindDN);
            bindPassword = new StringArgument("bindPassword", Character.valueOf('w'), "bindPassword", false, false, true, ToolMessages.INFO_BINDPWD_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_BINDPASSWORD.get());
            bindPassword.setPropertyName("bindPassword");
            argParser.addArgument(bindPassword);
            bindPasswordFile = new FileBasedArgument("bindPasswordFile", Character.valueOf('j'), "bindPasswordFile", false, false, ToolMessages.INFO_BINDPWD_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_BINDPASSWORDFILE.get());
            bindPasswordFile.setPropertyName("bindPasswordFile");
            argParser.addArgument(bindPasswordFile);
            baseDN = new StringArgument("baseDN", Character.valueOf('b'), "baseDN", true, false, true, ToolMessages.INFO_BASEDN_PLACEHOLDER.get(), null, null, ToolMessages.INFO_SEARCH_DESCRIPTION_BASEDN.get());
            baseDN.setPropertyName("baseDN");
            argParser.addArgument(baseDN);
            searchScope = new StringArgument("searchScope", Character.valueOf('s'), "searchScope", false, false, true, ToolMessages.INFO_SEARCH_SCOPE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_SEARCH_DESCRIPTION_SEARCH_SCOPE.get());
            searchScope.setPropertyName("searchScope");
            argParser.addArgument(searchScope);
            filename = new StringArgument("filename", Character.valueOf('f'), "filename", false, false, true, ToolMessages.INFO_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_SEARCH_DESCRIPTION_FILENAME.get());
            searchScope.setPropertyName("filename");
            argParser.addArgument(filename);
            saslExternal = new BooleanArgument("useSASLExternal", Character.valueOf('r'), "useSASLExternal", ToolMessages.INFO_DESCRIPTION_USE_SASL_EXTERNAL.get());
            saslExternal.setPropertyName("useSASLExternal");
            argParser.addArgument(saslExternal);
            saslOptions = new StringArgument("saslOption", Character.valueOf('o'), "saslOption", false, true, true, ToolMessages.INFO_SASL_OPTION_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_SASL_PROPERTIES.get());
            saslOptions.setPropertyName("saslOption");
            argParser.addArgument(saslOptions);
            trustAll = new BooleanArgument("trustAll", Character.valueOf('X'), "trustAll", ToolMessages.INFO_DESCRIPTION_TRUSTALL.get());
            trustAll.setPropertyName("trustAll");
            argParser.addArgument(trustAll);
            keyStorePath = new StringArgument("keyStorePath", Character.valueOf('K'), "keyStorePath", false, false, true, ToolMessages.INFO_KEYSTOREPATH_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_KEYSTOREPATH.get());
            keyStorePath.setPropertyName("keyStorePath");
            argParser.addArgument(keyStorePath);
            keyStorePassword = new StringArgument("keyStorePassword", Character.valueOf('W'), "keyStorePassword", false, false, true, ToolMessages.INFO_KEYSTORE_PWD_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_KEYSTOREPASSWORD.get());
            keyStorePassword.setPropertyName("keyStorePassword");
            argParser.addArgument(keyStorePassword);
            keyStorePasswordFile = new FileBasedArgument("keystorepasswordfile", Character.valueOf('u'), "keyStorePasswordFile", false, false, ToolMessages.INFO_KEYSTORE_PWD_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_KEYSTOREPASSWORD_FILE.get());
            keyStorePasswordFile.setPropertyName("keyStorePasswordFile");
            argParser.addArgument(keyStorePasswordFile);
            certNickname = new StringArgument("certnickname", Character.valueOf('N'), "certNickname", false, false, true, ToolMessages.INFO_NICKNAME_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_CERT_NICKNAME.get());
            certNickname.setPropertyName("certNickname");
            argParser.addArgument(certNickname);
            trustStorePath = new StringArgument("trustStorePath", Character.valueOf('P'), "trustStorePath", false, false, true, ToolMessages.INFO_TRUSTSTOREPATH_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_TRUSTSTOREPATH.get());
            trustStorePath.setPropertyName("trustStorePath");
            argParser.addArgument(trustStorePath);
            trustStorePassword = new StringArgument("trustStorePassword", null, "trustStorePassword", false, false, true, ToolMessages.INFO_TRUSTSTORE_PWD_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_TRUSTSTOREPASSWORD.get());
            trustStorePassword.setPropertyName("trustStorePassword");
            argParser.addArgument(trustStorePassword);
            trustStorePasswordFile = new FileBasedArgument("truststorepasswordfile", Character.valueOf('U'), "trustStorePasswordFile", false, false, ToolMessages.INFO_TRUSTSTORE_PWD_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_TRUSTSTOREPASSWORD_FILE.get());
            trustStorePasswordFile.setPropertyName("trustStorePasswordFile");
            argParser.addArgument(trustStorePasswordFile);
            proxyAuthzID = new StringArgument("proxy_authzid", Character.valueOf('Y'), "proxyAs", false, false, true, ToolMessages.INFO_PROXYAUTHID_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_PROXY_AUTHZID.get());
            proxyAuthzID.setPropertyName("proxyAs");
            argParser.addArgument(proxyAuthzID);
            reportAuthzID = new BooleanArgument("reportauthzid", Character.valueOf('E'), "reportAuthzID", ToolMessages.INFO_DESCRIPTION_REPORT_AUTHZID.get());
            reportAuthzID.setPropertyName("reportAuthzID");
            argParser.addArgument(reportAuthzID);
            usePasswordPolicyControl = new BooleanArgument("usepwpolicycontrol", null, "usePasswordPolicyControl", ToolMessages.INFO_DESCRIPTION_USE_PWP_CONTROL.get());
            usePasswordPolicyControl.setPropertyName("usePasswordPolicyControl");
            argParser.addArgument(usePasswordPolicyControl);
            pSearchInfo = new StringArgument("psearchinfo", Character.valueOf('C'), "persistentSearch", false, false, true, ToolMessages.INFO_PSEARCH_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_PSEARCH_INFO.get());
            pSearchInfo.setPropertyName("persistentSearch");
            argParser.addArgument(pSearchInfo);
            simplePageSize = new IntegerArgument("simplepagesize", null, "simplePageSize", false, false, true, ToolMessages.INFO_NUM_ENTRIES_PLACEHOLDER.get(), 1000, null, true, 1, false, 0, ToolMessages.INFO_DESCRIPTION_SIMPLE_PAGE_SIZE.get());
            simplePageSize.setPropertyName("simplePageSize");
            argParser.addArgument(simplePageSize);
            assertionFilter = new StringArgument("assertionfilter", null, "assertionFilter", false, false, true, ToolMessages.INFO_ASSERTION_FILTER_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_ASSERTION_FILTER.get());
            assertionFilter.setPropertyName("assertionFilter");
            argParser.addArgument(assertionFilter);
            matchedValuesFilter = new StringArgument("matchedvalues", null, "matchedValuesFilter", false, true, true, ToolMessages.INFO_FILTER_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_MATCHED_VALUES_FILTER.get());
            matchedValuesFilter.setPropertyName("matchedValuesFilter");
            argParser.addArgument(matchedValuesFilter);
            sortOrder = new StringArgument("sortorder", Character.valueOf('S'), "sortOrder", false, false, true, ToolMessages.INFO_SORT_ORDER_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_SORT_ORDER.get());
            sortOrder.setPropertyName("sortOrder");
            argParser.addArgument(sortOrder);
            vlvDescriptor = new StringArgument("vlvdescriptor", Character.valueOf('G'), "virtualListView", false, false, true, ToolMessages.INFO_VLV_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_VLV.get());
            vlvDescriptor.setPropertyName("virtualListView");
            argParser.addArgument(vlvDescriptor);
            controlStr = new StringArgument("control", Character.valueOf('J'), "control", false, true, true, ToolMessages.INFO_LDAP_CONTROL_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_CONTROLS.get());
            controlStr.setPropertyName("control");
            argParser.addArgument(controlStr);
            effectiveRightsUser = new StringArgument("effectiveRightsUser", Character.valueOf('g'), "getEffectiveRightsAuthzid", false, false, true, ToolMessages.INFO_PROXYAUTHID_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_EFFECTIVERIGHTS_USER.get());
            effectiveRightsUser.setPropertyName("getEffectiveRightsAuthzid");
            argParser.addArgument(effectiveRightsUser);
            effectiveRightsAttrs = new StringArgument("effectiveRightsAttrs", Character.valueOf('e'), "getEffectiveRightsAttribute", false, true, true, ToolMessages.INFO_ATTRIBUTE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_EFFECTIVERIGHTS_ATTR.get());
            effectiveRightsAttrs.setPropertyName("getEffectiveRightsAttribute");
            argParser.addArgument(effectiveRightsAttrs);
            version = new IntegerArgument("version", Character.valueOf('V'), "ldapVersion", false, false, true, ToolMessages.INFO_PROTOCOL_VERSION_PLACEHOLDER.get(), 3, null, ToolMessages.INFO_DESCRIPTION_VERSION.get());
            version.setPropertyName("ldapVersion");
            argParser.addArgument(version);
            encodingStr = new StringArgument("encoding", Character.valueOf('i'), "encoding", false, false, true, ToolMessages.INFO_ENCODING_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_ENCODING.get());
            encodingStr.setPropertyName("encoding");
            argParser.addArgument(encodingStr);
            dereferencePolicy = new StringArgument("derefpolicy", Character.valueOf('a'), "dereferencePolicy", false, false, true, ToolMessages.INFO_DEREFERENCE_POLICE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_SEARCH_DESCRIPTION_DEREFERENCE_POLICY.get());
            dereferencePolicy.setPropertyName("dereferencePolicy");
            argParser.addArgument(dereferencePolicy);
            typesOnly = new BooleanArgument("typesOnly", Character.valueOf('A'), "typesOnly", ToolMessages.INFO_DESCRIPTION_TYPES_ONLY.get());
            typesOnly.setPropertyName("typesOnly");
            argParser.addArgument(typesOnly);
            sizeLimit = new IntegerArgument("sizeLimit", Character.valueOf('z'), "sizeLimit", false, false, true, ToolMessages.INFO_SIZE_LIMIT_PLACEHOLDER.get(), 0, null, ToolMessages.INFO_SEARCH_DESCRIPTION_SIZE_LIMIT.get());
            sizeLimit.setPropertyName("sizeLimit");
            argParser.addArgument(sizeLimit);
            timeLimit = new IntegerArgument("timeLimit", Character.valueOf('l'), "timeLimit", false, false, true, ToolMessages.INFO_TIME_LIMIT_PLACEHOLDER.get(), 0, null, ToolMessages.INFO_SEARCH_DESCRIPTION_TIME_LIMIT.get());
            timeLimit.setPropertyName("timeLimit");
            argParser.addArgument(timeLimit);
            dontWrap = new BooleanArgument("dontwrap", Character.valueOf('T'), "dontWrap", ToolMessages.INFO_DESCRIPTION_DONT_WRAP.get());
            dontWrap.setPropertyName("dontWrap");
            argParser.addArgument(dontWrap);
            countEntries = new BooleanArgument("countentries", null, "countEntries", ToolMessages.INFO_DESCRIPTION_COUNT_ENTRIES.get());
            countEntries.setPropertyName("countEntries");
            argParser.addArgument(countEntries);
            continueOnError = new BooleanArgument("continueOnError", Character.valueOf('c'), "continueOnError", ToolMessages.INFO_DESCRIPTION_CONTINUE_ON_ERROR.get());
            continueOnError.setPropertyName("continueOnError");
            argParser.addArgument(continueOnError);
            noop = new BooleanArgument("noop", Character.valueOf('n'), "dry-run", ToolMessages.INFO_DESCRIPTION_NOOP.get());
            noop.setPropertyName("dry-run");
            argParser.addArgument(noop);
            verbose = new BooleanArgument("verbose", Character.valueOf('v'), "verbose", ToolMessages.INFO_DESCRIPTION_VERBOSE.get());
            verbose.setPropertyName("verbose");
            argParser.addArgument(verbose);
            showUsage = new BooleanArgument("showUsage", Character.valueOf('H'), "help", ToolMessages.INFO_DESCRIPTION_SHOWUSAGE.get());
            argParser.addArgument(showUsage);
            argParser.setUsageArgument(showUsage, out);
        }
        catch (ArgumentException ae) {
            Message message5 = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage());
            err.println(StaticUtils.wrapText(message5, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            Message message6 = ToolMessages.ERR_ERROR_PARSING_ARGS.get(ae.getMessage());
            err.println(StaticUtils.wrapText(message6, ServerConstants.MAX_LINE_WIDTH));
            err.println(argParser.getUsage());
            return 1;
        }
        if (argParser.usageOrVersionDisplayed()) {
            return 0;
        }
        ArrayList<String> filterAndAttributeStrings = argParser.getTrailingArguments();
        if (filterAndAttributeStrings.size() > 0) {
            if (!filename.isPresent()) {
                String filterString = filterAndAttributeStrings.remove(0);
                try {
                    filters.add(LDAPFilter.decode(filterString));
                }
                catch (LDAPException le) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, le);
                    }
                    err.println(StaticUtils.wrapText(le.getMessage(), ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
            }
            for (String s : filterAndAttributeStrings) {
                attributes.add(s);
            }
        }
        if (bindPassword.isPresent() && bindPasswordFile.isPresent()) {
            message4 = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(bindPassword.getLongIdentifier(), bindPasswordFile.getLongIdentifier());
            err.println(StaticUtils.wrapText(message4, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        if (useSSL.isPresent() && startTLS.isPresent()) {
            message4 = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(useSSL.getLongIdentifier(), startTLS.getLongIdentifier());
            err.println(StaticUtils.wrapText(message4, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        if (keyStorePassword.isPresent() && keyStorePasswordFile.isPresent()) {
            message4 = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(keyStorePassword.getLongIdentifier(), keyStorePasswordFile.getLongIdentifier());
            err.println(StaticUtils.wrapText(message4, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        if (trustStorePassword.isPresent() && trustStorePasswordFile.isPresent()) {
            message4 = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(trustStorePassword.getLongIdentifier(), trustStorePasswordFile.getLongIdentifier());
            err.println(StaticUtils.wrapText(message4, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        String hostNameValue = hostName.getValue();
        int portNumber = 389;
        try {
            portNumber = port.getIntValue();
        }
        catch (ArgumentException ae) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ae);
            }
            err.println(StaticUtils.wrapText(ae.getMessage(), ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            int versionNumber = version.getIntValue();
            if (versionNumber != 2 && versionNumber != 3) {
                err.println(StaticUtils.wrapText(ToolMessages.ERR_DESCRIPTION_INVALID_VERSION.get(String.valueOf(versionNumber)), ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            connectionOptions.setVersionNumber(versionNumber);
        }
        catch (ArgumentException ae) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ae);
            }
            err.println(StaticUtils.wrapText(ae.getMessage(), ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        connectionOptions.setReportAuthzID(reportAuthzID.isPresent());
        connectionOptions.setUsePasswordPolicyControl(usePasswordPolicyControl.isPresent());
        String baseDNValue = baseDN.getValue();
        String bindDNValue = bindDN.getValue();
        String fileNameValue = filename.getValue();
        String bindPasswordValue = bindPassword.getValue();
        if (bindPasswordValue != null && bindPasswordValue.equals("-")) {
            try {
                out.print(ToolMessages.INFO_LDAPAUTH_PASSWORD_PROMPT.get(bindDNValue));
                char[] pwChars = PasswordReader.readPassword();
                bindPasswordValue = new String(pwChars);
            }
            catch (Exception ex) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ex);
                }
                err.println(StaticUtils.wrapText(ex.getMessage(), ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        } else if (bindPasswordValue == null) {
            bindPasswordValue = bindPasswordFile.getValue();
        }
        String keyStorePathValue = keyStorePath.getValue();
        String trustStorePathValue = trustStorePath.getValue();
        String keyStorePasswordValue = null;
        if (keyStorePassword.isPresent()) {
            keyStorePasswordValue = keyStorePassword.getValue();
        } else if (keyStorePasswordFile.isPresent()) {
            keyStorePasswordValue = keyStorePasswordFile.getValue();
        }
        String trustStorePasswordValue = null;
        if (trustStorePassword.isPresent()) {
            trustStorePasswordValue = trustStorePassword.getValue();
        } else if (trustStorePasswordFile.isPresent()) {
            trustStorePasswordValue = trustStorePasswordFile.getValue();
        }
        searchOptions.setTypesOnly(typesOnly.isPresent());
        searchOptions.setShowOperations(noop.isPresent());
        searchOptions.setVerbose(verbose.isPresent());
        searchOptions.setContinueOnError(continueOnError.isPresent());
        searchOptions.setEncoding(encodingStr.getValue());
        searchOptions.setCountMatchingEntries(countEntries.isPresent());
        try {
            searchOptions.setTimeLimit(timeLimit.getIntValue());
            searchOptions.setSizeLimit(sizeLimit.getIntValue());
        }
        catch (ArgumentException ex1) {
            err.println(StaticUtils.wrapText(ex1.getMessage(), ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        boolean val = searchOptions.setSearchScope(searchScope.getValue(), err);
        if (!val) {
            return 1;
        }
        val = searchOptions.setDereferencePolicy(dereferencePolicy.getValue(), err);
        if (!val) {
            return 1;
        }
        if (controlStr.isPresent()) {
            for (String ctrlString : controlStr.getValues()) {
                LDAPControl ctrl = LDAPToolUtils.getControl(ctrlString, err);
                if (ctrl == null) {
                    Message message7 = ToolMessages.ERR_TOOL_INVALID_CONTROL_STRING.get(ctrlString);
                    err.println(StaticUtils.wrapText(message7, ServerConstants.MAX_LINE_WIDTH));
                    err.println(argParser.getUsage());
                    return 1;
                }
                searchOptions.getControls().add(ctrl);
            }
        }
        if (effectiveRightsUser.isPresent()) {
            String authzID = effectiveRightsUser.getValue();
            if (!authzID.startsWith("dn:")) {
                message3 = ToolMessages.ERR_EFFECTIVERIGHTS_INVALID_AUTHZID.get(authzID);
                err.println(StaticUtils.wrapText(message3, ServerConstants.MAX_LINE_WIDTH));
                err.println(argParser.getUsage());
                return 1;
            }
            Object v = null;
            ASN1OctetString effectiveRightsUserVal = new ASN1OctetString(authzID);
            ASN1Sequence sequence = null;
            ArrayList<ASN1Element> attrElements = new ArrayList<ASN1Element>();
            for (String a : effectiveRightsAttrs.getValues()) {
                attrElements.add(new ASN1OctetString(a));
            }
            ASN1Sequence attrSeq = new ASN1Sequence(attrElements);
            ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(2);
            elements.add(effectiveRightsUserVal);
            elements.add(attrSeq);
            sequence = new ASN1Sequence(elements);
            LDAPControl effectiveRightsControl = new LDAPControl("1.3.6.1.4.1.42.2.27.9.5.2", false, new ASN1OctetString(sequence.encode()));
            searchOptions.getControls().add(effectiveRightsControl);
        }
        if (proxyAuthzID.isPresent()) {
            ASN1OctetString proxyValue = new ASN1OctetString(proxyAuthzID.getValue());
            LDAPControl proxyControl = new LDAPControl("2.16.840.1.113730.3.4.18", true, proxyValue);
            searchOptions.getControls().add(proxyControl);
        }
        if (pSearchInfo.isPresent()) {
            Message message8;
            String infoString = StaticUtils.toLowerCase(pSearchInfo.getValue().trim());
            HashSet<PersistentSearchChangeType> changeTypes = new HashSet<PersistentSearchChangeType>();
            boolean changesOnly = true;
            boolean returnECs = true;
            StringTokenizer tokenizer = new StringTokenizer(infoString, ":");
            if (!tokenizer.hasMoreTokens()) {
                message2 = ToolMessages.ERR_PSEARCH_MISSING_DESCRIPTOR.get();
                err.println(StaticUtils.wrapText(message2, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            String token = tokenizer.nextToken();
            if (!token.equals("ps")) {
                message8 = ToolMessages.ERR_PSEARCH_DOESNT_START_WITH_PS.get(String.valueOf(infoString));
                err.println(StaticUtils.wrapText(message8, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            if (tokenizer.hasMoreTokens()) {
                StringTokenizer st = new StringTokenizer(tokenizer.nextToken(), ", ");
                while (st.hasMoreTokens()) {
                    String token2 = st.nextToken();
                    if (token2.equals("add")) {
                        changeTypes.add(PersistentSearchChangeType.ADD);
                        continue;
                    }
                    if (token2.equals("delete") || token2.equals("del")) {
                        changeTypes.add(PersistentSearchChangeType.DELETE);
                        continue;
                    }
                    if (token2.equals("modify") || token2.equals("mod")) {
                        changeTypes.add(PersistentSearchChangeType.MODIFY);
                        continue;
                    }
                    if (token2.equals("modifydn") || token2.equals("moddn") || token2.equals("modrdn")) {
                        changeTypes.add(PersistentSearchChangeType.MODIFY_DN);
                        continue;
                    }
                    if (token2.equals("any") || token2.equals("all")) {
                        changeTypes.add(PersistentSearchChangeType.ADD);
                        changeTypes.add(PersistentSearchChangeType.DELETE);
                        changeTypes.add(PersistentSearchChangeType.MODIFY);
                        changeTypes.add(PersistentSearchChangeType.MODIFY_DN);
                        continue;
                    }
                    Message message9 = ToolMessages.ERR_PSEARCH_INVALID_CHANGE_TYPE.get(String.valueOf(token2));
                    err.println(StaticUtils.wrapText(message9, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
            }
            if (changeTypes.isEmpty()) {
                changeTypes.add(PersistentSearchChangeType.ADD);
                changeTypes.add(PersistentSearchChangeType.DELETE);
                changeTypes.add(PersistentSearchChangeType.MODIFY);
                changeTypes.add(PersistentSearchChangeType.MODIFY_DN);
            }
            if (tokenizer.hasMoreTokens()) {
                token = tokenizer.nextToken();
                if (token.equals("1") || token.equals("true") || token.equals("yes")) {
                    changesOnly = true;
                } else if (token.equals("0") || token.equals("false") || token.equals("no")) {
                    changesOnly = false;
                } else {
                    message8 = ToolMessages.ERR_PSEARCH_INVALID_CHANGESONLY.get(String.valueOf(token));
                    err.println(StaticUtils.wrapText(message8, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
            }
            if (tokenizer.hasMoreTokens()) {
                token = tokenizer.nextToken();
                if (token.equals("1") || token.equals("true") || token.equals("yes")) {
                    returnECs = true;
                } else if (token.equals("0") || token.equals("false") || token.equals("no")) {
                    returnECs = false;
                } else {
                    message8 = ToolMessages.ERR_PSEARCH_INVALID_RETURN_ECS.get(String.valueOf(token));
                    err.println(StaticUtils.wrapText(message8, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
            }
            PersistentSearchControl psearchControl = new PersistentSearchControl(changeTypes, changesOnly, returnECs);
            searchOptions.getControls().add(new LDAPControl(psearchControl));
        }
        if (assertionFilter.isPresent()) {
            String filterString = assertionFilter.getValue();
            try {
                LDAPFilter filter = LDAPFilter.decode(filterString);
                LDAPControl assertionControl = new LDAPControl("1.3.6.1.1.12", true, new ASN1OctetString(filter.encode().encode()));
                searchOptions.getControls().add(assertionControl);
            }
            catch (LDAPException le) {
                Message message10 = ToolMessages.ERR_LDAP_ASSERTION_INVALID_FILTER.get(le.getMessage());
                err.println(StaticUtils.wrapText(message10, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        }
        if (matchedValuesFilter.isPresent()) {
            LinkedList<String> mvFilterStrings = matchedValuesFilter.getValues();
            ArrayList<MatchedValuesFilter> mvFilters = new ArrayList<MatchedValuesFilter>();
            for (String s : mvFilterStrings) {
                try {
                    LDAPFilter f = LDAPFilter.decode(s);
                    mvFilters.add(MatchedValuesFilter.createFromLDAPFilter(f));
                }
                catch (LDAPException le) {
                    message2 = ToolMessages.ERR_LDAP_MATCHEDVALUES_INVALID_FILTER.get(le.getMessage());
                    err.println(StaticUtils.wrapText(message2, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
            }
            MatchedValuesControl mvc = new MatchedValuesControl(true, mvFilters);
            searchOptions.getControls().add(new LDAPControl(mvc));
        }
        if (sortOrder.isPresent()) {
            try {
                searchOptions.getControls().add(new LDAPControl(new ServerSideSortRequestControl(sortOrder.getValue())));
            }
            catch (LDAPException le) {
                message3 = ToolMessages.ERR_LDAP_SORTCONTROL_INVALID_ORDER.get(le.getErrorMessage());
                err.println(StaticUtils.wrapText(message3, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        }
        if (vlvDescriptor.isPresent()) {
            if (!sortOrder.isPresent()) {
                message = ToolMessages.ERR_LDAPSEARCH_VLV_REQUIRES_SORT.get(vlvDescriptor.getLongIdentifier(), sortOrder.getLongIdentifier());
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            StringTokenizer tokenizer = new StringTokenizer(vlvDescriptor.getValue(), ":");
            int numTokens = tokenizer.countTokens();
            if (numTokens == 3) {
                try {
                    int beforeCount = Integer.parseInt(tokenizer.nextToken());
                    int afterCount = Integer.parseInt(tokenizer.nextToken());
                    ASN1OctetString assertionValue = new ASN1OctetString(tokenizer.nextToken());
                    searchOptions.getControls().add(new LDAPControl(new VLVRequestControl(beforeCount, afterCount, (ByteString)assertionValue)));
                }
                catch (Exception e) {
                    Message message11 = ToolMessages.ERR_LDAPSEARCH_VLV_INVALID_DESCRIPTOR.get();
                    err.println(StaticUtils.wrapText(message11, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
            } else if (numTokens == 4) {
                try {
                    int beforeCount = Integer.parseInt(tokenizer.nextToken());
                    int afterCount = Integer.parseInt(tokenizer.nextToken());
                    int offset = Integer.parseInt(tokenizer.nextToken());
                    int contentCount = Integer.parseInt(tokenizer.nextToken());
                    searchOptions.getControls().add(new LDAPControl(new VLVRequestControl(beforeCount, afterCount, offset, contentCount)));
                }
                catch (Exception e) {
                    Message message12 = ToolMessages.ERR_LDAPSEARCH_VLV_INVALID_DESCRIPTOR.get();
                    err.println(StaticUtils.wrapText(message12, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
            } else {
                Message message13 = ToolMessages.ERR_LDAPSEARCH_VLV_INVALID_DESCRIPTOR.get();
                err.println(StaticUtils.wrapText(message13, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        }
        connectionOptions.setSASLExternal(saslExternal.isPresent());
        if (saslOptions.isPresent()) {
            LinkedList<String> values = saslOptions.getValues();
            for (String saslOption : values) {
                boolean propValue;
                boolean mechValue;
                if (!(saslOption.startsWith("mech=") ? !(mechValue = connectionOptions.setSASLMechanism(saslOption)) : !(propValue = connectionOptions.addSASLProperty(saslOption)))) continue;
                return 1;
            }
        }
        connectionOptions.setUseSSL(useSSL.isPresent());
        connectionOptions.setStartTLS(startTLS.isPresent());
        if (connectionOptions.useSASLExternal()) {
            if (!connectionOptions.useSSL() && !connectionOptions.useStartTLS()) {
                message = ToolMessages.ERR_TOOL_SASLEXTERNAL_NEEDS_SSL_OR_TLS.get();
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            if (keyStorePathValue == null) {
                message = ToolMessages.ERR_TOOL_SASLEXTERNAL_NEEDS_KEYSTORE.get();
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        }
        connectionOptions.setVerbose(verbose.isPresent());
        if (fileNameValue != null) {
            BufferedReader in = null;
            try {
                in = new BufferedReader(new FileReader(fileNameValue));
                String line = null;
                while ((line = in.readLine()) != null) {
                    if (line.trim().equals("")) continue;
                    LDAPFilter ldapFilter = LDAPFilter.decode(line);
                    filters.add(ldapFilter);
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                err.println(StaticUtils.wrapText(e.getMessage(), ServerConstants.MAX_LINE_WIDTH));
                int ldapFilter = 1;
                return ldapFilter;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        if (filters.isEmpty()) {
            err.println(StaticUtils.wrapText(ToolMessages.ERR_SEARCH_NO_FILTERS.get(), ServerConstants.MAX_LINE_WIDTH));
            err.println(argParser.getUsage());
            return 1;
        }
        int wrapColumn = 80;
        if (dontWrap.isPresent()) {
            wrapColumn = 0;
        }
        LDAPSearch ldapSearch = null;
        try {
            if (initializeServer) {
                EmbeddedUtils.initializeForClientUse();
            }
            SSLConnectionFactory sslConnectionFactory = null;
            if (connectionOptions.useSSL() || connectionOptions.useStartTLS()) {
                String clientAlias = certNickname.isPresent() ? certNickname.getValue() : null;
                sslConnectionFactory = new SSLConnectionFactory();
                sslConnectionFactory.init(trustAll.isPresent(), keyStorePathValue, keyStorePasswordValue, clientAlias, trustStorePathValue, trustStorePasswordValue);
                connectionOptions.setSSLConnectionFactory(sslConnectionFactory);
            }
            if (noop.isPresent()) {
                int clientAlias = 0;
                return clientAlias;
            }
            AtomicInteger nextMessageID = new AtomicInteger(1);
            connection = new LDAPConnection(hostNameValue, portNumber, connectionOptions, out, err);
            connection.connectToHost(bindDNValue, bindPasswordValue, nextMessageID);
            int matchingEntries = 0;
            if (simplePageSize.isPresent()) {
                if (filters.size() > 1) {
                    Message message14 = ToolMessages.ERR_PAGED_RESULTS_REQUIRES_SINGLE_FILTER.get();
                    throw new LDAPException(89, message14);
                }
                int pageSize = simplePageSize.getIntValue();
                ASN1OctetString cookieValue = new ASN1OctetString();
                ArrayList<LDAPControl> origControls = searchOptions.getControls();
                do {
                    ArrayList<LDAPControl> newControls = new ArrayList<LDAPControl>(origControls.size() + 1);
                    newControls.addAll(origControls);
                    newControls.add(new LDAPControl(new PagedResultsControl(true, pageSize, cookieValue)));
                    searchOptions.setControls(newControls);
                    ldapSearch = new LDAPSearch(nextMessageID, out, err);
                    matchingEntries += ldapSearch.executeSearch(connection, baseDNValue, filters, attributes, searchOptions, wrapColumn);
                    ArrayList<LDAPControl> responseControls = ldapSearch.getResponseControls();
                    boolean responseFound = false;
                    for (LDAPControl c : responseControls) {
                        if (!c.getOID().equals("1.2.840.113556.1.4.319")) continue;
                        try {
                            PagedResultsControl control = new PagedResultsControl(c.isCritical(), c.getValue());
                            responseFound = true;
                            cookieValue = control.getCookie();
                            break;
                        }
                        catch (LDAPException le) {
                            Message message15 = ToolMessages.ERR_PAGED_RESULTS_CANNOT_DECODE.get(le.getMessage());
                            throw new LDAPException(84, message15, le);
                        }
                    }
                    if (responseFound) continue;
                    Message message16 = ToolMessages.ERR_PAGED_RESULTS_RESPONSE_NOT_FOUND.get();
                    throw new LDAPException(93, message16);
                } while (cookieValue.value().length != 0);
            } else {
                ldapSearch = new LDAPSearch(nextMessageID, out, err);
                matchingEntries = ldapSearch.executeSearch(connection, baseDNValue, filters, attributes, searchOptions, wrapColumn);
            }
            if (countEntries.isPresent()) {
                int n = matchingEntries;
                return n;
            }
            int n = 0;
            return n;
        }
        catch (LDAPException le) {
            int code;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, le);
            }
            LDAPToolUtils.printErrorMessage(err, le.getMessageObject(), le.getResultCode(), le.getErrorMessage(), le.getMatchedDN());
            int n = code = le.getResultCode();
            return n;
        }
        catch (LDAPConnectionException lce) {
            int code;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, lce);
            }
            LDAPToolUtils.printErrorMessage(err, lce.getMessageObject(), lce.getResultCode(), lce.getErrorMessage(), lce.getMatchedDN());
            int n = code = lce.getResultCode();
            return n;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            err.println(StaticUtils.wrapText(e.getMessage(), ServerConstants.MAX_LINE_WIDTH));
            int n = 1;
            return n;
        }
        finally {
            if (connection != null) {
                if (ldapSearch == null) {
                    connection.close(null);
                } else {
                    connection.close(ldapSearch.nextMessageID);
                }
            }
        }
    }
}

