/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.dsconfig;

import org.opends.messages.DSConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.DefaultBehaviorException;
import org.opends.server.admin.IllegalPropertyValueException;
import org.opends.server.admin.IllegalPropertyValueStringException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyDefinitionUsageBuilder;
import org.opends.server.admin.PropertyException;
import org.opends.server.admin.PropertyIsMandatoryException;
import org.opends.server.admin.PropertyIsReadOnlyException;
import org.opends.server.admin.PropertyIsSingleValuedException;
import org.opends.server.admin.RelationDefinition;
import org.opends.server.admin.client.IllegalManagedObjectNameException;
import org.opends.server.admin.client.ManagedObjectDecodingException;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.cli.CLIException;
import org.opends.server.util.cli.ConsoleApplication;
import org.opends.server.util.table.TableBuilder;
import org.opends.server.util.table.TextTablePrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArgumentExceptionFactory {
    public static CLIException adaptIllegalManagedObjectNameException(IllegalManagedObjectNameException e, AbstractManagedObjectDefinition<?, ?> d) {
        String illegalName = e.getIllegalName();
        PropertyDefinition<?> pd = e.getNamingPropertyDefinition();
        if (illegalName.length() == 0) {
            Message message = DSConfigMessages.ERR_DSCFG_ERROR_ILLEGAL_NAME_EMPTY.get(d.getUserFriendlyPluralName());
            return new CLIException(message);
        }
        if (illegalName.trim().length() == 0) {
            Message message = DSConfigMessages.ERR_DSCFG_ERROR_ILLEGAL_NAME_BLANK.get(d.getUserFriendlyPluralName());
            return new CLIException(message);
        }
        if (pd != null) {
            try {
                pd.decodeValue(illegalName);
            }
            catch (IllegalPropertyValueStringException e1) {
                PropertyDefinitionUsageBuilder b = new PropertyDefinitionUsageBuilder(true);
                Message syntax = b.getUsage(pd);
                Message message = DSConfigMessages.ERR_DSCFG_ERROR_ILLEGAL_NAME_SYNTAX.get(illegalName, d.getUserFriendlyName(), syntax);
                return new CLIException(message);
            }
        }
        Message message = DSConfigMessages.ERR_DSCFG_ERROR_ILLEGAL_NAME_UNKNOWN.get(illegalName, d.getUserFriendlyName());
        return new CLIException(message);
    }

    public static ArgumentException adaptPropertyException(PropertyException e, AbstractManagedObjectDefinition<?, ?> d) {
        if (e instanceof IllegalPropertyValueException) {
            IllegalPropertyValueException pe = (IllegalPropertyValueException)e;
            return ArgumentExceptionFactory.adapt(d, pe);
        }
        if (e instanceof IllegalPropertyValueStringException) {
            IllegalPropertyValueStringException pe = (IllegalPropertyValueStringException)e;
            return ArgumentExceptionFactory.adapt(d, pe);
        }
        if (e instanceof PropertyIsMandatoryException) {
            PropertyIsMandatoryException pe = (PropertyIsMandatoryException)e;
            return ArgumentExceptionFactory.adapt(d, pe);
        }
        if (e instanceof PropertyIsSingleValuedException) {
            PropertyIsSingleValuedException pe = (PropertyIsSingleValuedException)e;
            return ArgumentExceptionFactory.adapt(d, pe);
        }
        if (e instanceof PropertyIsReadOnlyException) {
            PropertyIsReadOnlyException pe = (PropertyIsReadOnlyException)e;
            return ArgumentExceptionFactory.adapt(d, pe);
        }
        if (e instanceof DefaultBehaviorException) {
            DefaultBehaviorException pe = (DefaultBehaviorException)e;
            return ArgumentExceptionFactory.adapt(d, pe);
        }
        Message message = DSConfigMessages.ERR_DSCFG_ERROR_PROPERTY_UNKNOWN_ERROR.get(d.getUserFriendlyName(), e.getPropertyDefinition().getName(), e.getMessage());
        return new ArgumentException(message);
    }

    public static void displayManagedObjectDecodingException(ConsoleApplication app, ManagedObjectDecodingException e) {
        ManagedObjectDefinition<?, Configuration> d = e.getPartialManagedObject().getManagedObjectDefinition();
        Message ufn = d.getUserFriendlyName();
        Message msg = e.getCauses().size() == 1 ? DSConfigMessages.ERR_GET_HEADING_MODE_SINGLE.get(ufn) : DSConfigMessages.ERR_GET_HEADING_MODE_PLURAL.get(ufn);
        app.println(msg);
        app.println();
        TableBuilder builder = new TableBuilder();
        for (PropertyException pe : e.getCauses()) {
            ArgumentException ae = ArgumentExceptionFactory.adaptPropertyException(pe, d);
            builder.startRow();
            builder.appendCell("*");
            builder.appendCell(ae.getMessage());
        }
        TextTablePrinter printer = new TextTablePrinter(app.getErrorStream());
        printer.setDisplayHeadings(false);
        printer.setColumnWidth(1, 0);
        printer.setIndentWidth(4);
        builder.print(printer);
    }

    public static void displayMissingMandatoryPropertyException(ConsoleApplication app, MissingMandatoryPropertiesException e) {
        Message ufn = e.getUserFriendlyName();
        Message msg = e.isCreate() ? (e.getCauses().size() == 1 ? DSConfigMessages.ERR_CREATE_HEADING_MMPE_SINGLE.get(ufn) : DSConfigMessages.ERR_CREATE_HEADING_MMPE_PLURAL.get(ufn)) : (e.getCauses().size() == 1 ? DSConfigMessages.ERR_MODIFY_HEADING_MMPE_SINGLE.get(ufn) : DSConfigMessages.ERR_MODIFY_HEADING_MMPE_PLURAL.get(ufn));
        app.println(msg);
        app.println();
        TableBuilder builder = new TableBuilder();
        builder.addSortKey(0);
        builder.appendHeading(DSConfigMessages.INFO_DSCFG_HEADING_PROPERTY_NAME.get());
        builder.appendHeading(DSConfigMessages.INFO_DSCFG_HEADING_PROPERTY_SYNTAX.get());
        PropertyDefinitionUsageBuilder b = new PropertyDefinitionUsageBuilder(true);
        for (PropertyIsMandatoryException pe : e.getCauses()) {
            PropertyDefinition<?> pd = pe.getPropertyDefinition();
            builder.startRow();
            builder.appendCell(pd.getName());
            builder.appendCell(b.getUsage(pd));
        }
        TextTablePrinter printer = new TextTablePrinter(app.getErrorStream());
        printer.setDisplayHeadings(true);
        printer.setColumnWidth(1, 0);
        printer.setIndentWidth(4);
        builder.print(printer);
    }

    public static void displayOperationRejectedException(ConsoleApplication app, OperationRejectedException e) {
        Message msg;
        Message ufn = e.getUserFriendlyName();
        switch (e.getOperationType()) {
            case CREATE: {
                if (e.getMessages().size() == 1) {
                    msg = DSConfigMessages.ERR_DSCFG_ERROR_CREATE_ORE_SINGLE.get(ufn);
                    break;
                }
                msg = DSConfigMessages.ERR_DSCFG_ERROR_CREATE_ORE_PLURAL.get(ufn);
                break;
            }
            case DELETE: {
                if (e.getMessages().size() == 1) {
                    msg = DSConfigMessages.ERR_DSCFG_ERROR_DELETE_ORE_SINGLE.get(ufn);
                    break;
                }
                msg = DSConfigMessages.ERR_DSCFG_ERROR_DELETE_ORE_PLURAL.get(ufn);
                break;
            }
            default: {
                msg = e.getMessages().size() == 1 ? DSConfigMessages.ERR_DSCFG_ERROR_MODIFY_ORE_SINGLE.get(ufn) : DSConfigMessages.ERR_DSCFG_ERROR_MODIFY_ORE_PLURAL.get(ufn);
            }
        }
        app.println(msg);
        app.println();
        TableBuilder builder = new TableBuilder();
        for (Message reason : e.getMessages()) {
            builder.startRow();
            builder.appendCell("*");
            builder.appendCell(reason);
        }
        TextTablePrinter printer = new TextTablePrinter(app.getErrorStream());
        printer.setDisplayHeadings(false);
        printer.setColumnWidth(1, 0);
        printer.setIndentWidth(4);
        builder.print(printer);
    }

    public static ArgumentException incompatiblePropertyModification(String arg) {
        Message msg = DSConfigMessages.ERR_DSCFG_ERROR_INCOMPATIBLE_PROPERTY_MOD.get(arg);
        return new ArgumentException(msg);
    }

    public static ArgumentException missingBindPassword(String bindDN) {
        Message msg = DSConfigMessages.ERR_DSCFG_ERROR_NO_PASSWORD.get(bindDN);
        return new ArgumentException(msg);
    }

    public static ArgumentException missingMandatoryNonInteractiveArgument(Argument arg) {
        Message msg = DSConfigMessages.ERR_DSCFG_ERROR_MISSING_NON_INTERACTIVE_ARG.get(arg.getLongIdentifier());
        return new ArgumentException(msg);
    }

    public static ArgumentException missingNameInPropertyArgument(String arg) {
        Message msg = DSConfigMessages.ERR_DSCFG_ERROR_NO_NAME_IN_PROPERTY_VALUE.get(arg);
        return new ArgumentException(msg);
    }

    public static ArgumentException missingNameInPropertyModification(String arg) {
        Message msg = DSConfigMessages.ERR_DSCFG_ERROR_NO_NAME_IN_PROPERTY_MOD.get(arg);
        return new ArgumentException(msg);
    }

    public static ArgumentException missingSeparatorInPropertyArgument(String arg) {
        Message msg = DSConfigMessages.ERR_DSCFG_ERROR_NO_SEPARATOR_IN_PROPERTY_VALUE.get(arg);
        return new ArgumentException(msg);
    }

    public static ArgumentException missingSeparatorInPropertyModification(String arg) {
        Message msg = DSConfigMessages.ERR_DSCFG_ERROR_NO_SEPARATOR_IN_PROPERTY_MOD.get(arg);
        return new ArgumentException(msg);
    }

    public static ArgumentException missingValueInPropertyArgument(String arg) {
        Message msg = DSConfigMessages.ERR_DSCFG_ERROR_NO_VALUE_IN_PROPERTY_VALUE.get(arg);
        return new ArgumentException(msg);
    }

    public static ArgumentException missingValueInPropertyModification(String arg) {
        Message msg = DSConfigMessages.ERR_DSCFG_ERROR_NO_NAME_IN_PROPERTY_MOD.get(arg);
        return new ArgumentException(msg);
    }

    public static ArgumentException unableToReadConnectionParameters(Exception cause) {
        Message message = DSConfigMessages.ERR_DSCFG_ERROR_CANNOT_READ_CONNECTION_PARAMETERS.get(cause.getMessage());
        return new ArgumentException(message, (Throwable)cause);
    }

    public static ArgumentException unableToReadBindPasswordInteractively() {
        Message message = DSConfigMessages.ERR_DSCFG_ERROR_BIND_PASSWORD_NONINTERACTIVE.get();
        return new ArgumentException(message);
    }

    public static ArgumentException unableToResetMandatoryProperty(AbstractManagedObjectDefinition<?, ?> d, String name, String setOption) {
        Message message = DSConfigMessages.ERR_DSCFG_ERROR_UNABLE_TO_RESET_MANDATORY_PROPERTY.get(d.getUserFriendlyPluralName(), name, setOption);
        return new ArgumentException(message);
    }

    public static ArgumentException unableToSetNamingProperty(AbstractManagedObjectDefinition<?, ?> d, PropertyDefinition<?> pd) {
        Message message = DSConfigMessages.ERR_DSCFG_ERROR_UNABLE_TO_SET_NAMING_PROPERTY.get(pd.getName(), d.getUserFriendlyName());
        return new ArgumentException(message);
    }

    public static ArgumentException unknownCategory(String categoryName) {
        Message msg = DSConfigMessages.ERR_DSCFG_ERROR_CATEGORY_UNRECOGNIZED.get(categoryName);
        return new ArgumentException(msg);
    }

    public static ArgumentException unknownProperty(AbstractManagedObjectDefinition<?, ?> d, String name) {
        Message message = DSConfigMessages.ERR_DSCFG_ERROR_PROPERTY_UNRECOGNIZED.get(name, d.getUserFriendlyPluralName());
        return new ArgumentException(message);
    }

    public static ArgumentException unknownProperty(String name) {
        Message message = DSConfigMessages.ERR_DSCFG_ERROR_PROPERTY_UNRECOGNIZED_NO_DEFN.get(name);
        return new ArgumentException(message);
    }

    public static ArgumentException unknownSubType(RelationDefinition<?, ?> r, String typeName, String typeUsage) {
        Message msg = DSConfigMessages.ERR_DSCFG_ERROR_SUB_TYPE_UNRECOGNIZED.get(typeName, r.getUserFriendlyName(), typeUsage);
        return new ArgumentException(msg);
    }

    public static ArgumentException unknownTypeForCategory(String typeName, String categoryName) {
        Message msg = DSConfigMessages.ERR_DSCFG_ERROR_CATEGORY_TYPE_UNRECOGNIZED.get(typeName, categoryName);
        return new ArgumentException(msg);
    }

    public static ArgumentException unknownValueForMultiValuedProperty(String value, String propertyName) {
        Message msg = DSConfigMessages.ERR_DSCFG_ERROR_VALUE_DOES_NOT_EXIST.get(value, propertyName);
        return new ArgumentException(msg);
    }

    public static CLIException wrongManagedObjectType(RelationDefinition<?, ?> r, ManagedObjectDefinition<?, ?> d, String subcommandName) {
        Message msg = DSConfigMessages.ERR_DSCFG_ERROR_TYPE_UNRECOGNIZED_FOR_SUBCOMMAND.get(d.getUserFriendlyName(), subcommandName);
        return new CLIException(msg);
    }

    private static ArgumentException adapt(AbstractManagedObjectDefinition<?, ?> d, DefaultBehaviorException e) {
        Message message = DSConfigMessages.ERR_DSCFG_ERROR_PROPERTY_DEFAULT_BEHAVIOR.get(d.getUserFriendlyName(), e.getPropertyDefinition().getName(), e.getMessage());
        return new ArgumentException(message);
    }

    private static ArgumentException adapt(AbstractManagedObjectDefinition<?, ?> d, IllegalPropertyValueException e) {
        PropertyDefinitionUsageBuilder b = new PropertyDefinitionUsageBuilder(true);
        Message syntax = b.getUsage(e.getPropertyDefinition());
        if (syntax.length() > 20) {
            // empty if block
        }
        Message message = DSConfigMessages.ERR_DSCFG_ERROR_PROPERTY_INVALID_VALUE.get(String.valueOf(e.getIllegalValue()), d.getUserFriendlyName(), e.getPropertyDefinition().getName(), syntax);
        return new ArgumentException(message);
    }

    private static ArgumentException adapt(AbstractManagedObjectDefinition<?, ?> d, IllegalPropertyValueStringException e) {
        PropertyDefinitionUsageBuilder b = new PropertyDefinitionUsageBuilder(true);
        Message syntax = b.getUsage(e.getPropertyDefinition());
        if (syntax.length() > 20) {
            // empty if block
        }
        Message message = DSConfigMessages.ERR_DSCFG_ERROR_PROPERTY_INVALID_VALUE.get(String.valueOf(e.getIllegalValueString()), d.getUserFriendlyName(), e.getPropertyDefinition().getName(), syntax);
        return new ArgumentException(message);
    }

    private static ArgumentException adapt(AbstractManagedObjectDefinition<?, ?> d, PropertyIsMandatoryException e) {
        Message message = DSConfigMessages.ERR_DSCFG_ERROR_PROPERTY_MANDATORY.get(d.getUserFriendlyName(), e.getPropertyDefinition().getName());
        return new ArgumentException(message);
    }

    private static ArgumentException adapt(AbstractManagedObjectDefinition<?, ?> d, PropertyIsReadOnlyException e) {
        Message message = DSConfigMessages.ERR_DSCFG_ERROR_PROPERTY_READ_ONLY.get(d.getUserFriendlyName(), e.getPropertyDefinition().getName());
        return new ArgumentException(message);
    }

    private static ArgumentException adapt(AbstractManagedObjectDefinition<?, ?> d, PropertyIsSingleValuedException e) {
        Message message = DSConfigMessages.ERR_DSCFG_ERROR_PROPERTY_SINGLE_VALUED.get(d.getUserFriendlyName(), e.getPropertyDefinition().getName());
        return new ArgumentException(message);
    }

    private ArgumentExceptionFactory() {
    }
}

