/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.dsconfig;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.opends.messages.DSConfigMessages;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.ConfigurationClient;
import org.opends.server.admin.DefinitionDecodingException;
import org.opends.server.admin.DurationUnit;
import org.opends.server.admin.InstantiableRelationDefinition;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.ManagedObjectNotFoundException;
import org.opends.server.admin.ManagedObjectOption;
import org.opends.server.admin.ManagedObjectPath;
import org.opends.server.admin.ManagedObjectPathSerializer;
import org.opends.server.admin.OptionalRelationDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyDefinitionUsageBuilder;
import org.opends.server.admin.SingletonRelationDefinition;
import org.opends.server.admin.SizeUnit;
import org.opends.server.admin.Tag;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.IllegalManagedObjectNameException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.ManagedObjectDecodingException;
import org.opends.server.admin.client.ManagementContext;
import org.opends.server.tools.ClientException;
import org.opends.server.tools.dsconfig.ArgumentExceptionFactory;
import org.opends.server.tools.dsconfig.CLIProfile;
import org.opends.server.tools.dsconfig.ManagementContextFactory;
import org.opends.server.types.CommonSchemaElements;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.args.SubCommand;
import org.opends.server.util.cli.CLIException;
import org.opends.server.util.cli.CommandBuilder;
import org.opends.server.util.cli.ConsoleApplication;
import org.opends.server.util.cli.Menu;
import org.opends.server.util.cli.MenuBuilder;
import org.opends.server.util.cli.MenuResult;
import org.opends.server.util.table.TabSeparatedTablePrinter;
import org.opends.server.util.table.TablePrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SubCommandHandler
implements Comparable<SubCommandHandler> {
    public static final int MULTI_COLUMN_THRESHOLD = 8;
    private static final String OPTION_DSCFG_LONG_PROPERTY = "property";
    private static final String OPTION_DSCFG_LONG_RECORD = "record";
    private static final String OPTION_DSCFG_LONG_UNIT_SIZE = "unit-size";
    private static final String OPTION_DSCFG_LONG_UNIT_TIME = "unit-time";
    private static final Character OPTION_DSCFG_SHORT_PROPERTY = null;
    private static final char OPTION_DSCFG_SHORT_RECORD = 'E';
    private static final char OPTION_DSCFG_SHORT_UNIT_SIZE = 'z';
    private static final char OPTION_DSCFG_SHORT_UNIT_TIME = 'm';
    private StringArgument propertyArgument;
    private BooleanArgument recordModeArgument;
    private final Set<Tag> tags = new HashSet<Tag>();
    private StringArgument unitSizeArgument;
    private StringArgument unitTimeArgument;
    private CommandBuilder commandBuilder;
    private boolean isCommandBuilderUseful = true;

    protected SubCommandHandler() {
    }

    @Override
    public final int compareTo(SubCommandHandler o) {
        String s1 = this.getSubCommand().getName();
        String s2 = o.getSubCommand().getName();
        return s1.compareTo(s2);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SubCommandHandler) {
            SubCommandHandler other = (SubCommandHandler)obj;
            String s1 = this.getSubCommand().getName();
            String s2 = other.getSubCommand().getName();
            return s1.equals(s2);
        }
        return false;
    }

    public abstract SubCommand getSubCommand();

    public final CommandBuilder getCommandBuilder() {
        if (this.commandBuilder == null) {
            this.commandBuilder = new CommandBuilder(System.getProperty("org.opends.server.scriptName"), this.getSubCommand().getName());
        }
        return this.commandBuilder;
    }

    public final boolean isCommandBuilderUseful() {
        return this.isCommandBuilderUseful;
    }

    protected final void setCommandBuilderUseful(boolean isCommandBuilderUseful) {
        this.isCommandBuilderUseful = isCommandBuilderUseful;
    }

    public final Set<Tag> getTags() {
        return this.tags;
    }

    public final int hashCode() {
        return this.getSubCommand().getName().hashCode();
    }

    public abstract MenuResult<Integer> run(ConsoleApplication var1, ManagementContextFactory var2) throws ArgumentException, ClientException, CLIException;

    public final String toString() {
        return this.getSubCommand().getName();
    }

    protected final void addTags(Collection<Tag> tags) {
        this.tags.addAll(tags);
    }

    protected final void addTags(Tag ... tags) {
        this.addTags(Arrays.asList(tags));
    }

    protected final List<StringArgument> createNamingArgs(SubCommand subCommand, ManagedObjectPath<?, ?> p, boolean isCreate) throws ArgumentException {
        return NamingArgumentBuilder.create(subCommand, p, isCreate);
    }

    protected final TablePrinter createScriptFriendlyTablePrinter(PrintStream stream) {
        return new TabSeparatedTablePrinter(stream);
    }

    protected final MenuResult<ManagedObject<?>> getManagedObject(ConsoleApplication app, ManagementContext context, ManagedObjectPath<?, ?> path, List<String> args) throws CLIException, AuthorizationException, DefinitionDecodingException, ManagedObjectDecodingException, CommunicationException, ConcurrentModificationException, ManagedObjectNotFoundException, ClientException {
        ManagedObjectFinder finder = new ManagedObjectFinder();
        return finder.find(app, context, path, args);
    }

    protected final List<String> getNamingArgValues(ConsoleApplication app, List<StringArgument> namingArgs) throws ArgumentException {
        ArrayList<String> values = new ArrayList<String>(namingArgs.size());
        for (StringArgument arg : namingArgs) {
            String value = arg.getValue();
            if (value == null && !app.isInteractive()) {
                throw ArgumentExceptionFactory.missingMandatoryNonInteractiveArgument(arg);
            }
            values.add(value);
        }
        return values;
    }

    protected final Set<String> getPropertyNames() {
        if (this.propertyArgument != null) {
            return new LinkedHashSet<String>(this.propertyArgument.getValues());
        }
        return Collections.emptySet();
    }

    protected final SizeUnit getSizeUnit() throws ArgumentException {
        String value;
        if (this.unitSizeArgument != null && (value = this.unitSizeArgument.getValue()) != null) {
            try {
                return SizeUnit.getUnit(value);
            }
            catch (IllegalArgumentException e) {
                Message msg = DSConfigMessages.INFO_DSCFG_ERROR_SIZE_UNIT_UNRECOGNIZED.get(value);
                throw new ArgumentException(msg);
            }
        }
        return null;
    }

    protected final DurationUnit getTimeUnit() throws ArgumentException {
        String value;
        if (this.unitTimeArgument != null && (value = this.unitTimeArgument.getValue()) != null) {
            try {
                return DurationUnit.getUnit(value);
            }
            catch (IllegalArgumentException e) {
                Message msg = DSConfigMessages.INFO_DSCFG_ERROR_TIME_UNIT_UNRECOGNIZED.get(value);
                throw new ArgumentException(msg);
            }
        }
        return null;
    }

    protected final boolean isRecordMode() {
        if (this.recordModeArgument != null) {
            return this.recordModeArgument.isPresent();
        }
        return false;
    }

    protected final <C extends ConfigurationClient, S extends Configuration> MenuResult<String> readChildName(ConsoleApplication app, ManagedObject<?> parent, InstantiableRelationDefinition<C, S> r, AbstractManagedObjectDefinition<? extends C, ? extends S> d) throws AuthorizationException, ConcurrentModificationException, CommunicationException, CLIException {
        if (d == null) {
            d = r.getChildDefinition();
        }
        app.println();
        app.println();
        String[] childNames = parent.listChildren(r, d);
        TreeSet<String> children = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (String childName : childNames) {
            try {
                ManagedObject<C> child = parent.getChild(r, childName);
                ManagedObjectDefinition<C, Configuration> cd = child.getManagedObjectDefinition();
                if (cd.hasOption(ManagedObjectOption.HIDDEN) || !app.isAdvancedMode() && cd.hasOption(ManagedObjectOption.ADVANCED)) continue;
                children.add(childName);
            }
            catch (DefinitionDecodingException e) {
                children.add(childName);
            }
            catch (ManagedObjectDecodingException e) {
                children.add(childName);
            }
            catch (ManagedObjectNotFoundException e) {
                // empty catch block
            }
        }
        switch (children.size()) {
            case 0: {
                Message msg = DSConfigMessages.ERR_DSCFG_ERROR_FINDER_NO_CHILDREN.get(d.getUserFriendlyPluralName());
                app.println(msg);
                return MenuResult.cancel();
            }
            case 1: {
                Message msg = DSConfigMessages.INFO_DSCFG_FINDER_PROMPT_SINGLE.get(d.getUserFriendlyName(), (CharSequence)children.first());
                if (app.confirmAction(msg, true)) {
                    try {
                        String argName = CLIProfile.getInstance().getNamingArgument(r);
                        StringArgument arg = new StringArgument(argName, null, argName, false, true, ToolMessages.INFO_NAME_PLACEHOLDER.get(), DSConfigMessages.INFO_DSCFG_DESCRIPTION_NAME_CREATE.get(d.getUserFriendlyName()));
                        arg.addValue((String)children.first());
                        this.getCommandBuilder().addArgument(arg);
                    }
                    catch (Throwable t) {
                        new RuntimeException("Unexpected exception: " + t, t);
                    }
                    return MenuResult.success(children.first());
                }
                return MenuResult.cancel();
            }
        }
        MenuBuilder<String> builder = new MenuBuilder<String>(app);
        builder.setMultipleColumnThreshold(8);
        builder.setPrompt(DSConfigMessages.INFO_DSCFG_FINDER_PROMPT_MANY.get(d.getUserFriendlyName()));
        for (String child : children) {
            Message option = Message.raw("%s", child);
            builder.addNumberedOption(option, MenuResult.success(child), new Message[0]);
        }
        if (app.isMenuDrivenMode()) {
            builder.addCancelOption(true);
        }
        builder.addQuitOption();
        Menu menu = builder.toMenu();
        MenuResult<String> result = menu.run();
        try {
            String argName = CLIProfile.getInstance().getNamingArgument(r);
            StringArgument arg = new StringArgument(argName, null, argName, false, true, ToolMessages.INFO_NAME_PLACEHOLDER.get(), DSConfigMessages.INFO_DSCFG_DESCRIPTION_NAME_CREATE.get(d.getUserFriendlyName()));
            arg.addValue((String)result.getValue());
            this.getCommandBuilder().addArgument(arg);
        }
        catch (Throwable t) {
            throw new RuntimeException("Unexpected exception: " + t, t);
        }
        return result;
    }

    protected final void registerPropertyNameArgument(SubCommand subCommand) throws ArgumentException {
        this.propertyArgument = new StringArgument(OPTION_DSCFG_LONG_PROPERTY, OPTION_DSCFG_SHORT_PROPERTY, OPTION_DSCFG_LONG_PROPERTY, false, true, true, ToolMessages.INFO_PROPERTY_PLACEHOLDER.get(), null, null, DSConfigMessages.INFO_DSCFG_DESCRIPTION_PROP.get());
        subCommand.addArgument(this.propertyArgument);
    }

    protected final void registerRecordModeArgument(SubCommand subCommand) throws ArgumentException {
        this.recordModeArgument = new BooleanArgument(OPTION_DSCFG_LONG_RECORD, Character.valueOf('E'), OPTION_DSCFG_LONG_RECORD, DSConfigMessages.INFO_DSCFG_DESCRIPTION_RECORD.get());
        this.recordModeArgument.setPropertyName(OPTION_DSCFG_LONG_RECORD);
        subCommand.addArgument(this.recordModeArgument);
    }

    protected final void registerUnitSizeArgument(SubCommand subCommand) throws ArgumentException {
        this.unitSizeArgument = new StringArgument(OPTION_DSCFG_LONG_UNIT_SIZE, Character.valueOf('z'), OPTION_DSCFG_LONG_UNIT_SIZE, false, true, ToolMessages.INFO_UNIT_PLACEHOLDER.get(), DSConfigMessages.INFO_DSCFG_DESCRIPTION_UNIT_SIZE.get());
        this.unitSizeArgument.setPropertyName(OPTION_DSCFG_LONG_UNIT_SIZE);
        subCommand.addArgument(this.unitSizeArgument);
    }

    protected final void registerUnitTimeArgument(SubCommand subCommand) throws ArgumentException {
        this.unitTimeArgument = new StringArgument(OPTION_DSCFG_LONG_UNIT_TIME, Character.valueOf('m'), OPTION_DSCFG_LONG_UNIT_TIME, false, true, ToolMessages.INFO_UNIT_PLACEHOLDER.get(), DSConfigMessages.INFO_DSCFG_DESCRIPTION_UNIT_TIME.get());
        this.unitTimeArgument.setPropertyName(OPTION_DSCFG_LONG_UNIT_TIME);
        subCommand.addArgument(this.unitTimeArgument);
    }

    protected final void updateCommandBuilderWithSubCommand() {
        for (Argument arg : this.getSubCommand().getArguments()) {
            if (!arg.isPresent()) continue;
            this.getCommandBuilder().addArgument(arg);
        }
    }

    protected static String getArgumentValue(Object o) {
        String value = o instanceof CommonSchemaElements ? ((CommonSchemaElements)o).getNameOrOID() : String.valueOf(o);
        return value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NamingArgumentBuilder
    implements ManagedObjectPathSerializer {
        private final List<StringArgument> arguments = new LinkedList<StringArgument>();
        private ArgumentException e = null;
        private final boolean isCreate;
        private final SubCommand subCommand;
        private int sz;

        public static List<StringArgument> create(SubCommand subCommand, ManagedObjectPath<?, ?> path, boolean isCreate) throws ArgumentException {
            NamingArgumentBuilder builder = new NamingArgumentBuilder(subCommand, path.size(), isCreate);
            path.serialize(builder);
            if (builder.e != null) {
                throw builder.e;
            }
            return builder.arguments;
        }

        private NamingArgumentBuilder(SubCommand subCommand, int sz, boolean isCreate) {
            this.subCommand = subCommand;
            this.sz = sz;
            this.isCreate = isCreate;
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> void appendManagedObjectPathElement(InstantiableRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d, String name) {
            --this.sz;
            String argName = CLIProfile.getInstance().getNamingArgument(r);
            try {
                StringArgument arg;
                if (this.isCreate && this.sz == 0) {
                    PropertyDefinition<?> pd = r.getNamingPropertyDefinition();
                    if (pd != null) {
                        PropertyDefinitionUsageBuilder b = new PropertyDefinitionUsageBuilder(false);
                        Message usage = Message.raw("{" + b.getUsage(pd) + "}", new Object[0]);
                        arg = new StringArgument(argName, null, argName, false, true, usage, DSConfigMessages.INFO_DSCFG_DESCRIPTION_NAME_CREATE_EXT.get(d.getUserFriendlyName(), pd.getName(), pd.getSynopsis()));
                    } else {
                        arg = new StringArgument(argName, null, argName, false, true, ToolMessages.INFO_NAME_PLACEHOLDER.get(), DSConfigMessages.INFO_DSCFG_DESCRIPTION_NAME_CREATE.get(d.getUserFriendlyName()));
                    }
                } else {
                    arg = new StringArgument(argName, null, argName, false, true, ToolMessages.INFO_NAME_PLACEHOLDER.get(), DSConfigMessages.INFO_DSCFG_DESCRIPTION_NAME.get(d.getUserFriendlyName()));
                }
                this.subCommand.addArgument(arg);
                this.arguments.add(arg);
            }
            catch (ArgumentException e) {
                this.e = e;
            }
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> void appendManagedObjectPathElement(OptionalRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d) {
            --this.sz;
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> void appendManagedObjectPathElement(SingletonRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d) {
            --this.sz;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ManagedObjectFinder
    implements ManagedObjectPathSerializer {
        private ConsoleApplication app;
        private int argIndex;
        private List<String> args;
        private AuthorizationException authze;
        private CommunicationException ce;
        private CLIException clie;
        private ConcurrentModificationException cme;
        private DefinitionDecodingException dde;
        private ManagedObjectDecodingException mode;
        private ManagedObjectNotFoundException monfe;
        private MenuResult<ManagedObject<?>> result;

        private ManagedObjectFinder() {
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> void appendManagedObjectPathElement(InstantiableRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d, String name) {
            if (this.result.isSuccess()) {
                String childName = this.args.get(this.argIndex++);
                try {
                    if (childName == null) {
                        try {
                            MenuResult<String> sresult = SubCommandHandler.this.readChildName(this.app, this.result.getValue(), r, d);
                            if (sresult.isCancel()) {
                                this.result = MenuResult.cancel();
                                return;
                            }
                            if (sresult.isQuit()) {
                                this.result = MenuResult.quit();
                                return;
                            }
                            childName = sresult.getValue();
                        }
                        catch (CLIException e) {
                            this.clie = e;
                            this.result = MenuResult.quit();
                            return;
                        }
                    } else if (childName.trim().length() == 0) {
                        IllegalManagedObjectNameException e = new IllegalManagedObjectNameException(childName);
                        this.clie = ArgumentExceptionFactory.adaptIllegalManagedObjectNameException(e, d);
                        this.result = MenuResult.quit();
                        return;
                    }
                    ManagedObject<C> child = this.result.getValue().getChild(r, childName);
                    if (!child.getManagedObjectDefinition().isChildOf(d)) {
                        this.clie = ArgumentExceptionFactory.wrongManagedObjectType(r, child.getManagedObjectDefinition(), SubCommandHandler.this.getSubCommand().getName());
                        this.result = MenuResult.quit();
                    } else {
                        this.result = MenuResult.success(child);
                    }
                }
                catch (DefinitionDecodingException e) {
                    this.dde = e;
                    this.result = MenuResult.quit();
                }
                catch (ManagedObjectDecodingException e) {
                    this.mode = e;
                    this.result = MenuResult.quit();
                }
                catch (AuthorizationException e) {
                    this.authze = e;
                    this.result = MenuResult.quit();
                }
                catch (ManagedObjectNotFoundException e) {
                    this.monfe = e;
                    this.result = MenuResult.quit();
                }
                catch (ConcurrentModificationException e) {
                    this.cme = e;
                    this.result = MenuResult.quit();
                }
                catch (CommunicationException e) {
                    this.ce = e;
                    this.result = MenuResult.quit();
                }
            }
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> void appendManagedObjectPathElement(OptionalRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d) {
            if (this.result.isSuccess()) {
                try {
                    ManagedObject<C> child = this.result.getValue().getChild(r);
                    if (!child.getManagedObjectDefinition().isChildOf(d)) {
                        this.clie = ArgumentExceptionFactory.wrongManagedObjectType(r, child.getManagedObjectDefinition(), SubCommandHandler.this.getSubCommand().getName());
                        this.result = MenuResult.quit();
                    } else {
                        this.result = MenuResult.success(child);
                    }
                }
                catch (DefinitionDecodingException e) {
                    this.dde = e;
                    this.result = MenuResult.quit();
                }
                catch (ManagedObjectDecodingException e) {
                    this.mode = e;
                    this.result = MenuResult.quit();
                }
                catch (AuthorizationException e) {
                    this.authze = e;
                    this.result = MenuResult.quit();
                }
                catch (ManagedObjectNotFoundException e) {
                    this.monfe = e;
                    this.result = MenuResult.quit();
                }
                catch (ConcurrentModificationException e) {
                    this.cme = e;
                    this.result = MenuResult.quit();
                }
                catch (CommunicationException e) {
                    this.ce = e;
                    this.result = MenuResult.quit();
                }
            }
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> void appendManagedObjectPathElement(SingletonRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d) {
            if (this.result.isSuccess()) {
                try {
                    ManagedObject<C> child = this.result.getValue().getChild(r);
                    if (!child.getManagedObjectDefinition().isChildOf(d)) {
                        this.clie = ArgumentExceptionFactory.wrongManagedObjectType(r, child.getManagedObjectDefinition(), SubCommandHandler.this.getSubCommand().getName());
                        this.result = MenuResult.quit();
                    } else {
                        this.result = MenuResult.success(child);
                    }
                }
                catch (DefinitionDecodingException e) {
                    this.dde = e;
                    this.result = MenuResult.quit();
                }
                catch (ManagedObjectDecodingException e) {
                    this.mode = e;
                    this.result = MenuResult.quit();
                }
                catch (AuthorizationException e) {
                    this.authze = e;
                    this.result = MenuResult.quit();
                }
                catch (ManagedObjectNotFoundException e) {
                    this.monfe = e;
                    this.result = MenuResult.quit();
                }
                catch (ConcurrentModificationException e) {
                    this.cme = e;
                    this.result = MenuResult.quit();
                }
                catch (CommunicationException e) {
                    this.ce = e;
                    this.result = MenuResult.quit();
                }
            }
        }

        public MenuResult<ManagedObject<?>> find(ConsoleApplication app, ManagementContext context, ManagedObjectPath<?, ?> path, List<String> args) throws CLIException, CommunicationException, AuthorizationException, ConcurrentModificationException, DefinitionDecodingException, ManagedObjectDecodingException, ManagedObjectNotFoundException {
            this.result = MenuResult.success(context.getRootConfigurationManagedObject());
            this.app = app;
            this.args = args;
            this.argIndex = 0;
            this.clie = null;
            this.authze = null;
            this.ce = null;
            this.cme = null;
            this.dde = null;
            this.mode = null;
            this.monfe = null;
            path.serialize(this);
            if (this.result.isSuccess()) {
                return this.result;
            }
            if (this.clie != null) {
                throw this.clie;
            }
            if (this.authze != null) {
                throw this.authze;
            }
            if (this.ce != null) {
                throw this.ce;
            }
            if (this.cme != null) {
                throw this.cme;
            }
            if (this.dde != null) {
                throw this.dde;
            }
            if (this.mode != null) {
                throw this.mode;
            }
            if (this.monfe != null) {
                throw this.monfe;
            }
            return this.result;
        }
    }
}

